# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to edit watchpoint properties.
"""

from qt import *

from EditWatchpointForm import EditWatchpointForm


class EditWatchpointDialog(EditWatchpointForm):
    """
    Class implementing a dialog to edit watchpoint properties.
    """
    def __init__(self, properties, parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param properties properties for the watchpoint (tuple)
                (condition, temporary flag, enabled flag, ignore count)
        @param parent the parent of this dialog
        @param name the widget name of this dialog
        @param modal flag indicating a modal dialog
        @param fl the window flags
        """
        EditWatchpointForm.__init__(self,parent,name,modal,fl)
        
        dummy = self.trUtf8("Dummy")
        
        cond, temp, enabled, count = properties
        
        # set the condition
        if cond is None:
            cond = ''
        self.conditionEdit.setText(cond)
        
        # set the ignore count
        self.ignoreSpinBox.setValue(count)
        
        # set the checkboxes
        self.temporaryCheckBox.setChecked(temp)
        self.enabledCheckBox.setChecked(enabled)
        
        self.conditionEdit.setFocus()
        
    def handleTextChanged(self, txt):
        """
        Private slot to handle the text changed signal of the condition line edit.
        
        @param txt text of the line edit (QString)
        """
        self.okButton.setEnabled(not txt.isEmpty())
        
    def getData(self):
        """
        Public method to retrieve the entered data.
        
        @return a tuple containing the watchpoints new properties
            (condition, temporary flag, enabled flag, ignore count)
        """
        return (self.conditionEdit.text(), 
                self.temporaryCheckBox.isChecked(),
                self.enabledCheckBox.isChecked(), 
                self.ignoreSpinBox.value())
