# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Mercurial Options Dialog for a new project from the repository.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from NewProjectForm import HgNewProjectOptionsForm
from Config import ConfigHgProtocols

class HgNewProjectOptionsDialog(HgNewProjectOptionsForm):
    """
    Class implementing the Options Dialog for a new project from the repository.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        HgNewProjectOptionsForm.__init__(self, parent, None, 1)
        
        self.protocolCombo.insertStringList(ConfigHgProtocols)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
        
    def handleProjectDir(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsProjectDirEdit.text(),
            self, None, self.trUtf8("Select Project Directory"), 1)
            
        if not directory.isNull():
            self.vcsProjectDirEdit.setText(QDir.convertSeparators(directory))
        
    def handleProtocol(self, protocol):
        """
        Private slot to switch the status of the directory selection button.
        """
        if str(protocol) == "file://":
            self.vcsDirButton.setEnabled(1)
        else:
            self.vcsDirButton.setEnabled(0)
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of a string (project directory) and a dictionary
            containing the data entered.
        """
        vcsdatadict = {
            "tag" : unicode(self.vcsTagEdit.text()),
        }
        protocol = str(self.protocolCombo.currentText())
        if protocol == "file://":
            vcsdatadict["url"] = unicode(self.vcsDirectoryEdit.text())
        else:
            vcsdatadict["url"] = \
                '%s%s' % (protocol, unicode(self.vcsDirectoryEdit.text())),
        return (unicode(self.vcsProjectDirEdit.text()), vcsdatadict)
