# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to show the output of the hg outgoing command.
"""

import os

from qt import *

import mercurial.commands as commands
from mercurial.hg import repository, RepoError
from mercurial.ui import ui

from IncomingDialog import HgIncomingDialog

import Utilities

class HgOutgoingDialog(HgIncomingDialog):
    """
    Module implementing a dialog to show the output of the hg incoming command.
    """
    def __init__(self, vcs, parent = None):
        """
        Constructor
        
        @param vcs reference to the vcs object
        @param parent parent widget (QWidget)
        """
        HgIncomingDialog.__init__(self, vcs, parent)
        
        self.contentsGroup.setTitle(self.trUtf8('Outgoing:'))
        QWhatsThis.add(self.contents,self.tr("<b>Mercurial Outgoing</b>\n"
            "<p>This shows the output of the hg outgoing command.</p>"
        ))
        QWhatsThis.add(self.errors,self.tr("<b>Mercurial outgoing errors</b>\n"
            "<p>This shows possible error messages of the hg outgoing command.</p>"
        ))
        
    def start(self, ppath, dest):
        """
        Public slot to start the cvs incoming command.
        
        @param ppath directory name of the project (string)
        @param dest directory name or URL of the destination repository (string)
        """
        self.changesetsfound = 0
        self.firstoutput = 1

        try:
            self.setActiveWindow()
            self.raiseW()
        except:
            pass
        
        cwd = os.getcwd()
        os.chdir(ppath)
        try:
            repo = repository(self, ppath)
            if not dest:
                dest = self.expandpath("default-push")
                if dest == "default-push":
                    dest = self.expandpath("default")
                    if dest == "default":
                        dest = ""
            self.setCaption(self.trUtf8('Mercurial Outgoing %1').arg(dest))
            commands.outgoing(self, repo, dest)
        except RepoError, inst:
            self.warn("abort: ", inst, "\n")
            self.changesetsfound = 1
        except:
            pass
        os.chdir(cwd)
        
        # at exit
        self.closeButton.setFocus()
        
        self.contents.setCursorPosition(0, 0)
        self.contents.ensureCursorVisible()
        
        if not self.changesetsfound:
            self.contents.append(\
                self.trUtf8("<br>No outgoing changesets available for '%1'")\
                .arg(dest))
