# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Mercurial Options Dialog for a push operation.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from PushForm import HgPushForm
from Config import ConfigHgProtocols

class HgPushDialog(HgPushForm):
    """
    Class implementing the Options Dialog for a push operation.
    """
    def __init__(self, forOutgoing=0, parent=None):
        """
        Constructor
        
        @param forOutgoing flag indicating a dialog for the hg outgoing command
            (boolean)
        @param parent parent widget (QWidget)
        """
        HgPushForm.__init__(self, parent, None, 1)
        
        self.protocolCombo.insertStringList(ConfigHgProtocols)
        
        if forOutgoing:
            self.setCaption(self.trUtf8("Mercurial Outgoing"))
            self.forceCheckBox.hide()
        
        self.resize(self.width(), 1)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
        
    def handleProtocol(self, protocol):
        """
        Private slot to switch the status of the directory selection button.
        """
        if str(protocol) == "file://":
            self.vcsDirButton.setEnabled(1)
        else:
            self.vcsDirButton.setEnabled(0)
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of a string (project directory) and a dictionary
            containing the data entered.
        """
        protocol = str(self.protocolCombo.currentText())
        if protocol == "file://":
            dest = unicode(self.vcsDirectoryEdit.text())
        else:
            dest = '%s%s' % (protocol, unicode(self.vcsDirectoryEdit.text())),
        return (dest, self.forceCheckBox.isChecked())
