# -*- coding: utf-8 -*-

# Copyright (c) 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a switch operation.
"""

from qt import *

from SwitchForm import SwitchForm

class HgSwitchDialog(SwitchForm):
    """
    Class implementing a dialog to enter the data for a switch operation.
    """
    def __init__(self, taglist, parent = None):
        """
        Constructor
        
        @param taglist list of previously entered tags (QStringList)
        @param parent parent widget (QWidget)
        """
        SwitchForm.__init__(self, parent, None, 1)
       
        dummy = self.trUtf8('dummy')
        
        self.tagCombo.clear()
        self.tagCombo.insertStringList(taglist)
        
    def getParameters(self):
        """
        Public method to retrieve the tag data.
        
        @return tag name (QString)
        """
        tagRev = self.tagCombo.currentText()
        if tagRev.isEmpty():
            return None
        else:
            return str(tagRev)
