# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the login data for CVS.
"""

from qt import *

from LoginForm import cvsLoginForm
from Config import ConfigCvsProtocols

class CvsLoginDialog(cvsLoginForm):
    """
    Class implementing a dialog to enter the login data for CVS.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        cvsLoginForm.__init__(self, parent, None, 1)
        
        self.validator = QIntValidator(self)
        self.portEdit.setValidator(self.validator)
        
        self.protocolComboBox.insertStringList(ConfigCvsProtocols)
        
        dummy = self.trUtf8('dummy')
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 6 strings (protocol, username,
            password, remote hostname, remote port and repository).
        """
        return (unicode(self.protocolComboBox.currentText()),
            unicode(self.usernameEdit.text()),
            unicode(self.passwordEdit.text()),
            unicode(self.hostEdit.text()),
            unicode(self.portEdit.text()),
            unicode(self.repositoryEdit.text())
        )
