# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a switch operation.
"""

from qt import *

from SwitchForm import SwitchForm

class CvsSwitchDialog(SwitchForm):
    """
    Class implementing a dialog to enter the data for a switch operation.
    """
    def __init__(self, taglist, parent = None):
        """
        Constructor
        
        @param taglist list of previously entered tags (QStringList)
        @param parent parent widget (QWidget)
        """
        SwitchForm.__init__(self, parent, None, 1)
       
        dummy = self.trUtf8('dummy')
        
        self.tagCombo.clear()
        self.tagCombo.insertStringList(taglist)
        
        self.cvsTagValidator = QRegExpValidator(QRegExp(r"[a-zA-Z][a-zA-Z0-9_-]*"), self)
        self.tagCombo.setValidator(self.cvsTagValidator)
        
    def getParameters(self):
        """
        Public method to retrieve the tag data.
        
        @return tag name (QString)
        """
        return self.tagCombo.currentText()
