# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog for entering repeat counts.
"""

from qt import *
from PyRegExpWizardRepeatForm import PyRegExpWizardRepeatForm


class PyRegExpWizardRepeatDialog(PyRegExpWizardRepeatForm):
    """
    Class implementing a dialog for entering repeat counts.
    """
    def __init__(self,parent = None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        PyRegExpWizardRepeatForm.__init__(self,parent)
        
        self.repetitionsGroup.setButton(0)
        
        dummy = self.trUtf8("Dummy")
        
    def getRepeat(self):
        """
        Public method to retrieve the dialog's result.
        
        @return ready formatted repeat string (string)
        """
        selected = self.repetitionsGroup.selectedId()
        
        if self.minimalCheckBox.isChecked():
            minimal = "?"
        else:
            minimal = ""
            
        # These ids must be kept in sync with the dialog
        if selected == 0:
            return "*" + minimal
        elif selected == 1:
            reps = self.minSpin.value()
            if reps == 1:
                return "+" + minimal
            else:
                return "{%d,}%s" % (reps, minimal)
        elif selected == 2:
            reps = self.maxSpin.value()
            if reps == 1:
                return "?" + minimal
            else:
                return "{,%d}%s" % (reps, minimal)
        elif selected == 3:
            reps = self.exactSpin.value()
            return "{%d}%s" % (reps, minimal)
        elif selected == 4:
            repsMin = self.lowerSpin.value()
            repsMax = self.upperSpin.value()
            return "{%d,%d}%s" % (repsMin, repsMax, minimal)
