#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric4 Configure

This is the main Python script to configure the eric4 IDE from the outside.
"""

import sys, os

if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    os.environ["e3nokde"] = "1"

from Utilities import Startup

import Preferences


def createMainWidget(argv, qtDir):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @param qtDir directory of the Qt installation (string)
    @return reference to the main widget (QWidget)
    """
    from Preferences.ConfigurationDialog import ConfigurationDialog
    return ConfigurationDialog(fromEric=0)

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric3 configure",
                                  "",
                                  "Configuration editor for eric3",
                                  options)
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget)
    sys.exit(res)

if __name__ == '__main__':
    main()
