#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric3 TR Previewer

This is the main Python script that performs the neccessary initialization
of the tr previewer and starts the Qt event loop. This is a standalone version
of the integrated tr previewer.
"""

import sys, os

if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    os.environ["e3nokde"] = "1"

from Tools.TRSingleApplication import TRSingleApplicationClient
from Utilities import Startup

def createMainWidget(argv, qtDir):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @param qtDir directory of the Qt installation (string)
    @return reference to the main widget (QWidget)
    """
    from Tools.TRPreviewer import TRPreviewer
    
    if len(argv) > 1:
        files = argv[1:]
    else:
        files = []
    
    previewer = TRPreviewer(files, None, 'TRPreviewer')
    return previewer

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric3 TR Previewer",
                                  "file",
                                  "TR file previewer",
                                  options)
    
    client = TRSingleApplicationClient()
    res = client.connect()
    if res > 0:
        if len(sys.argv) > 1:
            client.processArgs(sys.argv[1:])
        sys.exit(0)
    elif res < 0:
        print "eric3-trpreviewer: %s" % client.errstr()
        sys.exit(res)
    else:
        res = Startup.simpleAppStartup(sys.argv,
                                       appinfo,
                                       createMainWidget,
                                       [('!+file', '')])
        sys.exit(res)

if __name__ == '__main__':
    main()
