# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the EditorCalltips configuration page.
"""

from PyQt4.Qsci import QsciScintilla

from ConfigurationPageBase import ConfigurationPageBase
from Ui_EditorCalltipsPage import Ui_EditorCalltipsPage

import Preferences

class EditorCalltipsPage(ConfigurationPageBase, Ui_EditorCalltipsPage):
    """
    Class implementing the EditorCalltips configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("EditorCalltipsPage")
        
        # set initial values
        self.ctEnabledCheckBox.setChecked(\
            Preferences.getEditor("CallTipsEnabled"))
        self.ctVisibleSlider.setValue(\
            Preferences.getEditor("CallTipsVisible"))
        
        ctContext = Preferences.getEditor("CallTipsStyle")
        if ctContext == QsciScintilla.CallTipsNoContext:
            self.ctNoContextButton.setChecked(True)
        elif ctContext == QsciScintilla.CallTipsNoAutoCompletionContext:
            self.ctNoAutoCompletionButton.setChecked(True)
        elif ctContext == QsciScintilla.CallTipsContext:
            self.ctContextButton.setChecked(True)
        
    def save(self):
        """
        Public slot to save the EditorCalltips configuration.
        """
        Preferences.setEditor("CallTipsEnabled",
            int(self.ctEnabledCheckBox.isChecked()))
        Preferences.setEditor("CallTipsVisible",
            self.ctVisibleSlider.value())
        
        if self.ctNoContextButton.isChecked():
            Preferences.setEditor("CallTipsStyle", 
                                  QsciScintilla.CallTipsNoContext)
        elif self.ctNoAutoCompletionButton.isChecked():
            Preferences.setEditor("CallTipsStyle", 
                                  QsciScintilla.CallTipsNoAutoCompletionContext)
        elif self.ctContextButton.isChecked():
            Preferences.setEditor("CallTipsStyle", 
                                  QsciScintilla.CallTipsContext)
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = EditorCalltipsPage()
    return page
