# -*- coding: utf-8 -*-

# Copyright (c) 2004 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing templates for the documentation generator (lists style).
"""

#################################################
##  Common templates for index and docu files  ##
#################################################

headerTemplate = '''
    <!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Strict//EN'
    'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'>
    <html><head>
    <title>%(Title)s</title>
    </head>
    <body bgcolor="#FFFFFF">
'''

footerTemplate = '''
    </body></html>
'''

#########################################
##  Templates for documentation files  ##
#########################################

moduleTemplate = '''
    <a NAME="top" ID="top"></a>
    <h1><font color="#0000FF">%(Module)s</font></h1>
    %(ModuleDescription)s
    <h3><font color="#FF0000">Classes</font></h3>
    %(ClassList)s
    <h3><font color="#FF0000">Functions</font></h3>
    %(FunctionList)s
    <hr />
'''

classTemplate = '''
    <a NAME="%(Class)s" ID="%(Class)s"></a>
    <h2><font color="#0000FF">%(Class)s</font></h2>
    %(ClassDescription)s
    <h3><font color="#FF0000">Derived from</font></h3>
    %(ClassSuper)s
    <h3><font color="#FF0000">Methods</font></h3>
    %(MethodList)s
    <p>%(MethodDetails)s</p>
    <div align="right"><a href="#top">Up</a></div>
    <hr />
'''

methodTemplate = '''
    <a NAME="%(Class)s%(Method)s" ID="%(Class)s%(Method)s"></a>
    <h3><font color="#0000FF">%(Class)s.%(Method)s</font></h3>
    <b>%(Method)s</b>(<i>%(Params)s</i>)
    %(MethodDescription)s
'''

constructorTemplate = '''
    <a NAME="%(Class)s%(Method)s" ID="%(Class)s%(Method)s"></a>
    <h3><font color="#0000FF">%(Class)s (Constructor)</font></h3>
    <b>%(Class)s</b>(<i>%(Params)s</i>)
    %(MethodDescription)s
'''

functionTemplate = '''
    <a NAME="%(Function)s" ID="%(Function)s"></a>
    <h2><font color="#0000FF">%(Function)s</font></h2>
    <b>%(Function)s</b>(<i>%(Params)s</i>)
    %(FunctionDescription)s
    <div align="right"><a href="#top">Up</a></div>
    <hr />
'''

listTemplate = '''
    <table>
    %(Entries)s
    </table>
'''

listEntryTemplate = '''
    <tr>
    <td><a href="#%(Link)s">%(Name)s</a></td>
    <td>%(Deprecated)s%(Description)s</td>
    </tr>
'''

listEntryNoneTemplate = '''
    <tr><td>None</td></tr>
'''

listEntryDeprecatedTemplate = '''
    <b>Deprecated.</b>
'''

descriptionTemplate = '''
    %(Description)s
    %(Parameters)s
    %(Returns)s
    %(Exceptions)s
    %(Signals)s
'''

paragraphTemplate = '''
    <p>
    %(Lines)s
    </p>
'''

parametersListTemplate = '''
    <dl>
    %(Parameters)s
    </dl>
'''

parametersListEntryTemplate = '''
    <dt><i>%(Name)s</i></dt>
    <dd>
    %(Description)s
    </dd>
'''

returnsTemplate = '''
    <dl>
    <dt>Returns:</dt>
    <dd>
    %s
    </dd>
    </dl>
'''

exceptionsListTemplate = '''
    <dl>
    %(Exceptions)s
    </dl>
'''

exceptionsListEntryTemplate = '''
    <dt>Raises <b>%(Name)s</b>:</dt>
    <dd>
    %(Description)s
    </dd>
'''

signalsListTemplate = '''
    <h4>Signals</h4>
    <dl>
    %(Signals)s
    </dl>
'''

signalsListEntryTemplate = '''
    <dt>%(Name)s</dt>
    <dd>
    %(Description)s
    </dd>
'''

deprecatedTemplate = '''
    <p>
    <b>Deprecated.</b>
    %(Lines)s
    </p>
'''

#################################
##  Templates for index files  ##
#################################

indexBodyTemplate = '''
    <h1><font color="#0000FF">%(Title)s</font></h1>
    %(Description)s
    %(Subpackages)s
    %(Modules)s
'''

indexListPackagesTemplate = '''
    <h3><font color="#FF0000">Packages</font></h3>
    <table>
    %(Entries)s
    </table>
'''

indexListModulesTemplate = '''
    <h3><font color="#FF0000">Modules</font></h3>
    <table>
    %(Entries)s
    </table>
'''

indexListEntryTemplate = '''
    <tr>
    <td><a href="%(Link)s">%(Name)s</a></td>
    <td>%(Description)s</td>
    </tr>
'''
