# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to add files of a directory to the project.
"""

from qt import *

from AddDirectoryForm import AddDirForm

class AddDirectoryDialog(AddDirForm):
    """
    Class implementing a dialog to add files of a directory to the project.
    """
    def __init__(self,pro,filter='py',parent = None,name = None,
                 modal = 0,fl = 0):
        """
        Constructor
        
        @param pro reference to the project object
        @param filter file type filter (string or QString)
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        @param modal flag for a modal dialog (boolean)
        @param fl window flags
        """
        AddDirForm.__init__(self,parent,name,1,fl)
        
        self.targetDirEdit.setText(pro.ppath)
        self.ppath = pro.ppath
        if filter == 'py':
            filterList = QStringList.split(';;', self.trUtf8(\
                            "Python Files (*.py);;Quixote PTL Files (*.ptl)"))
        elif filter == 'ui':
            filterList = QStringList.split(';;', self.trUtf8(\
                            "Qt User-Interface Files (*.ui);;"))
        elif filter == 'idl':
            filterList = QStringList.split(';;', self.trUtf8(\
                            "Interface Files (*.idl);;"))
        else:
            filterList == QStringList()
        self.filterComboBox.insertStringList(filterList)
        fi = '(*.%s)' % str(filter)
        index = 0
        for filterItm in filterList:
            if filterItm.endsWith(fi):
                break
            index += 1
        self.filterComboBox.setCurrentItem(index)
        
    def handleDirDialog(self, textEdit):
        """
        Private slot to display a directory selection dialog.
        
        @param textEdit field for the display of the selected directory name
                (QLineEdit)
        """
        directory = QFileDialog.getExistingDirectory(self.targetDirEdit.text(),
            self, None, self.trUtf8("Select target directory"), 1)
            
        if not directory.isNull():
            textEdit.setText(QDir.convertSeparators(directory))
            
    def handleSDirDialog(self):
        """
        Private slot to handle the source dir button press.
        """
        self.handleDirDialog(self.sourceDirEdit)
        
    def handleTDirDialog(self):
        """
        Private slot to handle the target dir button press.
        """
        self.handleDirDialog(self.targetDirEdit)
        
    def handleSTextChanged(self, dir):
        """
        Private slot to handle the source dir text changed.
        
        If the entered source directory is a subdirectory of the current
        projects main directory, the target directory path is synchronized.
        It is assumed, that the user wants to add a bunch of files to
        the project in place.
        
        @param dir the text of the source directory line edit
        """
        if dir.startsWith(self.ppath):
            self.targetDirEdit.setText(dir)
            
    def getData(self):
        """
        Public slot to retrieve the dialogs data.
        
        @return tuple of four values (string, string, string, boolean) giving
            the selected file extension, the source and target directory and
            a flag indicating a recursive add
        """
        selectedFilter = self.filterComboBox.currentText()
        ext = selectedFilter.section('(*.',1,1).section(')',0,0)
        return (str(ext), str(self.sourceDirEdit.text()), 
            str(self.targetDirEdit.text()),
            self.recursiveCheckBox.isChecked())
