# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to select the zoom scale.
"""

from qt import *

from ZoomForm import ZoomForm

class ZoomDialog(ZoomForm):
    """
    Class implementing a dialog to select the zoom scale.
    """
    def __init__(self,zoom,parent,name=None,modal=0,fl=0):
        """
        Constructor
        
        @param zoom zoom factor to show in the spinbox
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        @param modal flag indicating a modal dialog
        @param fl window flags
        """
        ZoomForm.__init__(self,parent,name,modal,fl)
            
        dummy = self.trUtf8('dummy')
        
        self.zoomSpinBox.setValue(zoom)
        
    def getZoomSize(self):
        """
        Public method to retrieve the zoom size.
        
        @return zoom size (int)
        """
        return self.zoomSpinBox.value()
