# -*- coding: utf-8 -*-

# Copyright (c) 2004 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing an icon provider for QFileDialog.
"""

from qt import QFileIconProvider, QPixmap, QFileDialog

import UI.PixmapCache

class IconProvider(QFileIconProvider):
    """
    Class providing icons to QFileDialog.

    The icons provided are for Python (*.py, *.pyx, *.ptl)), Qt-Designer (*.ui),
    QT-Linguist (*.ts), IDL (*.idl), graphics, eric3 keyboard shortcuts (*.e3k, *.e3kz), 
    and eric3 project (*.e3p, *.e3pz) files.
    """
    def __init__(self):
        """
        Constructor
        """
        QFileIconProvider.__init__(self)
        
        # generate file icons for later use
        self.iconFilePython = UI.PixmapCache.getPixmap("filePython")
        self.iconFilePython2 = UI.PixmapCache.getPixmap("filePython2")
        self.iconFileDesigner = UI.PixmapCache.getPixmap("fileDesigner")
        self.iconFileLinguist = UI.PixmapCache.getPixmap("fileLinguist")
        self.iconFileProject = UI.PixmapCache.getPixmap("fileProject")
        self.iconFileIDL = UI.PixmapCache.getPixmap("fileIDL")
        self.iconFilePixmap = UI.PixmapCache.getPixmap("filePixmap")
        self.iconFileShortcuts = UI.PixmapCache.getPixmap("fileShortcuts")

    def pixmap(self,finfo):
        """
        Method to retrieve the pixmap for a file.
        
        @param finfo The file info object. (QFileInfo)
        @return The pixmap for the file. (QPixmap)
        """
        ext = str(finfo.extension())
        if ext == 'py':
            pm = self.iconFilePython
        elif ext in ['pyx', 'ptl']:
            pm = self.iconFilePython2
        elif ext == 'ui':
            pm = self.iconFileDesigner
        elif ext in ['ts', 'qm']:
            pm = self.iconFileLinguist
        elif ext in ['e3p', 'e3pz']:
            pm = self.iconFileProject
        elif ext == 'idl':
            pm = self.iconFileIDL
        elif ext in ['png', 'jpg', 'xpm', 'bmp', 'xbm', 'pnm', 'pbm',
                     'pgm', 'ppm', 'gif', 'mng']:
            pm = self.iconFilePixmap
        elif ext in ['e3k', 'e3kz']:
            pm = self.iconFileShortcuts
        else:
            pm = None

        return pm
