# -*- coding: utf-8 -*-

"""
Module implementing a dialog for entering repeat counts.
"""

from qt import *
from QRegExpWizardRepeatForm import QRegExpWizardRepeatForm


class QRegExpWizardRepeatDialog(QRegExpWizardRepeatForm):
    """
    Class implementing a dialog for entering repeat counts.
    """
    def __init__(self,parent = None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        QRegExpWizardRepeatForm.__init__(self,parent)
        
        self.repetitionsGroup.setButton(0)
        
        dummy = self.trUtf8("Dummy")
        
    def getRepeat(self):
        """
        Public method to retrieve the dialog's result.
        
        @return ready formatted repeat string (string)
        """
        selected = self.repetitionsGroup.selectedId()
        
        # These ids must be kept in sync with the dialog
        if selected == 0:
            return "*"
        elif selected == 1:
            reps = self.minSpin.value()
            if reps == 1:
                return "+"
            else:
                return "{%d,}" % reps
        elif selected == 2:
            reps = self.maxSpin.value()
            if reps == 1:
                return "?"
            else:
                return "{,%d}" % reps
        elif selected == 3:
            reps = self.exactSpin.value()
            return "{%d}" % reps
        elif selected == 4:
            repsMin = self.lowerSpin.value()
            repsMax = self.upperSpin.value()
            return "{%d,%d}" % (repsMin, repsMax)
