# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the highlevel wizard functions.
"""

import sys
import os
import glob

from ThirdParty.XMLFilter import parseFilePath

from qt import *

from WizardHandler import WizardHandler

class Wizards(QObject):
    """
    Class implementing the highlevel wizard functions.
    """
    def __init__(self, loc, parent = None):
        """
        Constructor
        
        @param loc the localizer string as determined by the main script (string)
        """
        QObject.__init__(self, parent)
        self.registeredWizards = []
        self.registeredTranslators = []
        self.locale = loc
        self.init()
       
        
    def init(self):
        """
        Private method to register all the wizards.
        """
        ericDir = os.path.dirname(sys.argv[0])
        if ericDir == '':
            ericDir = '.'
        wizDir = os.path.abspath(os.path.join(ericDir, 'Wizards'))
        wizFile = os.path.join(wizDir, "Wizards.e3w")
        
        handler = WizardHandler(self, wizDir, self.locale)
        
        try:
            parseFilePath(wizFile, handler)
        except IOError:
            print "Couldn't read the wizards configuration file."
        
    def initMenu(self):
        """
        Public slot to initialize the wizards menu.
        
        @return the generated menu
        """
        menu = QPopupMenu(self.parent())
        menu.insertTearOffHandle()
        
        for wizard in self.registeredWizards:
            if wizard == None:
                menu.insertSeparator()
            else:
                action = wizard.getAction()
                action.addTo(menu)
                        
        return menu
        
    def getCurrentEditor(self):
        """
        Public method to get a reference to the current editor.
        
        @return the current editor
        """
        return  self.parent().getViewManager().activeWindow() 
        
    def getActions(self):
        """
        Public method to get a list of all actions.
        
        @return list of all actions (list of QAction)
        """
        actionList = []
        for act in self.queryList("QAction"):
            if not isinstance(act, QActionGroup):
                actionList.append(act)
                
        return actionList
