# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module defining the wizards interface to be implemented by individual wizards.
"""

from qt import QObject, QAction

class WizardIFace(QObject):
    """
    Base class defining the wizards interface to be implemented by individual wizards.
    
    Any child class has to implement these class methods:
        <dl>
        <dt>handle</dt><dd>the function to be executed</dd>
        <dt>getAction</dt><dd>returns the action associated</dd>
        </dl>
    """
    def __init__(self, parent = None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        QObject.__init__(self, parent)
    
    def handle(self):
        """
        Worker method associated with the wizard action 
        """
        raise RuntimeError, 'Not implemented'

    def getAction(self):
        '''
        Public method to get the action associated with this class wizard. 
        
        The following is an example.
        
        <pre>
        self.action = QAction(self.trUtf8("Sample Wizard"),
             self.trUtf8("&Sample Wizard..."), 0, self)
        self.action.setStatusTip(self.trUtf8("Sample wizard"))
        self.action.setWhatsThis(self.trUtf8(
            """&lt;b&gt;Wizard&lt;/b&gt;"""
            """&lt;p&gt;Sample wizard&lt;/p&gt;"""
        ))
        self.connect(self.action, SIGNAL("activated()"), self.handle)
        return self.action
        </pre>
        
        @return the associated action
        '''
        raise RuntimeError, 'Not implemented'
