"""

This is the main part of ERoaster


"""

# ----------------------------------------------------------------------
# Import functions I need 

# Initialize i18n
from constants import localedir, unixname
from tools import gettext

gettext = gettext(unixname, localedir)
gettext.textdomain(unixname)
_ = gettext.gettext

# Check environment
from os import environ
from sys import platform

if ((platform != "win32") and (not environ.has_key("DISPLAY"))):              
    # This happens when started in a console on non win32 platforms
    raise ImportError, _("DISPLAY environment variable not set")

from os import popen, system, unlink
from socket import socket, SOCK_STREAM, AF_INET, error
from string import strip, find, split, lower, rjust, atoi, atof, replace, digits, zfill, join
from sys import exit, argv
from types import StringType
from time import sleep, strftime, localtime, time, strptime, asctime
from log4py import Logger
from re import sub, match
from lame import lame
from cdrdao import cdrdao
from bchunk import bchunk
from oggvorbis import ogginfo, oggenc
from process import ProcessTable, FILTERMODESUB
from ExecutionThread import ExecutionThread
from Project import Project
# from Preferences import Preferences

import sys
import getopt
import log4py
import cdrtools

sys_argv = sys.argv
sys.argv = [argv[0]]                              # remove all arguments, so gnome_init remains silent

# this is for installations with both python-gtk versions
try:
    import pygtk
    pygtk.require('2.0')
except:
    pass

# this way we get nice gtk error messages instead of having the text in the console
import gtkexcepthook

try:
    import gtk
    # import gtk.glade
    # import gnome.ui
except (RuntimeError, TypeError, NameError), detail:
    cat = Logger().get_instance()
    cat.error(_("An error occured: %s") % detail)
    exit(1)

from ConfigParser import ConfigParser
from select import select
from time import sleep, time, asctime, localtime
from tempfile import mktemp, tempdir
from urllib import unquote

from tools import bool2str, str2bool, striplist, nicetime, du, cmdoutput
from tools import cleanlist, which, filecopy, mkdirtree, touch, listmatch, rm, escapedfilename
from tools import get_username, get_tempdir, cmdexec

try:
    import gtk as gnome
    import gnome.tools
except:
    import gnometools
    gnome.tools = gnometools

from constants import title, version, frames, datacd, audiocd, imagecd, options, special, readcd, copycd
from constants import iconpath, deffile, ecat, modeFixateCD, playerZinf, waitreload, eraCDImage
from constants import DataCD, modeDataCDImage, AudioCD, modeImageCD, modeCopyCD, modeReadCD
from constants import modeReadAudioCD, modeImageCDcdrdao, data_file_list, execution_thread_done
from constants import year, deviceRecorder, deviceReader, playerMpg123, playerXMMS # socketport
from constants import BlankCDAll, BlankCDMinimal, BlankCDLast, audioinfostring, cdrSize650, cdrSize700
from constants import shortcutfile, systemshortcutfile, configdirectory, eraDataCD, eraAudioCD, eraCopyCD
from constants import encoderLame, encoderOggEnc, tipstatusfile, tips, version_short

import os
import popen2
import re
import copy
import wave
import MP3Info

try:
    import DiscID
    import CDDB
    cddb_available = gtk.TRUE
except ImportError:
    cddb_available = gtk.FALSE
    cat = Logger().get_instance()
    cat.warn(_("Python CDDB support not available"))

waitreload_lockfile = "%s%s%s%s.eroaster.waitreload.lock" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep)
if (sys.platform == "win32"):
    python_executable = which("python")
    if (python_executable == ""):
        cat = Logger().get_instance()
        cat.error(_("The python executable has to be in the PATH on win32 platforms!"))
        exit(1)
    pipe_ecat = "| %s %s" % (python_executable, ecat)
else:
    pipe_ecat = "| %s" % ecat

# -----------------------------------------------------------------------------
# This is the EROaster main class

class Application:

    def __init__(self):

        # Initialize threads
        try:
            gtk.threads_init()
        except RuntimeError:
            gnome.tools.ErrorDialog(_("Note: pygtk threading is disabled. ERoaster requires a thread-enabled installation of pygtk and python to work correctly.\n\nTo compile pygtk and python with threads enabled, use 'configure --enable-thread'"))
            sys.exit(1)

        # Initialize a Logger instance
        self.cat = Logger().get_instance(self)
        self.cat.set_loglevel(log4py.LOGLEVEL_NORMAL)

        # Check wether there is already an instance of eroaster running
        result = self.__Application_Check_Instance_running()
        if (result == gtk.TRUE):
            sys.exit(1)

        # Some necessary Variables
        self.parser = ConfigParser()                        # The Configuration File Parser
        self.project = Project()
        self.writermode = None                              # Data CD or Audio CD
        self.InitVariables()
        self.burnwindow = None                              # There's no burn window at the beginning

        self.parsecmdline()

        self.formataudio =          re.compile("Track ([ \d]+): ([ \d]+) of ([ \d]+) MB written\.")
        self.formataudiolong =      re.compile("Track ([ \d]+): ([ \d]+) of ([ \d]+) MB written \(fifo ([ \d]+)%\)")
        # self.formataudiolong =      re.compile("Track ([ \d]+): ([ \d]+) of ([ \d]+) MB written( \(fifo ([ \d]+)%\))?")
        self.formatdata =           re.compile("Track ([ \d]+): ([ \d]+) MB written\.$")
        self.formatdatalong =       re.compile("Track ([ \d]+): ([ \d]+) MB written ([ \d\.]+)% done, estimate finish")
        self.formatdatafifo =       re.compile("Track ([ \d]+): ([ \d]+) MB written \(fifo ([ \d]+)%\)")
        self.formatignore =         re.compile("([\d\.]+)% done, estimate|.*\d second")
        self.formatimage =          re.compile("([\d\.]+)% done, estimate finish")
        self.formatreadimage =      re.compile("addr: ([ \d]+) cnt:( \d+)")
        self.formatreadimageend =   re.compile("end: ([ \d]+)")
        self.formatreadaudio =      re.compile("([ \d]+)%")
        self.formatignorecopy =     re.compile("Track ([ \d]+): ([ \d]+) MB written.addr")
        self.formatreadaudioinfo =  re.compile(audioinfostring)
        self.formatwritecuecdrdao = re.compile("Wrote (\d+) of (\d+) MB \(Buffer (\d+)%\).")

        # Create the main window
        self.__Application_create_window()
        self.window.add(self.metabox)

        # Create a status bar
        self.statusbar = gtk.Statusbar()
        self.statusbar.show()
        self.statusbar.push(self.statusbar.get_context_id("main"), _(" Welcome to the %s %s (c) %s by Martin Preishuber" % (title, version, year)))

        # Box which holds the button list and tabs
        self.mainbox = gtk.VBox(spacing = 3)
        self.mainbox.set_border_width(3)
        self.metabox.pack_start(self.mainbox)
        self.metabox.pack_start(self.statusbar)
        self.mainbox.show()

        self.notebook = gtk.Notebook()
        self.notebook.set_show_tabs(gtk.FALSE)
        self.notebook.set_show_border(gtk.FALSE)
        hbox = gtk.HBox(spacing = 0)
        clist = self.__Application_create_shortcuts()
        hbox.pack_start(clist, expand = gtk.FALSE)
        hbox.pack_start(self.notebook)
        self.mainbox.pack_start(hbox)
        self.notebook.show()

        self.setstatustip = gtk.FALSE
        self.notebook.connect("switch_page", self.ShowStatusbarTips)

        # Create the Frames:
        for i in range(len(frames)):
            self.CreateFrame(frames[i])

        # Define entry fields & stuff which gets set per default
        self.LoadOptions()
        self.handle_startup_files()
        self.setstatustip = gtk.TRUE
        # self.__Application_preferences = preferences.Preferences()

    def __Application_Check_Instance_running(self):
        """ check wether there is already a copy of eroaster running. """
        if (sys.platform == "win32"):
            self.cat.warn("Can't read process table on win32 platform")
            return gtk.FALSE

        processes = ProcessTable(loglevel = self.cat.get_loglevel())
        processes.read()
        processes.filter(filters = {"cmd": "eroaster"}, filtermode = FILTERMODESUB)
        pids = processes.pids()
        if (len(pids) > 1):
            dialog = gnome.tools.QuestionDialog(_("There is already a copy of ERoaster running. Do you want to continue ?"))
            result = dialog.get_result()
            if (result == gtk.RESPONSE_YES):
                return gtk.FALSE
            else:
                return gtk.TRUE
        else:
            return gtk.FALSE

    def __Application_create_shortcuts(self):
        """ Create shortcut bar. """
        clist = gtk.CList(1, [ " Shortcuts " ])
        clist.set_column_justification(0, gtk.JUSTIFY_CENTER)
        clist.set_row_height(50)
        clist.connect("select_row", self.__Application_shortcut_show_page)
        icons = ["datacd.xpm", "audiocd.xpm", "isoimage.xpm", "readcd.xpm", "copycd.xpm", "special.xpm", "preferences.xpm"]
        for i in range(len(icons)):
            clist.append(icons[i])
            gdkcolor = gnome.tools.hex2gdkcolor(self.window, "#7b7b7b")
            if (gdkcolor != None):
                clist.set_background(i, gdkcolor)
            if (icons[i] != " "):
                icon, mask = gnome.tools.create_pixmap(self.window, "%s%s%s" % (iconpath, os.sep, icons[i]))
                clist.set_pixmap(i, 0, icon, mask)
        return clist

    def __Application_shortcut_show_page(self, clist, column, row, event):
        self.notebook.set_current_page(column)

    def __Application_get_menu(self):
        """ Create the main menu. """

        # File SubMenu
        miFileExit = gtk.ImageMenuItem(stock_id = gtk.STOCK_QUIT)
        miFileExit.connect('activate', self.Destroy)
        miFileExit.show()

        file_submenu = gtk.Menu()
        file_submenu.add(miFileExit)
        file_submenu.show()

        miFile = gtk.MenuItem(_("_File"))
        miFile.set_submenu(file_submenu)
        miFile.show()

        # Project SubMenu
        miNewProject = gtk.ImageMenuItem(stock_id = gtk.STOCK_NEW)
        miNewProject.connect('activate', self.ProjectNew)
        miNewProject.show()

        miOpenProject = gtk.ImageMenuItem(stock_id = gtk.STOCK_OPEN)
        miOpenProject.connect('activate', self.ProjectOpen)
        miOpenProject.show()

        miSaveProject = gtk.ImageMenuItem(stock_id = gtk.STOCK_SAVE)
        miSaveProject.connect('activate', self.ProjectSave)
        miSaveProject.show()

        miCloseProject = gtk.ImageMenuItem(stock_id = gtk.STOCK_CLOSE)
        miCloseProject.connect('activate', self.ProjectClose)
        miCloseProject.show()

        project_submenu = gtk.Menu()
        project_submenu.add(miNewProject)
        project_submenu.add(miOpenProject)
        project_submenu.add(miSaveProject)
        project_submenu.add(miCloseProject)
        project_submenu.show()

        miProject = gtk.MenuItem(_("_Project"))
        miProject.set_submenu(project_submenu)
        miProject.show()

        # Edit SubMenu
        miSelectAll = gtk.MenuItem(_("Select _all"))
        miSelectAll.connect('activate', self.SelectAll)
        miSelectAll.show()

        miUnselectAll = gtk.MenuItem(_("_Unselect all"))
        miUnselectAll.connect('activate', self.UnSelectAll)
        miUnselectAll.show()

        edit_submenu = gtk.Menu()
        edit_submenu.add(miSelectAll)
        edit_submenu.add(miUnselectAll)
        edit_submenu.show()

        miEdit = gtk.MenuItem(_("_Edit"))
        miEdit.set_submenu(edit_submenu)
        miEdit.show()

        # Help SubMenu
        miTipOfDay = gtk.MenuItem(_("_Tip of the day ..."))
        miTipOfDay.connect('activate', self.HelpShowTips)
        miTipOfDay.show()

        miAbout = gtk.MenuItem(_("_About ..."))
        miAbout.connect('activate', self.About)
        miAbout.show()

        help_submenu = gtk.Menu()
        help_submenu.add(miTipOfDay)
        help_submenu.add(miAbout)
        help_submenu.show()

        miHelp = gtk.ImageMenuItem(stock_id = gtk.STOCK_HELP)
        miHelp.set_submenu(help_submenu)
        miHelp.show()

        menubar = gtk.MenuBar()
        menubar.add(miFile)
        menubar.add(miProject)
        menubar.add(miEdit)
        menubar.add(miHelp)
        menubar.show()

        return menubar

    def __Application_get_toolbar(self):
        toolbar = gtk.Toolbar()
        toolbar.append_item("Burn CD", "Burn CD", None, gnome.tools.create_image(self.window, "%s%sburn.xpm" % (iconpath, os.sep)), self.BurnCD, None)
        toolbar.append_item("Create Image", "Create Image", None, gnome.tools.create_image(self.window, "%s%screateimage.xpm" % (iconpath, os.sep)), self.CreateImage, None)
        toolbar.append_space()
        toolbar.insert_stock(gtk.STOCK_ADD, "Add one or more files", None, self.__Application_Toolbar_Add, None, -1)
        toolbar.insert_stock(gtk.STOCK_REMOVE, "Remove one or more files", None, self.__Application_Toolbar_Remove, None, -1)
        toolbar.append_space()
        toolbar.append_item("Select All", "Select all files", None, gnome.tools.create_image(self.window, "%s%sselect.xpm" % (iconpath, os.sep)), self.SelectAll, None)
        toolbar.append_item("AutoSelect", "Automatically select the optimal amount of files", None, gnome.tools.create_image(self.window, "%s%sautoselect.xpm" % (iconpath, os.sep)), self.__Application_Toolbar_AutoSelect, None)
        toolbar.append_item("Unselect All", "Unselect all files", None, gnome.tools.create_image(self.window, "%s%sunselect.xpm" % (iconpath, os.sep)), self.UnSelectAll, None)
        toolbar.append_space()
        toolbar.insert_stock(gtk.STOCK_QUIT, "Quit ERoaster", None, self.Destroy, None, -1)
        toolbar.show()

        hbToolbar = gtk.HandleBox()
        hbToolbar.add(toolbar)
        hbToolbar.show()

        return hbToolbar

    def __Application_create_window(self):
        self.window = gtk.Window()
        self.window.set_role("eroaster")
        self.window.set_title("%s %s" % (title, version))
        self.window.connect("destroy", self.Destroy)
        self.window.set_border_width(1)

        # Initialize the Main Box
        self.metabox = gtk.VBox()
        self.metabox.pack_start(self.__Application_get_menu(), expand = gtk.FALSE)
        self.metabox.pack_start(self.__Application_get_toolbar(), expand = gtk.FALSE)
        self.metabox.show()

    def __Application_show_preferences(self, uic, verbname = None, win = None):
        """ Show the preferences window. """
        infoDialog = gnome.tools.InfoDialog("Note: The new preferences are not functional yet.")
        # self.__Application_preferences.show_window()

    def InitVariables(self):
        self.totalaudiosize = 0L                            # Total size of audio tracks
        self.totaltracklength = 0                           # Total length of audio tracks
        self.tracklength = {}                               # Dictionary containing the length of tracks
        self.tracksize = {}                                 # Dictionary containing the size of tracks
        self.datafilesize = {}                              # Dictionary containing the size of data files
        self.totaldatasize = 0L                             # Total size of data files
        self.selecteddatasize = 0L                          # Size of selected data files
        self.nraudiotracks = 0                              # Number of audio tracks
        self.cddb_info = {}                                 # CDDB Information

    def handle_startup_files(self):
        if (self.startup_burnmode == eraAudioCD):
            self.notebook.set_page(1)
            for i in range(len(self.startup_burnfiles)):
                self.AddFileToList(self.startup_burnfiles[i])
            self.BurnCD(None)
        elif (self.startup_burnmode == eraDataCD):
            self.notebook.set_page(0)
            for i in range(len(self.startup_burnfiles)):
                self.AddDataFileToList(self.startup_burnfiles[i])
            self.CalculateOptimize(None)
            self.BurnCD(None)
        elif (self.startup_burnmode == eraCopyCD):
            self.notebook.set_page(4)
            self.BurnCD(None)
        elif (self.startup_burnmode == eraCDImage):
            self.notebook.set_page(2)
            self.cdimage.set_text(gnome.tools.iso2utf(self.startup_burnfiles[0]))
            self.ImageInfo(None)
            self.BurnCD(None)
        else:
            self.window.show_all()
            self.__Application_show_tip_window()

    def __Application_show_tip_window(self, showAlways = gtk.FALSE):
        tip_window = gnome.tools.TipWindow("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, tipstatusfile), tips, iconpath, title, showAlways)
        tip_window.show()

    def HelpShowTips(self, uic, verbname = None, win = None):
        self.__Application_show_tip_window(gtk.TRUE)

    def ProjectNew(self, uic, verbname = None, win = None):
        self.project.New()
        if (self.project.CancelPressed == gtk.FALSE):
            self.ClearLists()

    def ProjectOpen(self, uic, verbname = None, win = None):
        self.project.Open()
        if (self.project.CancelPressed == gtk.FALSE):
            self.ClearLists()
            self.volumeidaudio.set_text(self.project.AudioVolumeID)
            self.volumeid.set_text(self.project.DataVolumeID)
            self.songlist.freeze()
            for i in range(len(self.project.AudioFiles)):
                self.songlist.append(self.project.AudioFiles[i])
                icon, mask = gnome.tools.get_file_icon(self.project.AudioFiles[i][2], self.window, iconpath)
                self.songlist.set_pixmap(i, 0, icon, mask)
            self.ColorizeCList(self.songlist)
            self.songlist.thaw()
            self.datafiles.freeze()
            for i in range(len(self.project.DataFiles)):
                self.datafiles.append(self.project.DataFiles[i])
                icon, mask = gnome.tools.get_file_icon(self.project.DataFiles[i][1], self.window, iconpath)
                self.datafiles.set_pixmap(i, 0, icon, mask)
            self.ColorizeCList(self.datafiles)
            self.datafiles.thaw()
            self.audiosize.set_text(self.project.AudioSize)
            self.datasize.set_text(self.project.DataSize)
            self.totalaudiosize, self.totaltracklength, self.tracklength, self.tracksize, self.datafilesize, self.totaldatasize, self.nraudiotracks = self.project.OtherInfo

    def ProjectClose(self, uic, verbname = None, win = None):
        self.project.Close()
        self.ClearLists()

    def ProjectSave(self, uic, verbname = None, win = None):
        self.project.Clear()
        self.project.AudioVolumeID = self.volumeidaudio.get_text()
        self.project.DataVolumeID = self.volumeid.get_text()
        self.project.AudioSize = self.audiosize.get_text()
        self.project.DataSize = self.datasize.get_text()
        self.project.OtherInfo = (self.totalaudiosize, self.totaltracklength, self.tracklength,
                                    self.tracksize, self.datafilesize, self.totaldatasize, self.nraudiotracks)
        for i in range(self.datafiles.rows):
            name, size, mdtm = (self.datafiles.get_text(i, 1), self.datafiles.get_text(i, 2), self.datafiles.get_text(i, 3))
            self.project.DataFiles.append(["", name, size, mdtm])
        for i in range(self.songlist.rows):
            number, length, name = (self.songlist.get_text(i, 1), self.songlist.get_text(i, 2), self.songlist.get_text(i, 3))
            self.project.AudioFiles.append(["", number, length, name])
        self.project.Save()

    def ClearLists(self):
        self.songlist.clear()
        self.volumeidaudio.set_text("")
        self.datafiles.clear()
        self.volumeid.set_text("")
        self.audiosize.set_text("00:00")
        self.datasize.set_text("0 MB")
        self.datasizesel.set_text("0 MB")
        self.InitVariables()

    def ShowStatusbarTips(self, notebook, object, index):
        """ Set tips in the status bar. """
        if (self.setstatustip == gtk.TRUE):
            if (index == 0):
                message = _("Drag & drop some files to the \"Files / Directories\"-list and click AutoSelect")
            elif (index == 1):
                message = _("Drag & drop wave-, mp3- or ogg-files to the list and order it via Drag & Drop")
            elif (index == 2):
                message = _("Select an image and click on \"Image info\" for checking")
            elif (index == 3):
                message = _("Read the a CD image")
            elif (index == 4):
                message = _("Copy a CD")
            elif (index == 5):
                message = _("Perform special operations on CDs")
            elif (index == 6):
                message = _("Set the general preferences")
            self.statusbar.push(self.statusbar.get_context_id("main"), " %s" % message)

    def About(self, uic, verbname = None, win = None):
        """ Shows an about box. """
        description = _('ERoaster is a GNOME frontend for writing, copying and grabbing data and\naudio CDs using cdrecord, mkisofs and some other tools.')
        description = _("%s\n\nAvailable from:\nhttp://www.eclipt.at\nhttp://eroaster.sourceforge.net\nhttp://www.its4you.at\n") % description
        description = _("%s\nSend comments, bug reports or any other suggestions to the appropriate\naddress from the credits.") % description
        copyright = _('May be distributed under the terms of the GPL2')
        authors = ['Martin Preishuber (Martin.Preishuber@eclipt.at)']
        documented_by = []
        translated_by = [ "English: Martin Preishuber (Martin.Preishuber@eclipt.at)", "Spanish: Alvaro Lopez Ortega (alvaro@alobbs.com)" ]
        pixbuf = gtk.gdk.pixbuf_new_from_file ("%s/s2cps.xpm" % iconpath)
        gnome.tools.About(title, version_short, copyright, description, authors, documented_by, translated_by).show()
        # gnome.ui.About(title, version, copyright, description, authors, documented_by, translated_by, pixbuf).show()

    # Create the various frames
    def CreateFrame(self, name):

        vbox = gtk.VBox(spacing = 3)
        if (name == datacd):
            box = gnome.tools.Pixmap(self.window, "%s/master.xpm" % iconpath, name).get_hbox()
            self.BurnData(vbox)
        elif (name == audiocd):
            box = gnome.tools.Pixmap(self.window, "%s/audio.xpm" % iconpath, name).get_hbox()
            self.BurnAudio(vbox)
        elif (name == imagecd):
            box = gnome.tools.Pixmap(self.window, "%s/iso.xpm" % iconpath, name).get_hbox()
            self.BurnImage(vbox)
        elif (name == readcd):
            box = gnome.tools.Pixmap(self.window, "%s/read.xpm" % iconpath, name).get_hbox()
            self.ReadCDFrame(vbox)
        elif (name == copycd):
            box = gnome.tools.Pixmap(self.window, "%s/copy.xpm" % iconpath, name).get_hbox()
            self.CopyCDFrame(vbox)
        elif (name == special):
            box = gnome.tools.Pixmap(self.window, "%s/iso.xpm" % iconpath, name).get_hbox()
            self.SpecialOperation(vbox)
        elif (name == options):
            box = gnome.tools.Pixmap(self.window, "%s/options.xpm" % iconpath, name).get_hbox()
            self.Options(vbox)

        vbox.show()
        self.notebook.append_page(vbox, box)

    # Burn CD (menu entry)
    def BurnCD(self, uic, verbname = None, win = None):
        if (self.burnwindow != None):
            gnome.tools.ErrorDialog(_("Close the output window first !"))
            return gtk.FALSE
        page = self.notebook.get_current_page()

        if ((frames[page] == options) or (frames[page] == readcd) or (frames[page] == special)):
            gnome.tools.ErrorDialog(_("You can't burn a CD at this point !"))
            return gtk.FALSE
        result = gtk.TRUE

        if (frames[page] == datacd):
            self.writermode = DataCD
            if (self.cdsize650.get_active()):
                cdsize = 650
            elif (self.cdsize700.get_active()):
                cdsize = 700
            if (len(self.datafiles.selection)) == 0:
                if ((self.totaldatasize / 1024) <= cdsize):
                    strDialogText = _("You have not selected files & directories yet.\nSince all data fits on one CD, ERoaster can select all files and start burning now.\nDo you want to continue?")
                else:
                    strDialogText = _("You have not selected files & directories yet.\nSince all data is larger than the selected CD size, ERoaster can auto-select files and start burning now.\nDo you want to continue?")
                dialog = gnome.tools.QuestionDialog(strDialogText)
                if (dialog.get_result() == gtk.RESPONSE_YES):
                    self.CalculateOptimize(None)
                else:
                    return gtk.FALSE
            selectedsize = atoi(self.datasizesel.get_text()[:-3])
            if (selectedsize > cdsize):
                gnomequestiondialog = gnome.tools.QuestionDialog(_("Warning: You selected %s MB which is larger then your selected CD size (%s MB).\nAre you sure you want to continue ?") % (selectedsize, cdsize))
                result = gnomequestiondialog.get_result()
                if (result == gtk.RESPONSE_YES):
                    result = gtk.TRUE
                else:
                    result = gtk.FALSE

        elif (frames[page] == audiocd):
            self.writermode = AudioCD
            if (self.songlist.rows == 0):
                gnome.tools.ErrorDialog(_("You have to select some audio files first."))
                return gtk.FALSE

        elif (frames[page] == imagecd):
            image = gnome.tools.utf2iso(self.cdimage.get_text())
            if (not os.path.isfile(image)):
                gnome.tools.ErrorDialog(_("The image file \"%s\" is not valid.") % image)
                return gtk.FALSE
            extension = lower(os.path.splitext(image)[1])
            if (extension == ".cue"):
                self.writermode = modeImageCDcdrdao
            else:
                self.writermode = modeImageCD

        elif (frames[page] == copycd):
            self.writermode = modeCopyCD

        if (result == gtk.TRUE):
            self.SelectWritingOptions()

    # --------------------------------------------------------------------------
    # Open a window asking some questions about the CD creation
    def SelectWritingOptions(self):

        self.woptwindow = gtk.Window()
        self.woptwindow.set_title("CD-R/RW Options")
        self.woptwindow.set_border_width(3)
        self.woptwindow.show()

        vbox = gtk.VBox(spacing = 3)
        vbox.set_border_width(3)
        vbox.show()

        infoframe = gtk.Frame(_(" Summary "))
        infoframe.set_border_width(3)
        infoframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        infoframe.show()

        modeLabel = gtk.Label(_("Mode: "))
        modeLabel.set_alignment(1.0, 0.5)
        modeLabel.show()
        if (self.dummy.get_active()):
            currentMode = gtk.Label(_("%s (Dummy Mode)") % self.writermode)
        else:
            currentMode = gtk.Label(self.writermode)
        currentMode.set_alignment(0.0, 0.5)
        currentMode.show()
        speedLabel = gtk.Label(_("Speed: "))
        speedLabel.set_alignment(1.0, 0.5)
        speedLabel.show()
        speeds = gtk.Label(_("%dx (CD-W) %dx (CD-RW)") % (self.speed.get_value_as_int(), self.speedRW.get_value_as_int()))
        speeds.set_alignment(0.0, 0.5)
        speeds.show()

        volumeIDLabel = gtk.Label(_("CD Info: "))
        volumeIDLabel.set_alignment(1.0, 0.5)
        volumeIDLabel.show()

        volumeID = ""
        discSize = ""

        if (self.writermode == DataCD):
            volumeID = self.volumeid.get_text()
            discSize = self.datasizesel.get_text()
        elif (self.writermode == AudioCD):
            volumeID = self.volumeidaudio.get_text()
            discSize = self.audiosize.get_text()
        elif (self.writermode == modeImageCD):
            if (self.volidtext.get_text() != ""):
                volumeID = self.volidtext.get_text()
            else:
                volumeID = _("<unknown>")
            if (self.volsizetext.get_text != ""):
                if (self.volsizetext.get_text() != ""):
                    discSize = (atoi(self.volsizetext.get_text()) * 2) / 1024
                    discSize = "%d MB" % discSize
        else:
            volumeID = _("<unknown>")

        if (volumeID == ""):
            volumeID = _("<none>")
        if (discSize == ""):
            discSize = _("<unknown>")

        discInfo = gtk.Label("%s (%s)" % (volumeID, discSize))
        discInfo.set_alignment(0.0, 0.5)
        discInfo.show()

        infotable = gtk.Table(3,2)
        infotable.attach(modeLabel, 0, 1, 0, 1, gtk.FILL, 0, 5)
        infotable.attach(currentMode, 1, 2, 0, 1, gtk.FILL, 0, 5)
        infotable.attach(speedLabel, 0, 1, 1, 2, gtk.FILL, 0, 5)
        infotable.attach(speeds, 1, 2, 1, 2, gtk.FILL, 0, 5)
        infotable.attach(volumeIDLabel, 0, 1, 2, 3, gtk.FILL, 0, 5)
        infotable.attach(discInfo, 1, 2, 2, 3, gtk.FILL, 0, 5)
        infotable.show()
        infoframe.add(infotable)

        woptframe = gtk.Frame(_(" Settings "))
        woptframe.set_border_width(3)
        woptframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)

        self.formatCDR = gtk.RadioButton(None, "CD-R")
        self.formatCDR.show()
        self.formatCDRW = gtk.RadioButton(self.formatCDR, "CD-RW")
        self.formatCDRW.show()
        if (self.tw_mode == 0):
            self.formatCDR.set_active(1)
        elif (self.tw_mode == 1):
            self.formatCDRW.set_active(1)

        self.fixate = gtk.CheckButton(_("fixate CD when done"))
        self.fixate.set_active(self.tw_fixate)
        if (self.writermode == modeCopyCD):
            self.fixate.set_sensitive(gtk.FALSE)
        else:
            self.fixate.set_sensitive(gtk.TRUE)            
        self.fixate.show()

        self.multisession = gtk.CheckButton(_("multisession CD"))
        self.multisession.set_active(self.tw_multisession)
        if (self.writermode == modeCopyCD):
            self.multisession.set_sensitive(gtk.FALSE)
        else:
            self.multisession.set_sensitive(gtk.TRUE)
        self.multisession.show()

        wopttable = gtk.Table(2, 3)
        wopttable.attach(self.formatCDR, 0, 1, 0, 1, 0, 0, 5)
        wopttable.attach(self.formatCDRW, 1, 2, 0, 1, 0, 0, 5)
        wopttable.attach(self.fixate, 0, 2, 1, 2, gtk.FILL, 0, 5)
        wopttable.attach(self.multisession, 2, 3, 1, 2, gtk.FILL, 0, 5)
        wopttable.show()

        woptframe.add(wopttable)
        woptframe.show()

        goBtn = gtk.Button(_(" Burn "))
        goBtn.set_size_request(75, -1)
        goBtn.connect('clicked', self.BurnWriterOptions)
        goBtn.show()
        cancelBtn = gtk.Button(stock="gtk-close")
        cancelBtn.set_size_request(75, -1)
        cancelBtn.connect('clicked', self.CloseWriterOptions)
        cancelBtn.show()

        labLeft = gtk.Label("")
        labLeft.show()

        buttontab = gtk.Table(1, 4)
        buttontab.attach(labLeft, 0, 1, 0, 1, gtk.EXPAND, 0, 5, 5)
        buttontab.attach(goBtn, 2, 3, 0, 1, 0, 0, 5, 5)
        buttontab.attach(cancelBtn, 1, 2, 0, 1, 0, 0, 5, 5)
        buttontab.show()

        vbox.pack_start(infoframe, expand = gtk.FALSE)
        vbox.pack_start(woptframe, expand = gtk.FALSE)
        vbox.pack_start(buttontab)

        self.woptwindow.add(vbox)

    # Close the writer options window and start burnin'
    def BurnWriterOptions(self, args):
        if (self.formatCDR.get_active()):
            self.tw_mode = 0
        elif (self.formatCDRW.get_active()):
            self.tw_mode = 1
        self.tw_fixate = self.fixate.get_active()
        self.tw_multisession = self.multisession.get_active()
        self.woptwindow.destroy()
        self.woptwindow = None

        successfull = gtk.TRUE

        if (frames[self.notebook.get_current_page()] == audiocd):
            successfull = self.ConvertMp3ToWav()
            if (successfull):
                successfull = self.Normalize()

        if (successfull):
            self.BurnCDNow()

    # Close the writer options window
    def CloseWriterOptions(self, args):
        self.woptwindow.destroy()
        self.woptwindow = None
        if (self.startup_burnmode != None):
            self.Destroy(None)

    # --------------------------------------------------------------------------
    # Create Image (menu entry)

    def CreateImage(self, uic, verbname = None, win = None):
        if (self.imageentry.get_text() == ""):
            gnome.tools.ErrorDialog(_("Please select an image path in the preferences tab first !"))
            return
        if (not os.path.isdir(gnome.tools.utf2iso(self.imageentry.get_text()))):
            gnome.tools.ErrorDialog(_("Error: \"%s\" is not a valid directory !") % gnome.tools.utf2iso(self.imageentry.get_text()))
            return
        if (self.burnwindow != None):
            gnome.tools.ErrorDialog(_("Close the output window first !"))
            return
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.writermode = modeDataCDImage
        elif (frames[page] == imagecd) or (frames[page] == audiocd) or (frames[page] == options) or (frames[page] == readcd) or (frames[page] == special) or (frames[page] == copycd):
            gnome.tools.ErrorDialog(_("You can't create any image at this point !"))
            return

        if (len(self.datafiles.selection)) == 0:
            gnome.tools.ErrorDialog(_("You have to select files & directories first."))
            return

        if (self.volumeid.get_text() != ""):
            isofilename = self.volumeid.get_text()
        else:
            isofilename = "ECLiPt Roaster - %s" % asctime(localtime(time()))
            if (sys.platform == "win32"):
                # On the win32 platform, ':' is invalid in a filename
                isofilename = replace(isofilename, ":", "_")

        imagepath = gnome.tools.utf2iso(self.imageentry.get_text())
        if (imagepath[-1] == os.sep):
            isofilename = "%s%s.iso" % (imagepath, isofilename)
        else:
            isofilename = "%s%s%s.iso" % (imagepath, os.sep, isofilename)

        input_dialog = gnome.tools.InputDialog(self.window, _("Enter Filename"), _("Filename:"), text = isofilename, width = 230)
        result = input_dialog.get_result()
        if (result != ""):
            self.fileNameCDImage = result
            self.BurnCDNow()

    def BurnCDNow(self):
        """ Burn the CD respectively create the command line for burning the CD. """

        if (self.tw_mode == 0):
            speed = self.speed.get_value_as_int()
        else:
            speed = self.speedRW.get_value_as_int()

        channel = self.channel.get_text()
        id = self.id.get_text()
        lun = self.lun.get_text()

        if (channel == "") or (id == "") or (lun == ""):
            gnome.tools.ErrorDialog(_("Invalid recorder settings !"))
            return gtk.FALSE

        cdrecord = cdrtools.cdrecord(channel, id, lun, self.devWriter.get_text(), self.cat.get_loglevel())
        cdrecord.verbose_mode = gtk.TRUE
        cdrecord.burnfree = self.burnproof.get_active()
        cdrecord.dummy_mode = self.dummy.get_active()
        cdrecord.eject = self.eject.get_active()
        cdrecord.fifosize = self.fifosize.get_value_as_int() * 1024 * 1024

        if (self.writermode == DataCD) or (self.writermode == modeDataCDImage):

            mkisofs = cdrtools.mkisofs(self.cat.get_loglevel())
            mkisofs.gui_behaviour = gtk.TRUE
            # causes version to be displayed on stdout
            # mkisofs.verbose_mode = gtk.TRUE
            mkisofs.disable_deep_relocation = self.diralloc.get_active()
            mkisofs.full_iso9660_filenames = self.fullchar.get_active()
            mkisofs.allow_leading_dots = self.allowdots.get_active()
            mkisofs.follow_links = self.followlinks.get_active()
            if (self.joliet.get_active()): mkisofs.joliet_charset = self.jolietCharSets.get_active_item()
            if (self.tw_multisession == gtk.TRUE):
                previous_session = cdrecord.previous_session()
                mkisofs.multi_session(previous_session, cdrecord.device())
            mkisofs.rational_rock = self.ratrock.get_active()
            if (self.rockridge.get_active()) or (self.tw_multisession == gtk.TRUE): mkisofs.rock_ridge = gtk.TRUE
            mkisofs.omit_trailing_periods = self.periods.get_active()
            mkisofs.volume_id = self.volumeid.get_text()
            if (self.writermode == modeDataCDImage):
                mkisofs.output_file = self.fileNameCDImage
            if (self.makebootable.get_active()):
                mkisofs.boot_catalog = gnome.tools.utf2iso(self.bootcatalog.get_text())
                mkisofs.boot_image = gnome.tools.utf2iso(self.bootimage.get_text())
            for i in range(len(self.datafiles.selection)):
                filename = gnome.tools.utf2iso(self.datafiles.get_text(self.datafiles.selection[i], 1))
                mkisofs.add_file(filename)

            if (self.writermode == DataCD):
                cdrecord.overburn = self.overburn.get_active()
                cdrecord.fixate = self.tw_fixate
                cdrecord.multisession = self.tw_multisession
                cdrecord.speed = speed
                cdrecord.pad_tracks = gtk.TRUE
                cdrecord.track_mode = cdrtools.TRACK_MODE_DATA
                cdrecord.add_track(cdrtools.TRACK_STDIN)
                # Get the track-size first
                mkisofs.print_size = gtk.TRUE
                command = "%s 2>&1" % mkisofs.command_line()
                self.cat.debug("Executing %s" % command)
                pipe = popen2.popen2(command)
                # Burn the CD
                # will get a warning if -d or -L are used, so eat it
                if ((mkisofs.allow_leading_dots) or (mkisofs.omot_trailing_periods)):
                    # so eat it
                    pipe[0].readline()
                # eat the line intended for the user
                pipe[0].readline()
                cdrecord.tsize = "%ss" % (strip(pipe[0].readline()))
                mkisofs.print_size = gtk.FALSE                
                command = "(%s | %s) 2>&1 %s" % (mkisofs.command_line(), cdrecord.command_line(), pipe_ecat)
            elif (self.writermode == modeDataCDImage):
                command = "%s 2>&1 %s" % (mkisofs.command_line(), pipe_ecat)

        elif (self.writermode == AudioCD):

            cdrecord.track_mode = cdrtools.TRACK_MODE_AUDIO
            if (self.dao.get_active()): cdrecord.write_mode = cdrtools.WRITE_MODE_DAO
            cdrecord.fixate = self.tw_fixate
            cdrecord.multisession = self.tw_multisession
            cdrecord.speed = speed
            cdrecord.swap_audio_tracks = self.swab.get_active()
            cdrecord.pad_tracks = self.pad.get_active()

            line = 0
            try:
                filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
            except:
                filename = None
            while (filename != None):
                cdrecord.add_track(escapedfilename(filename))
                self.nraudiotracks = line + 1                                   # Numbers don't start at 0 !
                line = line + 1
                try:
                    filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
                except:
                    filename = None
            command = "%s 2>&1 %s" % (cdrecord.command_line(), pipe_ecat)

        elif (self.writermode == modeImageCD):

            image = gnome.tools.utf2iso(self.cdimage.get_text())
            cdrecord.overburn = self.overburn.get_active()
            cdrecord.fixate = self.tw_fixate
            cdrecord.multisession = self.tw_multisession
            cdrecord.speed = speed
            cdrecord.add_track(image)
            command = "%s 2>&1 %s" % (cdrecord.command_line(), pipe_ecat)

        elif (self.writermode == modeImageCDcdrdao):
            cue_file = gnome.tools.utf2iso(self.cdimage.get_text())
            current_directory = os.getcwd()
            cue_directory = os.path.dirname(cue_file)
            mycdrdao = cdrdao(channel, id, lun, self.devWriter.get_text(), self.cat.get_loglevel())
            if (mycdrdao.installed() == gtk.TRUE):
                mycdrdao.speed = speed
                mycdrdao.multisession = self.tw_multisession
                # mycdrdao.swap_byte_order = self.swab.get_active()
                mycdrdao.eject = self.eject.get_active()
                mycdrdao.dummy_mode = self.dummy.get_active()
                mycdrdao.toc_file = os.path.basename(cue_file)
                command = "cd \"%s\";%s 2>&1 %s;cd \"%s\"" % (cue_directory, mycdrdao.command_line(), pipe_ecat, current_directory)
            else:
                self.cat.error(_("'cdrdao' is not installed"))
                gnome.tools.ErrorDialog(_("'cdrdao' is not installed, please install it first."))
                command = ""

        elif (self.writermode == modeCopyCD):
            read_cd = cdrtools.readcd(self.channelReader.get_text(), self.idReader.get_text(), self.lunReader.get_text(), self.cat.get_loglevel())
            read_cd.filename = "/dev/stdout"
            cdrecord.fifosize = self.fifosize.get_value_as_int() * 1024 * 1024
            cdrecord.speed = speed
            cdrecord.pad_tracks = gtk.TRUE
            cdrecord.track_mode = cdrtools.TRACK_MODE_DATA
            cdrecord.add_track(cdrtools.TRACK_STDIN)
            command = "(%s | %s) 2>&1 %s" % (read_cd.command_line(), cdrecord.command_line(), pipe_ecat)

        elif (self.writermode == BlankCDAll) or (self.writermode == BlankCDMinimal) or (self.writermode == BlankCDLast):

            speed = self.speedRW.get_value_as_int()
            if (self.writermode == BlankCDAll):
                cdrecord.blank_mode = cdrtools.BLANK_MODE_DISC
            elif (self.writermode == BlankCDMinimal):
                cdrecord.blank_mode = cdrtools.BLANK_MODE_FAST
            elif (self.writermode == BlankCDLast):
                cdrecord.blank_mode = cdrtools.BLANK_MODE_SESSION
            cdrecord.speed = speed
            command = "%s 2>&1 %s" % (cdrecord.command_line(), pipe_ecat)

        elif (self.writermode == modeFixateCD):

            cdrecord.speed = self.speedRW.get_value_as_int()
            self.cat.debug("Fixate command line (wrong): %s" % cdrecord.command_line())
            command = "%s  -fix 2>&1 %s" % (cdrecord.command_line(), pipe_ecat)

        # only open the burn window if the command line is valid
        if (command != ""):
            self.cat.debug(_("Executing: %s") % command)
            self.BurnWindow(command)

    def BurnWindow(self, command):
        """ Open a new window which contains the cdrecord & mkisofs output """

        self.burnwindow = gtk.Window()
        self.burnwindow.set_title("%s Output" % title)
        self.burnwindow.connect("delete_event", self.BurnWindowDontKill)
        self.burnwindow.connect("destroy", self.BurnWindowDontKill)
        self.burnwindow.set_border_width(1)

        # Creata frame for the output of cdrecord & mkisofs        
        self.__Application_text_view = gtk.TextView()
        self.__Application_text_buffer = self.__Application_text_view.get_buffer()
        self.__Application_text_view.set_size_request(520, 180)
        self.__Application_text_view.set_editable(gtk.FALSE)
        self.__Application_text_view.set_wrap_mode(gtk.WRAP_NONE)
        self.__Application_text_view.set_cursor_visible(gtk.FALSE)
        self.__Application_text_view.show()
        scrolled_win = gtk.ScrolledWindow()
        scrolled_win.set_policy(gtk.POLICY_ALWAYS, gtk.POLICY_ALWAYS)
        scrolled_win.set_shadow_type(gtk.SHADOW_ETCHED_IN)
        scrolled_win.add(self.__Application_text_view)
        scrolled_win.show_all()

        outputframe = gtk.Frame(label = _(" CDR-Tools Output "))
        outputframe.set_border_width(3)
        outputframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        outputframe.add(scrolled_win)
        outputframe.show()

        # Create a frame containing tracknumber & progress bar
        frame = gtk.Frame(label = _(" Information "))
        frame.set_border_width(3)
        frame.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        frame.show()

        startLabel = gtk.Label(_("Start time: %s   ") % (strftime("%H:%M:%S", localtime(time()))))
        startLabel.show()

        donelabel = gtk.Label(_("Estimated end time:"))
        donelabel.show()

        self.estimate = gtk.Label("")
        self.estimate.set_text(_("(not estimated)"))
        self.estimate.show()

        timebox = gtk.HBox(spacing = 3)
        timebox.set_border_width(3)
        timebox.pack_start(startLabel, expand = gtk.FALSE)
        timebox.pack_start(donelabel, expand = gtk.FALSE)
        timebox.pack_start(self.estimate, expand = gtk.FALSE)
        timebox.show()

        self.track = gtk.Label(_("Track:"))
        self.track.set_size_request(80, -1)
        self.track.set_alignment(1.0, 0.5)
        self.track.show()

        self.progressbar = gtk.ProgressBar()
        self.progressbar.show()

        fifolabel = gtk.Label(_("FIFO usage:"))
        fifolabel.set_alignment(1.0, 0.5)
        fifolabel.show()

        self.fifoprogressbar = gtk.ProgressBar()
        self.fifoprogressbar.show()

        self.closebutton = gtk.Button(stock = 'gtk-close')
        self.closebutton.set_sensitive(gtk.FALSE)
        self.closebutton.show()

        table = gtk.Table(2, 3)
        table.attach(self.track, 0, 1, 0, 1, 0, 0, 3, 3)
        table.attach(self.progressbar, 1, 2, 0, 1, gtk.EXPAND|gtk.FILL, 0, 3, 3)
        table.attach(fifolabel, 0, 1, 1, 2, gtk.FILL, 0, 3, 3)
        table.attach(self.fifoprogressbar, 1, 2, 1, 2, gtk.EXPAND|gtk.FILL, 0, 3, 3)
        table.attach(self.closebutton, 2, 3, 1, 2, 0, 0, 3, 3)
        table.show()

        infobox = gtk.VBox(spacing = 3)
        infobox.set_border_width(3)
        infobox.pack_start(timebox, expand = gtk.FALSE)
        infobox.pack_start(table)
        infobox.show()

        frame.add(infobox)

        self.burnbox = gtk.VBox(spacing = 3)
        self.burnbox.set_border_width(3)
        self.burnbox.pack_start(outputframe)
        self.burnbox.pack_start(frame, expand = gtk.FALSE)
        self.burnbox.show()

        self.burnwindow.add(self.burnbox)
        self.burnwindow.show()

        imagepath = gnome.tools.utf2iso(self.imageentry.get_text())

        if (self.writermode == modeReadAudioCD):
            fileList = []
            for i in range(len(self.audiotracklist)):
                if self.audiotracklist[i].get_active():
                    fileList.append(i + 1)
        else:
            fileList = [ data_file_list ]

        execution_thread = ExecutionThread(command, fileList, self.cddb_info, waitreload_lockfile, self.__Application_execution_callback, self.cat.get_loglevel())
        execution_thread.start()

    def __Application_append_output(self, text):
        """ This function appends text to the output window. """
        text = gnome.tools.iso2utf("%s\n" % text)
        end_iter = self.__Application_text_buffer.get_end_iter()
        self.__Application_text_buffer.insert(end_iter, text)
        self.__Application_text_view.scroll_to_mark(self.__Application_text_buffer.get_insert(), 0)

    def __Application_execution_callback(self, packet):
        """ This function handles the output of the ExecutionThread. """
        splitted = split(packet, "\n")
        for i in range(len(splitted)):
            line = strip(splitted[i])
            if (line != ""):
                if (find(line, "Re-load disk and hit <CR>") != -1):
                    touch(waitreload_lockfile)
                    cmdoutput(waitreload)
                    unlink(waitreload_lockfile)
                elif (line == execution_thread_done):
                    # Make sure that the progress bar finishes at 100%
                    self.progressbar.set_fraction(1)
                    self.progressbar.set_text("100% (done)")
                    self.closebutton.set_sensitive(gtk.TRUE)
                    self.closebutton.connect("clicked", self.BurnWindowDestroy)
                    return gtk.TRUE
                elif (self.writermode == AudioCD):
                    self.__Application_parse_write_audio_cd(line)
                elif (self.writermode == modeReadCD):
                    self.__Application_parse_read_data_cd(line)
                elif (self.writermode == modeReadAudioCD):
                    self.__Application_parse_read_audio_cd(line)
                elif (self.writermode == DataCD):
                    self.__Application_parse_write_data_cd(line)
                elif ((self.writermode == BlankCDAll) or (self.writermode == BlankCDMinimal) or (self.writermode == BlankCDLast) or (self.writermode == modeFixateCD)):
                    if (not self.formatignore.match(line)):
                        self.__Application_append_output(line)
                elif (self.writermode == modeCopyCD):
                    self.__Application_parse_copy_data_cd(line)
                elif (self.writermode == modeImageCD):
                    self.__Application_parse_write_cd_image(line)
                elif (self.writermode == modeDataCDImage):
                    self.__Application_parse_create_data_cd_image(line)
                elif (self.writermode == modeImageCDcdrdao):
                    self.__Application_parse_write_cd_cdrdao(line)

    def __Application_format_time_estimated(self, timestring):
        """ Format the time estimated """
        timestring = strip(timestring)
        left_index = find(timestring, ":") - 2
        timestring = timestring[left_index:left_index + 8]
        return timestring

    def __Application_parse_write_audio_cd(self, line):
        """ Parse the output for writing audio CDs. """
        matchobject = self.formataudio.match(line)
        if (matchobject):
            track_number = atoi(matchobject.group(1))
            current_mb = atoi(matchobject.group(2))
            total_mb = atoi(matchobject.group(3))
            self.track.set_text(_("Track %d of %d:") % (track_number, self.nraudiotracks))
            if (current_mb <= total_mb):
                if (total_mb > 0):
                    self.progressbar.set_fraction(float(current_mb) / float(total_mb))
                    self.progressbar.set_text("%d %s %dMB (Total %d MB)" % (current_mb, _("of"), total_mb, round(float(self.totalaudiosize) / (1024 * 1024))))
        else:
            matchobject = self.formataudiolong.match(line)
            if (matchobject):
                track_number = atoi(matchobject.group(1))
                current_mb = atoi(matchobject.group(2))
                total_mb = atoi(matchobject.group(3))
                fifo = atof(matchobject.group(4))
                self.track.set_text(_("Track %d of %d:") % (track_number, self.nraudiotracks))
                if (current_mb <= total_mb):
                    if (total_mb > 0):
                        self.progressbar.set_fraction(float(current_mb) / float(total_mb))
                        self.progressbar.set_text("%d %s %dMB (Total %d MB)" % (current_mb, _("of"), total_mb, round(float(self.totalaudiosize) / (1024 * 1024))))
                self.fifoprogressbar.set_fraction(fifo / 100.0)
                self.fifoprogressbar.set_text("%.2f%%" % fifo)
            else:
                if (not self.formatignore.match(line)):
                    self.__Application_append_output(line)

    def __Application_parse_read_data_cd(self, line):
        """ Parse the output for reading data CDs. """
        matchobject = self.formatreadimage.match(line)
        if (matchobject):
            cursize = atoi(matchobject.group(1)) * 2
            if (float(self.tmpimagesize) / 1024) > 0:
                self.progressbar.set_fraction((float(cursize) / 1024) / (float(self.tmpimagesize) / 1024))
                self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, round(cursize / 1024), _("of"), round(self.tmpimagesize / 1024)))
        else:
            matchobject = self.formatreadimageend.match(line)
            if (matchobject):
                self.tmpimagesize = atoi(matchobject.group(1)) * 2
                self.progressbar.set_text("%.2f%% (0 %s %d MB)" % (self.progressbar.get_fraction() * 100, _("of"), round(self.tmpimagesize / 1024)))

            else:
                if (not self.formatignore.match(line)):
                    self.__Application_append_output(line)

    def __Application_parse_read_audio_cd(self, line):
        """ Parse the output for reading audio CDs. """
        matchobject = self.formatreadaudio.match(line)
        if (matchobject):
            percent = atof(matchobject.group(1))
            self.progressbar.set_fraction(float(percent) / 100)
            self.progressbar.set_text("%.2f%% (%s %s)" % (self.progressbar.get_fraction() * 100, _("File"), self.filenumber))

        elif (self.formatreadaudioinfo.match(line)):
            self.filenumber = line[len(audioinfostring) + 1:]

        elif (not self.formatignore.match(line)):
            self.__Application_append_output(line)

    def __Application_parse_write_data_cd(self, line):
        """ Parse the output for writing data CDs. """
        matchobject = self.formatdata.match(line)
        if (matchobject):
            track_number = atoi(matchobject.group(1))
            current_mb = atoi(matchobject.group(2))
            self.track.set_text(_("Track %d:") % track_number)
            if (current_mb <= round(float(self.selecteddatasize) / 1024)):
                if (round(float(self.selecteddatasize) / 1024) > 0):
                    self.progressbar.set_fraction(float(current_mb) / round(float(self.selecteddatasize) / 1024))
                    self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, current_mb, _("of"), round(float(self.selecteddatasize) / 1024)))
        else:
            matchobject = self.formatdatafifo.match(line)
            if (matchobject):
                track_number = atoi(matchobject.group(1))
                current_mb = atoi(matchobject.group(2))
                fifo = atof(matchobject.group(3))
                self.track.set_text(_("Track %d:") % track_number)
                if (current_mb <= round(float(self.selecteddatasize) / 1024)):
                    if (round(float(self.selecteddatasize) / 1024) > 0):
                        self.progressbar.set_fraction(float(current_mb) / round(float(self.selecteddatasize) / 1024))
                        self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, current_mb, _("of"), round(float(self.selecteddatasize) / 1024)))
                self.fifoprogressbar.set_fraction(fifo / 100.0)
                self.fifoprogressbar.set_text("%.2f%%" % fifo)
            else:
                matchobject = self.formatdatalong.match(line)
                if (matchobject):
                    track_number = atoi(matchobject.group(1))
                    current_mb = atoi(matchobject.group(2))
                    fifo = atof(matchobject.group(3))
                    self.track.set_text(_("Track %d:") % track_number)
                    if (current_mb <= round(float(self.selecteddatasize) / 1024)):
                        if (round(float(self.selecteddatasize) / 1024) > 0):
                            self.progressbar.set_fraction(float(current_mb) / round(float(self.selecteddatasize) / 1024))
                            self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, current_mb, _("of"), round(float(self.selecteddatasize) / 1024)))
                    self.fifoprogressbar.set_fraction(fifo / 100.0)
                    self.fifoprogressbar.set_text("%.2f%%" % fifo)
                    self.estimate.set_text(self.__Application_format_time_estimated(line[find(line, "estimate finish") + 15:]))
                elif (not self.formatignore.match(line)):
                    self.__Application_append_output(line)

    def __Application_parse_copy_data_cd(self, line):
        """ Parse the output of copying a CD. """
        matchobject = self.formatreadimageend.match(line)
        if (matchobject):
            self.tmpimagesize = atoi(matchobject.group(1)) * 2
        else:
            matchobject = self.formatdatafifo.match(line)
            if (matchobject):
                track_number = atoi(matchobject.group(1))
                current_mb = atoi(matchobject.group(2))
                fifo = atof(matchobject.group(3))
                self.track.set_text(_("Track %d:") % track_number)
                if (round(float(self.tmpimagesize) / 1024) > 0):
                    self.progressbar.set_fraction(float(current_mb) / round(float(self.tmpimagesize) / 1024))
                self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, current_mb, _("of"), int(round(float(self.tmpimagesize) / 1024))))
                self.fifoprogressbar.set_fraction(fifo / 100.0)
                self.fifoprogressbar.set_text("%.2f%%" % fifo)
            elif ((not self.formatignorecopy.match(line)) and (not self.formatreadimage.match(line)) and (not self.formatignore.match(line))):
                self.__Application_append_output(line)

    def __Application_parse_write_cd_image(self, line):
        """ Parse the output of writing a CD image. """
        matchobject = self.formataudio.match(line)
        if (matchobject):
            track_number = atoi(matchobject.group(1))
            current_mb = atoi(matchobject.group(2))
            total_mb = atoi(matchobject.group(3))
            self.track.set_text(_("Track %d:") % track_number)
            if (current_mb <= total_mb):
                if (total_mb > 0):
                    self.progressbar.set_fraction(float(current_mb) / float(total_mb))
                self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, current_mb, _("of"), total_mb))
        else:
            matchobject = self.formataudiolong.match(line)
            if (matchobject):
                track_number = atoi(matchobject.group(1))
                current_mb = atoi(matchobject.group(2))
                total_mb = atoi(matchobject.group(3))
                fifo = atof(matchobject.group(4))
                self.track.set_text(_("Track") + "%d:" % track_number)
                if (current_mb <= total_mb):
                    if (total_mb > 0):
                        self.progressbar.set_fraction(float(current_mb) / float(total_mb))
                    self.progressbar.set_text("%.2f%% (%d %s %d MB)" % (self.progressbar.get_fraction() * 100, current_mb, _("of"), total_mb))
                self.fifoprogressbar.set_fraction(fifo / 100.0)
                self.fifoprogressbar.set_text("%.2f%%" % fifo)
            elif (not self.formatignore.match(line)):
                self.__Application_append_output(line)

    def __Application_parse_create_data_cd_image(self, line):
        """ Format the output of creating a data CD image. """
        matchobject = self.formatimage.match(line)
        if (matchobject):
            self.progressbar.set_fraction(atof(matchobject.group(1)) / 100)
            self.progressbar.set_text("%.2f%%" % atof(matchobject.group(1)))
            self.estimate.set_text(self.__Application_format_time_estimated(line[find(line, ".") + 27:]))
        elif (not self.formatignore.match(line)):
            self.__Application_append_output(line)

    def __Application_parse_write_cd_cdrdao(self, line):
        """ Write a CD image (cue/bin) by using cdrdao. """
        matchobject = self.formatwritecuecdrdao.match(line)
        if (matchobject):
            self.progressbar.set_fraction(atof(matchobject.group(1)) / atof(matchobject.group(2)))
            self.progressbar.set_text("%.2f%% (%s %s %s MB)" % (self.progressbar.get_fraction() * 100, matchobject.group(1), _("of"), matchobject.group(2)))
            self.fifoprogressbar.set_fraction(atof(matchobject.group(3)) / 100.0)
            self.fifoprogressbar.set_text("%.2f%%" % atof(matchobject.group(3)))
        else:
            self.__Application_append_output(line)

    def BurnWindowDestroy(self, args):
        """ Close the burn window """
        self.burnwindow.destroy()
        self.burnwindow = None
        if (self.startup_burnmode != None):
            self.Destroy(None)

    def BurnWindowDontKill(self, *args):
        """ Handler to prevent users to kill the burn window. """
        return 1
    
    def Normalize(self):
        """ Normalize wav-files. """

        if (self.normalize.get_active()):

            command = which("normalize")
            if (command == ""):
                gnome.tools.ErrorDialog("'normalize' is not installed !")
                return

            pgb = gnome.tools.ProgressBar(_("ECLiPt Roaster Info"), _("Normalizing wav-files - This may take a minute or two..."), 1)

            command = "%s -q" % command
            line = 0
            try:
                filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
            except detail:
                filename = None
            while (filename != None):

                command = "%s \"%s\"" % (command, filename)
                line = line + 1
                try:
                    filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
                except:
                    filename = None

            system(command)

            pgb.update()
            pgb.close()
            pgb = None

        return gtk.TRUE

    def SelectTempPath(self, args):
        """ Select the default temporary path for CD images. """
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.cdimages" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SelectTempDirectory, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", filedialog.destroy)
        filedialog.show()

    def SelectTempDirectory(self, args, get_directory, get_filenames, destroy):
        """ After browsing for the cd image enter the filename in the entry field. """
        self.imageentry.set_text(gnome.tools.iso2utf("%s%s%s" % (get_directory(), os.sep, get_filenames())))
        destroy()

    # Set various options for CDRecord & MkIsoFS
    def Options(self, frame):

        # A table containing various options
        opttable = gtk.Table(3, 1)
        opttable.show()

        # Filesystem options
        fsframe = gtk.Frame(_(" Filesystem (Data & Audio) "))
        fsframe.set_border_width(5)
        fsframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        fsframe.show()

        # Create a table containing the check buttons
        fstab = gtk.Table(6, 4)
        fstab.show()

        self.diralloc = gtk.CheckButton(_("Disable deep directory relocation"))
        self.diralloc.show()
        self.fullchar = gtk.CheckButton(_("Allow full 32 character filenames"))
        self.fullchar.show()
        self.allowdots = gtk.CheckButton(_("Allow file to start with '.'"))
        self.allowdots.show()
        self.followlinks = gtk.CheckButton(_("Follow symbolic links"))
        self.followlinks.show()
        self.joliet = gtk.CheckButton(_("Generate Joliet directory information"))
        self.joliet.show()
        self.ratrock = gtk.CheckButton(_("Generate rationalized Rock Ridge directory information"))
        self.ratrock.show()
        self.rockridge = gtk.CheckButton(_("Generate Rock Ridge directory information"))
        self.rockridge.show()
        self.periods = gtk.CheckButton(_("Omit trailing periods from filenames"))
        self.periods.show()
        self.pad = gtk.CheckButton(_("Pad audio tracks to a multiple of 2352 bytes"))
        self.pad.show()
        self.swab = gtk.CheckButton(_("Audio data source is byte-swapped (little-endian/Intel)"))
        self.swab.show()

        fifolabel = gtk.Label(_("FIFO Size:"))
        fifolabel.show()
        self.fifosize = gtk.SpinButton(gtk.Adjustment(4,2,64,1,10,0), 0, 0)
        self.fifosize.show()
        mblabel = gtk.Label("MB ")
        mblabel.show()
        empty = gtk.Label("")
        empty.show()

        self.dao = gtk.CheckButton(_("DAO mode (Audio)"))
        self.dao.show()
        self.burnproof = gtk.CheckButton(_("Use Burnfree driveropt."))
        self.burnproof.show()
        self.overburn = gtk.CheckButton(_("Allow overburning"))
        self.overburn.show()

        fifobox = gtk.HBox(spacing = 5)
        fifobox.pack_start(fifolabel, expand = gtk.FALSE)
        fifobox.pack_start(self.fifosize, expand = gtk.FALSE)
        fifobox.pack_start(mblabel, expand = gtk.FALSE)
        fifobox.show()

        jolietCharsets = cdrtools.cdrtools(self.cat.get_loglevel()).joliet_charsets()
        self.jolietCharSets = gnome.tools.OptionMenu(loglevel=self.cat.get_loglevel())
        self.jolietCharSets.append_itemlist(jolietCharsets)
        self.jolietCharSets.show()

        fstab.attach(self.diralloc, 0, 1, 0, 1, gtk.FILL, 0, 5)
        fstab.attach(self.fullchar, 0, 1, 1, 2, gtk.FILL, 0, 5)
        fstab.attach(self.allowdots, 0, 1, 2, 3, gtk.FILL, 0, 5)
        fstab.attach(self.followlinks, 0, 1, 3, 4, gtk.FILL, 0, 5)
        fstab.attach(self.periods, 0, 1, 4, 5, gtk.FILL, 0, 5)

        fstab.attach(self.joliet, 1, 2, 0, 1, gtk.FILL, 0, 5)
        fstab.attach(self.jolietCharSets.get_gtkoptionmenu(), 2, 3, 0, 1, 0, 0, 0)
        fstab.attach(self.ratrock, 1, 3, 1, 2, gtk.FILL, 0, 5)
        fstab.attach(self.rockridge, 1, 3, 2, 3, gtk.FILL, 0, 5)
        fstab.attach(self.pad, 1, 3, 3, 4, gtk.FILL, 0, 5)
        fstab.attach(self.swab, 1, 3, 4, 5, gtk.FILL, 0, 5)

        fstab.attach(self.dao, 3, 4, 0, 1, gtk.FILL, 0, 0)
        fstab.attach(self.burnproof, 3, 4, 1, 2, gtk.FILL, 0, 0)
        fstab.attach(self.overburn, 3, 4, 2, 3, gtk.FILL, 0, 0)
        fstab.attach(fifobox, 3, 4, 3, 4, 0, 0, 0)
        fstab.attach(empty, 3, 4, 4, 5, 0, 0, 0)
        fsframe.add(fstab)

        opttable.attach(fsframe, 0, 1, 0, 1, gtk.FILL, 0, 0, 0)

        # Recorder options
        recframe = gtk.Frame(_(" Recorder / Reader"))
        recframe.set_border_width(5)
        recframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        recframe.show()

        # Create a vertical box containing the SCSI-options, speed and mode checkboxes
        recordbox = gtk.VBox(spacing = 10)
        recordbox.show()

        # Create a table containing the SCSI-options (Select CD-Writer)
        channel = gtk.Label(_("Channel:"))
        channel.set_alignment(1.0, 0.5)
        channel.show()
        id = gtk.Label(_("ID:"))
        id.set_alignment(1.0, 0.5)
        id.show()
        lun = gtk.Label(_("Lun:"))
        lun.set_alignment(1.0, 0.5)
        lun.show()

        self.channel = gtk.Entry()
        self.channel.set_size_request(35, -1)
        self.channel.show()
        self.id = gtk.Entry()
        self.id.set_size_request(35, -1)
        self.id.show()
        self.lun = gtk.Entry()
        self.lun.set_size_request(35, -1)
        self.lun.show()

        autobutton = gtk.Button(_(" Detect Recorder "))
        autobutton.connect('clicked', self.DetectRecorder)
        autobutton.show()

        channelReader = gtk.Label(_("Channel:"))
        channelReader.set_alignment(1.0, 0.5)
        channelReader.show()
        idReader = gtk.Label(_("ID:"))
        idReader.set_alignment(1.0, 0.5)
        idReader.show()
        lunReader = gtk.Label(_("Lun:"))
        lunReader.set_alignment(1.0, 0.5)
        lunReader.show()

        self.channelReader = gtk.Entry()
        self.channelReader.set_size_request(35, -1)
        self.channelReader.show()
        self.idReader = gtk.Entry()
        self.idReader.set_size_request(35, -1)
        self.idReader.show()
        self.lunReader = gtk.Entry()
        self.lunReader.set_size_request(35, -1)
        self.lunReader.show()

        btnAutoReader = gtk.Button(_(" Detect Reader "))
        btnAutoReader.connect('clicked', self.DetectReader)
        btnAutoReader.show()

        speedlabel = gtk.Label(_("Speed (CD-W):"))
        speedlabel.set_alignment(1.0, 0.5)
        speedlabel.show()
        self.speed = gtk.SpinButton(gtk.Adjustment(8,2,64,2,10,0), 0, 0)
        self.speed.show()
        xlabel = gtk.Label("x")
        xlabel.show()

        speedtable = gtk.Table(2, 3)
        speedtable.attach(speedlabel, 0, 1, 0, 1, gtk.EXPAND|gtk.FILL, 0, 5)
        speedtable.attach(self.speed, 1, 2, 0, 1, gtk.FILL, 0, 5)
        speedtable.attach(xlabel, 2, 3, 0, 1, 0, gtk.FILL, 5)

        speedlabel = gtk.Label(_("Speed (CD-RW):"))
        speedlabel.set_alignment(1.0, 0.5)
        speedlabel.show()
        self.speedRW = gtk.SpinButton(gtk.Adjustment(4,2,64,2,10,0), 0, 0)
        self.speedRW.show()
        xlabel = gtk.Label("x")
        xlabel.show()

        speedtable.attach(speedlabel, 0, 1, 1, 2, gtk.EXPAND|gtk.FILL, 0, 5)
        speedtable.attach(self.speedRW, 1, 2, 1, 2, gtk.FILL, 0, 5)
        speedtable.attach(xlabel, 2, 3, 1, 2, gtk.FILL, 0, 5)

        speedtable.show()

        self.devReader = gtk.Entry()
        self.devReader.set_size_request(70, -1)
        self.devReader.show()
        devReader = gtk.Label(_("Device:"))
        devReader.set_alignment(1.0, 0.5)
        devReader.show()

        self.devWriter = gtk.Entry()
        self.devWriter.set_size_request(70, -1)
        self.devWriter.show()
        devWriter = gtk.Label(_("Device:"))
        devWriter.set_alignment(1.0, 0.5)
        devWriter.show()

        recordtab = gtk.Table(3, 9)
        recordtab.attach(channel, 0, 1, 0, 1, gtk.FILL, 0, 5)
        recordtab.attach(self.channel, 1, 2, 0, 1, 0, 0, 5)
        recordtab.attach(id, 0, 1, 1, 2, gtk.FILL, 0, 5)
        recordtab.attach(self.id, 1, 2, 1, 2, 0, 0, 5)
        recordtab.attach(lun, 0, 1, 2, 3, gtk.FILL, 0, 5)
        recordtab.attach(self.lun, 1, 2, 2, 3, 0, 0, 5)
        recordtab.attach(autobutton, 2, 4, 0, 2, gtk.SHRINK, 0, 5)
        recordtab.attach(devWriter, 2, 3, 2, 3, 0, 0, 5)
        recordtab.attach(self.devWriter, 3, 4, 2, 3, 0, 0, 5)

        recordtab.attach(channelReader, 4, 5, 0, 1, gtk.FILL, 0, 5)
        recordtab.attach(self.channelReader, 5, 6, 0, 1, 0, 0, 5)
        recordtab.attach(idReader, 4, 5, 1, 2, gtk.FILL, 0, 5)
        recordtab.attach(self.idReader, 5, 6, 1, 2, 0, 0, 5)
        recordtab.attach(lunReader, 4, 5, 2, 3, gtk.FILL, 0, 5)
        recordtab.attach(self.lunReader, 5, 6, 2, 3, 0, 0, 5)
        recordtab.attach(btnAutoReader, 6, 8, 0, 2, gtk.SHRINK, 0, 5)
        recordtab.attach(devReader, 6, 7, 2, 3, 0, 0, 5)
        recordtab.attach(self.devReader, 7, 8, 2, 3, 0, 0, 5)
        recordtab.attach(speedtable, 8, 9, 0, 3, 0, 0, 5)
        recordtab.show()

        # Create a table containing varions Recorder options
        recopttab = gtk.Table(1, 2)
        recopttab.show()

        self.dummy = gtk.CheckButton(_("Dummy operation"))
        self.dummy.show()
        self.eject = gtk.CheckButton(_("Eject CD after operation"))
        self.eject.show()

        recopttab.attach(self.dummy, 0, 1, 0, 1, gtk.FILL, 0, 5)
        recopttab.attach(self.eject, 1, 2, 0, 1, gtk.FILL, 0, 5)

        recordbox.pack_start(recordtab, expand = gtk.FALSE, fill = gtk.FALSE)
        recordbox.pack_start(recopttab, expand = gtk.FALSE, fill = gtk.FALSE)

        recframe.add(recordbox)

        opttable.attach(recframe, 0, 1, 1, 2, gtk.FILL, 0, 0, 0)

        # Miscellaneous options
        miscframe = gtk.Frame(_(" Miscellaneous "))
        miscframe.set_border_width(5)
        miscframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        miscframe.show()

        miscvbox = gtk.VBox(spacing = 5)
        miscvbox.set_border_width(5)
        miscvbox.show()

        imagelabel = gtk.Label(_("Image path: "))
        imagelabel.show()

        self.imageentry = gtk.Entry()
        self.imageentry.set_size_request(350, -1)
        self.imageentry.show()

        openimagebutton = gtk.Button()
        openImage = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_SMALL_TOOLBAR)
        openImage.show()
        openimagebutton.add(openImage)
        openimagebutton.connect('clicked', self.SelectTempPath)
        openimagebutton.show()

        imagebox = gtk.HBox(spacing = 5)
        imagebox.pack_start(imagelabel, expand = gtk.FALSE)
        imagebox.pack_start(self.imageentry, expand = gtk.FALSE)
        imagebox.pack_start(openimagebutton, expand = gtk.FALSE)
        imagebox.show()

        miscvbox.pack_start(imagebox, expand = gtk.FALSE)

        mischbox = gtk.HBox(spacing = 5)
        mischbox.show()

        self.convmp3wav = gtk.CheckButton(_("Automatically convert mp3-/ogg-files to wav-files"))
        self.convmp3wav.show()

        self.normalize = gtk.CheckButton(_("Normalize wav-files"))
        self.normalize.show()

        labPlayer = gtk.Label(_(" Audio Player:"))
        labPlayer.show()

        self.playermenu = gnome.tools.OptionMenu()
        self.playermenu.append_itemlist([playerMpg123, playerXMMS, playerZinf])
        self.playermenu.show()

        mischbox.pack_start(self.convmp3wav, expand = gtk.FALSE)
        mischbox.pack_start(self.normalize, expand = gtk.FALSE)
        mischbox.pack_start(labPlayer, expand = gtk.FALSE)
        mischbox.pack_start(self.playermenu.get_gtkoptionmenu(), expand = gtk.FALSE)

        miscvbox.pack_start(mischbox, expand = gtk.FALSE)

        miscframe.add(miscvbox)

        opttable.attach(miscframe, 0, 1, 2, 3, gtk.FILL, 0, 0, 0)

        frame.add(opttable)

    def SaveOptions(self):
        """ Save options to the config file. """

        filename = "%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, deffile)
        file = open(filename, "w")

        # Filesystem options
        file.write("[Filesystem]\n")
        file.write("DisableDeepRelocation: %s\n" % bool2str(self.diralloc.get_active()))
        file.write("FullIso9660Filenames: %s\n" % bool2str(self.fullchar.get_active()))
        file.write("AllowLeadingDots: %s\n" % bool2str(self.allowdots.get_active()))
        file.write("FollowLinks: %s\n" % bool2str(self.followlinks.get_active()))
        file.write("Joliet: %s\n" % bool2str(self.joliet.get_active()))
        file.write("Joliet-Characterset: %s\n" % self.jolietCharSets.get_active_item())
        file.write("RationalRock: %s\n" % bool2str(self.ratrock.get_active()))
        file.write("Rock: %s\n" % bool2str(self.rockridge.get_active()))
        file.write("OmitPeriod: %s\n" % bool2str(self.periods.get_active()))
        file.write("Pad: %s\n" % bool2str(self.pad.get_active()))
        file.write("Swab: %s\n" % bool2str(self.swab.get_active()))
        file.write("DAO: %s\n" % bool2str(self.dao.get_active()))
        file.write("Burnproof: %s\n" % bool2str(self.burnproof.get_active()))
        file.write("Overburn: %s\n" % bool2str(self.overburn.get_active()))

        # Recorder options
        file.write("\n[Recorder]\n")
        file.write("Speed: %d\n" % self.speed.get_value_as_int())
        file.write("SpeedRW: %d\n" % self.speedRW.get_value_as_int())
        file.write("Channel: %s\n" % self.channel.get_text())
        file.write("ID: %s\n" % self.id.get_text())
        file.write("LUN: %s\n" % self.lun.get_text())
        file.write("Device: %s\n" % self.devWriter.get_text())
        file.write("DummyMode: %s\n" % bool2str(self.dummy.get_active()))
        file.write("Eject: %s\n" % bool2str(self.eject.get_active()))

        # Reader options
        file.write("\n[Reader]\n")
        file.write("Channel: %s\n" % self.channelReader.get_text())
        file.write("ID: %s\n" % self.idReader.get_text())
        file.write("LUN: %s\n" % self.lunReader.get_text())
        file.write("Device: %s\n" % self.devReader.get_text())

        # Temporary writing settings
        file.write("\n[Settings]\n")
        file.write("Mode: %d\n" % self.tw_mode)
        file.write("Fixate: %s\n" % bool2str(self.tw_fixate))
        file.write("Multisession: %s\n" % bool2str(self.tw_multisession))
        if (self.cdsize650.get_active()):
            file.write("CDR-Size: %s\n" % cdrSize650)
        else:
            file.write("CDR-Size: %s\n" % cdrSize700)

        # Miscellaneous options
        file.write("\n[Miscellaneous]\n")
        file.write("FIFO: %d\n" % self.fifosize.get_value_as_int())
        file.write("ImagePath: %s\n" % gnome.tools.utf2iso(self.imageentry.get_text()))
        file.write("ConvertMp3: %s\n" % bool2str(self.convmp3wav.get_active()))
        file.write("Mp3-Player: %s\n" % self.playermenu.get_active_item())
        file.write("Normalize: %s\n" % bool2str(self.normalize.get_active()))
        file.write("Audio-prefix: %s\n\n" % self.__Application_audio_fileheader.get_text())

        file.close()

    def LoadOptions(self):
        """ Load configuration options (or set defaults) and copy shortcut file if necessary. """

        home_directory = gnome.tools.get_homedirectory()
        if (not (os.path.exists("%s%s%s" % (home_directory, os.sep, configdirectory)))):
            mkdirtree("%s%s%s" % (home_directory, os.sep, configdirectory))
        filename = "%s%s%s%s%s" % (home_directory, os.sep, configdirectory, os.sep, deffile)
        if (not os.path.exists("%s%s%s%s%s" % (home_directory, os.sep, configdirectory, os.sep, shortcutfile))):
            filecopy(systemshortcutfile, "%s%s%s%s%s" % (home_directory, os.sep, configdirectory, os.sep, shortcutfile))
        if (os.path.exists(waitreload_lockfile)):
            unlink(waitreload_lockfile)

        setDefault = gtk.FALSE

        if (os.path.exists(filename)):                        # Load configuration file
            try:
                self.parser.read(filename)

                # Filesystem options
                self.diralloc.set_active(str2bool(self.parser.get("Filesystem", "DisableDeepRelocation")))
                self.fullchar.set_active(str2bool(self.parser.get("Filesystem", "FullIso9660Filenames")))
                self.allowdots.set_active(str2bool(self.parser.get("Filesystem", "AllowLeadingDots")))
                self.followlinks.set_active(str2bool(self.parser.get("Filesystem", "FollowLinks")))
                self.joliet.set_active(str2bool(self.parser.get("Filesystem", "Joliet")))
                self.jolietCharSets.activate_item(self.parser.get("Filesystem", "Joliet-Characterset"))
                self.ratrock.set_active(str2bool(self.parser.get("Filesystem", "RationalRock")))
                self.rockridge.set_active(str2bool(self.parser.get("Filesystem", "Rock")))
                self.periods.set_active(str2bool(self.parser.get("Filesystem","OmitPeriod")))
                self.pad.set_active(str2bool(self.parser.get("Filesystem", "Pad")))
                self.swab.set_active(str2bool(self.parser.get("Filesystem","Swab")))
                self.dao.set_active(str2bool(self.parser.get("Filesystem", "DAO")))
                self.burnproof.set_active(str2bool(self.parser.get("Filesystem", "Burnproof")))
                self.overburn.set_active(str2bool(self.parser.get("Filesystem", "Overburn")))

                # Recorder options
                self.speed.set_value(atoi(self.parser.get("Recorder", "Speed")))
                self.speedRW.set_value(atoi(self.parser.get("Recorder", "SpeedRW")))
                self.channel.set_text(self.parser.get("Recorder", "Channel"))
                self.id.set_text(self.parser.get("Recorder", "ID"))
                self.lun.set_text(self.parser.get("Recorder", "LUN"))
                self.devWriter.set_text(self.parser.get("Recorder", "Device"))
                self.dummy.set_active(str2bool(self.parser.get("Recorder", "DummyMode")))
                self.eject.set_active(str2bool(self.parser.get("Recorder", "Eject")))

                # Reader options
                self.channelReader.set_text(self.parser.get("Reader", "Channel"))
                self.idReader.set_text(self.parser.get("Reader", "ID"))
                self.lunReader.set_text(self.parser.get("Reader", "LUN"))
                self.devReader.set_text(self.parser.get("Reader", "Device"))

                # Temporary writing settings
                self.tw_mode = atoi(self.parser.get("Settings", "Mode"))
                self.tw_fixate = str2bool(self.parser.get("Settings", "Fixate"))
                self.tw_multisession = str2bool(self.parser.get("Settings", "Multisession"))
                cdrsize = self.parser.get("Settings", "CDR-Size")
                if (cdrsize == cdrSize650):
                    self.cdsize650.set_active(gtk.TRUE)
                elif (cdrsize == cdrSize700):
                    self.cdsize700.set_active(gtk.TRUE)

                # Miscellaneous options
                self.fifosize.set_value(atoi(self.parser.get("Miscellaneous", "FIFO")))
                tmpImagePath = self.parser.get("Miscellaneous", "ImagePath")
                self.imageentry.set_text(gnome.tools.iso2utf(tmpImagePath))
                self.readcdimage.set_text(gnome.tools.iso2utf(tmpImagePath))
                self.cdimage.set_text(gnome.tools.iso2utf(tmpImagePath))
                self.convmp3wav.set_active(str2bool(self.parser.get("Miscellaneous", "ConvertMp3")))
                self.playermenu.activate_item(self.parser.get("Miscellaneous", "Mp3-Player"))
                self.normalize.set_active(str2bool(self.parser.get("Miscellaneous", "Normalize")))
                self.__Application_audio_fileheader.set_text(self.parser.get("Miscellaneous", "Audio-prefix"))

            except:

                setDefault = gtk.TRUE

        else:                                               # Set default values

            setDefault = gtk.TRUE

        if (setDefault == gtk.TRUE):
            self.cat.warn(_("Couldn't read settings - setting default values !"))

            # Filesystem options
            self.diralloc.set_active(1)
            self.fullchar.set_active(1)
            self.allowdots.set_active(1)
            self.followlinks.set_active(0)
            self.joliet.set_active(1)
            self.jolietCharSets.activate_item("iso8859-1")
            self.ratrock.set_active(0)
            self.rockridge.set_active(1)
            self.periods.set_active(0)
            self.pad.set_active(1)
            self.swab.set_active(1)
            self.dao.set_active(1)
            self.burnproof.set_active(0)
            self.overburn.set_active(0)

            # Recorder options
            self.speed.set_value(8)
            self.speedRW.set_value(4)
            self.channel.set_text("00")
            self.id.set_text("00")
            self.lun.set_text("00")
            self.dummy.set_active(0)
            self.eject.set_active(1)

            # Reader options
            self.channelReader.set_text("00")
            self.idReader.set_text("00")
            self.lunReader.set_text("00")

            # Temporary writing settings
            self.tw_mode = 0
            self.tw_fixate = 1
            self.tw_multisession = 0

            # Miscellaneous options
            self.fifosize.set_value(4)
            self.convmp3wav.set_active(1)
            self.playermenu.activate_item(playerXMMS)
            self.normalize.set_active(0)
            self.__Application_audio_fileheader.set_text("%m/%u/%d/%n - %c - %t")

    def DetectRecorder(self, args):
        """ Detect SCSI recorder. """
        self.DetectSCSIDevice(deviceRecorder)

    def DetectReader(self, args):
        """ Detect SCSI reader. """
        self.DetectSCSIDevice(deviceReader)

    def DetectSCSIDevice(self, device):
        """ Detect SCSI device. """
        devicelist = cdrtools.cdrtools(self.cat.get_loglevel()).devices()
        if (len(devicelist) == 0):
            gnome.tools.ErrorDialog(_("Couldn't detect your reader / recorder !\nPlease make sure that you are root or that you're allowed to read /dev/sg* !"))
        elif len(devicelist) == 1:
            if (device == deviceReader):
                self.channelReader.set_text(devicelist[0][0])
                self.idReader.set_text(devicelist[0][1])
                self.lunReader.set_text(devicelist[0][2])
                self.devReader.set_text("/dev/scd0")
            elif (device == deviceRecorder):
                self.channel.set_text(devicelist[0][0])
                self.id.set_text(devicelist[0][1])
                self.lun.set_text(devicelist[0][2])
                self.devWriter.set_text("/dev/scd0")
                # Detect maximum write speed
                cdrecord = cdrtools.cdrecord(devicelist[0][0], devicelist[0][1], devicelist[0][2], "/dev/scd0")
                (cd_speed, dvd_speed) = cdrecord.get_write_speed()
                self.speed.set_value(cd_speed)
        else:
            self.SelectSCSIDevice(device, devicelist)

    def SelectSCSIDevice(self, device, devicelist):
        """ Select the device if more than one devices have been found. """
        self.scsiwindow = gtk.Window()
        self.scsiwindow.set_role("ERoasterSCSI")
        self.scsiwindow.set_title("SCSI Devices")
        self.scsiwindow.set_border_width(1)
        self.scsiwindow.show()

        scsibox = gtk.VBox(spacing = 5)
        scsibox.set_border_width(5)
        scsibox.show()

        scsifrm = gtk.Frame(_(" Select SCSI-device "))
        scsifrm.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        scsifrm.show()

        box = gtk.VBox(spacing = 5)
        box.set_border_width(5)
        box.show()

        self.scsidevice = []
        for intCounter in range(len(devicelist)):
            if intCounter == 0:
                self.scsidevice.append(gtk.RadioButton(None, devicelist[intCounter][3]))
            else:
                self.scsidevice.append(gtk.RadioButton(self.scsidevice[intCounter - 1], devicelist[intCounter][3]))
            self.scsidevice[intCounter].show()
            box.pack_start(self.scsidevice[intCounter], expand = gtk.FALSE)

        scsifrm.add(box)

        btnSelect = gtk.Button(_(" Select "))
        btnSelect.connect('clicked', self.SelectSCSIDeviceSelect)
        btnSelect.show()

        self.device = device
        self.devicelist = devicelist

        scsibox.pack_start(scsifrm, expand = gtk.FALSE)
        scsibox.pack_start(btnSelect, expand = gtk.FALSE)

        self.scsiwindow.add(scsibox)

    def SelectSCSIDeviceSelect(self, args):
        """ Select SCSI Device (Select button clicked). """
        for intCounter in range(len(self.scsidevice)):
            if (self.scsidevice[intCounter].get_active() == 1):
                if (self.device == deviceReader):
                    self.idReader.set_text(self.devicelist[intCounter][1])
                    self.channelReader.set_text(self.devicelist[intCounter][0])
                    self.lunReader.set_text(self.devicelist[intCounter][2])
                    self.devReader.set_text("/dev/scd%d" % intCounter)
                elif (self.device == deviceRecorder):
                    self.id.set_text(self.devicelist[intCounter][1])
                    self.channel.set_text(self.devicelist[intCounter][0])
                    self.lun.set_text(self.devicelist[intCounter][2])
                    self.devWriter.set_text("/dev/scd%d" % intCounter)

        self.scsiwindow.destroy()
        self.scsiwindow = None

    def SongListSwap(self, row, event):
        """ Swap two entries in the Songlist. """
        if (row < 0):
            return                                    # You can't move out of the top
        self.cat.debug(_("Swapping rows %d and %d") % (self.songlist.focus_row, row))
        if (row > self.songlist.focus_row):
            swaprows = range(self.songlist.focus_row, row)
        else:
            swaprows = range(row, self.songlist.focus_row)
            swaprows.reverse()
        for row in swaprows:
            sourceindex = self.songlist.get_text(row, 1)
            targetindex = self.songlist.get_text(row + 1, 1)
            self.songlist.set_text(row, 1, targetindex)
            self.songlist.set_text(row + 1, 1, sourceindex)
            self.songlist.row_move(row, row + 1)

    def SongListButtonPressed(self, widget, event = None):
        """ When button is pressed move the selected file. """
        try:
            row = self.songlist.get_selection_info(event.x, event.y)[0]
        except:
            row = -1

    def SongListButtonReleased(self, widget, event = None):
        """ Stop moving the file when the mouse button is released. """
        try:
            row = self.songlist.get_selection_info(event.x, event.y)[0]
        except:
            row = -1
        if (row != self.songlist.focus_row) and (row != -1) and (self.songlist.focus_row != -1):
            self.SongListSwap(row, event)

        self.songlist.freeze()

        if ((event.state & gtk.gdk.SHIFT_MASK) == 0) and ((event.state & gtk.gdk.CONTROL_MASK) == 0):
            self.songlist.set_selection_mode(gtk.SELECTION_SINGLE)
            self.songlist.unselect_row(self.songlist.focus_row, 0)
            while (gtk.events_pending()):
                gtk.mainiteration()
            self.songlist.set_selection_mode(gtk.SELECTION_EXTENDED)
            self.songlist.select_row(self.songlist.focus_row, 0)

        self.ColorizeCList(self.songlist)
        self.songlist.thaw()

    def SongListMotion(self, widget, event = None):
        """ Move files up & down when "dragging". """
        if (event.state == 0):                           # Fix "random reordering" bug
            return
        try:
            row = self.songlist.get_selection_info(event.x, event.y)[0]
        except:
            row = -1
        if (row != self.songlist.focus_row) and (row != -1) and (self.songlist.focus_row != -1):
            self.SongListSwap(row, event)

    def __Application_format_drag_drop_filename(self, filename):
        """ format a filename we received via d&d to make it useable. """
        if (filename[:5] == "file:"):
            filename = filename[5:]
        filename = replace(filename, "\000", "")
        filename = unquote(filename)
        # on the win32 platform, we have to strip leading /
        if (sys.platform == "win32"):
            while (filename[0] == "/"):
                filename = filename[1:]
        filename = replace(filename, "/", os.sep)
        return strip(filename)

    def SongListDragReceive(self, window, context, x, y, data, info, time):
        """ Drag & Drop - Add file to the Songlist window. """
        filenames = cleanlist(split(data.data,"\n"))
        self.songlist.freeze()
        for i in range(len(filenames)):
            filename = self.__Application_format_drag_drop_filename(filenames[i])
            basename = strip(os.path.basename(filename))
            if (len(filename) > 0) and (basename != "") and (basename != ".") and (basename != ".."):
                if ((sys.platform == "win32") or (filename[0] == "/")):
                    self.AddFileToList(filename)
        self.ColorizeCList(self.songlist)
        self.songlist.thaw()

    # Burn Audio CDs
    def BurnAudio(self, burnbox):

        # Volume ID
        volumeframe = gtk.Frame(_(" Audio CD - CD Info (Volume) "))
        volumeframe.set_border_width(5)
        volumeframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        volumeframe.show()

        # Create a hbox containing the Volume ID
        volume_HBox = gtk.HBox(spacing = 3)
        volume_HBox.set_border_width(3)
        label = gtk.Label(_(" Enter Volume ID: "))
        label.show()
        self.volumeidaudio = gtk.Entry()
        self.volumeidaudio.show()
        volume_HBox.pack_start(label, expand = gtk.FALSE)
        volume_HBox.pack_start(self.volumeidaudio, expand = gtk.FALSE)
        volume_HBox.show()

        volumeframe.add(volume_HBox)

        volumebox = gtk.HBox(spacing = 0)
        volumebox.pack_start(volumeframe, expand = gtk.TRUE)
        volumebox.pack_start(gnome.tools.Pixmap(self.window, "%s/cdwriter.xpm" % iconpath).get_pixmap(), expand = gtk.FALSE)
        volumebox.show()

        burnbox.pack_start(volumebox, expand = gtk.FALSE)

        # Create a table containing the wav files
        wavframe = gtk.Frame(_(" Wav-/Ogg-/Mp3-files "))
        wavframe.set_border_width(5)
        wavframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        wavframe.show()

        self.songlist = gtk.CList(4, [ "", _(" Nr "), _(" Length "), _(" Filename ") ])
        self.songlist.connect("button_press_event", self.SongListButtonPressed)
        self.songlist.connect("button_release_event", self.SongListButtonReleased)
        self.songlist.connect("motion_notify_event", self.SongListMotion)
        self.songlist.connect("drag_data_received", self.SongListDragReceive)
        self.songlist.drag_dest_set(gtk.DEST_DEFAULT_DROP | gtk.DEST_DEFAULT_MOTION, gnome.tools.targets, gtk.gdk.ACTION_COPY | gtk.gdk.ACTION_MOVE)
        self.songlist.set_selection_mode(gtk.SELECTION_EXTENDED)
        self.songlist.set_column_width(0, 18)
        self.songlist.set_column_resizeable(0, gtk.FALSE)
        self.songlist.set_column_width(1, 20)        
        self.songlist.set_column_resizeable(1, gtk.FALSE)
        self.songlist.set_column_width(2, 40)
        self.songlist.set_column_resizeable(2, gtk.FALSE)
        self.songlist.set_column_resizeable(3, gtk.FALSE)
        self.songlist.set_column_auto_resize(3, gtk.TRUE)
        self.songlist.set_column_justification(2, gtk.JUSTIFY_RIGHT)
        self.songlist.show()

        songlistwin = gtk.ScrolledWindow()
        songlistwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        songlistwin.add(self.songlist)
        songlistwin.show()

        import_button = gtk.Button(_(" Import XMMS "))
        import_button.connect("clicked", self.__Application_ImportXMMSPlaylist)
        import_button.show()

        btnPlay = gtk.Button(_(" Play File "))
        btnPlay.connect('clicked', self.PlayAudioFile)
        btnPlay.show()

        sizelabel = gtk.Label(_("Total time: "))
        sizelabel.set_alignment(1.0, 0.5)
        sizelabel.show()

        self.audiosize = gtk.Entry()
        self.audiosize.set_editable(gtk.FALSE)
        self.audiosize.set_size_request(40, -1)
        self.audiosize.set_text("00:00")
        self.audiosize.show()

        emptyLabel = gtk.Label("")
        emptyLabel.show()

        audio_special_box = gtk.HBox(spacing = 3)
        audio_special_box.pack_start(import_button, expand = gtk.FALSE)
        audio_special_box.pack_start(btnPlay, expand = gtk.FALSE)
        audio_special_box.pack_start(emptyLabel)
        audio_special_box.pack_start(sizelabel, expand = gtk.FALSE)
        audio_special_box.pack_start(self.audiosize, expand = gtk.FALSE)
        audio_special_box.show()

        audio_box = gtk.VBox(spacing = 3)
        audio_box.set_border_width(3)
        audio_box.pack_start(songlistwin)
        audio_box.pack_start(audio_special_box, expand = gtk.FALSE)
        audio_box.show()

        wavframe.add(audio_box)

        burnbox.pack_start(wavframe)

    def PlayAudioFile(self, args):
        """ Play an audio file using an external player. """
        if ((len(self.songlist.selection) == 0) and (self.songlist.focus_row < 0)):
            gnome.tools.ErrorDialog(_("No audio file selected for playing"))
            return

        if (len(self.songlist.selection) == 0):
            myselection = [self.songlist.focus_row]
        else:
            myselection = self.songlist.selection

        audiofiles = ""
        oggfile = gtk.FALSE
        for i in myselection:
            filename = gnome.tools.utf2iso(self.songlist.get_text(i, 3))
            if (lower(os.path.splitext(filename)[1]) == ".ogg"):
                oggfile = gtk.TRUE
            audiofiles = "%s \"%s\"" % (audiofiles, filename)

        active_player = self.playermenu.get_active_item()
        if (active_player == playerXMMS):
            command = which("xmms")
            if (command == ""):
                gnome.tools.ErrorDialog(_("xmms not found for audio playback"))
                return
            else:
                command = "%s %s &" % (command, audiofiles)
        elif (active_player == playerMpg123):
            if (oggfile == gtk.TRUE):
                gnome.tools.ErrorDialog(_("Sorry, you cannot play ogg files with mpg123."))
                return
            command = which("mpg123")
            if (command == ""):
                gnome.tools.ErrorDialog(_("mpg123 not found for audio playback"))
                return
            else:
                command = "%s %s &" % (command, audiofiles)
        elif (active_player == playerZinf):
            zinf_command = which(playerZinf)
            if (zinf_command == ""):
                gnome.tools.ErrorDialog(_("zinf not found for audio playback"))
                return
            else:
                command = "%s %s &" % (zinf_command, audiofiles)

        system(command)

    def __Application_ImportXMMSPlaylist(self, args):
        """ Import XMMS Playlist files. """
        importwin = gnome.tools.FileSelectionDialog(filetypes = [gnome.tools.XMMS_PLAYLISTS], icondir = iconpath, loglevel = self.cat.get_loglevel(), multiselection = gtk.FALSE)
        importwin.use_lastdirectory("%s%s%s%slastdirectory.import_xmms" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        importwin.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        importwin.ok_button.connect("clicked", self.__Application_ReadXMMSPlaylistFile, importwin.get_directory, importwin.get_filenames, importwin.destroy)
        importwin.close_button.connect("clicked", importwin.destroy)
        importwin.show()

    def __Application_ReadXMMSPlaylistFile(self, args, get_directory, get_filenames, destroy):
        filename = "%s/%s" % (get_directory(), get_filenames())
        destroy()
        file = open(filename, "r")
        filenames = striplist(file.readlines())
        file.close()
        for i in range(len(filenames)):
            filename = strip(filenames[i])
            if (filename != ""):
                if (filename[0] != "#"):
                    if (os.path.exists(filename)):
                        self.AddFileToList(filename)
                    else:
                        self.cat.error(_("File doesn't exist: %s") % filename)

    def SpecialOperation(self, frame):
        """ Create a frame for special operations on CDs (blanking, fixating CDs ...) """
        burnbox = gtk.VBox(spacing = 5)
        burnbox.set_border_width(5)
        burnbox.show()

        blankfrm = gtk.Frame(_(" Select operation "))
        blankfrm.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        blankfrm.show()

        self.blankDisc = gtk.RadioButton(None, _("Erase disc [full]"))
        self.blankDisc.show()
        self.blankMinimal = gtk.RadioButton(self.blankDisc, _("Erase disc [minimal] (PMA, TOC, pregap)"))
        self.blankMinimal.show()
        self.blankSession = gtk.RadioButton(self.blankMinimal, _("Erase last session"))
        self.blankSession.show()
        self.fixate = gtk.RadioButton(self.blankSession, _("Fixate CD"))
        self.fixate.show()
        self.writeTOC = gtk.RadioButton(self.fixate, _("Write TOC"))
        self.writeTOC.set_sensitive(gtk.FALSE)
        self.writeTOC.show()

        # Set default to "Erase disc [minimal]
        self.blankMinimal.set_active(1)

        blankTable = gtk.Table(3,2)
        blankTable.attach(self.blankDisc, 0, 1, 0, 1, gtk.FILL, 0, 5)
        blankTable.attach(self.blankMinimal, 0, 1, 1, 2, gtk.FILL, 0, 5)
        blankTable.attach(self.blankSession, 0, 1, 2, 3, gtk.FILL, 0, 5)
        blankTable.attach(self.fixate, 1, 2, 0, 1, gtk.FILL, 0, 5)
        blankTable.attach(self.writeTOC, 1, 2, 1, 2, gtk.FILL, 0, 5)
        blankTable.show()

        blankfrm.add(blankTable)

        miscfrm = gtk.Frame()
        miscfrm.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        miscfrm.show()

        blankBtn = gtk.Button(stock="gtk-execute")
        blankBtn.connect('clicked', self.PerformSpecialOperation)
        blankBtn.show()

        btnbox = gtk.HBox(spacing = 5)
        btnbox.set_border_width(5)
        btnbox.show()

        leftlabel = gtk.Label("")
        leftlabel.show()

        rightlabel = gtk.Label("")
        rightlabel.show()

        btnbox.pack_start(leftlabel)
        btnbox.pack_start(blankBtn, expand = gtk.FALSE)
        btnbox.pack_start(rightlabel)

        miscfrm.add(btnbox)

        burnbox.pack_start(blankfrm, expand = gtk.FALSE)
        burnbox.pack_start(miscfrm, expand = gtk.FALSE)

        frame.add(burnbox)

    # Really perform special operation on CD now
    def PerformSpecialOperation(self, args):
        if (self.blankDisc.get_active() == 1):
            self.writermode = BlankCDAll
        elif (self.blankMinimal.get_active() == 1):
            self.writermode = BlankCDMinimal
        elif (self.blankSession.get_active() == 1):
            self.writermode = BlankCDLast
        elif (self.fixate.get_active() == 1):
            self.writermode = modeFixateCD
        elif (self.writeTOC.get_active() == 1):
            return

        self.BurnCDNow()

    def DelFile(self, args):
        """ Delete selected files from the list of wavefiles. """
        if (len(self.songlist.selection) == 0):
            gnome.tools.ErrorDialog(_("You have to select files first!"))
        else:
            list = copy.copy(self.songlist.selection)
            list.sort()
            list.reverse()
            for i in range(len(list)):
                filename = gnome.tools.utf2iso(self.songlist.get_text(list[i], 3))
                self.totalaudiosize = self.totalaudiosize - self.tracksize[filename]
                self.totaltracklength = self.totaltracklength - self.tracklength[filename]
                self.audiosize.set_text(nicetime(self.totaltracklength))

                del self.tracksize[filename]
                del self.tracklength[filename]
                self.songlist.remove(list[i])

                # Renumber files
                line = list[i]
                try:
                    index = self.songlist.get_text(line, 1)
                except:
                    index = None
                while (index != None):
                    self.songlist.set_text(line, 1, str(int(self.songlist.get_text(line, 1)) - 1))
                    line = line + 1
                    try:
                        index = self.songlist.get_text(line, 1)
                    except:
                        index = None

    # Actually add the file to the list
    def AddFileToList(self, filename):
        filename = strip(filename)
        found = gtk.FALSE
        for i in range(self.songlist.rows):
            listname = gnome.tools.utf2iso(self.songlist.get_text(i, 3))
            if (listname == filename):
                found = gtk.TRUE

        if (found == gtk.FALSE):
            filesize = os.path.getsize(filename)
            self.totalaudiosize = self.totalaudiosize + filesize
            seconds = self.GetAudioTrackLength(filename)
            self.tracksize[filename] = filesize
            self.tracklength[filename] = seconds
            self.totaltracklength = self.totaltracklength + seconds
            playtime = nicetime(seconds)
            self.songlist.append([ "", str(self.songlist.rows + 1), playtime, gnome.tools.iso2utf(filename)])
            icon, mask = gnome.tools.get_file_icon(filename, self.window, iconpath)
            self.songlist.set_pixmap((self.songlist.rows - 1), 0, icon, mask)
            self.audiosize.set_text(nicetime(self.totaltracklength))

    def ConvertMp3ToWav(self):
        """ Converts mp3/ogg-files to wav-files. """

        if (self.convmp3wav.get_active()):

            imagepath = gnome.tools.utf2iso(self.imageentry.get_text())
            if (imagepath == ""):
                gnome.tools.ErrorDialog(_("Please select an image path in the preferences tab first !"))
                return gtk.FALSE
            mp3count = 0
            oggcount = 0
            line = 0
            try:
                filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
            except:
                filename = None
            while (filename != None):
                if (lower(filename[-4:]) == ".mp3"):
                    mp3count = mp3count + 1
                if (lower(filename[-4:]) == ".ogg"):
                    oggcount = oggcount + 1
                line = line + 1
                try:
                    filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
                except:
                    filename = None

            # Check wether mpg123 and oggdec exists
            mpg123_command = which("mpg123")
            oggdec_command = which("oggdec")
            if ((mp3count > 0) and (mpg123_command == "")):
                gnome.tools.ErrorDialog(_("mpg123 not found for converting mp3 files"))
                return gtk.FALSE
            if ((oggcount > 0) and (oggdec_command == "")):
                gnome.tools.ErrorDialog(_("oggdec not found for converting ogg files"))
                return gtk.FALSE

            self.cat.debug(_("Converting %d file(s) now") % (mp3count + oggcount))

            if ((mp3count > 0) or (oggcount > 0)):
                win = gnome.tools.ProgressBar("ECLiPt Roaster Info", _("Converting %d wav-, ogg- and mp3-files to wav-files.") % (mp3count + oggcount), (mp3count + oggcount))

                line = 0
                sox_command = which("sox")
                try:
                    filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
                except:
                    filename = None
                while (filename != None):

                    if (lower(filename[-4:]) == ".mp3") or (lower(filename[-4:]) == ".ogg"):
                        tracklength = self.songlist.get_text(line, 2)
                        if (imagepath[-1] == "/"):
                            wavfilename = "%s%s.wav" % (imagepath, os.path.basename(filename)[:-4])
                        else:
                            wavfilename = "%s/%s.wav" % (imagepath, os.path.basename(filename)[:-4])

                        if (lower(filename[-4:]) == ".mp3"):
                            # Make sure that conversion is done with the correct sample rate
                            file = open(filename, "rb")
                            mpeg3info = MP3Info.MP3Info(file)
                            file.close()
                            samplerate = mpeg3info.mpeg.samplerate
                            command = "(%s --stereo -s \"%s\" | %s -t raw -r %d  -w -s -c 2 - -r 44100 -t wav \"%s\") 2>&1" % (mpg123_command, escapedfilename(filename), sox_command, samplerate, escapedfilename(wavfilename))
                        elif (lower(filename[-4:]) == ".ogg"):
                            command = "%s -Q -o \"%s\" \"%s\" 2>&1" % (oggdec_command, escapedfilename(wavfilename), escapedfilename(filename))
                        self.cat.debug("Executing: %s" % command)
                        (result, (stdout_output, stderr_output)) = cmdexec(command)
                        if (result != 0):
                            win.close()
                            win = None
                            if (lower(filename[-4:]) == ".mp3"):
                                result = listmatch(stderr_output, "Playing")
                                stderr_output = stderr_output[result[0]:]
                            gnome.tools.ErrorDialog(_("An error occured while decoding \"%s\":\n\n%s") % (filename, join(stderr_output, "")))
                            return gtk.FALSE

                        self.songlist.remove(line)
                        self.songlist.insert(line, [ "", str(line + 1), tracklength, gnome.tools.iso2utf(wavfilename)])
                        icon, mask = gnome.tools.get_file_icon(wavfilename, self.window, iconpath)
                        self.songlist.set_pixmap(line, 0, icon, mask)

                        # Correct filesize
                        self.totalaudiosize = self.totalaudiosize - self.tracksize[filename]
                        filesize = os.path.getsize(wavfilename)
                        self.tracksize[wavfilename] = filesize
                        self.tracklength[wavfilename] = self.tracklength[filename]
                        self.totalaudiosize = self.totalaudiosize + self.tracksize[wavfilename]

                        del self.tracksize[filename]
                        del self.tracklength[filename]

                        win.update()

                    line = line + 1
                    try:
                        filename = gnome.tools.utf2iso(self.songlist.get_text(line, 3))
                    except:
                        filename = None

                win.close()
                win = None
    
        return gtk.TRUE

    def AddFile(self, args):
        """ Open the file window to select a list of wavefiles. """
        addfilewin = gnome.tools.FileSelectionDialog(filetypes = [gnome.tools.AUDIO_FILES, gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        addfilewin.use_lastdirectory("%s%s%s%slastdirectory.audio" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        addfilewin.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        addfilewin.ok_button.connect("clicked", self.AddAudioFileToList, addfilewin.get_directory, addfilewin.get_filenames)
        addfilewin.close_button.connect("clicked", addfilewin.destroy)
        addfilewin.show()

    def AddAudioFileToList(self, args, get_directory, get_filenames):
        """ Add audio files to audio list. """
        filenames = get_filenames()
        self.songlist.freeze()
        for i in range(len(filenames)):
            self.AddFileToList("%s%s%s" % (get_directory(), os.sep, filenames[i]))
        self.ColorizeCList(self.songlist)
        self.songlist.thaw()

    def DragDataReceive(self, window, context, x, y, data, info, time):
        """ Drag & Drop - Add file to the datafile window. """
        filenames = cleanlist(split(data.data,"\n"))
        self.datafiles.freeze()
        for i in range(len(filenames)):
            filename = self.__Application_format_drag_drop_filename(filenames[i])
            basename = strip(os.path.basename(filename))
            if (len(filename) > 0) and (basename != "") and (basename != ".") and (basename != ".."):
                if ((sys.platform == "win32") or (filename[0] == "/")):
                    self.AddDataFileToList(filename)
        self.ColorizeCList(self.datafiles)
        self.datafiles.thaw()

    def ColorizeCList(self, clist):
        for i in range(clist.rows):
            if (divmod(i, 2)[1] == 1):
                gdkcolor = gnome.tools.hex2gdkcolor(self.window, "#ffffff")
            else:
                gdkcolor = gnome.tools.hex2gdkcolor(self.window, "#f6f6f6")
            if (gdkcolor != None):
                clist.set_background(i, gdkcolor)

    def AddDataFileToList(self, filename):
        """ Add Files to the Datafile list. """
        filename = strip(filename)
        found = gtk.FALSE
        for i in range(self.datafiles.rows):
            listname = gnome.tools.utf2iso(self.datafiles.get_text(i, 1))
            if (listname == filename):
                found = gtk.TRUE

        if (found == gtk.FALSE):
            if (filename[-1] == "\000"):
                filename = filename[:-1]
            if (os.path.exists(filename)):
                try:
                    size = du(filename) / 1024
                    self.totaldatasize = self.totaldatasize + size
                    self.datafilesize[filename] = size
                    statinfo = os.stat(filename)
                    self.datafiles.append(["", gnome.tools.iso2utf(filename), "%.0f KB" % size, asctime(localtime(statinfo[8]))])
                    icon, mask = gnome.tools.get_file_icon(filename, self.window, iconpath)
                    self.datafiles.set_pixmap((self.datafiles.rows - 1), 0, icon, mask)
                    self.datasize.set_text("%.0f MB" % (round(self.totaldatasize / 1024.0)))
                except:
                    gnome.tools.ErrorDialog(_("Warning: Can't stat \"%s\"!") % filename)
            else:
                gnome.tools.ErrorDialog(_("Warning: \"%s\" doesn't exist!") % filename)

    def AddDataFile(self, args):
        """ Open the file window to select a list of data files. """
        adddatawin = gnome.tools.FileSelectionDialog(icondir = iconpath, loglevel = self.cat.get_loglevel())
        adddatawin.use_lastdirectory("%s%s%s%slastdirectory.files" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        adddatawin.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        adddatawin.ok_button.connect("clicked", self.AddDataFileFromDialogToList, adddatawin.get_directory, adddatawin.get_filenames)
        adddatawin.close_button.connect("clicked", adddatawin.destroy)
        adddatawin.show()

    def AddDataFileFromDialogToList(self, args, get_directory, get_filenames):
        filenames = get_filenames()
        self.datafiles.freeze()
        for i in range(len(filenames)):
            self.AddDataFileToList("%s%s%s" % (get_directory(), os.sep, filenames[i]))
        self.ColorizeCList(self.datafiles)
        self.datafiles.thaw()

    # Delete files from the data file selection
    def DelDataFile(self, args):
        if (len(self.datafiles.selection) == 0):
            gnome.tools.ErrorDialog(_("You have to select files/directories first!"))
        else:
            list = copy.copy(self.datafiles.selection)
            list.sort()
            list.reverse()
            for i in range(len(list)):
                filename = gnome.tools.utf2iso(self.datafiles.get_text(list[i], 1))
                size = self.datafilesize[filename]
                self.totaldatasize = self.totaldatasize - size
                self.datasize.set_text("%d MB" % (round(self.totaldatasize / 1024.0)))
                del self.datafilesize[filename]
                self.datafiles.remove(list[i])

    # Select a data row
    def DataSelectRow(self, clist, row, column, event):
        if ((event == None) or
            ((event.type != gtk.gdk._2BUTTON_PRESS) and (event.type != gtk.gdk._3BUTTON_PRESS))):
            size = atoi(self.datafiles.get_text(row, 2)[:-3])
            self.selecteddatasize = self.selecteddatasize + size
            self.datasizesel.set_text("%d MB" % round(float(self.selecteddatasize) / 1024))

    # Unselect a data row
    def DataUnselectRow(self, clist, row, column, event):
        size = atoi(self.datafiles.get_text(row, 2)[:-3])
        self.selecteddatasize = self.selecteddatasize - size
        self.datasizesel.set_text("%d MB" % round(float(self.selecteddatasize) / 1024))

    def CalculateOptimize(self, args):
        """ Calculate & select optimal directories. """
        maxsize = 0
        self.datafiles.unselect_all()
        if (self.cdsize650.get_active()):
            maxsize = 665600                                # 650 * 1024
        elif (self.cdsize700.get_active()):
            maxsize = 716800                                # 700 * 1024
        if (self.totaldatasize <= maxsize):
            self.datafiles.select_all()
        else:

            # Insert size & filename into a valuable data structure
            sizefilename = {}
            sizelist = []
            line = 0
            try:
                name = gnome.tools.utf2iso(self.datafiles.get_text(line, 1))
                size = self.datafilesize[name]
            except:
                name = None
            while (name != None):
                if (sizefilename.has_key(size)):
                    sizefilename[size].append(name)
                else:
                    sizefilename[size] = [name]
                    sizelist.append(size)
                line = line + 1
                try:
                    name = gnome.tools.utf2iso(self.datafiles.get_text(line, 1))
                    size = atoi(self.datafiles.get_text(line, 2)[:-3])
                except:
                    name = None
            sizelist.sort()
            sizelist.reverse()

            # Move through all available sizes
            selectedsize = 0
            selectedfilenames = []
            for i in range(len(sizelist)):
                size = sizelist[i]
                filenames = sizefilename[size]
                for j in range(len(filenames)):
                    filename = filenames[j]
                    if ((selectedsize + size) <= maxsize):
                        selectedsize = selectedsize + size
                        selectedfilenames.append(filename)

            # Select files
            line = 0
            try:
                name = gnome.tools.utf2iso(self.datafiles.get_text(line, 1))
            except:
                name = None
            while (name != None):
                if (name in selectedfilenames):
                    self.datafiles.select_row(line, 1)
                line = line + 1
                try:
                    name = gnome.tools.utf2iso(self.datafiles.get_text(line, 1))
                except:
                    name = None

    def BurnData(self, burnbox):
        """ Create the window for selecting data. """

        # CD information and boot option frame
        info_frame = gtk.Frame(_(" Data CD - CD Info (Volume / Boot options) "))
        info_frame.set_border_width(5)
        info_frame.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        info_frame.show()

        # Create a table containing the Volume ID
        label = gtk.Label(_(" Enter Volume ID: "))
        label.show()
        self.volumeid = gtk.Entry()
        self.volumeid.show()
        volume_box = gtk.HBox(spacing = 3)
        volume_box.set_border_width(3)
        volume_box.pack_start(label, expand=gtk.FALSE)
        volume_box.pack_start(self.volumeid, expand=gtk.FALSE)
        volume_box.show()

        # Create a box with boot options
        self.makebootable = gtk.CheckButton(_("Bootable"))
        self.makebootable.connect("clicked", self.BootableClicked)
        self.makebootable.show()
        bootimagelabel = gtk.Label(_(" Image:"))
        bootimagelabel.show()
        self.bootimage = gtk.Entry()
        self.bootimage.show()
        bootimagehelp = gtk.Button()
        infoImage = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO, gtk.ICON_SIZE_SMALL_TOOLBAR)
        bootimagehelp.add(infoImage)
        bootimagehelp.connect("clicked", self.BootImageClicked)
        bootimagehelp.show()
        bootcataloglabel = gtk.Label(_(" Catalog:"))
        bootcataloglabel.show()
        self.bootcatalog = gtk.Entry()
        self.bootcatalog.show()
        bootcataloghelp = gtk.Button()
        infoImage = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO, gtk.ICON_SIZE_SMALL_TOOLBAR)
        bootcataloghelp.add(infoImage)
        bootcataloghelp.connect("clicked", self.BootCatalogClicked)
        bootcataloghelp.show()
        bootablebox = gtk.HBox(spacing = 3)
        bootablebox.set_border_width(3)
        bootablebox.pack_start(self.makebootable, expand = gtk.FALSE)
        bootablebox.pack_start(bootimagelabel, expand = gtk.FALSE)
        bootablebox.pack_start(self.bootimage, expand = gtk.FALSE)
        bootablebox.pack_start(bootimagehelp, expand = gtk.FALSE)
        bootablebox.pack_start(bootcataloglabel, expand = gtk.FALSE)
        bootablebox.pack_start(self.bootcatalog, expand = gtk.FALSE)
        bootablebox.pack_start(bootcataloghelp, expand = gtk.FALSE)
        bootablebox.show()

        # Create a new box with volume and boot options
        info_box = gtk.VBox()
        info_box.pack_start(volume_box)
        info_box.pack_start(bootablebox)
        info_box.show()

        info_frame.add(info_box)

        volumebox = gtk.HBox(spacing = 0)
        volumebox.pack_start(info_frame, expand = gtk.TRUE)
        volumebox.pack_start(gnome.tools.Pixmap(self.window, "%s/cdwriter.xpm" % iconpath).get_pixmap(), expand = gtk.FALSE)
        volumebox.show()

        burnbox.pack_start(volumebox, expand = gtk.FALSE)

        # Create some fields for selecting the Source Directory & calculating the directory size

        sourceframe = gtk.Frame(_(" Directories "))
        sourceframe.set_border_width(5)
        sourceframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        sourceframe.show()

        self.datafiles = gtk.CList(4, [ "", _(" Files / Directories "), _(" Size "), _(" Last modified ")])
        self.datafiles.connect("select_row", self.DataSelectRow)
        self.datafiles.connect("unselect_row", self.DataUnselectRow)
        self.datafiles.connect("drag_data_received", self.DragDataReceive)
        self.datafiles.drag_dest_set(gtk.DEST_DEFAULT_DROP | gtk.DEST_DEFAULT_MOTION, gnome.tools.targets, gtk.gdk.ACTION_COPY | gtk.gdk.ACTION_MOVE)
        self.datafiles.set_selection_mode(gtk.SELECTION_EXTENDED)
        self.datafiles.set_column_width(0, 18)
        self.datafiles.set_column_width(1, 350)
        self.datafiles.set_column_width(2, 80)
        self.datafiles.set_column_width(3, 155)
        self.datafiles.set_column_justification(2, gtk.JUSTIFY_RIGHT)
        self.datafiles.set_column_justification(3, gtk.JUSTIFY_RIGHT)
        self.datafiles.set_auto_sort(gtk.TRUE)
        self.datafiles.show()

        listwin = gtk.ScrolledWindow()
        listwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        listwin.add(self.datafiles)
        listwin.show()

        cdsize_label = gtk.Label(_("Select CD size:"))
        cdsize_label.show()
        self.cdsize650 = gtk.RadioButton(None, "650 MB")
        self.cdsize650.show()
        self.cdsize700 = gtk.RadioButton(self.cdsize650, "700 MB")
        self.cdsize700.show()
        sizelabel = gtk.Label(_("Total: "))
        sizelabel.set_alignment(1.0, 0.5)
        sizelabel.show()
        self.datasize = gtk.Entry()
        self.datasize.set_editable(gtk.FALSE)
        self.datasize.set_size_request(60, -1)
        self.datasize.set_text("0 MB")
        self.datasize.show()
        selectsize = gtk.Label(_("Selected: "))
        selectsize.set_alignment(1.0, 0.5)
        selectsize.show()
        self.datasizesel = gtk.Entry()
        self.datasizesel.set_editable(gtk.FALSE)
        self.datasizesel.set_size_request(60, -1)
        self.datasizesel.set_text("0 MB")
        self.datasizesel.show()
        empty_label = gtk.Label("")
        empty_label.show()

        sizebox = gtk.HBox(spacing = 3)
        sizebox.pack_start(cdsize_label, expand=gtk.FALSE)
        sizebox.pack_start(self.cdsize650, expand=gtk.FALSE)
        sizebox.pack_start(self.cdsize700, expand=gtk.FALSE)
        sizebox.pack_start(empty_label)
        sizebox.pack_start(sizelabel, expand=gtk.FALSE)
        sizebox.pack_start(self.datasize, expand=gtk.FALSE)
        sizebox.pack_start(selectsize, expand=gtk.FALSE)
        sizebox.pack_start(self.datasizesel, expand=gtk.FALSE)
        sizebox.show()

        file_box = gtk.VBox(spacing = 3)
        file_box.set_border_width(3)
        file_box.pack_start(listwin)
        file_box.pack_start(sizebox, expand = gtk.FALSE)
        file_box.show()

        sourceframe.add(file_box)
        burnbox.pack_start(sourceframe)

    def BootableClicked(self, args):
        """ Perform operations when someone has checked the "Bootable" checkbox. """
        if (gnome.tools.utf2iso(self.bootimage.get_text()) == ""):
            self.bootimage.set_text(gnome.tools.iso2utf("boot/boot.img"))
        if (gnome.tools.utf2iso(self.bootcatalog.get_text()) == ""):
            self.bootcatalog.set_text(gnome.tools.iso2utf("boot.catalog"))

    def BootImageClicked(self, args):
        gnome.tools.InfoDialog(_("The boot image has to be exactly the size of either a 1.2, 1.44, or " + 
                                    "a 2.88 meg floppy. You can create such an image with the command\n\n" +
                                    "dd if=/dev/fd0 of=boot.img bs=8192\n\n" +
                                    "if you have bootable floppy disk. For more information, please check " +
                                    "the README.eltorito from the mkisofs distribution."))

    def BootCatalogClicked(self, args):
        gnome.tools.InfoDialog(_("The filename you have to enter here is usually \"boot.catalog\". " + 
                                    "You don't have to create the file yourself, this will be done automatically."))

    def Destroy(self, uic, verbname = None, win = None):
        """ Close the main window (save options first). """
        self.SaveOptions()
        self.window.destroy()
        gtk.mainquit()

    def ImageInfo(self, args):
        """ Get the information of the image. """
        image = gnome.tools.utf2iso(self.cdimage.get_text())
        if (image == ""):
            gnome.tools.ErrorDialog(_("Please select an image file first."))
            return
        if (not os.path.exists(image)) or (os.path.isdir(image)):
            gnome.tools.ErrorDialog(_("The image file \"%s\" is not valid.") % image)
            return
        output = cmdoutput("isoinfo -d -i \"%s\"" % image, gtk.TRUE)
        for i in range(len(output)):
            line = output[i]
            if (line[:10] == "System id:"): self.sysidtext.set_text(line[11:])
            elif (line[:10] == "Volume id:"): self.volidtext.set_text(line[11:])
            elif (line[:14] == "Volume set id:"): self.volsettext.set_text(line[15:])
            elif (line[:13] == "Publisher id:"): self.pubidtext.set_text(line[14:])
            elif (line[:15] == "Application id:"): self.appidtext.set_text(line[16:])
            elif (line[:22] == "Logical block size is:"): self.blsizetext.set_text(line[23:])
            elif (line[:15] == "Volume size is:"): self.volsizetext.set_text(line[16:])

    def DeleteCDImage(self, args):
        """ Delete a CD image. """
        image = gnome.tools.utf2iso(self.cdimage.get_text())
        if (not os.path.exists(image)) or (os.path.isdir(image)):
            gnome.tools.ErrorDialog(_("The file \"%s\" doesn't exist.") % image)
            return
        dialog = gnome.tools.QuestionDialog(_("Do you really want to delete this ISO file ?"))
        if (dialog.get_result() == gtk.RESPONSE_YES):
            rm(image)

    def OpenBrowseCDImage(self, args):
        """ Browse for a CD Image. """
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.ISO_IMAGES, gnome.tools.CUE_SHEETS, gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.cdimages" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SelectImageFile, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", filedialog.destroy)
        filedialog.show()

    def SelectImageFile(self, args, get_directory, get_filenames, destroy):
        """ After browsing for the cd image enter the filename in the entry field. """
        self.cdimage.set_text(gnome.tools.iso2utf("%s%s%s" % (get_directory(), os.sep, get_filenames())))
        destroy()

    def BurnImage(self, frame):
        """ Create a frame for burning CD images. """

        # Create a table containing the Image selection
        label = gtk.Label(_("Select image: "))
        label.show()

        self.cdimage = gtk.Entry()
        self.cdimage.set_size_request(270, -1)
        self.cdimage.show()

        opencdimage = gtk.Button()
        openImage = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_SMALL_TOOLBAR)
        opencdimage.add(openImage)
        opencdimage.connect('clicked', self.OpenBrowseCDImage)
        opencdimage.show()

        infobutton = gtk.Button(stock="gtk-dialog-info")
        infobutton.connect('clicked', self.ImageInfo)
        infobutton.show()

        deleteButton = gtk.Button(stock="gtk-delete")
        deleteButton.connect("clicked", self.DeleteCDImage)
        deleteButton.show()

        imagetab = gtk.Table(1, 5)
        imagetab.attach(label, 0, 1, 0, 1, gtk.FILL, 0, 3, 3)
        imagetab.attach(self.cdimage, 1, 2, 0, 1, gtk.FILL, 0, 3, 3)
        imagetab.attach(opencdimage, 2, 3, 0, 1, gtk.FILL, 0, 3, 3)
        imagetab.attach(infobutton, 3, 4, 0, 1, gtk.FILL, 0, 3, 3)
        imagetab.attach(deleteButton, 4, 5, 0, 1, gtk.FILL, 0, 3, 3)
        imagetab.show()

        imageframe = gtk.Frame(_(" ISO or BIN/CUE Image "))
        imageframe.set_border_width(5)
        imageframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        imageframe.add(imagetab)
        imageframe.show()

        # Frame which contains the iso information
        infoframe = gtk.Frame(_(" ISO Information "))
        infoframe.set_border_width(5)
        infoframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        infoframe.show()

        sysidlabel = gtk.Label(_("System ID:"))
        sysidlabel.set_alignment(1.0, 0.5)
        sysidlabel.show()

        self.sysidtext = gtk.Entry()
        self.sysidtext.set_size_request(130, -1)
        self.sysidtext.set_editable(gtk.FALSE)
        self.sysidtext.show()

        volidlabel = gtk.Label(_("Volume ID:"))
        volidlabel.set_alignment(1.0, 0.5)
        volidlabel.show()

        self.volidtext = gtk.Entry()
        self.volidtext.set_size_request(130, -1)
        self.volidtext.set_editable(gtk.FALSE)
        self.volidtext.show()

        volsetlabel = gtk.Label(_("Volume set ID:"))
        volsetlabel.set_alignment(1.0, 0.5)
        volsetlabel.show()

        self.volsettext = gtk.Entry()
        self.volsettext.set_size_request(250, -1)
        self.volsettext.set_editable(gtk.FALSE)
        self.volsettext.show()

        pubidlabel = gtk.Label(_("Publisher ID:"))
        pubidlabel.set_alignment(1.0, 0.5)
        pubidlabel.show()

        self.pubidtext = gtk.Entry()
        self.pubidtext.set_size_request(250, -1)
        self.pubidtext.set_editable(gtk.FALSE)
        self.pubidtext.show()

        appidlabel = gtk.Label(_("Application ID:"))
        appidlabel.set_alignment(1.0, 0.5)
        appidlabel.show()

        self.appidtext = gtk.Entry()
        self.appidtext.set_size_request(350, -1)
        self.appidtext.set_editable(gtk.FALSE)
        self.appidtext.show()

        blsizelabel = gtk.Label(_("Logical block size:"))
        blsizelabel.set_alignment(1.0, 0.5)
        blsizelabel.show()

        self.blsizetext = gtk.Entry()
        self.blsizetext.set_size_request(80, -1)
        self.blsizetext.set_editable(gtk.FALSE)
        self.blsizetext.show()

        volsizelabel = gtk.Label(_("Volume size:"))
        volsizelabel.set_alignment(1.0, 0.5)
        volsizelabel.show()

        self.volsizetext = gtk.Entry()
        self.volsizetext.set_size_request(180, -1)
        self.volsizetext.set_editable(gtk.FALSE)
        self.volsizetext.show()

        infotab = gtk.Table(5, 5)
        infotab.attach(sysidlabel, 0, 1, 0, 1, gtk.FILL, 0, 3, 3)
        infotab.attach(self.sysidtext, 1, 2, 0, 1, gtk.FILL, 0, 3, 3)
        infotab.attach(volidlabel, 2, 3, 0, 1, gtk.FILL, 0, 3)
        infotab.attach(self.volidtext, 3, 4, 0, 1, gtk.FILL, 0, 3)
        infotab.attach(volsetlabel, 0, 1, 1, 2, gtk.FILL, 0, 3)
        infotab.attach(self.volsettext, 1, 4, 1, 2, gtk.FILL, 0, 3)
        infotab.attach(pubidlabel, 0, 1, 2, 3, gtk.FILL, 0, 3, 3)
        infotab.attach(self.pubidtext, 1, 4, 2, 3, gtk.FILL, 0, 3, 3)
        infotab.attach(appidlabel, 0, 1, 3, 4, gtk.FILL, 0, 3)
        infotab.attach(self.appidtext, 1, 4, 3, 4, gtk.FILL, 0, 3)
        infotab.attach(blsizelabel, 0, 1, 4, 5, gtk.FILL, 0, 3, 3)
        infotab.attach(self.blsizetext, 1, 2, 4, 5, gtk.FILL, 0, 3, 3)
        infotab.attach(volsizelabel, 2, 3, 4, 5, gtk.FILL, 0, 3)
        infotab.attach(self.volsizetext, 3, 4, 4, 5, gtk.FILL, 0, 3)
        infotab.show()

        infoframe.add(infotab)

        inputLabel = gtk.Label(_("Input:"))
        inputLabel.set_alignment(1.0, 0.5)
        inputLabel.show()

        cuefilelabel = gtk.Label(_("Cue file:"))
        cuefilelabel.set_alignment(1.0, 0.5)
        cuefilelabel.show()
        self.cuefile = gtk.Entry()
        # FIXME: self.__Application_ToolTips.set_tip(self.cuefile.gtk_entry(), _("Enter the name of the track index file"))
        # FIXME: self.__Application_ToolTips.set_tip(self.cuefile, _("Enter the name of the track index file"))
        self.cuefile.set_size_request(130, -1)
        self.cuefile.show()
        browsecuefilebutton = gtk.Button()
        openImage = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_SMALL_TOOLBAR)
        browsecuefilebutton.add(openImage)
        browsecuefilebutton.connect('clicked', self.OpenBrowseCueFilename)
        browsecuefilebutton.show()

        binfilelabel = gtk.Label(_("Bin file:"))
        binfilelabel.set_alignment(1.0, 0.5)
        binfilelabel.show()
        self.binfile = gtk.Entry()
        # FIXME: self.__Application_ToolTips.set_tip(self.binfile, _("Enter the name of the raw CD image file"))
        self.binfile.set_size_request(130, -1)
        self.binfile.show()
        browsebinfilebutton = gtk.Button()
        openImage = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_SMALL_TOOLBAR)
        browsebinfilebutton.add(openImage)
        browsebinfilebutton.connect('clicked', self.OpenBrowseBinFilename)
        browsebinfilebutton.show()

        outputLabel = gtk.Label(_("Output:"))
        outputLabel.set_alignment(1.0, 0.5)
        outputLabel.show()

        basenamelabel = gtk.Label(_("Basename:"))
        basenamelabel.set_alignment(1.0, 0.5)
        basenamelabel.show()
        self.basename = gtk.Entry()
        # FIXME: self.__Application_ToolTips.set_tip(self.basename.gtk_entry(), _("Basename is used for the beginning part of the created track files"))
        # FIXME: self.__Application_ToolTips.set_tip(self.basename, _("Basename is used for the beginning part of the created track files"))
        self.basename.set_size_request(130, -1)
        self.basename.show()
        browsebasenamebutton = gtk.Button()
        openImage = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_SMALL_TOOLBAR)
        browsebasenamebutton.add(openImage)
        browsebasenamebutton.connect('clicked', self.OpenBrowseBasename)
        browsebasenamebutton.show()

        frameCaption = _(" Convert cue/bin to iso ")
        mybchunk = bchunk()
        btnConvertCueToIso = gtk.Button(stock="gtk-execute")
        if (mybchunk.available() == gtk.TRUE):
            # FIXME: self.__Application_ToolTips.set_tip(btnConvertCueToIso, _("Converts a CD image in a \".bin / .cue\" format to a set of .iso and .cdr tracks"))
            btnConvertCueToIso.connect('clicked', self.ConvertCueBinToISO)
        else:
            frameCaption = _("%s - Note: You have to install 'bchunk' to enable this feature") % frameCaption
            # FIXME: self.__Application_ToolTips.set_tip(btnConvertCueToIso, _("You have to install 'bchunk' to enable the conversion."))
            btnConvertCueToIso.set_sensitive(gtk.FALSE)
            self.cuefile.set_sensitive(gtk.FALSE)
            browsecuefilebutton.set_sensitive(gtk.FALSE)
            self.binfile.set_sensitive(gtk.FALSE)
            browsebinfilebutton.set_sensitive(gtk.FALSE)
            self.basename.set_sensitive(gtk.FALSE)
            browsebasenamebutton.set_sensitive(gtk.FALSE)
        btnConvertCueToIso.show()
        emptyLabel = gtk.Label("")
        emptyLabel.show()
        performBox = gtk.HBox()
        performBox.pack_start(btnConvertCueToIso, expand = gtk.FALSE)
        performBox.pack_start(emptyLabel)
        performBox.show()

        bincuetoisotable = gtk.Table(2, 8)
        bincuetoisotable.attach(inputLabel, 0, 1, 0, 1, gtk.FILL, 0, 3, 3)
        bincuetoisotable.attach(cuefilelabel, 1, 2, 0, 1, gtk.FILL, 0, 3, 3)
        bincuetoisotable.attach(self.cuefile, 2, 3, 0, 1, 0, 0, 3, 3)
        bincuetoisotable.attach(browsecuefilebutton, 3, 4, 0, 1, 0, 0, 3, 3)
        bincuetoisotable.attach(binfilelabel, 4, 5, 0, 1, gtk.FILL, 0, 3, 3)
        bincuetoisotable.attach(self.binfile, 5, 6, 0, 1, 0, 0, 3, 3)
        bincuetoisotable.attach(browsebinfilebutton, 6, 7, 0, 1, 0, 0, 3, 3)
        bincuetoisotable.attach(outputLabel, 0, 1, 1, 2, gtk.FILL, 0, 3, 3)
        bincuetoisotable.attach(basenamelabel, 1, 2, 1, 2, gtk.FILL, 0, 3, 3)
        bincuetoisotable.attach(self.basename, 2, 3, 1, 2, 0, 0, 3, 3)
        bincuetoisotable.attach(browsebasenamebutton, 3, 4, 1, 2, 0, 0, 3, 3)
        bincuetoisotable.attach(performBox, 4, 7, 1, 2, gtk.FILL, 0, 3, 3)
        bincuetoisotable.show()
        
        bincuetoisoframe = gtk.Frame(frameCaption)
        bincuetoisoframe.set_border_width(5)
        bincuetoisoframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        bincuetoisoframe.add(bincuetoisotable)
        bincuetoisoframe.show()

        burnbox = gtk.VBox(spacing = 3)
        burnbox.pack_start(imageframe, expand = gtk.FALSE)
        burnbox.pack_start(infoframe, expand = gtk.FALSE)
        # burnbox.pack_start(frmBurnCueBin, expand = gtk.FALSE)
        burnbox.pack_start(bincuetoisoframe, expand = gtk.FALSE)
        burnbox.show()

        frame.add(burnbox)

    def ConvertCueBinToISO(self, args):
        """ Convert non-unix .cue/.bin files to .iso files by using bchunk """
        if (self.cuefile.get_text() == "") or (self.binfile.get_text() == "") or (self.basename.get_text() == ""):
            gnome.tools.ErrorDialog(_("You have to select a .cue and .bin file and a basename for the iso files first."))
        else:
            mybchunk = bchunk()
            mybchunk.cue_file = gnome.tools.utf2iso(self.cuefile.get_text())
            mybchunk.bin_file = gnome.tools.utf2iso(self.binfile.get_text())
            mybchunk.basename = gnome.tools.utf2iso(self.basename.get_text())
            command_line = "%s 2>&1 %s" % (mybchunk.command_line(), pipe_ecat)
            pgb = gnome.tools.ProgressBar("ECLiPt Roaster Info", _("Converting .cue/.bin files to .iso files - This may take a minute or two..."), 1)
            self.cat.debug(_("Executing %s") % command_line)
            pipe = popen2.popen2(command_line)
            line = None
            while (line != ""):
                line = pipe[0].readline()
            pipe[0].close()
            pipe[1].close()
            pipe = None
            pgb.update()
            pgb.close()
            pgb = None

    def OpenBrowseCueFilename(self, args):
        """ Browse for a cuesheet filename. """
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.CUE_SHEETS, gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.cuesheets" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SelectCueFile, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", filedialog.destroy)
        filedialog.show()

    def SelectCueFile(self, args, get_directory, get_filenames, destroy):
        self.cuefile.set_text(gnome.tools.iso2utf("%s%s%s" % (get_directory(), os.sep, get_filenames())))
        destroy()

    def OpenBrowseBinFilename(self, args):
        """ Browse for a .bin filename. """
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.BIN_FILES, gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.cuesheets" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SelectBinFile, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", filedialog.destroy)
        filedialog.show()

    def SelectBinFile(self, args, get_directory, get_filenames, destroy):
        self.binfile.set_text(gnome.tools.iso2utf("%s%s%s" % (get_directory(), os.sep, get_filenames())))
        destroy()

    def OpenBrowseBasename(self, args):
        """ Browse for a basename for the converted cue/bin file(s). """
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.basename" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SelectBasename, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", filedialog.destroy)
        filedialog.show()

    def SelectBasename(self, args, get_directory, get_filenames, destroy):
        self.basename.set_text(gnome.tools.iso2utf("%s%s%s" % (get_directory(), os.sep, get_filenames())))
        destroy()

    def OpenBrowseReadCDImage(self, args):
        """ Browse for a filename for reading a CD image. """
        filedialog = gnome.tools.FileSelectionDialog(multiselection = gtk.FALSE, filetypes = [gnome.tools.ISO_IMAGES, gnome.tools.ALL_FILES], icondir = iconpath, loglevel = self.cat.get_loglevel())
        filedialog.use_lastdirectory("%s%s%s%slastdirectory.cdimages" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep))
        filedialog.load_shortcuts_from_file("%s%s%s%s%s" % (gnome.tools.get_homedirectory(), os.sep, configdirectory, os.sep, shortcutfile))
        filedialog.ok_button.connect("clicked", self.SelectReadImageFile, filedialog.get_directory, filedialog.get_filenames, filedialog.destroy)
        filedialog.close_button.connect("clicked", filedialog.destroy)
        filedialog.show()

    def SelectReadImageFile(self, args, get_directory, get_filenames, destroy):
        """ After browsing for the cd image enter the filename in the entry field. """
        self.readcdimage.set_text(gnome.tools.iso2utf("%s%s%s" % (get_directory(), os.sep, get_filenames())))
        destroy()

    def __Application_show_audio_help(self, args):
        """ Shows an information dialog for file name creation. """
        gnome.tools.InfoDialog(_("The following identifiers are available for substitution:\n\n" +
                                    "     %m ..... Temporary direcotry\n" + 
                                    "     %c ..... CD title\n" +
                                    "     %d ..... Date and time\n" +
                                    "     %n ..... Track number\n" +
                                    "     %t ..... Track title\n" +
                                    "     %u ..... Username"))

    def ReadCDFrame(self, frame):
        """ Create a Frame for reading CDs. """
        readCDbox = gtk.VBox(spacing = 5)
        readCDbox.show()

        # Frame containing a button for reading an image
        readlabel = gtk.Label(_("Image filename: "))
        readlabel.show()

        readframe = gtk.Frame(_(" Read ISO Image "))
        readframe.set_border_width(5)
        readframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        readframe.show()

        readtab = gtk.Table(1, 4)
        readtab.show()

        self.readcdimage = gtk.Entry()
        self.readcdimage.set_size_request(350, -1)
        self.readcdimage.show()

        browsecdbutton = gtk.Button()
        openImage = gtk.image_new_from_stock(gtk.STOCK_OPEN, gtk.ICON_SIZE_SMALL_TOOLBAR)
        browsecdbutton.add(openImage)
        browsecdbutton.connect('clicked', self.OpenBrowseReadCDImage)
        browsecdbutton.show()
        
        readbutton = gtk.Button(stock="gtk-execute")
        readbutton.connect('clicked', self.ReadImage)
        readbutton.show()

        readtab.attach(readlabel, 0, 1, 0, 1, gtk.FILL, 0, 5, 5)
        readtab.attach(self.readcdimage, 1, 2, 0, 1, gtk.FILL, 0, 5, 5)
        readtab.attach(browsecdbutton, 2, 3, 0, 1, gtk.FILL, 0, 5, 5)
        readtab.attach(readbutton, 3, 4, 0, 1, gtk.FILL, 0, 5, 5)

        readframe.add(readtab)

        readCDbox.pack_start(readframe, expand = gtk.FALSE)

        readaudioframe = gtk.Frame(_(" Read Audio Files "))
        readaudioframe.set_border_width(5)
        readaudioframe.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        readaudioframe.show()

        self.readaudiowin = gtk.ScrolledWindow()
        self.readaudiowin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)
        self.readaudiowin.show()

        btnReadContent = gtk.Button(_(" Read Track List "))
        btnReadContent.connect('clicked', self.ReadAudioContent)
        btnReadContent.show()

        btnReadCD = gtk.Button(_(" Read Track Audio "))
        btnReadCD.connect('clicked', self.ReadAudioCD)
        btnReadCD.show()

        check_lame = lame(self.cat.get_loglevel())
        check_oggenc = oggenc()
        encoding_enabled = check_lame.available() and check_oggenc.available()

        self.__Application_encode_wav_button = gtk.CheckButton(_("Encode source with:"))
        self.__Application_encode_wav_button.set_sensitive(encoding_enabled)
        self.__Application_encode_wav_button.show()

        self.__Application_encoder_menu = gnome.tools.OptionMenu()
        self.__Application_encoder_menu.append_itemlist([encoderLame, encoderOggEnc])
        self.__Application_encoder_menu.show()

        emptyLabel = gtk.Label("")
        emptyLabel.show()

        boxButton = gtk.HBox(spacing = 3)
        boxButton.set_border_width(3)
        boxButton.pack_start(btnReadContent, expand = gtk.FALSE)
        boxButton.pack_start(btnReadCD, expand = gtk.FALSE)
        boxButton.pack_start(emptyLabel)
        boxButton.pack_start(self.__Application_encode_wav_button, expand = gtk.FALSE)
        boxButton.pack_start(self.__Application_encoder_menu.get_gtkoptionmenu(), expand = gtk.FALSE)
        boxButton.show()

        tracksLabel = gtk.Label(_("Number of tracks:"))
        tracksLabel.show()
        self.tracknumentry = gtk.Entry()
        self.tracknumentry.set_size_request(30, -1)
        self.tracknumentry.set_text("0")
        self.tracknumentry.set_editable(gtk.FALSE)
        self.tracknumentry.show()

        lengthLabel = gtk.Label(_("Total time:"))
        lengthLabel.show()
        self.totaltime = gtk.Entry()
        self.totaltime.set_size_request(60, -1)
        self.totaltime.set_text("00:00:00")
        self.totaltime.set_editable(gtk.FALSE)
        self.totaltime.show()

        cdnameLabel = gtk.Label(_("CD Title:"))
        cdnameLabel.show()
        self.cddb_title = gtk.Entry()
        self.cddb_title.set_size_request(250, -1)
        self.cddb_title.set_editable(gtk.FALSE)
        self.cddb_title.show()

        filenameLabel = gtk.Label(_("Target filename:"))
        filenameLabel.show()

        self.__Application_audio_fileheader = gtk.Entry()
        self.__Application_audio_fileheader.set_size_request(350, -1)
        self.__Application_audio_fileheader.show()

        audio_fileheader_info_button = gtk.Button()
        infoImage = gtk.image_new_from_stock(gtk.STOCK_DIALOG_INFO, gtk.ICON_SIZE_SMALL_TOOLBAR)
        audio_fileheader_info_button.add(infoImage)
        audio_fileheader_info_button.connect("clicked", self.__Application_show_audio_help)
        audio_fileheader_info_button.show()

        boxTargetFilename = gtk.HBox(spacing = 3)
        boxTargetFilename.set_border_width(3)
        boxTargetFilename.pack_start(filenameLabel, expand = gtk.FALSE)
        boxTargetFilename.pack_start(self.__Application_audio_fileheader, expand = gtk.FALSE)
        boxTargetFilename.pack_start(audio_fileheader_info_button, expand = gtk.FALSE)
        boxTargetFilename.show()

        boxTrackInfo = gtk.HBox(spacing = 3)
        boxTrackInfo.set_border_width(3)
        boxTrackInfo.pack_start(tracksLabel, expand = gtk.FALSE)
        boxTrackInfo.pack_start(self.tracknumentry, expand = gtk.FALSE)
        boxTrackInfo.pack_start(lengthLabel, expand = gtk.FALSE)
        boxTrackInfo.pack_start(self.totaltime, expand = gtk.FALSE)
        boxTrackInfo.pack_start(cdnameLabel, expand = gtk.FALSE)
        boxTrackInfo.pack_start(self.cddb_title, expand = gtk.FALSE)
        boxTrackInfo.show()

        self.boxTracks = gtk.VBox(spacing = 2)
        self.boxTracks.set_border_width(5)
        self.boxTracks.show()

        self.readaudiowin.add_with_viewport(self.boxTracks)
    
        boxReadAudioCD = gtk.VBox()
        boxReadAudioCD.pack_start(boxTargetFilename, expand = gtk.FALSE)
        boxReadAudioCD.pack_start(boxTrackInfo, expand = gtk.FALSE)
        boxReadAudioCD.pack_start(self.readaudiowin)
        boxReadAudioCD.pack_start(boxButton, expand = gtk.FALSE)
        boxReadAudioCD.show()

        readaudioframe.add(boxReadAudioCD)

        readCDbox.pack_start(readaudioframe)

        self.audiotracklist = []

        frame.add(readCDbox)

    def __Application_CheckCDInDrive(self, device):
        """ Check, wether there is a medium in the CDROM drive or not. """
        if (cddb_available == gtk.TRUE):
            try:
                cdrom = DiscID.open(device)
                disc_id = DiscID.disc_id(cdrom)
            except Exception, (num, msg):
                return gtk.FALSE
            return gtk.TRUE
        else:
            return gtk.TRUE

    def QueryCDDB(self):
        """ Query the CDDB Server and return an array of track names. """
        self.cat.debug(_("Querying CDDB Server"))
        try:
            cdrom = DiscID.open(self.devReader.get_text())
            disc_id = DiscID.disc_id(cdrom)
        except:
            self.cat.warn(_("Couldn't open CD: permission denied"))
            return {}

        try:
            (query_stat, query_info) = CDDB.query(disc_id)
        except:
            self.cat.warn(_("Couldn't query CDDB server"))
            return {}

        success = gtk.FALSE
        if (query_stat == 210) or (query_stat == 211):
            success = gtk.TRUE
            query_info = query_info[0]
        elif (query_stat == 200):
            success = gtk.TRUE

        if (success == gtk.TRUE):                 # Query successful
            self.cddb_title.set_text(query_info["title"])
            (read_stat, read_info) = CDDB.read(query_info['category'], query_info['disc_id'])
            if (read_stat == 210):
                tracks = {}
                for i in range(0, disc_id[1]):
                    tracks[i + 1] = read_info['TTITLE' + `i`]
                return tracks
            else:                               # Couldn't read track info
                return {}
        else:
            errorDialog = gnome.tools.ErrorDialog(_("CDDB info not available for this CD."))
            errorDialog.run()
            return {}                           # Couldn't query cddb server

    def ReadAudioCD(self, args):
        """ Read one or more tracks from an audio CD. """
        if (self.imageentry.get_text() == ""):
            gnome.tools.ErrorDialog(_("Please select an image path in the preferences tab first !"))
            return

        audio_files_selected = gtk.FALSE
        for i in range(len(self.audiotracklist)):
            if (self.audiotracklist[i].get_active()):
                audio_files_selected = gtk.TRUE
        if (audio_files_selected == gtk.FALSE):
            gnome.tools.ErrorDialog(_("Please select files to read first !"))
            return

        self.writermode = modeReadAudioCD
        if (self.__Application_encode_wav_button.get_active()):
            encoder = self.__Application_encoder_menu.get_active_item()
            if (encoder == encoderLame):
                mylame = lame(self.cat.get_loglevel())
                mylame.bitrate = 192
                mylame.source = "-"
                mylame.target = "\"%s.mp3\"" % self.__Application_audio_fileheader.get_text()
                encoder_command_line = mylame.command_line()
            elif (encoder == encoderOggEnc):
                myoggenc = oggenc()
                myoggenc.quality = 5
                myoggenc.quiet = gtk.TRUE
                myoggenc.source = "-"
                myoggenc.target = "\"%s.ogg\"" % self.__Application_audio_fileheader.get_text()
                encoder_command_line = myoggenc.command_line()
            command = "(cdda2wav -D %d,%d,%d -x -B -H -g -O wav -t %%n+%%n - | %s) 2>&1 %s" % ( int(self.channelReader.get_text()), int(self.idReader.get_text()), int(self.lunReader.get_text()), encoder_command_line, pipe_ecat)
        else:
            target_filename = "\"%s.wav\"" % self.__Application_audio_fileheader.get_text()
            command = "cdda2wav -D %d,%d,%d -x -B -H -g -O wav -t %%n+%%n %s 2>&1 %s" % ( int(self.channelReader.get_text()), int(self.idReader.get_text()), int(self.lunReader.get_text()), target_filename, pipe_ecat)
        command = sub("%u", get_username(), command)
        command = sub("%m", get_tempdir(), command)
        command = sub("%d", strftime("%d.%m.%Y %H:%M:%S", localtime(time())), command)
        self.BurnWindow(command)

    # Get Content of a Audio-CD
    def ReadAudioContent(self, args):
        if (self.__Application_CheckCDInDrive(self.devReader.get_text()) == gtk.FALSE):
            gnome.tools.ErrorDialog(_("No medium found in device") + " " + self.devReader.get_text())
            return
        self.cddb_title.set_text("")
        if (cddb_available == gtk.TRUE):
            self.cddb_info = self.QueryCDDB()
        else:
            self.cat.debug(_("No CDDB Query (python-cddb not available)"))
            self.cddb_info = {}
        cdda2wav = cdrtools.cdda2wav(self.channelReader.get_text(), self.idReader.get_text(), self.lunReader.get_text(), self.cat.get_loglevel())
        track_info = cdda2wav.get_track_info()
        self.audiotracklist = []
        self.readaudiowin.remove(self.readaudiowin.get_children()[0])
        self.boxTracks = gtk.VBox(spacing = 2)
        self.boxTracks.set_border_width(5)
        if (track_info["error_message"] != ""):
            gnome.tools.ErrorDialog(_(track_info["error_message"]))
        else:
            self.tracknumentry.set_text(track_info["number_of_tracks"])
            self.totaltime.set_text(track_info["total_time"])
            track_numbers = track_info["track_lengths"].keys()
            track_numbers.sort()
            for i in range(len(track_numbers)):
                track_number = track_numbers[i]
                track_length = track_info["track_lengths"][track_number]
                if (self.cddb_info.has_key(track_number)):
                    track_string = "%s - %s - Length: %s" % (zfill(track_number, 2), self.cddb_info[track_number], track_length)
                else:
                    track_string = "Track: %s - Length: %s" % (zfill(track_number, 2), track_length)
                self.audiotracklist.append(gtk.CheckButton(track_string))
                self.audiotracklist[track_number - 1].show()
                self.boxTracks.pack_start(self.audiotracklist[track_number - 1])
        self.boxTracks.show()
        self.readaudiowin.add_with_viewport(self.boxTracks)

    # Create a frame for copying a CD
    def CopyCDFrame(self, frame):

        labwarning = gtk.Label(_("Directly copying a CD might not be a good idea if your computer " +
                                "is slow, the source CD is scratched, \nthe magnetic radiation of your heater is " +
                                "too extreme, or if your wife has had a bad day. So everything you do here is at \nyour " +
                                "own risk !"))
        labwarning.show()

        warning_box = gtk.HBox(spacing = 8)
        warning_box.set_border_width(3)
        warningImage = gtk.image_new_from_stock(gtk.STOCK_STOP, gtk.ICON_SIZE_DND)
        warning_box.pack_start(warningImage, expand = gtk.FALSE)
        warning_box.pack_start(labwarning, expand = gtk.FALSE)
        warning_box.show()

        frmWarning = gtk.Frame(_(" CD-Copy - Warning "))
        frmWarning.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        frmWarning.add(warning_box)
        frmWarning.show()

        labLeft = gtk.Label("")
        labLeft.show()
        labRight = gtk.Label("")
        labRight.show()

        btnPerformCopy = gtk.Button(stock="gtk-execute")
        btnPerformCopy.connect('clicked', self.BurnCD)
        btnPerformCopy.show()

        tabCopyCD = gtk.Table(1, 3)
        tabCopyCD.attach(labLeft, 0, 1, 0, 1, gtk.EXPAND, 0, 5, 5)
        tabCopyCD.attach(btnPerformCopy, 1, 2, 0, 1, 0, 0, 5, 5)
        tabCopyCD.attach(labRight, 2, 3, 0, 1, gtk.EXPAND, 0, 5, 5)
        tabCopyCD.show()

        frmBurn = gtk.Frame()
        frmBurn.set_shadow_type(gtk.SHADOW_ETCHED_OUT)
        frmBurn.add(tabCopyCD)
        frmBurn.show()

        copyCDbox = gtk.VBox(spacing = 5)
        copyCDbox.set_border_width(5)
        copyCDbox.pack_start(frmWarning, expand = gtk.FALSE)
        copyCDbox.pack_start(frmBurn, expand = gtk.FALSE)
        copyCDbox.show()

        frame.add(copyCDbox)

    # Read a CD
    def ReadImage(self, args):
        readimage = gnome.tools.utf2iso(self.readcdimage.get_text())
        if (readimage == ""):
            gnome.tools.ErrorDialog(_("Please enter a filename for the image file first."))
            return
        if (os.path.exists(readimage)):
            question_dialog = gnome.tools.QuestionDialog(_("Warning: The file ") + readimage + _(" already exists - Do you want to overwrite ?"))
            if (question_dialog.get_result() != gtk.RESPONSE_YES):
                return
        my_readcd = cdrtools.readcd(int(self.channelReader.get_text()), int(self.idReader.get_text()), int(self.lunReader.get_text()))
        my_readcd.filename = readimage
        command = "%s 2>&1 %s" % (my_readcd.command_line(), pipe_ecat)
        self.writermode = modeReadCD
        self.BurnWindow(command)

    # Returns the length of a mp3/wav file in seconds
    def GetAudioTrackLength(self, filename):
        seconds = 0
        if (lower(filename[-4:]) == ".mp3"):
            file = open(filename, "rb")
            mpeginfo = MP3Info.MP3Info(file)
            seconds = int(mpeginfo.mpeg.length)
            file.close()
            del mpeginfo
        elif (lower(filename[-4:]) == ".ogg"):
            oggfileinfo = ogginfo(filename, self.cat.get_loglevel())
            seconds = int(oggfileinfo.track_length())
            del oggfileinfo
        else:
            try:
                wavefile = wave.open(filename, "r")
                seconds = wavefile.getnframes() / wavefile.getframerate ()
                wavefile.close()
            except:
                gnome.tools.ErrorDialog(_("An error occured when getting the track length of the wav file \"%s\"") % filename)
        return seconds

    def SelectAll(self, uic, verbname = None, win = None):
        """ Select all files either in the audio track or data track window. """
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.datafiles.select_all()
        elif (frames[page] == audiocd):
            self.songlist.select_all()
        elif (frames[page] == readcd):
            for i in range(len(self.audiotracklist)):
                self.audiotracklist[i].set_active(1)

    def UnSelectAll(self, uic, verbname = None, win = None):
        """ UnSelect all files either in the audio track or data track window. """
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.datafiles.unselect_all()
        elif (frames[page] == audiocd):
            self.songlist.unselect_all()
        elif (frames[page] == readcd):
            for i in range(len(self.audiotracklist)):
                self.audiotracklist[i].set_active(0)

    def __Application_Toolbar_AutoSelect(self, uic, verbname = None, win = None):
        """ AutoSelect files in the data track window. """
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.CalculateOptimize(None)

    def __Application_Toolbar_Add(self, uic, verbname = None, win = None):
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.AddDataFile(None)
        elif (frames[page] == audiocd):
            self.AddFile(None)

    def __Application_Toolbar_Remove(self, uic, verbname = None, win = None):
        page = self.notebook.get_current_page()
        if (frames[page] == datacd):
            self.DelDataFile(None)
        elif (frames[page] == audiocd):
            self.DelFile(None)

    def parsecmdline(self):
        """ Parse command line parameters. """
        self.startup_burnmode = None
        self.startup_burnfiles = None
        try:
            optlist, args = getopt.getopt(sys_argv[1:], 'dh', ["debug", "help", "data", "audio", "copy", "image"])

            for flag, arg in optlist:
                if (flag == "-d") or (flag == "--debug"):
                    self.cat.set_loglevel(log4py.LOGLEVEL_DEBUG)
                    self.cat.debug(_("Setting debug level"))
                elif (flag == "-h") or (flag == "--help"):
                    self.cat.info(_("Usage: eroaster [options] [files]"))
                    self.cat.info(_("Options:"))
                    self.cat.info(_("      --audio   use [files] to burn a audio CD."))
                    self.cat.info(_("      --copy    perform a direct CD copy."))
                    self.cat.info(_("      --data    use [files] to burn a data CD."))
                    self.cat.info(_("  -d, --debug   debug mode (be very verbose)."))
                    self.cat.info(_("  -h, --help    print this help."))
                    self.cat.info(_("      --image   burn an image to CD."))
                    sys.exit(0)
                elif (flag == "--data"):
                    self.startup_burnmode = eraDataCD
                    self.startup_burnfiles = args
                elif (flag == "--audio"):
                    self.startup_burnmode = eraAudioCD
                    self.startup_burnfiles = args
                elif (flag == "--copy"):
                    self.startup_burnmode = eraCopyCD
                    self.startup_burnfiles = args
                elif (flag == "--image"):
                    self.startup_burnmode = eraCDImage
                    self.startup_burnfiles = args
                else:
                    self.cat.error(_("Option %s not recognized") % str(flag))
                    sys.exit(1)

        except getopt.error, detail:
            self.cat.error(detail)
            sys.exit(1)

    def main(self):
        """ This is the main loop. """
        gtk.threads_enter()
        gtk.main()
        gtk.threads_leave()
