/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __AEDGE_H
#define __AEDGE_H

//-- Project includes --
#include "Foundation/vec3.h"

/*!
  \class AEdge
  \brief abstract base class for edges in mesh (2D or 3D)

  \author Steffen Abe
  $Revision$
  $Date$
*/
class AEdge
{
 protected:
  Vec3 m_p0,m_p1;
  
 public:
  AEdge(const Vec3&,const Vec3&);
  virtual ~AEdge();

  double sep(const Vec3&) const;
  pair<bool,double> dist(const Vec3&) const ; // signed separation according to direction of the normal
  Vec3 getBoundingBoxMin() const; 
  Vec3 getBoundingBoxMax() const;   
};
#endif // __AEDGE_H
