#############################################################
##                                                         ##
## Copyright (c) 2003-2011 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

import logging
import string

strLevelDict = dict()
strLevelDict["INFO"]     = logging.INFO
strLevelDict["WARNING"]  = logging.WARNING
strLevelDict["ERROR"]    = logging.ERROR
strLevelDict["DEBUG"]    = logging.DEBUG
strLevelDict["CRITICAL"] = logging.CRITICAL

def getLevel(levelString):
    return strLevelDict[string.upper(levelString)]

def getStringLevelList():
    return strLevelDict.keys()

getLogger = logging.getLogger
basicConfig = logging.basicConfig
