/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __PARALLEL_INTERACTION_STORAGE_SINGLE_H
#define __PARALLEL_INTERACTION_STORAGE_SINGLE_H

#include "pis/pi_storage.h"
#include <vector>

//--- IO includes ---

/*!
  \brief parallel storage array without exchange for dynamically created single particle
  interactions (i.e. Damping...)
*/
template<typename P,typename I>
class ParallelInteractionStorage_Single : public TParallelInteractionStorage<I>
{
 protected:
  typename I::ParameterType m_param;

 public:
  ParallelInteractionStorage_Single(AParallelParticleArray*,const typename I::ParameterType&);

  virtual void addExIG(AParallelInteractionStorage*){}; // do nothing
  virtual bool update();
  virtual void exchange(){}; //!< do nothing
  virtual void rebuild(){}; //!< do nothing
  virtual void tryInsert(const vector<int>&){};//!< do nothing
  virtual bool isIn(const vector<int>&){return true;}; 
  virtual void calcForces();
  virtual void setTimeStepSize(double dt);
};

#include "pi_storage_single.hpp"

#endif //__PARALLEL_INTERACTION_STORAGE_SINGLE_H
