/* $Id: plugin.c 16088 2005-10-03 18:59:41Z etxrab $
 *
 * Routines for H.223 packet dissection
 * Copyright (c) 2005 MX Telecom Ltd <richardv@mxtelecom.com>
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <gmodule.h>
#include <glib.h>
#include "moduleinfo.h"

#include "packet-h223.h"
#include "packet-srp.h"

#ifndef ENABLE_STATIC
G_MODULE_EXPORT const gchar version[] = VERSION;

G_MODULE_EXPORT void plugin_register(void)
{
    /* register the new protocol, protocol fields, and subtrees */
    proto_register_h223();
    proto_register_srp();
    proto_register_ccsrl();
}

G_MODULE_EXPORT void plugin_reg_handoff(void){
    proto_reg_handoff_h223();
    proto_reg_handoff_srp();
}
#endif
