#ifndef _ETOKEN_H
#define _ETOKEN_H

#include <sys/types.h>

struct eToken {
	struct usb_dev_handle *usb;
	int atrlen;
	u_int8_t atr[MAX_ATR_SIZE];
	u_int8_t nad;		/* NAD */
	u_int8_t ns;		/* N(S) */
	u_int8_t nr;		/* N(R) */
	u_int8_t ifsd;		/* Information Field Size Device */
	u_int8_t ifsc;		/* Information Field Size Card */
	u_int8_t rc;		/* Redundancy Check (LRC/CRC) */
};

/* etoken.c */
int power_up_etoken(struct eToken *eToken);
int power_down_etoken(struct eToken *eToken);
int init_etoken(struct eToken *eToken);

/* T=1 checksum */

#define T1_CHECKSUM_LRC      0x00
#define T1_CHECKSUM_CRC      0x01

void hexdump(const u_int8_t * data, int length);

int usb_transfer(struct eToken *eToken, u_int8_t * buffer_out,
		 u_int8_t * buffer_in, int len_out, int *len_int);

int send_command(struct eToken *t1, u_int8_t * apdu_cmd,
		 u_int8_t * apdu_rsp, int apdu_cmdlen, int *apdu_rsplen);

#endif				/* _ETOKEN_H */
