#include <wintypes.h>
#include <pcsclite.h>
#include <usb.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <syslog.h>

#include "ifdhandler.h"
#include "etoken.h"

/* get eToken */

struct eToken *get_token_by_lun(DWORD Lun)
{
	static struct eToken eToken;

	if (Lun == 0)
		return &eToken;

	return NULL;
}

/* the ifd handler functions */

RESPONSECODE IFDHCreateChannel(DWORD Lun, DWORD Channel)
{
	struct eToken *eToken;

#ifdef DEBUG
	syslog(LOG_DEBUG,
	       "%s %d %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_COMMUNICATION_ERROR;
	}

	if (eToken->usb) {
		IFDHCloseChannel(Lun);
	}

	return IFD_SUCCESS;
}

RESPONSECODE IFDHCloseChannel(DWORD Lun)
{
	struct eToken *eToken;

#ifdef DEBUG
	syslog(LOG_DEBUG,
	       "%s %d %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_COMMUNICATION_ERROR;
	}

	if (eToken->usb) {
		power_down_etoken(eToken);
		return IFD_SUCCESS;
	}

	return IFD_COMMUNICATION_ERROR;
}

RESPONSECODE
IFDHGetCapabilities(DWORD Lun, DWORD Tag, PDWORD Length, PUCHAR Value)
{
#ifdef DEBUG
	syslog(LOG_DEBUG, "%s %d %s: Lun %ld, Tag %ld\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__, Lun, Tag);
#endif

	/* incomplete */
	return IFD_ERROR_TAG;
}

RESPONSECODE
IFDHSetCapabilities(DWORD Lun, DWORD Tag, DWORD Length, PUCHAR Value)
{
#if 0 && defined(DEBUG)
	syslog(LOG_DEBUG,
	       "%s %d %s: Lun %ld, Tag %ld, Length %ld, hexdump follows\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__, Lun, Tag, Length);
	hexdump(Value, Length);
#endif

	/* incomplete */
	return IFD_ERROR_TAG;
}

RESPONSECODE
IFDHSetProtocolParameters(DWORD Lun, DWORD Protocol,
			  UCHAR FLAGS, UCHAR PTS1, UCHAR PTS2, UCHAR PTS3)
{
	struct eToken *eToken;

#ifdef DEBUG
	syslog(LOG_DEBUG,
	       "%s %d %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_COMMUNICATION_ERROR;
	}

	if (Protocol == 0) {
		/* FIXME: we should support T=0 */
		return IFD_PROTOCOL_NOT_SUPPORTED;
	}

	if (Protocol > 1) {
		/* unsupported protocoll */
		return IFD_PROTOCOL_NOT_SUPPORTED;
	}

	/* FIXME: incomplete */
	return IFD_COMMUNICATION_ERROR;
}

/* very ugly hack to work around pcsc-lite bugs */
int firsttime = 0;

RESPONSECODE IFDHPowerICC(DWORD Lun, DWORD Action,
			  PUCHAR Atr, PDWORD AtrLength)
{
	struct eToken *eToken;

#ifdef DEBUG
	syslog(LOG_DEBUG, "%s %d %s: Lun %ld, Action %ld\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__, Lun, Action);
#endif

	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_ERROR_NOT_SUPPORTED;
	}

	*AtrLength = 0;

	switch (Action) {
	case IFD_RESET:
		if (eToken->usb && init_etoken(eToken)) {
			memcpy(Atr, eToken->atr, eToken->atrlen);
			*AtrLength = eToken->atrlen;
			return IFD_SUCCESS;
		}
		/* fallthrough */
	case IFD_POWER_UP:
		if (power_up_etoken(eToken)) {
			memcpy(Atr, eToken->atr, eToken->atrlen);
			*AtrLength = eToken->atrlen;
			return IFD_SUCCESS;
		}

		/* very ugly hack ! */
		if (firsttime==0) {
			static u_int8_t ATR[]= { 0x3b, 0xe2, 0x00, 0xff, 0xc1, 0x10, 0x31, 0xfe, 0x55, 0xc8, 0x02, 0x9c};
			firsttime=1;
	
			memcpy(Atr, ATR, sizeof(ATR));
			*AtrLength = sizeof(ATR);
#ifdef DEBUG
			syslog(LOG_DEBUG, "%s %d %s: forced power up to succeed (very ugly hack!)\n",
		       		__FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif
			return IFD_SUCCESS;
		}


		return IFD_ERROR_POWER_ACTION;

	case IFD_POWER_DOWN:
		if (eToken->usb) {
			power_down_etoken(eToken);
			return IFD_SUCCESS;
		}
		return IFD_ERROR_POWER_ACTION;
	default:
		return IFD_ERROR_NOT_SUPPORTED;
	}
}

RESPONSECODE IFDHControl(DWORD Lun, PUCHAR TxBuffer,
			 DWORD TxLength, PUCHAR RxBuffer, PDWORD RxLength)
{
	struct eToken *eToken;

#ifdef DEBUG
	syslog(LOG_DEBUG,
	       "%s %d %s: Lun %ld TxLength %ld RxLength %ld, hexdump follows\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__,
	       Lun, TxLength, *RxLength);
	hexdump(TxBuffer, TxLength);
#endif

	*RxLength = 0;
	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_COMMUNICATION_ERROR;
	}

	/* Control is for reader communication.
	 * Implementation is optional. */
	return IFD_COMMUNICATION_ERROR;
}

RESPONSECODE IFDHICCPresence(DWORD Lun)
{
	struct eToken *eToken;

#if 0 && defined(DEBUG)
	syslog(LOG_DEBUG,
	       "%s %d %s: Lun %ld\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__, Lun);
#endif

	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_COMMUNICATION_ERROR;
	}

	/* how do we probe, if some usb device got unplugged ? */
	/* one we try to communicate we will so. 
	 * for now the card is always present. 
	 * FIXME: replace with better handling */
	return IFD_ICC_PRESENT;
}

RESPONSECODE IFDHTransmitToICC(DWORD Lun,
			       SCARD_IO_HEADER SendPci,
			       PUCHAR TxBuffer,
			       DWORD TxLength,
			       PUCHAR RxBuffer,
			       PDWORD RxLength, PSCARD_IO_HEADER RecvPci)
{
	struct eToken *eToken;
	int rc, len_in;

#ifdef DEBUG
	syslog(LOG_DEBUG,
	       "%s %d %s: Lun %ld Protocol %ld TxLength %ld RxLength %ld, hexdump follows\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__, Lun,
	       SendPci.Protocol, TxLength, *RxLength);
	hexdump(TxBuffer, TxLength);
#endif

	len_in = *RxLength;
	*RxLength = 0;		/* should be 0 on all errors */

	eToken = get_token_by_lun(Lun);
	if (!eToken) {
		return IFD_COMMUNICATION_ERROR;
	}

	if (SendPci.Protocol == 0) {
		/* FIXME: we should support T=0 */
		return IFD_PROTOCOL_NOT_SUPPORTED;
	}

	if (SendPci.Protocol > 1) {
		/* only T=0 and T=1 supported */
		return IFD_PROTOCOL_NOT_SUPPORTED;
	}

	if ((TxBuffer == NULL) || (RxBuffer == NULL)
	    || (RxLength == NULL)) {
		/* these should not be NULL */
		return IFD_COMMUNICATION_ERROR;
	}

	rc = send_command(eToken, TxBuffer, RxBuffer, TxLength, &len_in);
	*RxLength = len_in;

#ifdef DEBUG
	syslog(LOG_DEBUG,
	       "%s %d %s: Status %d, RxLength %ld, hexdump follows\n",
	       __FILE__, __LINE__, __PRETTY_FUNCTION__, rc, *RxLength);
	hexdump(RxBuffer, *RxLength);
#endif

	return rc;
}
