/*
 * Software License Agreement (BSD License)
 *
 * Copyright (c) 2008, Regents of the University of California
 * All rights reserved.
 *
 * Redistribution and use of this software in source and binary forms, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 *
 * * Redistributions of source code must retain the above
 *   copyright notice, this list of conditions and the
 *   following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above
 *   copyright notice, this list of conditions and the
 *   following disclaimer in the documentation and/or other
 *   materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * Author: Sunil Soman sunils@cs.ucsb.edu
 */

package edu.ucsb.eucalyptus.storage;

import edu.ucsb.eucalyptus.cloud.EucalyptusCloudException;

import java.util.List;

public interface BlockStorageManager {
    public void initVolumeManager();

    public void configure();
    
    public void checkPreconditions() throws EucalyptusCloudException;

    public void reload();

    public void startupChecks();

    public void setStorageInterface(String storageInterface);

    public void cleanVolume(String volumeId);

    public void cleanSnapshot(String volumeId);

    public List<String> createSnapshot(String volumeId, String snapshotId) throws EucalyptusCloudException;

    public List<String> prepareForTransfer(String volumeId, String snapshotId) throws EucalyptusCloudException;

    public void createVolume(String volumeId, int size) throws EucalyptusCloudException;

    public int createVolume(String volumeId, String volumePath) throws EucalyptusCloudException;

    public int createVolume(String volumeId, String snapshotId, int size) throws EucalyptusCloudException;

    public void dupVolume(String volumeId, String dupedVolumeId) throws EucalyptusCloudException;
    
    public List<String> getStatus(List<String> volumeSet) throws EucalyptusCloudException;

    public void deleteVolume(String volumeId) throws EucalyptusCloudException;

    public void deleteSnapshot(String snapshotId) throws EucalyptusCloudException;

    public List<String> getVolume(String volumeId) throws EucalyptusCloudException;

    public void loadSnapshots(List<String> snapshotSet, List<String> snapshotFileNames) throws EucalyptusCloudException;

    public List<String> getSnapshotValues(String snapshotId) throws EucalyptusCloudException;

    public int getSnapshotSize(String snapshotId) throws EucalyptusCloudException;    
}