/*  Evoution RSS Reader Plugin
 *  Copyright (C) 2007  Lucian Langa <cooly@mips.edu.ms> 
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H

#include "config.h"
#endif

/* We include gi18n-lib.h so that we have strings translated directly for this package */
//#include <glib/gi18n-lib.h>
#include <string.h>
#include <stdio.h>

#include <camel/camel-mime-message.h>
#include <camel/camel-folder.h>
#include <camel/camel-exception.h>
#include <camel/camel-multipart.h>
#include <camel/camel-stream-mem.h>

#include <mail/em-popup.h>
#include <e-util/e-error.h>
#include <e-util/e-icon-factory.h>

#include <mail/em-config.h>
#include <mail/em-event.h>

#include <mail/em-utils.h>
#include <mail/em-folder-tree.h>
#include <mail/em-folder-tree-model.h>
#include <mail/em-folder-utils.h>
#include <mail/em-folder-view.h>
#include <mail/mail-mt.h>

#include "mail/em-format-html.h"

#include <mail/em-format.h>
#include <mail/em-format-hook.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h> 
#include <stdlib.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "mail/mail-component.h"

#include <bonobo/bonobo-shlib-factory.h>

#include <glade/glade-xml.h>
#include <glade/glade.h>
#include <shell/evolution-config-control.h>

#include <libxml/parser.h>
#include <libxml/xmlmemory.h>
#include <libxml/HTMLparser.h>


#include <libsoup/soup.h>
#include <libsoup/soup-message-queue.h>

#include "rss.h"
#include "network-soup.c"

//#define RSS_DEBUG 1
#define d(x)

/* ms between status updates to the gui */
#define STATUS_TIMEOUT (250)

static volatile int org_gnome_rss_controls_counter_id = 0;

struct _org_gnome_rss_controls_pobject {
        EMFormatHTMLPObject object;

        CamelMimePart *part;
	gchar *website;
	guint is_html;
};

extern int xmlSubstituteEntitiesDefaultValue;

rssfeed *rf;

#define RSS_CONTROL_ID  "OAFIID:GNOME_Evolution_RSS:" EVOLUTION_VERSION
#define FACTORY_ID      "OAFIID:GNOME_Evolution_RSS_Factory:" EVOLUTION_VERSION

gboolean setup_feed(add_feed *feed);
gchar *display_doc (RDF *r);
void check_folders(void);
gboolean update_articles(gboolean disabler);
u_int32_t update_channel(const char *chn_name, char *main_date, GArray *item);
static char *layer_find (xmlNodePtr node, char *match, char *fail);
static xmlNode *html_find (xmlNode *node, char *match);
gchar *strplchr(gchar *source);

/*======================================================================*/

static void
statuscb(NetStatusType status, gpointer statusdata, gpointer data)
{
//	rssfeed *rf = data;
    NetStatusProgress *progress;
    float fraction = 0;
#ifdef RSS_DEBUG
	g_print("status:%d\n", status);
#endif

    switch (status) {
    case NET_STATUS_BEGIN:
        //progress_window_set_cancel_cb(pw, net_mainloop_cancel, statusdata);
        //progress_window_set_progress(pw, 0);
        g_print("NET_STATUS_BEGIN\n");
        break;
    case NET_STATUS_PROGRESS:
        progress = (NetStatusProgress*)statusdata;
        if (progress->current > 0 && progress->total > 0) {
		fraction = (float)progress->current / progress->total;
		while (gtk_events_pending ())
                        gtk_main_iteration ();
#ifndef EVOLUTION_2_12
		if (rf->progress_dialog  && 0 <= fraction && 1 >= fraction)
		{
			gtk_progress_bar_set_fraction((GtkProgressBar *)rf->progress_bar, fraction);
			gchar *what = g_strdup_printf(_("%2.0f%% done"), fraction*100);
			gtk_label_set_text(GTK_LABEL(rf->label), data);
	        	gtk_progress_bar_set_text((GtkProgressBar *)rf->progress_bar, what);
	        	g_free(what);
		}
#else
		if (rf->progress_bar && 0 <= fraction && 1 >= fraction)
			gtk_progress_bar_set_fraction((GtkProgressBar *)rf->progress_bar, fraction);
		if (rf->sr_feed)
		{
			gchar *furl = g_strdup_printf("<b>%s</b>: %s", 
				g_hash_table_lookup(rf->hrt, data),
				data);
			gtk_label_set_markup (GTK_LABEL (rf->sr_feed), furl);
			g_free(furl);
		}
#endif
        }
        break;
    case NET_STATUS_DONE:
        //progress_window_set_cancel_cb(pw, NULL, NULL);
        //progress_window_set_progress(pw, -1);
        g_print("NET_STATUS_DONE\n");
        break;
    default:
        g_warning("unhandled network status %d\n", status);
    }
}

static void
textcb(NetStatusType status, gpointer statusdata, gpointer data)
{
    NetStatusProgress *progress;
    float fraction = 0;
    switch (status) {
    case NET_STATUS_PROGRESS:
        progress = (NetStatusProgress*)statusdata;
        if (progress->current > 0 && progress->total > 0) {
	fraction = (float)progress->current / progress->total;
	g_print("%f.", fraction*100);
	}
	while (gtk_events_pending())
      		gtk_main_iteration ();
        break;
    default:
        g_warning("unhandled network status %d\n", status);
    }
}

void
create_user_pass_dialog(gchar *url)
{
GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *username;
  GtkWidget *password;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
  GtkWidget *checkbutton1;
  GtkWidget *vbox1;

  if (!rf->hruser)
        rf->hruser = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_free);
  if (!rf->hrpass)
        rf->hrpass = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_free);

  GtkAccelGroup *accel_group = gtk_accel_group_new ();

  dialog1 = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog1), _("Enter User/Pass for Feed"));
  gtk_window_set_type_hint (GTK_WINDOW (dialog1), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_window_set_modal (GTK_WINDOW (dialog1), FALSE);

  dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 3);

  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (vbox1), table1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

  label1 = gtk_label_new (_("Username:"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label1), 0, 0.5);

  label2 = gtk_label_new (_("Password:"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label2), 0, 0.5);

  username = gtk_entry_new ();
  gtk_widget_show (username);
  gtk_table_attach (GTK_TABLE (table1), username, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (username), 8226);
    gchar *user = g_hash_table_lookup(rf->hruser,  url);
    if (user)
        gtk_entry_set_text (GTK_ENTRY (username), user);
  password = gtk_entry_new ();
  gtk_widget_show (password);
  gtk_table_attach (GTK_TABLE (table1), password, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_visibility (GTK_ENTRY (password), FALSE);
  gchar *pass = g_hash_table_lookup(rf->hrpass,  url);
    if (pass)
        gtk_entry_set_text (GTK_ENTRY (password), pass);
  gtk_entry_set_invisible_char (GTK_ENTRY (password), 8226);

  checkbutton1 = gtk_check_button_new_with_mnemonic (_("Remember password"));
  gtk_widget_show (checkbutton1);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton1, FALSE, FALSE, 0);


  dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);
  gtk_widget_add_accelerator (okbutton1, "activate", accel_group,
                              GDK_Return, (GdkModifierType) 0,
                              GTK_ACCEL_VISIBLE);
  gtk_window_add_accel_group (GTK_WINDOW (dialog1), accel_group);
  gint result = gtk_dialog_run(GTK_DIALOG(dialog1));
  switch (result)
  {
    case GTK_RESPONSE_OK:
        if (user)
            g_hash_table_remove(rf->hruser, url);
        g_hash_table_insert(rf->hruser, url, g_strdup(gtk_entry_get_text (GTK_ENTRY (username))));
        if (pass)
            g_hash_table_remove(rf->hrpass, url);
        g_hash_table_insert(rf->hrpass, url, g_strdup(gtk_entry_get_text (GTK_ENTRY (password))));
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkbutton1)))
		save_up(url);
	else
		del_up(url);
	
        gtk_widget_destroy (dialog1);
        break;
    default:
        gtk_widget_destroy (dialog1);
        break;
  }
}

add_feed *
create_dialog_add(gchar *text, gchar *feed_text)
{
  GtkWidget *dialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *hbox1;
  GtkWidget *label2;
  GtkWidget *entry1;
  GtkWidget *checkbutton1;
  GtkWidget *dialog_action_area1;
  GtkWidget *cancelbutton1;
  GtkWidget *okbutton1;
  add_feed *feed = g_new0(add_feed, 1);
  gboolean fhtml = FALSE;
  GtkAccelGroup *accel_group = gtk_accel_group_new ();

  dialog1 = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (dialog1), _("Add Feeds"));
  gtk_window_set_destroy_with_parent (GTK_WINDOW (dialog1), TRUE);
  gtk_window_set_type_hint (GTK_WINDOW (dialog1), GDK_WINDOW_TYPE_HINT_DIALOG);
  gtk_window_set_modal (GTK_WINDOW (dialog1), FALSE);

  dialog_vbox1 = GTK_DIALOG (dialog1)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 9);

  label2 = gtk_label_new (_("Feed URL: "));
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox1), label2, FALSE, FALSE, 0);

  entry1 = gtk_entry_new ();
  gtk_widget_show (entry1);
  gtk_box_pack_start (GTK_BOX (hbox1), entry1, TRUE, TRUE, 0);
  gtk_entry_set_invisible_char (GTK_ENTRY (entry1), 8226);
  //editing
  if (text != NULL)
  {
	gtk_entry_set_text(GTK_ENTRY(entry1), text);
	fhtml = GPOINTER_TO_INT(
		g_hash_table_lookup(rf->hrh, feed_text));
  }

  checkbutton1 = gtk_check_button_new_with_mnemonic (
		_("Show the article summary instead of web page"));
  gtk_widget_show (checkbutton1);
  gtk_box_pack_start (GTK_BOX (vbox1), checkbutton1, FALSE, TRUE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton1), 1-fhtml);
  dialog_action_area1 = GTK_DIALOG (dialog1)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (dialog1), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);
  
  gtk_widget_add_accelerator (okbutton1, "activate", accel_group,
                              GDK_Return, (GdkModifierType) 0,
                              GTK_ACCEL_VISIBLE);
  gtk_widget_add_accelerator (okbutton1, "activate", accel_group,
                              GDK_KP_Enter, (GdkModifierType) 0,
                              GTK_ACCEL_VISIBLE);
  gtk_window_add_accel_group (GTK_WINDOW (dialog1), accel_group);

  gint result = gtk_dialog_run(GTK_DIALOG(dialog1));
  switch (result)
  {
    case GTK_RESPONSE_OK:
	feed->feed_url = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry1)));
	fhtml = gtk_toggle_button_get_active (
		GTK_TOGGLE_BUTTON (checkbutton1));
	fhtml ^= 1;
	feed->fetch_html = fhtml;
	feed->add = 1;
	// there's no reason to feetch feed if url isn't changed
	if (text && !strncmp(text, feed->feed_url, strlen(text)))
		feed->changed = 0;
	else
		feed->changed = 1;
       	break;
    default:
	feed->add = 0;
	gtk_widget_destroy (dialog1);
	break;
  }
	feed->dialog = dialog1;
  return feed;
}

static void
construct_list(gpointer key, gpointer value, gpointer user_data)
{
	GtkListStore  *store = user_data;
	GtkTreeIter    iter;

	gtk_list_store_append (store, &iter);
  	gtk_list_store_set (store, &iter,
		0, g_hash_table_lookup(rf->hre, key),
       		1, key, 
     		2, g_hash_table_lookup(rf->hrt, key),
      		-1);
}

void
cancel_soup_sess(gpointer key, gpointer value, gpointer user_data)
{
	g_print("sess:%p ", key);
	g_print("msg:%p\n", value);
	soup_message_set_status(value,  SOUP_STATUS_CANCELLED);
	soup_session_cancel_message(key, value);
	soup_session_abort(key);
	g_hash_table_remove(rf->session, key);
}

static void
readrss_dialog_cb (GtkWidget *widget, gpointer data)
{
#ifdef RSS_DEBUG
	g_print("\nCancel reading feeds\n");
#endif
	//abort all session
	g_hash_table_foreach(rf->session, cancel_soup_sess, NULL);
	if (rf->progress_bar)
		gtk_progress_bar_set_fraction((GtkProgressBar *)rf->progress_bar, 1);
	rf->progress_bar = NULL;	//there's no need to update bar once we canceled feeds
#ifndef EVOLUTION_2_12
	gtk_widget_destroy(widget);
	rf->progress_dialog = NULL;
#endif
	rf->cancel = 1;
}

static void
receive_cancel(GtkButton *button, struct _send_info *info)
{
        if (info->state == SEND_ACTIVE) {
                if (info->status_label)
			gtk_label_set_markup (GTK_LABEL (info->status_label),
//                        e_clipped_label_set_text (
  //                              E_CLIPPED_LABEL (info->status_label),
                                _("Canceling..."));
                info->state = SEND_CANCELLED;
		readrss_dialog_cb(NULL, NULL);
        }
        if (info->cancel_button)
                gtk_widget_set_sensitive(info->cancel_button, FALSE);
}

void
update_feeds_file_line(gpointer key, gpointer value, gpointer user_data)
{
	    gchar *rfeed = g_strdup_printf("%s--%s--%d--%s--%d\n", 
		key, value,
		g_hash_table_lookup(rf->hre, key),
		g_hash_table_lookup(rf->hrt, key),
		g_hash_table_lookup(rf->hrh, key));
	    fputs(rfeed, (FILE *)user_data);
	    g_free(rfeed);
}

void
update_feeds_file(void)
{
	FILE *ffile;
        char **str;
        //contruct feeds
        gchar *feed_dir = g_strdup_printf("%s/mail/rss",
            mail_component_peek_base_directory (mail_component_peek ()));
        if (!g_file_test(feed_dir, G_FILE_TEST_EXISTS))
            g_mkdir_with_parents (feed_dir, 0755);
        gchar *feed_file = g_strdup_printf("%s/evolution-feeds", feed_dir);
        g_free(feed_dir);
        if (ffile = fopen(feed_file, "w+"))
		g_hash_table_foreach(rf->hr, update_feeds_file_line, ffile);
        fclose(ffile);
}

//prefixes uri with http:// if it's misssing
//resulting text should be freed when no longer needed
gchar *
sanitize_url(gchar *text)
{
	if (!strstr (text, "http://"))
		return g_strconcat("http://", text, NULL);
	else
		return g_strdup(text);
}

feeds_dialog_add(GtkDialog *d, gpointer data)
{
	gchar *text;
	add_feed *feed = create_dialog_add(NULL, NULL);
	if (feed->feed_url)
	{
		text = feed->feed_url;
		feed->feed_url = sanitize_url(feed->feed_url);
		g_free(text);
		setup_feed(feed);
  		GtkTreeModel *model = gtk_tree_view_get_model ((GtkTreeView *)data);
		gtk_list_store_clear(GTK_LIST_STORE(model));
		g_hash_table_foreach(rf->hr, construct_list, model);
		update_feeds_file();
	}
	g_free(feed);
}

feeds_dialog_edit(GtkDialog *d, gpointer data)
{
	GtkTreeSelection *selection;
	GtkTreeModel     *model;
	GtkTreeIter       iter;
	gchar *name, *feed_name;
	gchar *text;

	/* This will only work in single or browse selection mode! */

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(data));
	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, 1, &feed_name, -1);
		name = g_hash_table_lookup(rf->hr, feed_name);
		if (name)
		{
			add_feed *feed = create_dialog_add(name, feed_name);
			if (feed->feed_url)
			{
				text = feed->feed_url;
				feed->feed_url = sanitize_url(feed->feed_url);
				g_free(text);
				gtk_tree_model_get (model, &iter, 1, &name, -1);
				gchar *value1 = g_hash_table_lookup(rf->hr, name);
				g_hash_table_remove(rf->hr, name);
				gchar *value2 = g_hash_table_lookup(rf->hrid, 
					g_strdup_printf("%x", gen_crc(feed->feed_url)));
				g_hash_table_remove(rf->hrid, g_strdup_printf("%x",
					gen_crc(feed->feed_url)));
				if (!setup_feed(feed))
				{
					//editing might loose a corectly setup feed
					//so re-add previous deleted feed
					g_hash_table_insert(rf->hr, name, value1);
                                	g_hash_table_insert(rf->hrid, g_strdup_printf("%x",
                                        gen_crc(feed->feed_url)), value2);
				}
				gtk_list_store_clear(GTK_LIST_STORE(model));
				g_hash_table_foreach(rf->hr, construct_list, model);
				update_feeds_file();
			}
			g_free(feed);
		}
	}
}

feeds_dialog_delete(GtkDialog *d, gpointer data)
{
	GtkTreeSelection *selection;
	GtkTreeModel     *model;
	GtkTreeIter       iter;
	gchar *name;
	gint *ind = NULL;
	guint i;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(data));
	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, 1, &name, -1);
		g_hash_table_remove(rf->hr, name);
	}
	gtk_list_store_clear(GTK_LIST_STORE(model));
	g_hash_table_foreach(rf->hr, construct_list, model);
	update_feeds_file();
}

feeds_dialog_disable(GtkDialog *d, gpointer data)
{
	GtkTreeSelection *selection;
	GtkTreeModel     *model;
	GtkTreeIter       iter;
	gchar *name;

	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(rf->treeview));
	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, 1, &name, -1);
		g_hash_table_replace(rf->hre, name, 
			GINT_TO_POINTER(!g_hash_table_lookup(rf->hre, name)));
		gtk_button_set_label(data, g_hash_table_lookup(rf->hre, name) ? _("Disable") : _("Enable"));
	}
	//update list instead of rebuilding
	gtk_list_store_clear(GTK_LIST_STORE(model));
	g_hash_table_foreach(rf->hr, construct_list, model);
	update_feeds_file();
}

static void
enable_html_cb(GtkCellRendererToggle *cell,
               gchar *path_str,
               gpointer data)
{
  GtkTreeModel *model = (GtkTreeModel *)data;
  GtkTreeIter  iter;
  GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
  gchar *name;
  gchar *url;
  gboolean fixed;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 1, &fixed, -1);
  gtk_tree_model_get (model, &iter, 2, &name, -1);
  fixed ^= 1;
  g_hash_table_replace(rf->hrh, name, GINT_TO_POINTER(fixed));
  g_hash_table_replace(rf->hrid, g_strdup_printf("%x", gen_crc(name)), GINT_TO_POINTER(fixed));
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, 1, fixed, -1);
  gtk_tree_path_free (path);
  update_feeds_file();
}

static void
enable_toggle_cb(GtkCellRendererToggle *cell,
               gchar *path_str,
               gpointer data)
{
  GtkTreeModel *model = (GtkTreeModel *)data;
  GtkTreeIter  iter;
  GtkTreePath *path = gtk_tree_path_new_from_string (path_str);
  gchar *name;
  gboolean fixed;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 0, &fixed, -1);
  gtk_tree_model_get (model, &iter, 1, &name, -1);
  fixed ^= 1;
  g_hash_table_replace(rf->hre, name, GINT_TO_POINTER(fixed));
//  gtk_button_set_label(GTK_BUTTON(rf->edbutton), fixed ? _("Disable") : _("Enable"));
  gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0, fixed, -1);
  gtk_tree_path_free (path);
  update_feeds_file();
}

static void
tree_cb (GtkWidget *widget, gpointer data)
{
	GtkTreeSelection *selection;
        GtkTreeModel     *model;
        GtkTreeIter       iter;
        gchar *name;

        selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(rf->treeview));
        if (gtk_tree_selection_get_selected(selection, &model, &iter))
        {
                gtk_tree_model_get (model, &iter, 2, &name, -1);
		gtk_button_set_label(data, g_hash_table_lookup(rf->hre, name) ? _("Disable") : _("Enable"));
        }
}

static void
start_check_cb (GtkWidget *widget, gpointer data)
{
    gboolean active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
    /* Save the new setting to gconf */
    gconf_client_set_bool (rss_gconf, data, active, NULL);
}

static void
rep_check_cb (GtkWidget *widget, gpointer data)
{
    gboolean active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
    /* Save the new setting to gconf */
    gconf_client_set_bool (rss_gconf, GCONF_KEY_REP_CHECK, active, NULL);
    //if we already have a timeout set destroy it first
    if (rf->rc_id && !active)
	g_source_remove(rf->rc_id);
    if (active)
    {
    	//we have to make sure we have a timeout value
    	if (!gconf_client_get_float(rss_gconf, GCONF_KEY_REP_CHECK_TIMEOUT, NULL))
    		gconf_client_set_float (rss_gconf, GCONF_KEY_REP_CHECK_TIMEOUT, 
			gtk_spin_button_get_value((GtkSpinButton *)data), NULL);
    	if (rf->rc_id)
		g_source_remove(rf->rc_id);
    	rf->rc_id = g_timeout_add (60 * 1000 * gtk_spin_button_get_value((GtkSpinButton *)data),
                           (GtkFunction) update_articles,
                           (gpointer)1);
    }
}

static void
set_string_cb (GtkWidget *widget, gpointer data)
{
    const gchar *text = gtk_entry_get_text (GTK_ENTRY (widget));
    gconf_client_set_string (rss_gconf, data, text, NULL);
}

static void
close_details_cb (GtkWidget *widget, gpointer data)
{
	gtk_widget_hide(data);
}

static void
details_cb (GtkWidget *widget, gpointer data)
{
	GtkWidget *details = glade_xml_get_widget(data, "http-proxy-details");
	GtkWidget *close = glade_xml_get_widget(data, "closebutton2");
	GtkWidget *proxy_auth = glade_xml_get_widget(data, "proxy_auth");
	GtkWidget *proxy_user = glade_xml_get_widget(data, "proxy_user");
	GtkWidget *proxy_pass = glade_xml_get_widget(data, "proxy_pass");
	g_signal_connect(close, "clicked", G_CALLBACK(close_details_cb), details);

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (proxy_auth),
        	gconf_client_get_bool(rss_gconf, GCONF_KEY_AUTH_PROXY, NULL));
	g_signal_connect(proxy_auth, "clicked", G_CALLBACK(start_check_cb), GCONF_KEY_AUTH_PROXY);

	gchar *user = gconf_client_get_string(rss_gconf, GCONF_KEY_USER_PROXY, NULL);
	if (user)
		gtk_entry_set_text(GTK_ENTRY(proxy_user), user);
	g_signal_connect(proxy_user, "changed", G_CALLBACK(set_string_cb), GCONF_KEY_USER_PROXY);
	gchar *pass = gconf_client_get_string(rss_gconf, GCONF_KEY_PASS_PROXY, NULL);
	if (pass)
		gtk_entry_set_text(GTK_ENTRY(proxy_pass), pass);
	g_signal_connect(proxy_pass, "changed", G_CALLBACK(set_string_cb), GCONF_KEY_PASS_PROXY);

	gtk_widget_show(details);
}

static void
host_proxy_cb (GtkWidget *widget, gpointer data)
{
    gconf_client_set_string (rss_gconf, GCONF_KEY_HOST_PROXY, 
		gtk_entry_get_text((GtkEntry*)widget), NULL);
}

static void
port_proxy_cb (GtkWidget *widget, gpointer data)
{
    gconf_client_set_float (rss_gconf, GCONF_KEY_PORT_PROXY, 
		gtk_spin_button_get_value((GtkSpinButton*)widget), NULL);
}

static void
rep_check_timeout_cb (GtkWidget *widget, gpointer data)
{
    gboolean active = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (data));
    gconf_client_set_float (rss_gconf, GCONF_KEY_REP_CHECK_TIMEOUT, 
		gtk_spin_button_get_value((GtkSpinButton*)widget), NULL);
    if (active)
    {
    	if (rf->rc_id)
		g_source_remove(rf->rc_id);
    	rf->rc_id = g_timeout_add (60 * 1000 * gtk_spin_button_get_value((GtkSpinButton *)widget),
                           (GtkFunction) update_articles,
                           (gpointer)1);
    }
}

static void
err_destroy (GtkWidget *widget, gpointer data)
{
       gtk_widget_destroy(widget);
       rf->errdialog = NULL;
}

guint
read_feeds(rssfeed *rf)
{
	FILE *ffile;
	gchar rfeed[512];
	char **str;
	guint res = 0;
	memset(rfeed, 0, 512);
	rf->hr = NULL;
	rf->hre = NULL;
	//contruct feeds
	gchar *feed_dir = g_strdup_printf("%s/mail/rss", 
	    mail_component_peek_base_directory (mail_component_peek ()));
	if (!g_file_test(feed_dir, G_FILE_TEST_EXISTS))
	    g_mkdir_with_parents (feed_dir, 0755);
	gchar *feed_file = g_strdup_printf("%s/evolution-feeds", feed_dir);
	g_free(feed_dir);
	rf->hr = g_hash_table_new_full(g_str_hash, g_str_equal, g_free,g_free);
	rf->hre = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);
	rf->hrt = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, g_free);
	rf->hrh = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);
	rf->hrid = g_hash_table_new_full(g_str_hash, g_str_equal, g_free, NULL);
	rf->hruser = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_free);
	rf->hrpass = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, g_free);
	if (g_file_test(feed_file, G_FILE_TEST_EXISTS))
	{
		if (ffile = fopen(feed_file, "r"))
		{
		    while (fgets(rfeed, 511, ffile) != NULL)
		    {
			str = g_strsplit(rfeed, "--", 0);
			g_hash_table_insert(rf->hr, g_strdup(str[0]), g_strstrip(str[1]));
			if (NULL != str[4])
			{
				g_hash_table_insert(rf->hrid, g_strdup_printf("%x", gen_crc(str[0])), 
					GINT_TO_POINTER(atoi(g_strstrip(str[4]))));
				g_hash_table_insert(rf->hrh, g_strdup(str[0]), 
					GINT_TO_POINTER(atoi(str[4])));
				g_hash_table_insert(rf->hrt, g_strdup(str[0]), g_strdup(str[3]));
				g_hash_table_insert(rf->hre, g_strdup(str[0]), 
					GINT_TO_POINTER(atoi(str[2])));
			}
			else
			{
				g_hash_table_insert(rf->hrid, g_strdup_printf("%x", gen_crc(str[0])),
					(gpointer)0);
				if (NULL != str[2])	// 0.0.1 -> 0.0.2
				{
					g_hash_table_insert(rf->hrh, g_strdup(str[0]), (gpointer)0);
					g_hash_table_insert(rf->hrt, g_strdup(str[0]), g_strstrip(str[3]));
					g_hash_table_insert(rf->hre, g_strdup(str[0]), 
						GINT_TO_POINTER(atoi(str[2])));
				}
				else
				{
					g_hash_table_insert(rf->hrh, g_strdup(str[0]),  (gpointer)0);
					g_hash_table_insert(rf->hrt, g_strdup(str[0]), g_strdup("RSS"));
					g_hash_table_insert(rf->hre, g_strdup(str[0]), 
					(gpointer)1);
				}
			}
		    }
		    fclose(ffile);
		}
		else goto out;
	}
	else goto out;
	res = 1;
out:	g_free(feed_file);
	return res;
}

static gchar *
get_url_basename(gchar *url)
{
	gchar *p;
	p = strrchr(url, '/');
	if (p)
		return p+1;
	else
		return url;
}

gchar *
get_server_from_uri(gchar *uri)
{
	g_return_val_if_fail( uri != NULL, NULL);

	gchar **str = g_strsplit(uri, "://", 2);
        gchar **str2 = g_strsplit(str[1], "/", 2);
        gchar *server = g_strdup_printf("%s://%s", str[0], str2[0]);
	g_strfreev(str);
	g_strfreev(str2);
	return server;
}

void
html_set_base(xmlNode *doc, char *base, char *tag, char *prop, char *basehref)
{
	gchar *url;
	SoupUri *newuri;
        gchar *newuristr;
        SoupUri *base_uri = soup_uri_new (base);
	while (doc = html_find((xmlNode *)doc, tag))
	{
		if (url = xmlGetProp(doc, prop))
		{
			if (!strncmp(tag, "img", 3) && !strncmp(prop, "src", 3))
			{
				gchar *tmpurl = strplchr(url);
				xmlSetProp(doc, prop, tmpurl);
				g_free(tmpurl);
			}
#ifdef RSS_DEBUG
			g_print("DEBUG: parsing: %s\n", url);
#endif
			if (url[0] == '/' && url[1] != '/')
			{
				gchar *server = get_server_from_uri(base);
				gchar *tmp = g_strdup_printf("%s/%s", server, url);
				xmlSetProp(doc, prop, tmp);
				g_free(tmp);
				g_free(server);
			}
			if (url[0] == '/' && url[1] == '/')
			{
				gchar *tmp = g_strdup_printf("%s%s", "http:", url);
				xmlSetProp(doc, prop, tmp);
				g_free(tmp);
			}
			if (url[0] != '/' && !g_str_has_prefix(url,  "http://"))
			{
				// in case we have a base href= set then rewrite
				// all relative links
				if (basehref != NULL)
				{
        				SoupUri *newbase_uri = soup_uri_new (basehref);
        				newuri = soup_uri_new_with_base (newbase_uri, url);
					soup_uri_free(newbase_uri);
				}
				else	
        				newuri = soup_uri_new_with_base (base_uri, url);
				//xmlSetProp(doc, prop, g_strdup_printf("%s/%s", get_server_from_uri(base), url));
				if (newuri)
				{
        				newuristr = soup_uri_to_string (newuri, FALSE);
					xmlSetProp(doc, prop, (xmlChar *)newuristr);
					g_free(newuristr);
					soup_uri_free(newuri);
				}
			}
			xmlFree(url);
		}
	}
	soup_uri_free(base_uri);
}

static void
my_xml_parser_error_handler (void *ctx, const char *msg, ...)
{
        ;
}

xmlDoc *
parse_html_sux (const char *buf, int len)
{
        xmlDoc *doc;
#if LIBXML_VERSION > 20600
        static xmlSAXHandler *sax;
        htmlParserCtxtPtr ctxt;

        g_return_val_if_fail (buf != NULL, NULL);

        if (!sax) {
                xmlInitParser();
                sax = xmlMalloc (sizeof (htmlSAXHandler));
                memcpy (sax, &htmlDefaultSAXHandler, sizeof (xmlSAXHandlerV1));
                sax->warning = my_xml_parser_error_handler;
                sax->error = my_xml_parser_error_handler;
        }

        if (len == -1)
                len = strlen (buf);
        ctxt = htmlCreateMemoryParserCtxt (buf, len);
        if (!ctxt)
                return NULL;

        xmlFree (ctxt->sax);
        ctxt->sax = sax;
        ctxt->vctxt.error = my_xml_parser_error_handler;
        ctxt->vctxt.warning = my_xml_parser_error_handler;

        htmlParseDocument (ctxt);
        doc = ctxt->myDoc;

        ctxt->sax = NULL;
        htmlFreeParserCtxt (ctxt);

#else /* LIBXML_VERSION <= 20600 */
        char *buf_copy = g_strndup (buf, len);

        doc = htmlParseDoc (buf_copy, NULL);
        g_free (buf_copy);
#endif
        return doc;
}

gchar *
strplchr(gchar *source)
{
	GString *str = g_string_new(NULL);
	gchar *string;
        const unsigned char *s = (const unsigned char *)source;
        guint len = strlen(source);
        while (*s != 0 || len)
        {
            if (*s == 0x3f)
            {
                  g_string_append(str, "%3F");
                  *s++;
            }
            else
                  g_string_append_c (str, *s++);
            len--;
        }
        g_string_append_c(str, 0);
	string = str->str;
	g_string_free(str, 0);	
	return string;
} 

/*modifies a html document to be absolute */
xmlDoc *
parse_html(char *url, const char *html, int len)
{
	xmlDoc *src = NULL;
	xmlDoc *doc = NULL;

	src = (xmlDoc *)parse_html_sux(html, len);

	if (!src)
		return NULL;
	doc = src;
	gchar *newbase = NULL;
	newbase = xmlGetProp(html_find((xmlNode *)doc, "base"), "href");
#ifdef RSS_DEBUG
	g_print("newbase:|%s|\n", newbase);
#endif
	xmlDoc *tmpdoc = (xmlDoc *)html_find((xmlNode *)doc, "base");
	xmlUnlinkNode((xmlNode *)tmpdoc);
	html_set_base((xmlNode *)doc, url, "a", "href", newbase);
	html_set_base((xmlNode *)doc, url, "img", "src", newbase);
	html_set_base((xmlNode *)doc, url, "input", "src", newbase);
	html_set_base((xmlNode *)doc, url, "link", "src", newbase);
	html_set_base((xmlNode *)doc, url, "body", "background", newbase);
	html_set_base((xmlNode *)doc, url, "script", "src", newbase);
/*	while (doc = html_find((xmlNode *)doc, "img"))
	{
		if (url = xmlGetProp(doc, "src"))
		{
			gchar *str = strplchr(url);
                	g_print("%s\n", str);
                	xmlSetProp(doc, "src", str);
			g_free(str);
			xmlFree(url);
                }
	}*/
	doc = src;
	if (newbase)
		xmlFree(newbase);
	return doc;
}

static gchar *
parse_href (const gchar *s, const gchar *base)
{
        gchar *retval;
        gchar *tmp;
        gchar *tmpurl;

        if(s == NULL || *s == 0)
                return g_strdup ("");

//	tmpurl = html_url_new (s);
//        if (html_url_get_protocol (tmpurl) == NULL) {
                if (s[0] == '/') {
                        if (s[1] == '/') {
                                gchar *t;

                                /* Double slash at the beginning.  */

                                /* FIXME?  This is a bit sucky.  */
/*                                t = g_strconcat (html_url_get_protocol (baseURL),
                                                 ":", s, NULL);
                                html_url_destroy (tmpurl);
                                tmpurl = html_url_new (t);
                                retval = html_url_to_string (tmpurl);
                                html_url_destroy (tmpurl);
                                g_free (t);*/
                        } else {
                                /* Single slash at the beginning.  */

				tmpurl = g_strdup_printf("%s%s", base, s);
                        }
                } else {
                                gchar *t;
/*                        html_url_destroy (tmpurl);
                        tmpurl = html_url_append_path (baseURL, s);
                        retval = html_url_to_string (tmpurl);
                        html_url_destroy (tmpurl);*/
                }
//        } else {
  //              retval = html_url_to_string (tmpurl);
    //            html_url_destroy (tmpurl);
      //  }

        return tmpurl;
}

static void
summary_cb (GtkWidget *button, EMFormatHTMLPObject *pobject)
{
	rf->cur_format = rf->cur_format^1;
	rf->chg_format = 1;
	em_format_redraw((EMFormat *)pobject);
	while (gtk_events_pending ())
             gtk_main_iteration ();
	
}

static gboolean
org_gnome_rss_controls (EMFormatHTML *efh, void *eb, EMFormatHTMLPObject *pobject)
{
	GtkWidget *box = gtk_hbutton_box_new ();
	struct _org_gnome_rss_controls_pobject *po = (struct _org_gnome_rss_controls_pobject *) pobject;

	GtkWidget *vbox = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox);
	GtkWidget *hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);

	GtkWidget *label3 = gtk_label_new ("");
	gchar *mem = g_strdup_printf(" <b>%s:</b>", _("Feed view"));
	gtk_label_set_markup_with_mnemonic(GTK_LABEL(label3), mem);
	gtk_widget_show (label3);
	gtk_box_pack_start (GTK_BOX (hbox2), label3, FALSE, FALSE, 0);

	GtkWidget *button = gtk_button_new_with_label(
				rf->cur_format ? _("HTML") : _("Summary"));
	g_signal_connect (button, "clicked", G_CALLBACK(summary_cb), efh);
	gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_HALF);
        gtk_widget_show (button);
	gtk_box_pack_end_defaults (GTK_BOX (box), button);
	gtk_box_pack_start (GTK_BOX (hbox2), box, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox2, TRUE, TRUE, 0);

        gtk_widget_show (box);
        gtk_container_add ((GtkContainer *) eb, vbox);

        return TRUE;
}

void org_gnome_cooly_format_rss(void *ep, EMFormatHookTarget *t);

void org_gnome_cooly_format_rss(void *ep, EMFormatHookTarget *t)
{
        GError *err = NULL;
        GString *content;
	xmlChar *buff = NULL;
	int size = 0;
	unsigned char *buffer2 = NULL;
   	int inlen, utf8len;
	CamelDataWrapper *dw = camel_data_wrapper_new();
	CamelMimePart *part = camel_mime_part_new();
	CamelStream *fstream = camel_stream_mem_new();
        g_print("formatting\n");

	const char *website = camel_medium_get_header (CAMEL_MEDIUM (t->part), "Website");
	if (!website)
		goto fmerror;
	gchar *addr = (gchar *)camel_header_location_decode(website);
	gchar *feedid = NULL;
	feedid  = (gchar *)camel_medium_get_header ((CamelMedium *)t->part, "RSS-ID");
	gchar *subject = camel_header_decode_string(camel_medium_get_header (CAMEL_MEDIUM (t->part), "Subject"), NULL);
	
	gboolean is_html = 0;
	if (feedid)
		is_html =  GPOINTER_TO_INT(g_hash_table_lookup(rf->hrid, g_strstrip(feedid)));
	
	if (!rf->chg_format)
		rf->cur_format = is_html;
	
	if (rf->chg_format)
		rf->chg_format = 0;

	struct _org_gnome_rss_controls_pobject *pobj;
        char *classid = g_strdup_printf ("org-gnome-rss-controls-%d",
			org_gnome_rss_controls_counter_id);
	org_gnome_rss_controls_counter_id++;
	pobj = (struct _org_gnome_rss_controls_pobject *) em_format_html_add_pobject ((EMFormatHTML *) t->format, sizeof(*pobj), classid, t->part, (EMFormatHTMLPObjectFunc)org_gnome_rss_controls);
	camel_object_ref (t->part);
        pobj->part = t->part;
	pobj->website = (gchar *)website;
	pobj->is_html = is_html;
        camel_stream_printf (t->stream, "<object classid=%s></object>\n", classid);

	EMFormatHTML *emfh = (EMFormatHTML *)t->format;
	/* force loading of images even if mail images disabled */
	emfh->load_http_now = TRUE;

	if (rf->cur_format || (feedid && is_html && rf->cur_format))
	{
		content = net_post_blocking(addr, NULL, NULL, textcb, NULL, &err);
		if (err)
        	{
			//we do not need to setup a pop error menu since we're in 
			//formatting process. But instead display mail body an error
			//such proxy error or transport error
			camel_stream_printf (t->stream, "<table border=1 width=\"100%%\" cellpadding=0 cellspacing=0><tr><td bgcolor=#ffffff>");
			camel_stream_printf(t->stream, "<table border=0 width=\"100%%\" cellspacing=4 cellpadding=4><tr>");
     			camel_stream_printf (t->stream, "<td bgcolor=\"#ffffff\">%s</td>", err->message);
    			camel_stream_printf (t->stream, "</tr></table></td></tr></table>");
                	goto out;
        	}
		xmlDoc *doc = parse_html(addr, content->str, content->len);
		if (doc)
		{
			htmlDocDumpMemory(doc, &buff, &size);
#ifdef RSS_DEBUG
			g_print("%s\n", buff);
#endif
			xmlFree(doc);
		}
		else
			goto out;

		camel_stream_printf(fstream,
		 "<table border=1 width=\"100%%\" cellpadding=0 cellspacing=0><tr><td bgcolor=#ffffff>");
		camel_stream_printf(fstream,
		 "<table border=0 width=\"100%%\" cellspacing=4 cellpadding=4>");
   		camel_stream_printf(fstream,
		 "<tr><td bgcolor=\"#ffffff\"><b><font size=+1><a href=%s>%s</a></font></b></td></tr>", website, subject);
     		camel_stream_printf(fstream, "</head></html><tr><td bgcolor=\"#ffffff\">%s</td>", buff);
    		camel_stream_printf(fstream, "</tr></table></td></tr></table>");
		if (buff)
			g_free(buff);
		g_string_free(content, 1);
	}
	else
	{
		GByteArray *buffer;
		CamelStreamMem *stream = (CamelStreamMem *)camel_stream_mem_new();
		buffer = g_byte_array_new ();
        	camel_stream_mem_set_byte_array (stream, buffer);

		CamelDataWrapper *content = camel_medium_get_content_object(CAMEL_MEDIUM(t->part));
     		camel_data_wrapper_write_to_stream(content, (CamelStream *)stream);
		g_byte_array_append (buffer, "", 1);
#ifdef EVOLUTION_2_12	//aparently this ("?" char parsing) is fixed in 2.12
		buff = buffer->data;
#else
		inlen = buffer->len;
		utf8len = 5*inlen+1;
		buffer2 = g_malloc(utf8len);
		UTF8ToHtml(buffer2, &utf8len, buffer->data, &inlen);
		g_byte_array_free (buffer, 1);
		xmlDoc *src = (xmlDoc *)parse_html_sux(buffer2, strlen(buffer2));
		if (src)
		{
			xmlNode *doc = (xmlNode *)src;

			while (doc = html_find(doc, "img"))
        		{
                		xmlChar *url = xmlGetProp(doc, "src");
				gchar *str = strplchr((gchar *)url);
				xmlFree(url);
				xmlSetProp(doc, "src", str);
				g_free(str);
			}
			xmlDocDumpMemory(src, &buff, &size);
		}
		else goto out;

#endif
#ifdef RSS_DEBUG
		g_print("%s\n", buff);
#endif
		camel_stream_printf (fstream, 
		"<table border=1 width=\"100%%\" cellpadding=0 cellspacing=0><tr><td bgcolor=#ffffff>");
		camel_stream_printf(fstream, 
		"<table border=0 width=\"100%%\" cellspacing=4 cellpadding=4><tr>");
     		camel_stream_printf(fstream,
		 "<tr><td bgcolor=\"#ffffff\"><b><font size=+1><a href=%s>%s</a></font></b></td></tr>", website, subject);
     		camel_stream_printf (fstream, "<td bgcolor=\"#ffffff\">%s</td>", buff);
    		camel_stream_printf (fstream, "</tr></table></td></tr></table>");
	}

       	camel_data_wrapper_construct_from_stream(dw, fstream);
       	camel_medium_set_content_object((CamelMedium *)part, dw);
	em_format_format_text((EMFormat *)t->format, (CamelStream *)t->stream, (CamelDataWrapper *)part);
	camel_object_unref(dw);
	camel_object_unref(part);
	camel_object_unref(fstream);

out:	if (addr)
		g_free(addr);
	if (buffer2)
		g_free(buffer2);
	g_print("out\n");
	return;
fmerror:
	camel_stream_printf (t->stream, 
	"<table border=1 width=\"100%%\" cellpadding=0 cellspacing=0><tr><td bgcolor=#ffffff>");
	camel_stream_printf(t->stream, 
	"<table border=0 width=\"100%%\" cellspacing=4 cellpadding=4><tr>");
     	camel_stream_printf (t->stream,
	"<td bgcolor=\"#ffffff\">Cannot format email. Formatting error!</td>");
    	camel_stream_printf (t->stream, "</tr></table></td></tr></table>");
	return;
}

void org_gnome_cooly_article_show(void *ep, EMPopupTargetSelect *t);

void org_gnome_cooly_article_show(void *ep, EMPopupTargetSelect *t)
{
	g_print("(l)user is reading mail\n");
}

gboolean
setup_feed(add_feed *feed)
{
	CamelException ex;
	guint ret = 0;
        RDF *r;
        GString *post;
        GError *err = NULL;
        GString *content;

	check_folders();

        r = g_new0 (RDF, 1);
        r->shown = TRUE;

	if (rf->hr == NULL)	
		rf->hr = g_hash_table_new_full(g_str_hash,
						g_str_equal, 
						g_free,
						g_free);
	if (rf->hre == NULL)	
        	rf->hre = g_hash_table_new_full(g_str_hash, 
						g_str_equal,
						g_free,
						NULL);
	if (rf->hrt == NULL)	
        	rf->hrt = g_hash_table_new_full(g_str_hash,
						g_str_equal,
						g_free,
						g_free);
	if (rf->hrh == NULL)	
        	rf->hrh = g_hash_table_new_full(g_str_hash,
						g_str_equal,
						g_free,
						NULL);
	if (rf->hrid == NULL)	
        	rf->hrid = g_hash_table_new_full(g_str_hash,
						 g_str_equal,
						 g_free,
						 NULL);
	if (rf->hruser == NULL)	
	    	rf->hruser = g_hash_table_new_full(g_str_hash,
						 g_str_equal,
						 NULL,
						 g_free);
	if (rf->hrpass == NULL)	
	    	rf->hrpass = g_hash_table_new_full(g_str_hash,
						 g_str_equal,
						 NULL,
						 g_free);

	rf->pending = TRUE;
        content = net_post_blocking(feed->feed_url, NULL, post, textcb, rf, &err);
	if (err)
	{
		e_error_run(NULL, "org-gnome-evolution-rss:feederr",
			_("Error while Fetching Feeds."), err->message, NULL);
		goto out;
	}
        xmlDocPtr doc = NULL;
        xmlSubstituteEntitiesDefaultValue = 1;
        doc = xmlParseMemory (content->str, content->len);
#ifdef RSS_DEBUG
	g_print("content:%s\n", content->str);
#endif
	if ((doc != NULL || xmlDocGetRootElement(doc) != NULL)
		&& (!strcasestr(doc->children->name, "rss")
		|| !strcasestr(doc->children->name, "rdf")))
	{
        	r->cache = doc;
        	gchar *chn_name = display_doc (r);
		if (chn_name == NULL)
                       chn_name = g_strdup_printf (_("Untitled Channel"));
		g_hash_table_insert(rf->hr, g_strdup(chn_name), g_strdup(feed->feed_url));
		g_hash_table_insert(rf->hre, g_strdup(chn_name), (gpointer)1);
		g_hash_table_insert(rf->hrt, g_strdup(chn_name), g_strdup(r->type));
		g_hash_table_insert(rf->hrh, g_strdup(chn_name), GINT_TO_POINTER(feed->fetch_html));
		g_hash_table_insert(rf->hrid, g_strdup_printf("%x", gen_crc(chn_name)),
                                        GINT_TO_POINTER(feed->fetch_html));
		rf->setup = 1;
		ret = 1;
	}
	else
	{
		e_error_run(NULL, "org-gnome-evolution-rss:feederr", _("Invalid Feed!"), NULL);
		ret = 0;
	}
	xmlFreeDoc(doc);
out:	if (feed->dialog)
		gtk_widget_destroy(feed->dialog);
	rf->pending = FALSE;
	return ret;
}

void
finish_feed (SoupMessage *msg, gpointer user_data)
{
	GError *err = NULL;
	if (rf->feed_queue)
		rf->feed_queue--;

#ifndef EVOLUTION_2_12
	if(rf->progress_dialog && rf->feed_queue == 0)
        {
              gtk_widget_destroy(rf->progress_dialog);
              rf->progress_dialog = NULL;
              rf->progress_bar = NULL;
        }
#endif

	if (msg->status_code != SOUP_STATUS_OK &&
	    msg->status_code != SOUP_STATUS_CANCELLED) {
        	g_set_error(&err, NET_ERROR, NET_ERROR_GENERIC,
                	soup_status_get_phrase(msg->status_code));
                GtkWidget *ed;
                if (!rf->errdialog)
                {
                     gchar *msg = g_strdup_printf("\n%s\n%s", user_data, err->message);
                     ed  = e_error_new(NULL, "org-gnome-evolution-rss:feederr",
                                       _("Error Fetching Feed"), msg, NULL);
                     g_signal_connect(ed, "response", G_CALLBACK(err_destroy), NULL);
                     gtk_widget_show(ed);
                     rf->errdialog = ed;
                     g_free(msg);
                }
        	return;
    	}

	if (rf->cancel)
	{
#ifdef EVOLUTION_2_12
		if(rf->label && rf->feed_queue == 0 && rf->info)
        	{
                	gtk_label_set_markup (GTK_LABEL (rf->label), _("Canceled"));
                if (rf->info->cancel_button)
                        gtk_widget_set_sensitive(rf->info->cancel_button, FALSE);

                g_hash_table_remove(rf->info->data->active, rf->info->uri);
                rf->info->data->infos = g_list_remove(rf->info->data->infos, rf->info);

                if (g_hash_table_size(rf->info->data->active) == 0) {
                        if (rf->info->data->gd)
                                gtk_widget_destroy((GtkWidget *)rf->info->data->gd);
                }
                //clean data that might hang on rf struct
                rf->sr_feed = NULL;
                rf->label = NULL;
                rf->progress_bar = NULL;
                rf->info = NULL;
		}
#endif
		return;
	}
	GString *response = g_string_new_len(msg->response.body, msg->response.length);
#ifdef RSS_DEBUG
	g_print("feed %s\n", user_data);
#endif
//	rf->pending = TRUE;
	RDF *r = g_new0 (RDF, 1);
        r->shown = TRUE;
        xmlDocPtr doc;
        xmlSubstituteEntitiesDefaultValue = 1;
        doc = xmlParseMemory (response->str, response->len);
        r->cache = doc;
        display_doc (r);
	xmlFree(doc);
	g_string_free(response, 1);
//        rf->pending = FALSE;

#ifdef EVOLUTION_2_12
	if (rf->sr_feed)
	{
		gchar *furl = g_strdup_printf("<b>%s</b>: %s", 
			g_hash_table_lookup(rf->hrt, user_data),
			user_data);
		gtk_label_set_markup (GTK_LABEL (rf->sr_feed), furl);
		g_free(furl);
	}
	if(rf->label && rf->feed_queue == 0 && rf->info)
	{
		gtk_label_set_markup (GTK_LABEL (rf->label), _("Complete"));
        	if (rf->info->cancel_button)
                	gtk_widget_set_sensitive(rf->info->cancel_button, FALSE);

        	g_hash_table_remove(rf->info->data->active, rf->info->uri);
        	rf->info->data->infos = g_list_remove(rf->info->data->infos, rf->info);

        	if (g_hash_table_size(rf->info->data->active) == 0) {
                	if (rf->info->data->gd)
                        	gtk_widget_destroy((GtkWidget *)rf->info->data->gd);
        	}
		//clean data that might hang on rf struct
		rf->sr_feed = NULL;
		rf->label = NULL;
		rf->progress_bar = NULL;
		rf->info = NULL;
	}
#endif
}

void
fetch_feed(gpointer key, gpointer value, gpointer user_data)
{ 
	GError *err = NULL;
	GString *content;
	GString *post;
	RDF *r;
//	rf->cfeed = key;

	// check if we're enabled and no cancelation signal pending
	if (g_hash_table_lookup(rf->hre, key) && !rf->cancel)
	{
		//rf->pending = TRUE;
#ifdef RSS_DEBUG
		g_print("\nFetching: %s..%s\n", g_hash_table_lookup(rf->hr, key), key);
#endif
		rf->feed_queue++;
		net_get_unblocking(value, user_data, key, (gpointer)finish_feed, key);
	}
	else if (rf->cancel && !rf->feed_queue)
		rf->cancel = 0;		//all feeds where either procesed or skipped
}

gboolean
update_articles(gboolean disabler)
{
	if (!rf->pending && !rf->feed_queue)
	{
		g_print("Reading RSS articles...\n");
		rf->pending = TRUE;
		check_folders();
		rf->err = NULL;
		g_hash_table_foreach(rf->hr, fetch_feed, statuscb);	
		rf->pending = FALSE;
	}
	return disabler;
}

void org_gnome_cooly_rss_startup(void *ep, EMPopupTargetSelect *t);

void org_gnome_cooly_rss_startup(void *ep, EMPopupTargetSelect *t)
{
  	if (gconf_client_get_bool (rss_gconf, GCONF_KEY_START_CHECK, NULL))
	{
		//as I don't know how to set this I'll setup a 10 secs timeout
		//and return false for disableation
		g_timeout_add (3 * 1000,
                           (GtkFunction) update_articles,
                           0);
	}
	gdouble timeout = gconf_client_get_float(rss_gconf, GCONF_KEY_REP_CHECK_TIMEOUT, NULL);
    	if (gconf_client_get_bool (rss_gconf, GCONF_KEY_REP_CHECK, NULL))
	{
		rf->rc_id = g_timeout_add (60 * 1000 * timeout,
                           (GtkFunction) update_articles,
                           (gpointer)1);
		
	}
}

/* check if rss folders exists and create'em otherwise */
void
check_folders(void)
{
        CamelException ex;
	CamelStore *store = mail_component_peek_local_store(NULL);
	//I'm not sure folder name can be translatable
	CamelFolder *mail_folder = camel_store_get_folder (store, "News&Blogs", 0, NULL);
	if (mail_folder == NULL)
	{
		camel_store_create_folder (store, NULL, "News&Blogs", &ex);
	}
}

void org_gnome_cooly_rss_refresh(void *ep, EMPopupTargetSelect *t);

void
org_gnome_cooly_rss_refresh(void *ep, EMPopupTargetSelect *t)
{
#ifndef EVOLUTION_2_12
	GtkWidget *readrss_dialog;
        GtkWidget *readrss_label;
        GtkWidget *readrss_progress;
        GtkWidget *label,*progress_bar, *cancel_button, *status_label;

        rf->t = t;

        if (!rf->setup || g_hash_table_size(rf->hr)<1)
        {
                e_error_run(NULL, "org-gnome-evolution-rss:generr", "No RSS feeds configured!", NULL);
                return;
        }
	readrss_dialog = e_error_new(NULL, "org-gnome-evolution-rss:readrss",
                _("Reading RSS feeds..."), NULL);

        g_signal_connect(readrss_dialog, "response", G_CALLBACK(readrss_dialog_cb), NULL);
        GtkWidget *label2 = gtk_label_new(NULL);
        readrss_label = gtk_label_new(_("Please wait"));
        if (!rf->progress_dialog)
        {
                readrss_progress = gtk_progress_bar_new();
                gtk_box_pack_start(GTK_BOX(((GtkDialog *)readrss_dialog)->vbox), label2, TRUE, TRUE, 10);
                gtk_box_pack_start(GTK_BOX(((GtkDialog *)readrss_dialog)->vbox), readrss_label, FALSE, FALSE, 0);
                gtk_box_pack_start(GTK_BOX(((GtkDialog *)readrss_dialog)->vbox), readrss_progress, FALSE, FALSE, 0);
                gtk_progress_bar_set_fraction((GtkProgressBar *)readrss_progress, 0);
                gtk_progress_bar_set_text((GtkProgressBar *)readrss_progress, _("0% done"));
                gtk_widget_show_all(readrss_dialog);
                rf->progress_dialog = readrss_dialog;
                rf->progress_bar = readrss_progress;
                rf->label       = label2;
        }
        if (!rf->pending && !rf->feed_queue)
        {
                rf->pending = TRUE;
                check_folders();

                rf->err = NULL;
                g_hash_table_foreach(rf->hr, fetch_feed, statuscb);
                // reset cancelation signal
                if (rf->cancel)
                        rf->cancel = 0;
                        rf->pending = FALSE;
        }
#endif
}

void
#ifdef EVOLUTION_2_12
org_gnome_cooly_rss(void *ep, EMEventTargetSendReceive *t);
#else
org_gnome_cooly_rss(void *ep, EMPopupTargetSelect *t);
#endif

void
#ifdef EVOLUTION_2_12
org_gnome_cooly_rss(void *ep, EMEventTargetSendReceive *t)
#else
org_gnome_cooly_rss(void *ep, EMPopupTargetSelect *t)
#endif
{
	GtkWidget *readrss_dialog;
	GtkWidget *readrss_label;
	GtkWidget *readrss_progress;
	GtkWidget *label,*progress_bar, *cancel_button, *status_label;

	rf->t = t;

	if (!rf->setup || g_hash_table_size(rf->hr)<1)
	{
		e_error_run(NULL, "org-gnome-evolution-rss:generr", "No RSS feeds configured!", NULL);
		return;
	}
	
#ifdef EVOLUTION_2_12
	struct _send_info *info;
	struct _send_data *data = (struct _send_data *)t->data;

        info = g_malloc0 (sizeof (*info));
//        info->type = type;
                        
        info->uri = g_strdup ("wwww");
//        info->keep = source->keep_on_server;
//        info->cancel = camel_operation_new (operation_status, info);
        info->state = SEND_ACTIVE;
//        info->timeout_id = g_timeout_add (STATUS_TIMEOUT, operation_status_timeout, info);
                        
        g_hash_table_insert (data->active, info->uri, info);
//        list = g_list_prepend (list, info);

	gchar *iconfile = g_build_filename (EVOLUTION_ICONDIR,
	                                    "rss.png",
                                            NULL);

	GtkWidget *recv_icon = e_icon_factory_get_image (
                        iconfile, E_ICON_SIZE_LARGE_TOOLBAR);
	g_free(iconfile);


	guint row = t->row;
	row+=2;
	t->row = row;

        char *pretty_url = g_strdup ("RSS");
        label = gtk_label_new (NULL);
        gtk_label_set_ellipsize (
                GTK_LABEL (label), PANGO_ELLIPSIZE_END);
        gtk_label_set_markup (GTK_LABEL (label), pretty_url);
        g_free (pretty_url);

        progress_bar = gtk_progress_bar_new ();

        cancel_button = gtk_button_new_from_stock (GTK_STOCK_CANCEL);

        status_label = gtk_label_new (_("Waiting..."));
//                status_label = e_clipped_label_new (
  //                    "www",
    //                  PANGO_WEIGHT_BOLD, 1.0);

        gtk_misc_set_alignment (GTK_MISC (label), 0, .5);
        gtk_misc_set_alignment (GTK_MISC (status_label), 0, .5);

	gtk_table_attach (
                        GTK_TABLE (t->table), recv_icon,
                        0, 1, row, row+2, 0, 0, 0, 0);
	gtk_table_attach (
                        GTK_TABLE (t->table), label,
                        1, 2, row, row+1, GTK_EXPAND | GTK_FILL, 0, 0, 0);
	gtk_table_attach (
                        GTK_TABLE (t->table), progress_bar,
                        2, 3, row, row+2, 0, 0, 0, 0);
	gtk_table_attach (
                        GTK_TABLE (t->table), cancel_button,
                        3, 4, row, row+2, 0, 0, 0, 0);
	gtk_table_attach (
                        GTK_TABLE (t->table), status_label,
                        1, 2, row+1, row+2, GTK_EXPAND | GTK_FILL, 0, 0, 0);

	g_signal_connect (
                        cancel_button, "clicked",
			G_CALLBACK (receive_cancel), info);

        info->progress_bar = progress_bar;
        info->status_label = status_label;
        info->cancel_button = cancel_button;
        info->data = (struct _send_data *)t->data;
	rf->info = info;

	rf->progress_bar = progress_bar;
	rf->sr_feed	= label;
	rf->label	= status_label;
#else

	readrss_dialog = e_error_new(NULL, "org-gnome-evolution-rss:readrss",
		_("Reading RSS feeds..."), NULL);

	g_signal_connect(readrss_dialog, "response", G_CALLBACK(readrss_dialog_cb), NULL);
	GtkWidget *label2 = gtk_label_new(NULL);
	readrss_label = gtk_label_new(_("Please wait"));
	if (!rf->progress_dialog)
	{
    		readrss_progress = gtk_progress_bar_new();
    		gtk_box_pack_start(GTK_BOX(((GtkDialog *)readrss_dialog)->vbox), label2, TRUE, TRUE, 10);
    		gtk_box_pack_start(GTK_BOX(((GtkDialog *)readrss_dialog)->vbox), readrss_label, FALSE, FALSE, 0);
    		gtk_box_pack_start(GTK_BOX(((GtkDialog *)readrss_dialog)->vbox), readrss_progress, FALSE, FALSE, 0);
    		gtk_progress_bar_set_fraction((GtkProgressBar *)readrss_progress, 0);
    		gtk_progress_bar_set_text((GtkProgressBar *)readrss_progress, _("0% done"));
    		gtk_widget_show_all(readrss_dialog);
		rf->progress_dialog = readrss_dialog;
		rf->progress_bar = readrss_progress;
		rf->label	= label2;
	}
#endif
	if (!rf->pending && !rf->feed_queue)
	{
		rf->pending = TRUE;
		check_folders();
	
		rf->err = NULL;
		g_hash_table_foreach(rf->hr, fetch_feed, statuscb);	
		// reset cancelation signal
		if (rf->cancel)
			rf->cancel = 0;
		rf->pending = FALSE;
	}
	

//camel_store_subscribe_folder (store, ->node->info->full_name, &mm->ex);
//camel_store_subscribe_folder (store, "www", NULL);
}

int e_plugin_lib_enable(EPluginLib *ep, int enable);

int
e_plugin_lib_enable(EPluginLib *ep, int enable)
{
	CORBA_Object factory;

	if (enable) {
		bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
		bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
		rss_gconf = gconf_client_get_default();
		printf("RSS Plugin enabled\n");
		//initiate main rss structure
		rf = malloc(sizeof(rssfeed));
		memset(rf, 0, sizeof(rssfeed));
		rf->setup = read_feeds(rf);
		rf->pending = FALSE;
		rf->progress_dialog = NULL;
		rf->errdialog = NULL;
		rf->cancel = FALSE;
		rf->rc_id = 0;
		rf->feed_queue = 0;
	} else {
		printf("Plugin disabled\n");
	}

	return 0;
}

void
create_mail(const char *folder, gchar *author, const char *subj, const char *body, const char *date, const char *dcdate, const char *website, const char *feedid)
{
CamelFolder *mail_folder;
CamelMimeMessage *new = camel_mime_message_new();
CamelInternetAddress *addr;
CamelInternetAddress *addr2;
CamelMessageInfo *info;
struct tm tm;
time_t time;
CamelDataWrapper *rtext;
CamelContentType *type;
CamelStream *stream;
CamelStore *store = mail_component_peek_local_store(NULL);

	mail_folder = camel_store_get_folder (store, folder, 0, NULL);
	camel_object_ref(mail_folder);

	info = camel_message_info_new(NULL);
	camel_message_info_set_flags(info, CAMEL_MESSAGE_SEEN, 1);

	camel_mime_message_set_subject(new, subj);

	addr = camel_internet_address_new(); 
#ifdef RSS_DEBUG
	g_print("date:%s\n", date);
#endif
	//CamelURL *url = camel_url_new(author, NULL);
	//camel_address_decode (CAMEL_ADDRESS (addr), url->path);
	//g_print("url:%s\n", url->path);

   	camel_address_decode(CAMEL_ADDRESS(addr), author);
//	addr2 = camel_address_format((CamelAddress *)addr);
	camel_mime_message_set_from(new, addr);
	camel_object_unref(addr);

	int offset = 0;

	//handle pubdate
	if (date)
	{
		time_t actual_time;
		actual_time = camel_header_decode_date(date, &offset);
		camel_mime_message_set_date(new, actual_time, offset);
	}
	else 
	{
		if (dcdate)	//dublin core 
		{
			strptime(dcdate, "%Y-%m-%dT%T%z", &tm);
			time = mktime(&tm);
			time_t actual_time = camel_header_decode_date (ctime(&time), &offset);
			camel_mime_message_set_date(new, actual_time, offset);
		}
		else /*use now as time for failsafe*/
			camel_mime_message_set_date(new, CAMEL_MESSAGE_DATE_CURRENT, 0);
	}

	camel_medium_set_header(CAMEL_MEDIUM(new), "Website", website);
	camel_medium_set_header(CAMEL_MEDIUM(new), "RSS-ID", feedid);
	rtext = camel_data_wrapper_new ();
        type = camel_content_type_new ("text", "evolution-rss-feed");
        camel_content_type_set_param (type, "format", "flowed");
        camel_data_wrapper_set_mime_type_field (rtext, type);
        camel_content_type_unref (type);
        stream = camel_stream_mem_new ();
	// w/out an format argument this throws and seg fault
        camel_stream_printf (stream, "%s", body);
        camel_data_wrapper_construct_from_stream (rtext, stream);
        camel_object_unref (stream);

        camel_medium_set_content_object(CAMEL_MEDIUM(new), CAMEL_DATA_WRAPPER(rtext));
//        camel_object_unref(body);

	camel_folder_append_message(mail_folder, new, info, NULL, NULL);
}

/************ RDF Parser *******************/

static char *
layer_find_innerelement (xmlNodePtr node, 
	    char *match, char *el,
	    char *fail)
{
	while (node!=NULL) {
#ifdef RDF_DEBUG
		xmlDebugDumpNode (stdout, node, 32);
		printf("%s.\n", node->name);
#endif
		if (strcasecmp (node->name, match)==0) {
			return xmlGetProp(node, el);
		}
		node = node->next;
	}
	return fail;
}

xmlNode *
html_find (xmlNode *node,
            char *match)
{
#ifdef RDF_DEBUG
g_print("parser error 3_1!!!\n");
#endif
	while (node) {
#ifdef RDF_DEBUG
                xmlDebugDumpNode (stdout, node, 32);
                printf("%s.\n", node->name);
#endif
                if (node->children)
                        node = node->children;
                else {
                        while (node && !node->next)
                                node = node->parent;
                        //if (!node || node == top)
                        if (!node)
{
#ifdef RDF_DEBUG
g_print("parser error 3_2 -> return NULL!!!\n");
#endif
                                return NULL;
}
                        node = node->next;
                }

                if (node->name) {
                        if (!strcmp (node->name, match))
{
#ifdef RDF_DEBUG
g_print("parser error 3_3 -> return NULL!!!\n");
#endif
                                return node;
}
                }
        }
#ifdef RDF_DEBUG
g_print("parser error 3_4 -> return NULL!!!\n");
#endif
        return NULL;
}

static char *
layer_find (xmlNodePtr node, 
	    char *match, 
	    char *fail)
{
	while (node!=NULL) {
#ifdef RDF_DEBUG
		xmlDebugDumpNode (stdout, node, 32);
		printf("%s.\n", node->name);
#endif
		if (strcasecmp (node->name, match)==0) {
			if (node->children != NULL && node->children->content != NULL) {
				return node->children->content;
			} else {
				return fail;
			}
		}
		node = node->next;
	}
	return fail;
}

static char *
layer_find_tag (xmlNodePtr node,
            char *match,
            char *fail)
{
	xmlBufferPtr buf = xmlBufferCreate();
	gchar *content;
	guint len = 0;
        while (node!=NULL) {
#ifdef RDF_DEBUG
                xmlDebugDumpNode (stdout, node, 32);
                printf("%s.\n", node->name);
#endif
                if (strcasecmp (node->name, match)==0) {
                        if (node->children != NULL && node->children->next != NULL) {
				len = xmlNodeDump(buf, node->doc, node->children->next, 0, 0);
				content = g_strdup(xmlBufferContent(buf));
				xmlBufferFree(buf);
				return content;
                        } else {
				xmlBufferFree(buf);
                                return fail;
                        }
                }
                node = node->next;
        }
	xmlBufferFree(buf);
        return fail;
}

static gchar *
layer_find_innerhtml (xmlNodePtr node,
	    char *match, char *submatch,
	    char *fail)
{
	while (node!=NULL) {
#ifdef RDF_DEBUG
		xmlDebugDumpNode (stdout, node, 32);
		printf("%s.\n", node->name);
#endif
		if (strcasecmp (node->name, match)==0) {
			return layer_find(node->children->next, submatch, NULL);
		}
		node = node->next;
	}
	return fail;
}

static char *
layer_find_url (xmlNodePtr node, 
		char *match, 
		char *fail)
{
	char *p = layer_find (node, match, fail);
	char *r = p;
	static char *wb = NULL;
	char *w;
	
	if (wb) {
		g_free (wb);
	}
	
	wb = w = g_malloc (3 * strlen (p));

	if (w == NULL) {
		return fail;
	}
	
	if (*r == ' ') r++;	/* Fix UF bug */

	while (*r) {
		if (strncmp (r, "&amp;", 5) == 0) {
			*w++ = '&';
			r += 5;
			continue;
		}
		if (strncmp (r, "&lt;", 4) == 0) {
			*w++ = '<';
			r += 4;
			continue;
		}
		if (strncmp (r, "&gt;", 4) == 0) {
			*w++ = '>';
			r += 4;
			continue;
		}
		if (*r == '"' || *r == ' '){
			*w++ = '%';
			*w++ = "0123456789ABCDEF"[*r/16];
			*w++ = "0123456789ABCDEF"[*r&15];
			r++;
			continue;
		}
		*w++ = *r++;
	}
	*w = 0;
	return wb;
}

gchar *
tree_walk (xmlNodePtr root, RDF *r)
{
	xmlNodePtr walk;
	xmlNodePtr rewalk = root;
	xmlNodePtr channel = NULL;
	xmlNodePtr image = NULL;
	GArray *item = g_array_new (TRUE, TRUE, sizeof (xmlNodePtr));
	char *t;
	char *charset;

	/* check in-memory encoding first, fallback to transport encoding, which may or may not be correct */
	if (r->cache->charset == XML_CHAR_ENCODING_UTF8
	    || r->cache->charset == XML_CHAR_ENCODING_ASCII) {
		charset = NULL;
	} else {
		/* bad/missing encoding, fallback to latin1 (locale?) */
		charset = r->cache->encoding ? (char *)r->cache->encoding : "iso-8859-1";
	}

	do {
		walk = rewalk;
		rewalk = NULL;
		
		while (walk!=NULL){
#ifdef RDF_DEBUG
			printf ("%p, %s\n", walk, walk->name);
#endif
			if (strcasecmp (walk->name, "rdf") == 0) {
				rewalk = walk->children;
				walk = walk->next;
				if (!r->type)
				r->type = g_strdup("RDF");
				r->type_id = RDF_FEED;
				continue;
			}
			if (strcasecmp (walk->name, "rss") == 0){
				rewalk = walk->children;
				walk = walk->next;
				if (!r->type)
				r->type = g_strdup("RSS");
				r->type_id = RSS_FEED;
				continue;
			}
			if (strcasecmp (walk->name, "feed") == 0) {
				if (!r->type)
				r->type = g_strdup("ATOM");
				r->type_id = ATOM_FEED;
			}

			/* This is the channel top level */
#ifdef RDF_DEBUG
			printf ("Top level '%s'.\n", walk->name);
#endif
			if (strcasecmp (walk->name, "channel") == 0) {
				channel = walk;
				rewalk = channel->children;
			}
			if (strcasecmp (walk->name, "feed") == 0) {
				channel = walk;
				rewalk = channel->children;
			}
			if (strcasecmp (walk->name, "image") == 0) {
				image = walk;
			}
			if (strcasecmp (walk->name, "item") == 0) {
				g_array_append_val(item, walk);
			}
			if (strcasecmp (walk->name, "entry") == 0) {
				g_array_append_val(item, walk);
			}
			walk = walk->next;
		}
	}
	while (rewalk);
	
	if (channel == NULL) {
		fprintf(stderr, "No channel definition.\n");
		return NULL;
	}

	t = layer_find(channel->children, "title", "");
	//items might not have a date
	// so try to grab channel/feed date
	gchar *md2 = layer_find(channel->children, "date", 
		layer_find(channel->children, "pubDate", 
		layer_find(channel->children, "updated", NULL)));

	r->feedid = update_channel(t, md2, item);
	g_array_free(item, TRUE);
	return t;
}

u_int32_t
gen_crc(const char *msg)
{
        register unsigned long crc, poly;
        u_int32_t crc_tab[256];
        int i,j;

        poly = 0xEDB88320L;
        for (i = 0; i < 256; i++)
        {
                crc = i;
                for (j = 8; j > 0; j--)
                {
                        if (crc & 1)
                                crc = (crc >> 1) ^ poly;
                        else
                                crc >>= 1;
                }
                crc_tab[i] = crc;
        }

        crc = 0xFFFFFFFF;
        for (i = 0; i < strlen(msg); i++)
                crc = ((crc >> 8) & 0x00FFFFFF) ^ crc_tab[(crc ^ *msg++) & 0xFF];
   return (crc ^ 0xFFFFFFFF);
}

u_int32_t
update_channel(const char *chn_name, char *main_date, GArray *item)
{
        gchar *tmp = NULL;
        guint i;
	gchar *full_path = g_strdup_printf("News&Blogs/%s", chn_name);
	gchar *sender = g_strdup_printf("<%s>", chn_name);
	CamelFolder *mail_folder;
	CamelStore *store = mail_component_peek_local_store(NULL);
	char *d2 = NULL;
	xmlNodePtr el;
	char *q = NULL;
	char *b = NULL;
	gchar *feed = NULL;
	gboolean freeb = 0; //if b needs to be freed or not

	mail_folder = camel_store_get_folder (store, full_path, 0, NULL);
	if (mail_folder == NULL)
	{
		camel_store_create_folder (store, "News&Blogs", chn_name, NULL);
		mail_folder = camel_store_get_folder (store, full_path, 0, NULL);
	}

	camel_folder_freeze(mail_folder);

	u_int32_t feedid = gen_crc(chn_name);
	gchar *buf = g_strdup_printf("%x", feedid);

	gchar *feed_dir = g_strdup_printf("%s/mail/rss", 
	    mail_component_peek_base_directory (mail_component_peek ()));
	if (!g_file_test(feed_dir, G_FILE_TEST_EXISTS))
	    g_mkdir_with_parents (feed_dir, 0755);

	gchar *feed_name = g_strdup_printf("%s/%s", feed_dir, buf);
	g_free(feed_dir);
	
	FILE *fr = fopen(feed_name, "r");
	FILE *fw = fopen(feed_name, "a+");

	for (i=0; NULL != (el = g_array_index(item, xmlNodePtr, i)); i++)
	{
                char *p = layer_find (el->children, "title", "Untitled article");
		//firstly try to parse as an ATOM author
               	char *q1 = layer_find_innerhtml (el->children, "author", "name", NULL);
		char *q2 = layer_find_innerhtml (el->children, "author", "uri", NULL);
		char *q3 = layer_find_innerhtml (el->children, "author", "email", NULL);
		if (q1)
		{
        		q1 = g_strdelimit(q1, "><", ' ');
			if (q3)
			{
        			q3 = g_strdelimit(q3, "><", ' ');
               			q = g_strdup_printf("%s <%s>", q1, q3);
			}
			else
			{
				if (q2)
        				q2 = g_strdelimit(q2, "><", ' ');
				else 
					q2 = q1;
               			q = g_strdup_printf("%s <%s>", q1, q2);
			}
		}
		else	//then RSS or RDF
		{
                	q = layer_find (el->children, "author", 
				layer_find (el->children, "creator", NULL));
			if (q)
			{
				//evo will go crazy when it'll encounter ":" character
        			//it probably enforces strict rfc2047 compliance
        			q = g_strdelimit(q, "><:", ' ');
        			q = g_strdup_printf("\"%s\" <\"%s\">", q, g_strdelimit(q, "><:", ' '));
			}
		}
		b = layer_find_tag (el->children, "description",
				layer_find_tag (el->children, "content", NULL));

		if (b)
			freeb = 1;
		else
                	b = layer_find (el->children, "description",
				layer_find (el->children, "content", "No information"));

                char *d = layer_find (el->children, "pubDate", NULL);
		//date in dc module format
		if (!d)
		{
                	d2 = layer_find (el->children, "date", NULL);		//RSS2
			if (!d2)
			{
				d2 = layer_find(el->children, "updated", NULL); //ATOM
				if (!d2) //take channel date if exists
					d2 = main_date;
			}
		}

                char *link = layer_find (el->children, "link",				//RSS,
			layer_find_innerelement(el->children, "link", "href", _("No Information")));	//ATOM
		char *id = layer_find (el->children, "id", NULL);	//ATOM
		feed = g_strdup_printf("%s\n", id ? id : link);
#ifdef RSS_DEBUG
		g_print("link:%s\n", link);
		g_print("body:%s\n", b);
		g_print("author:%s\n", q);
		g_print("sender:%s\n", sender);
		g_print("title:%s\n", p);
		g_print("date:%s\n", d);
		g_print("date:%s\n", d2);
#endif
		gchar rfeed[513];
		memset(rfeed, 0, 512);
		int occ = 0;
		if (fr)
		{
		    while (fgets(rfeed, 511, fr) != NULL)
		    {
			if (rfeed && strstr(rfeed, feed))
			{
				occ=1;
				break;
			}
		    }
		    (void)fseek(fr, 0L, SEEK_SET);
		}
		if (!occ)
		{
		    if (fw) fputs(feed, fw);
        	    create_mail(full_path, q ? q : sender, p, b, d, d2, link, buf);
		}
#ifdef RSS_DEBUG
		g_print("put success()\n");
#endif
		
        }
	if (freeb)
		g_free(b);
	g_free(buf);
	g_free(full_path);
	g_free(sender);

	if (fr) fclose(fr);
	if (fw) fclose(fw);
	
	g_free(feed_name);
	g_free(feed);
	if (q) g_free(q);
	camel_folder_sync(mail_folder, FALSE, NULL);
	camel_folder_thaw(mail_folder);
	camel_operation_end(NULL);
	return feedid;
}

gchar *
display_doc (RDF *r)
{
	return tree_walk (xmlDocGetRootElement (r->cache), r);
}

/*static void
rdf_free (RDF *r)
{
	/* Stop the download */
/*	if (r->message) {
		soup_message_cancel (r->message);
	}

	g_free (r->uri);
	g_free (r->html);

	if (r->cache) {
		xmlFreeDoc (r->cache);
	}

	g_free (r);
}

static void
e_summary_rdf_set_online (ESummary *summary,
			  GNOME_Evolution_OfflineProgressListener progress,
			  gboolean online,
			  void *data)
{
	ESummaryRDF *rdf;
	GList *p;

	rdf = summary->rdf;
	if (rdf->online == online) {
		return;
	}

	if (online == TRUE) {
		e_summary_rdf_update (summary);

		if (summary->preferences->rdf_refresh_time != 0)
			rdf->timeout = gtk_timeout_add (summary->preferences->rdf_refresh_time * 1000,
							(GtkFunction) e_summary_rdf_update,
							summary);
	} else {
		for (p = rdf->rdfs; p; p = p->next) {
			RDF *r;

			r = p->data;
			if (r->message) {
				soup_message_cancel (r->message);
				r->message = NULL;
			}
		}

		gtk_timeout_remove (rdf->timeout);
		rdf->timeout = 0;
	}

	rdf->online = online;
}

void
e_summary_rdf_init (ESummary *summary)
{
	ESummaryPrefs *prefs;
	ESummaryRDF *rdf;
	ESummaryConnection *connection;
	GSList *p;
	int timeout;

	g_return_if_fail (summary != NULL);
	g_return_if_fail (IS_E_SUMMARY (summary));

	prefs = summary->preferences;
	g_assert (prefs != NULL);

	rdf = g_new0 (ESummaryRDF, 1);
	summary->rdf = rdf;

	connection = g_new (ESummaryConnection, 1);
	connection->count = e_summary_rdf_count;
	connection->add = e_summary_rdf_add;
	connection->set_online = e_summary_rdf_set_online;
	connection->closure = NULL;
	connection->callback = NULL;
	connection->callback_closure = NULL;

	rdf->connection = connection;
	rdf->online = TRUE;
	e_summary_add_online_connection (summary, connection);

	e_summary_add_protocol_listener (summary, "rdf", e_summary_rdf_protocol, rdf);

	for (p = prefs->rdf_urls; p; p = p->next) {
		e_summary_rdf_add_uri (summary, p->data);
	}
	timeout = prefs->rdf_refresh_time;

	e_summary_rdf_update (summary);

	if (rdf->timeout == 0)
		rdf->timeout = 0;
	else
		rdf->timeout = gtk_timeout_add (timeout * 1000,
						(GtkFunction) e_summary_rdf_update, summary);

	return;
}

void
e_summary_rdf_reconfigure (ESummary *summary)
{
	ESummaryRDF *rdf;
	GList *old, *p;
	GSList *sp;

	g_return_if_fail (summary != NULL);
	g_return_if_fail (IS_E_SUMMARY (summary));

	rdf = summary->rdf;

	/* Stop timeout */
/*	if (rdf->timeout != 0) {
		gtk_timeout_remove (rdf->timeout);
		rdf->timeout = 0;
	}

	old = rdf->rdfs;
	rdf->rdfs = NULL;
	for (p = old; p; p = p->next) {
		RDF *r;

		r = p->data;
		rdf_free (r);
	}
	g_list_free (old);

	for (sp = summary->preferences->rdf_urls; sp; sp = sp->next) {
		e_summary_rdf_add_uri (summary, sp->data);
	}

	if (summary->preferences->rdf_refresh_time != 0)
		rdf->timeout = gtk_timeout_add (summary->preferences->rdf_refresh_time * 1000,
						(GtkFunction) e_summary_rdf_update, summary);

	e_summary_rdf_update (summary);
}

void
e_summary_rdf_free (ESummary *summary)
{
	ESummaryRDF *rdf;
	GList *p;

	g_return_if_fail (summary != NULL);
	g_return_if_fail (IS_E_SUMMARY (summary));

	rdf = summary->rdf;

	if (rdf->timeout != 0)
		gtk_timeout_remove (rdf->timeout);

	for (p = rdf->rdfs; p; p = p->next) {
		RDF *r = p->data;

		rdf_free (r);
	}
	g_list_free (rdf->rdfs);
	g_free (rdf->html);

	e_summary_remove_online_connection (summary, rdf->connection);
	g_free (rdf->connection);

	g_free (rdf);
	summary->rdf = NULL;
}
*/

/*=============*
 * BONOBO part *
 *=============*/

proxy_toggled_cb (GtkToggleButton *toggle, gpointer data)
{
        if (!GTK_IS_RADIO_BUTTON (toggle) || toggle->active)
		g_print("toggle\n");
}

EvolutionConfigControl*
rss_config_control_new (void)
{
        GtkWidget *control_widget;
        char *gladefile;
	setupfeed *sf;
	
	GtkListStore  *store;
	GtkTreeIter    iter;
	int i;
	GtkCellRenderer *cell;
	GtkTreeSelection *selection;
	GtkTreeViewColumn *column;
	GtkWidget *vbox1;
	GtkWidget *vbox2;
	GtkWidget *hbox2;
	GtkWidget *hbox3;

	g_print("rf->%p\n", rf);
	sf = g_new0(setupfeed, 1);

        gladefile = g_build_filename (EVOLUTION_GLADEDIR,
                                      "rss-ui.glade",
                                      NULL);
        sf->gui = glade_xml_new (gladefile, NULL, NULL);
        g_free (gladefile);

        GtkTreeView *treeview = (GtkTreeView *)glade_xml_get_widget (sf->gui, "feeds-treeview");
	rf->treeview = (GtkWidget *)treeview;
	sf->treeview = (GtkWidget *)treeview;

	//gtk_widget_set_size_request ((GtkWidget *)treeview, 395, -1);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);

	store = gtk_list_store_new (3, G_TYPE_BOOLEAN, G_TYPE_STRING,
                                G_TYPE_STRING);

	gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), (GtkTreeModel *)store);

	cell = gtk_cell_renderer_toggle_new ();

	column = gtk_tree_view_column_new_with_attributes (_("Enabled"),
                                                  cell,
                                                  "active", 0,
                                                  NULL);
	g_signal_connect((gpointer) cell, "toggled", G_CALLBACK(enable_toggle_cb), store);
	gtk_tree_view_column_set_resizable(column, FALSE);
	gtk_tree_view_column_set_max_width (column, 70);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview),
                               column);
	cell = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes (_("Feed Name"),
                                                  cell,
                                                  "text", 1,
                                                  NULL);
	gtk_tree_view_column_set_resizable(column, TRUE);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview),
                               column);
	gtk_tree_view_column_set_sort_column_id (column, 1);
	gtk_tree_view_column_clicked(column);
	column = gtk_tree_view_column_new_with_attributes (_("Type"),
                                                  cell,
                                                  "text", 2,
                                                  NULL);
	gtk_tree_view_column_set_resizable(column, TRUE);
	gtk_tree_view_append_column (GTK_TREE_VIEW (treeview),
                               column);
	gtk_tree_view_column_set_sort_column_id (column, 2);
	gtk_tree_view_set_search_column (GTK_TREE_VIEW (treeview),
                                                   2);

	if (rf->hr != NULL)
        	g_hash_table_foreach(rf->hr, construct_list, store);

	//make sure something (first row) is selected
       selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
       gtk_tree_model_iter_nth_child(GTK_TREE_MODEL(store), &iter, NULL, 0);
       gtk_tree_selection_select_iter(selection, &iter);
 
       GtkWidget *button1 = glade_xml_get_widget (sf->gui, "feed-add-button");
       g_signal_connect(button1, "clicked", G_CALLBACK(feeds_dialog_add), treeview);

       GtkWidget *button2 = glade_xml_get_widget (sf->gui, "feed-edit-button");
       g_signal_connect(button2, "clicked", G_CALLBACK(feeds_dialog_edit), treeview);

       GtkWidget *button3 = glade_xml_get_widget (sf->gui, "feed-delete-button");
       g_signal_connect(button3, "clicked", G_CALLBACK(feeds_dialog_delete), treeview);


	sf->add_feed = glade_xml_get_widget (sf->gui, "add-feed-dialog");
	sf->check1 = glade_xml_get_widget(sf->gui, "checkbutton1");
	sf->check2 = glade_xml_get_widget(sf->gui, "checkbutton2");
	sf->check3 = glade_xml_get_widget(sf->gui, "checkbutton3");
	sf->spin = glade_xml_get_widget(sf->gui, "spinbutton1");

 	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sf->check1), 
	gconf_client_get_bool(rss_gconf, GCONF_KEY_REP_CHECK, NULL));

  	gdouble adj = gconf_client_get_float(rss_gconf, GCONF_KEY_REP_CHECK_TIMEOUT, NULL);
  	if (adj)
		gtk_spin_button_set_value((GtkSpinButton *)sf->spin, adj);
	g_signal_connect(sf->check1, "clicked", G_CALLBACK(rep_check_cb), sf->spin);
	g_signal_connect(sf->spin, "changed", G_CALLBACK(rep_check_timeout_cb), sf->check1);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sf->check2),
        	gconf_client_get_bool(rss_gconf, GCONF_KEY_START_CHECK, NULL));
	g_signal_connect(sf->check2, "clicked", G_CALLBACK(start_check_cb), GCONF_KEY_START_CHECK);


	/* Network tab */
	sf->use_proxy = glade_xml_get_widget(sf->gui, "use_proxy");
	sf->host_proxy = glade_xml_get_widget(sf->gui, "host_proxy");
	sf->port_proxy = glade_xml_get_widget(sf->gui, "port_proxy");
	sf->details = glade_xml_get_widget(sf->gui, "details");
	sf->proxy_details = glade_xml_get_widget(sf->gui, "http-proxy-details");

	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sf->use_proxy),
        	gconf_client_get_bool(rss_gconf, GCONF_KEY_USE_PROXY, NULL));
	g_signal_connect(sf->use_proxy, "clicked", G_CALLBACK(start_check_cb), GCONF_KEY_USE_PROXY);

	gchar *host = gconf_client_get_string(rss_gconf, GCONF_KEY_HOST_PROXY, NULL);
	if (host)
		gtk_entry_set_text(GTK_ENTRY(sf->host_proxy), host);
	g_signal_connect(sf->host_proxy, "changed", G_CALLBACK(host_proxy_cb), NULL);

  	gdouble port = gconf_client_get_float(rss_gconf, GCONF_KEY_PORT_PROXY, NULL);
  	if (port)
		gtk_spin_button_set_value((GtkSpinButton *)sf->port_proxy, port);
	g_signal_connect(sf->port_proxy, "changed", G_CALLBACK(port_proxy_cb), NULL);
	g_signal_connect(sf->port_proxy, "value_changed", G_CALLBACK(port_proxy_cb), NULL);

	g_signal_connect(sf->details, "clicked", G_CALLBACK(details_cb), sf->gui);



/*        cfm_data->contactcerts_treeview = glade_xml_get_widget (cfm_data->gui, "contactcerts-treeview");
        cfm_data->authoritycerts_treeview = glade_xml_get_widget (cfm_data->gui, "authoritycerts-treeview");

        cfm_data->delete_ca_button = glade_xml_get_widget (cfm_data->gui, "authority-delete-button");

        initialize_yourcerts_ui(cfm_data);
        initialize_contactcerts_ui(cfm_data);
        initialize_authoritycerts_ui(cfm_data);

        populate_ui (cfm_data);*/

        control_widget = glade_xml_get_widget (sf->gui, "feeds-notebook");
        gtk_widget_ref (control_widget);

        gtk_container_remove (GTK_CONTAINER (control_widget->parent), control_widget);

        return evolution_config_control_new (control_widget);
}


static BonoboObject *
factory (BonoboGenericFactory *factory,
         const char *component_id,
         void *closure)
{

	g_print("component_id:%s\n", component_id);

        if (strcmp (component_id, RSS_CONTROL_ID) == 0)
                return BONOBO_OBJECT (rss_config_control_new ());

        g_warning (FACTORY_ID ": Don't know what to do with %s", component_id);
        return NULL;
}


BONOBO_ACTIVATION_SHLIB_FACTORY (FACTORY_ID, "Evolution RSS component factory", factory, NULL)
