;;; ewb-check.el --- Functions to check index of EWB.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(require 'ewb-tools)
(require 'ewb-index)

(defvar ewb-checklist-buffer "*EWB check buffer*"
  "EWBǥåΥå̤ΥꥹȤɽХåե")

(defvar ewb-check-list-str-width 25
  "Check ListХåեɽʸĹ")

(defun ewb-check-not-in-forall ()
  "ߤΥХåեˤ//in??ForAll.indexˤ뤫ɤĴ١
ForAll.indexˤʤ//in??ΥꥹȤɽ롣"
  (interactive)
  (save-excursion
    (goto-char (point-min))
    (let ((result)
	  (cwin (ewb-make-check-list-buffer)))
      (progn
	(setq result 0)
	(while (not (= result -1))
	  (setq result (ewb-is-index-on-forall))
	  (if (> result 0)
	      (ewb-make-list-on-check-list-buffer cwin)))))))

(defun ewb-check-double-index ()
  "ߤΥХåեˤ//in??˽ʣ뤫ɤĴ١
ʣƤ//in??ΥꥹȤɽ롣"
  (interactive)
  (save-excursion
    (goto-char (point-min))
    (let ((result)
	  (double-list nil)
	  (cwin (ewb-make-check-list-buffer)))
      (progn
	(setq result 0)
	(while (not (= result -1))
	  (setq result (ewb-is-same-index))
	  (if (> result 0)
	      (if (not (memq result double-list))
		  (progn
		    (setq double-list (cons result double-list))
		    (ewb-make-list-on-check-list-buffer cwin)
		    (save-excursion
		      (while (re-search-forward
			      (concat
			       "//in"
			       (number-to-string result)
			       "[^0-9]")
			      nil t nil)
			(ewb-make-list-on-check-list-buffer cwin)))))))))))

(defun ewb-is-same-index ()
  "ƱХåե˼˸դä//in??Ʊֹ//in??
뤫ɤĴ١Фκֹ֤
//in??դʤ-1ʳʤ0֤"
  (let ((inum))
    (progn
      (if (not (re-search-forward "//in[0-9]+[^0-9]" nil t nil))
	  -1
	(progn
	  (backward-char)
	  (if (< 0 (setq inum
			 (save-excursion
			   (backward-char)
			   (ewb-get-in-triger-number))))
	      (save-excursion
		(if (re-search-forward
		     (concat
		      "//in"
		      (number-to-string inum)
		      "[^0-9]")
		     nil t nil)
		    inum
		  0))
	    0))))))

(defun ewb-make-check-list-buffer ()
  "Check ListХåե롣Window(selected-window)֤"
    (let ((cwin)
	  (obuf (current-buffer))
	  (obufname (buffer-name))
	  (owin (selected-window))
	  (cbuf (get-buffer-create ewb-checklist-buffer)))
      (progn
	(if (one-window-p)
	    (split-window))
	(other-window 1)
	(set-window-buffer (selected-window) cbuf)
	(setq cwin (selected-window))
	(erase-buffer)
	(ewb-checklist-mode)
	(setq ewb-checklist-text-buffer obuf)
	(insert (format "EWB check list in buffer %s.\n" obufname))
	(select-window owin)
	cwin)))

(defun ewb-make-list-on-check-list-buffer (cwin)
  "cwinˤCheck ListХåեˡȥݥľˤ//in??ΥꥹȤ롣"
    (let ((line)(str)(instr-start)(instr-end)
	  (owin (selected-window)))
      (save-excursion
	(setq line (count-lines (point-min) (point)))
	(re-search-backward "//in[0-9]+" nil t nil)
	(setq instr-start (match-beginning 0))
	(setq instr-end (match-end 0))
	(if ewb-index-position-forward
	    (progn
	      (setq str (buffer-substring instr-start
					  (if (> (+ instr-end ewb-check-list-str-width) (point-max))
					      (point-max)
					    (+ instr-end ewb-check-list-str-width))))
	      ;; check line end
	      (setq str
		    (if (= (length str) (string-match "$" str))
			str
		      (substring str 0 (match-beginning 0))))
;	      ;; check //in after the very //in
;	      (setq str
;		    (progn
;		      (while (string-match "//in[0-9]+.*//in[0-9]+" str)
;			(string-match "//in[0-9]+" str 5)
;			(setq str (substring str 0 (match-beginning 0))))
;		      str))
	      )
	  (progn
	    (setq str (buffer-substring
		       (if (< (- instr-start ewb-check-list-str-width) (point-min))
			   (point-min)
			 (- instr-start ewb-check-list-str-width))
		       instr-end))
	    ;; check line end
	    (setq str
		  (progn
		    (while (not (= (length str) (string-match "$" str)))
		      (setq str (substring str (+ (match-end 0) 1))))
		    str))
;	    ;; check //in before the very //in
;	    (setq str
;		  (progn
;		    (while (string-match "//in[0-9]+.*//in[0-9]+" str)
;		      (string-match "//in[0-9]+" str)
;		      (setq str (substring str (match-end 0))))
;		    str))
	    ))
	(select-window cwin)
	(goto-char (point-max))
	(insert (format "%7d: %s\n" line str))
	(select-window owin))))

(defun ewb-jump-checklist ()
  "åꥹȤγ//in??֡"
  (interactive)
  (let* ((line (get-one-line-from-buffer))
	 (lnums
	  (if (not (string= line ""))
	      (if (> (length line) 7)
		  (substring line 0 7)
		"")
	    ""))
	 (instr
	  (if (not (string= line ""))
	      (substring line 9)
	    ""))
	 (obuf ewb-checklist-text-buffer)
	 )
    (progn
      (if (<= (string-to-number lnums) 0)
	  (princ "Ǥ٤ޤ")
	(progn
	  (if (one-window-p)
	      (split-window))
	  (other-window 1)
	  (set-window-buffer (selected-window) obuf)
	  (goto-char (point-min))
	  (goto-line (string-to-number lnums))
	  (search-forward instr)
	  (if ewb-index-position-forward
	      (search-backward (substring instr 0 (- (length instr) 1)))
	    (search-backward "//in"))
	  )))))

(defun ewb-jump-checklist-mouse (event)
  "ޥewb-jump-checklist

Go to the occurrence highlighted by mouse.
This function is only reasonable when bound to a mouse key in the check list buffer"
  (interactive "e")
  (let ((window-save (selected-window))
	(frame-save (selected-frame)))
    ;; preserve the window/frame setup
    (unwind-protect
	(progn
	  (mouse-set-point event)
	  (ewb-jump-checklist))
      (select-frame frame-save)
      (select-window window-save))))

(defvar ewb-checklist-mode-map ())
(if ewb-checklist-mode-map
    ()
  (setq ewb-checklist-mode-map (make-sparse-keymap))
  (set-keymap-name ewb-checklist-mode-map 'ewb-checklist-mode-map) ; XEmacs
  (define-key ewb-checklist-mode-map 'button1 'ewb-jump-checklist-mouse) ; XEmacs
  (define-key ewb-checklist-mode-map 'button2 'ewb-jump-checklist-mouse) ; XEmacs
  (define-key ewb-checklist-mode-map 'button3 'ewb-jump-checklist-mouse) ; XEmacs
  (define-key ewb-checklist-mode-map "\C-c\C-c" 'ewb-jump-checklist)
  (define-key ewb-checklist-mode-map "\C-m" 'ewb-jump-checklist))

(defvar ewb-checklist-text-buffer nil
  "åꥹȤθХåե¸ѿ")

(defun ewb-checklist-mode ()
  "Major mode for output from \\[ewb-check-not-in-forall].
\\<ewb-checklist-mode-map>Move point to one of the items in this buffer, then use
\\[ewb-jump-checklist] to go to the ewb-checklistrence that the item refers to.
Alternatively, click \\[ewb-checklist-mode-mouse-goto] on an item to go to it.

\\{ewb-checklist-mode-map}"
  (kill-all-local-variables)
  (use-local-map ewb-checklist-mode-map)
  (setq major-mode 'ewb-checklist-mode)
  (setq mode-name (gettext "EWB Checklist")) ; XEmacs
  (make-local-variable 'ewb-checklist-text-buffer)
  (require 'mode-motion) ; XEmacs
  (setq mode-motion-hook 'mode-motion-highlight-line) ; XEmacs
  (if ewb-font-lock-mode-p
      (font-lock-mode t))
  (run-hooks 'ewb-checklist-mode-hook))

(put 'ewb-checklist-mode 'font-lock-defaults
     '(ewb-checklist-font-lock-keywords nil nil nil))

(defconst ewb-checklist-font-lock-keywords (purecopy
  (list
   '("^[ 0-9]+:" . font-lock-function-name-face)
   '("//in\\([0-9]+\\)?" . font-lock-comment-face)
   ))
  "Additional expressions to highlight in ewb-checklist-mode.")

(provide 'ewb-check)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; ewb-check.el ends here.
