;;; ewb-phy.el --- Functions for ForAll.phy in EWB.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(require 'ewb-triger)

(defvar ewb-phy-type-default "e"
  "ʪ°Υǥեȥ")

(defvar ewb-phy-directory-default "FIG/"
  "EPSեΥǥեȥǥ쥯ȥ")

(defvar ewb-phy-size-default "0mm,0mm"
  "ɽΥǥեȥ")

(defvar ewb-phy-cappos-default "cs"
  "ץΥǥեȰ")

(defvar ewb-phy-capspace-default ""
  "ץȿɽΤΥǥե")

(defvar ewb-phy-pos-default "htb"
  "ɽ֤Υǥե")

(defvar ewb-phy-align-default "C"
  "ɽ·Υǥե")

(defvar ewb-phy-space-default ","
  ",ΤΥǥե")

(defvar ewb-view-eps-command "ghostview"
  "EPSեɽ륳ޥ̾")

(defvar ewb-phy-file-name "ForAll.phy"
  "EWBphyե̾")

(defvar ewb-temp-process-name "ewb-process"
  "Ūʥץ̾")

(defvar ewb-output-buffer-name " *ewb process output*"
  "ŪʥץѤνϥХåե")

(defvar ewb-phy-width-history nil
  "ɽ")

(defvar ewb-phy-height-history nil
  "ɽι⤵")

(defvar ewb-phy-ratio-history nil
  "ɽγ")

(defvar ewb-phy-capspace-history nil
  "ɽȥץΤ")

(defvar ewb-phy-pos-history nil
  "ɽ֤")

(defvar ewb-phy-right-space-history nil
  "ɽα")

(defvar ewb-phy-left-space-history nil
  "ɽκ")

(defvar ewb-phy-cappos-alist
  '(
    ("cn" . "")
    ("rn" . "屦")
    ("ln" . "庸")
    ("cs" . "")
    ("ls" . "")
    ("rs" . "")
    ("ne" . "")
    ("e" . "")
    ("sw" . "")
    ("nw" . "")
    ("w" . "")
    ("se" . "")
    )
  "ForAll.phyΥץ֤assoc list")

(defvar ewb-phy-align-alist
  '(
    ("C" . "")
    ("R" . "")
    ("L" . "")
    )
  "ForAll.phy·assoc list")

(defun ewb-edit-phy ()
  "֤οɽȥꥬʪ°Խ/ɲä롣"
  (interactive)
  (let* (default
	 (file (buffer-name))
	 (file
	  (if (string-match "\@" file)
	      (substring file 0 (- (match-end 0) 1))
	    file))
	 (triger (ewb-current-figure-triger)))
    (if (null triger)
	(message "ɽȥꥬĤޤ")
      (progn
	(setq default (ewb-get-phy file triger))
	(if (null default)
	    (setq default (ewb-get-default-phy triger)))
	(ewb-write-phy file (ewb-make-phy-list default))))))

(defun ewb-view-figure ()
  "֤οɽȥꥬ˳Ƥ줿ɽɽ롣"
  (interactive)
  (let* (otype ofile osize sbuf default
	 (file (buffer-name))
	 (file
	  (if (string-match "\@" file)
	      (substring file 0 (- (match-end 0) 1))
	    file))
	 (dir (file-name-directory (buffer-file-name)))
	 (obuf (current-buffer))
	 (triger (ewb-current-figure-triger)))
    (progn
      (if (null triger)
	  (message "ɽȥꥬĤޤ")
	(progn
	  (setq olist (ewb-get-phy file triger))
	  (if (null olist)
	      (if (y-or-n-p
		   (concat
		    ewb-phy-file-name
		    "˻꤬ޤ󡣻ɲäޤ? "))
		  (progn
		    (setq default (ewb-get-default-phy triger))
		    (ewb-write-phy
		     file
		     (if (y-or-n-p
			  (format "%s ǤǤ? "
				  (ewb-makeout-phy default)))
			 default
		       (ewb-make-phy-list default)))
		    (set-buffer obuf)
		    (ewb-view-figure)))
	    (progn
	      (setq otype (nth 1 olist))
	      (setq ofile (nth 2 olist))
	      (setq osize (nth 3 olist))
	      (if (or (null ofile)
		      (string= ofile "-"))
		  (message "ե̾ꤵƤޤ")
		(progn
		  (cd dir)
		  (if (string= otype "i")
		      (find-file-other-window (expand-file-name ofile))
		    (if (string= otype "e")
			(if (file-readable-p ofile)
			    (progn
			      (setq sbuf (get-buffer ewb-output-buffer-name))
			      (start-process ewb-temp-process-name ewb-output-buffer-name
					     ewb-view-eps-command (expand-file-name ofile)))
			  (message (format "ե %s ɤޤ" ofile)))
		      (if (string= otype "l")
			  (message (format "ӤΤ %s " osize))))))))))))))

(defun ewb-get-phy (file triger)
  "ForAll.phy 鳺ȥꥬξ롣ȥꥬϡʲΥꥹȤ֤롣

ȥꥬ̾  ե̾  װ,פ  ·,,"
  (let* (file-name size cappos pos space ratio type
	 (sbuf (find-file-noselect ewb-phy-file-name))
	 (m (make-marker)))
    (progn
      (set-buffer sbuf)
      (goto-char (point-min))
      (if (re-search-forward
	   (concat
	    "^\# *\.\./"
	    file
	    )
	   nil t nil)
	  (progn
	    (beginning-of-line)
	    (set-marker m (point))
	    (if (re-search-forward "^\.\./" nil t nil)
		(beginning-of-line)
	      (goto-char (point-max)))
	    (narrow-to-region m (point))
	    (goto-char (point-min))
	    (if (re-search-forward
		 (concat
		  "^"
		  triger "\t+"		; ȥꥬ̾
		  "\\(.\\)\t+"		; 
		  "\\([^\t]+\\)\t+"	; Ĺ,ĤĹ or ɽꥹȤΥե̾
		  "\\([^\t]+\\)\t+"	; ·ȥץ
		  "\\([^\t]+\\)\t+"	; 
		  "\\([^\t]+\\)\t+"	; ץȤΤ,,
		  "\\([^\t]+\\)\t+"	; EPSե̾ or '-'
		  "\\([^\t]+\\)\t+"	; Ψ
		  ".*$"
		  )
		 nil t nil)
		(progn
		  (setq type (match-string 1))
		  (setq cappos (match-string 3))
		  (setq pos (match-string 4))
		  (setq space (match-string 5))
		  (if (or
		       (string= type "e")
		       (string= type "l"))
		      (progn
			(setq size (match-string 2))
			(setq ratio (match-string 7))
			(if (string= type "e")
			    (setq size
				  (if (string= ratio "0")
				      size
				    ratio)))
			(setq file-name
			      (if (string= type "e")
				  (match-string 6)
				"-")))
		    (progn
		      (setq size "-")
		      (setq file-name (match-string 2))))
		  (kill-buffer sbuf)
		  (list
		   triger
		   type
		   file-name
		   size
		   (concat
		    (substring cappos 1)
		    ","
		    (substring space 0 (string-match "\\," space)))
		   pos
		   (concat
		    (substring cappos 0 1)
		    (substring space (string-match "\\," space)))))
	      nil))
	nil))))

(defun ewb-current-figure-triger ()
  "֤ѤƤɽȥꥬ֤̾"
  (save-excursion
    (if (looking-at (concat
		     "\\(\\/\\|"
		     (ewb-make-figure-regexp-list-text (ewb-get-figure-from-triger-def))
		     "\\|[0-9]\\)"))
	(progn
	  (while (and
		  (looking-at (concat
			       "\\(\\/\\|"
			       (ewb-make-figure-regexp-list-text (ewb-get-figure-from-triger-def))
			       "\\|[0-9]\\)"))
		  (not (= (point) (point-min))))
	    (backward-char 1))
	  (forward-char 1)
	  (if (looking-at (concat
			   "//\\(\\("
			   (ewb-make-figure-regexp-list-text (ewb-get-figure-from-triger-def))
			   "\\)[0-9]+\\)"))
	      (match-string 1)
	    (ewb-current-line-figure-triger)))
      (ewb-current-line-figure-triger))))

(defun ewb-current-line-figure-triger ()
  "Ƭˤɽȥꥬ֤̾"
  (save-excursion
    (beginning-of-line)
    (if (looking-at "//[a-zA-Z]+[0-9]+[^0-9]")
	(progn
	  (re-search-forward "^//\\([a-zA-Z]+[0-9]+\\)[^0-9]" nil t nil)
	  (match-string 1))
      nil)))

(defun ewb-make-figure-regexp-list-text (clist)
  "ɽȥꥬΥꥹȤɽʸˤ֤"
  (let* ((num (- (length clist) 1))
	 (result ""))
    (progn
      (while (<= 0 num)
	(if (string= result "")
	    (setq result (nth 0 (nth num clist)))
	  (setq result 
		(concat
		 (nth 0 (nth num clist))
		 "\\|"
		 result)))
	(setq num (- num 1)))
       result)))

(defun ewb-make-phy-list (default-list)
  "ǥեȤȤưʲΥꥹȤꡢ桼䤤碌ʲΥꥹȤ֤

ȥꥬ̾  ե̾  װ,פ  ·,,"
  (let* ((triger (nth 0 default-list))
	 (type (ewb-read-phy-type triger (nth 1 default-list)))
	 (file-name (ewb-read-phy-file-name triger type (nth 2 default-list)))
	 (size (ewb-read-phy-size type (nth 3 default-list)))
	 (cappos
	  (ewb-read-phy-cappos
	   type
	   (if (null (nth 4 default-list))
	       nil
	     (substring
	      (nth 4 default-list)
	      0 (string-match "\\," (nth 4 default-list))))))
	 (capspace
	  (ewb-read-phy-capspace
	   (if (null (nth 4 default-list))
	       nil
	     (substring
	      (nth 4 default-list)
	      (+ (string-match "\\," (nth 4 default-list)) 1)))))
	 (pos (ewb-read-phy-pos (nth 5 default-list)))
	 (align
	  (ewb-read-phy-align
	   (if (null (nth 6 default-list))
	       nil
	     (substring
	      (nth 6 default-list)
	      0 (string-match "\\," (nth 6 default-list))))))
	 (space
	  (ewb-read-phy-space
	   (if (null (nth 6 default-list))
	       nil
	     (substring
	      (nth 6 default-list)
	      (+ (string-match "\\," (nth 6 default-list)) 1)))))
	 (result
	  (list
	   triger
	   type
	   file-name
	   size
	   (concat cappos "," capspace)
	   pos
	   (concat align "," space))))
    (if (y-or-n-p
	 (format "%s ǤǤ? "
		 (ewb-makeout-phy result)))
	result
      (ewb-make-phy-list result))))

(defun ewb-read-phy-type (triger default)
  "ɽΥפ䤤碌桼Ϥ֤"
  (let* ((default
	   (if (null default)
	       ewb-phy-type-default
	     default))
	 (type
	  (completing-read
	   (format "%s  e:EPSե l:ӤΤ i:ե : " triger)
	   '(("e" 1) ("l" 2) ("i" 3))
	   nil t
	   default)))
    (if (string= type "")
	default
      type)))

(defun ewb-read-phy-file-name (triger type default)
  "ե̾䤤碌桼Ϥ֤"
  (let* ((default
	   (if (null default)
	       (concat
		ewb-phy-directory-default
		triger
		".eps")
	     default))
	 (file-name
	  (if (string= type "l")
	      "-"
	    (read-file-name
	     "ե̾ : "
	     "" nil nil
	     default)))
	 (file-name
	  (if (string-match default-directory file-name)
	      (substring file-name (match-end 0))
	    file-name)))
    (if (string= file-name "")
	default
      file-name)))

(defun ewb-read-phy-size (type default)
  "䤤碌桼Ϥ֤"
  (if (string= type "i")
      "-"
    (let* ((default
	     (if (null default)
		 ewb-phy-size-default
	       default))
	   (size
	    (if (string= type "l")
		(concat
		 (completing-read
		  "Ĺ [ñ mm/cm/pt/H/W()] : "
		  '(lambda (str prec dummy)
		     (or
		      (string-match "^[1-9][0-9]*mm$" str)
		      (string-match "^[1-9][0-9]*cm$" str)
		      (string-match "^[1-9][0-9]*pt$" str)
		      (string-match "^[1-9][0-9]*H$" str)
		      (string-match "^[1-9][0-9]*W$" str)))
		  nil t
		  (if (not (string-match "\\," default))
		      nil
		    (substring default 0 (string-match "\\," default)))
		  ewb-phy-width-history)
		 ","
		 (completing-read
		  "ĤĹ [ñ mm/cm/pt/H/L()] : "
		  '(lambda (str prec dummy)
		     (or
		      (string-match "^[1-9][0-9]*mm$" str)
		      (string-match "^[1-9][0-9]*cm$" str)
		      (string-match "^[1-9][0-9]*pt$" str)
		      (string-match "^[1-9][0-9]*H$" str)
		      (string-match "^[1-9][0-9]*L$" str)))
		  nil t
		  (if (not (string-match "\\," default))
		      nil
		    (substring default (+ (string-match "\\," default) 1)))
		  ewb-phy-height-history))
	      (if (y-or-n-p
		   (if (string-match "\\," default)
		       (format "ȽĤĹ %s ǤǤ? " default)
		     (format "Ψ %s%s ǤǤ? " default "\%")))
		  default
		(if (y-or-n-p "Ψǻꤷޤ? ")
		    (completing-read
		     "Ψ [Τ / 0=] : "
		     '(lambda (str prec dummy)
			(string-match "^[0-9]+$" str))
		     nil t
		     (if (null default)
			 nil
		       (if (string-match "\\," default)
			   nil
			 default))
		     ewb-phy-ratio-history)
		  (concat
		   (completing-read
		    "Ĺ [ñ mm/cm/pt/H/W() / 0=] : "
		    '(lambda (str prec dummy)
		       (or
			(string-match "^[1-9][0-9]*mm$" str)
			(string-match "^[1-9][0-9]*cm$" str)
			(string-match "^[1-9][0-9]*pt$" str)
			(string-match "^[1-9][0-9]*H$" str)
			(string-match "^[1-9][0-9]*W$" str)
			(string-match "^0$" str)))
		    nil t
		    (if (not (string-match "\\," default))
			nil
		      (substring default 0 (string-match "\\," default)))
		    ewb-phy-width-history)
		   ","
		   (completing-read
		    "ĤĹ [ñ mm/cm/pt/H/L() / 0=] : "
		    '(lambda (str prec dummy)
		       (or
			(string-match "^[1-9][0-9]*mm$" str)
			(string-match "^[1-9][0-9]*cm$" str)
			(string-match "^[1-9][0-9]*pt$" str)
			(string-match "^[1-9][0-9]*H$" str)
			(string-match "^[1-9][0-9]*L$" str)
			(string-match "^0$" str)))
		    nil t
		    (if (not (string-match "\\," default))
			nil
		      (substring default (+ (string-match "\\," default) 1)))
		    ewb-phy-height-history)))))))
      (if (string-match "\\," size)
	  (concat
	   (if (string-match "^0$" (substring size 0 (string-match "\\," size)))
	       "0mm"
	     (if (string-match "^\\([0-9]+\\)W$" (substring size 0 (string-match "\\," size)))
		 (concat
		  (match-string 1 (substring size 0 (string-match "\\," size)))
		  "")
	       (if (string= "" (substring size 0 (string-match "\\," size)))
		   (substring default 0 (string-match "\\," default))
		 (substring size 0 (string-match "\\," size)))))
	   ","
	   (if (string-match "^0$" (substring size (+ (string-match "\\," size) 1)))
	       "0mm"
	     (if (string-match "^\\([0-9]+\\)L$" (substring size (+ (string-match "\\," size) 1)))
		 (concat
		  (match-string 1 (substring size (+ (string-match "\\," size) 1)))
		  "")
	       (if (string= "" (substring size (+ (string-match "\\," size) 1)))
		   (substring default (+ (string-match "\\," default) 1))
		 (substring size (+ (string-match "\\," size) 1))))))
	(if (string= "" size)
	    default
	  size)))))

(defun ewb-read-phy-cappos (type default)
  "ץ֤䤤碌桼Ϥ֤"
  (let* ((default
	    (if (null default)
		ewb-phy-cappos-default
	      default)))
    (if (y-or-n-p
	 (format "ץ %s ǤǤ? "
		 (cdr (assoc default ewb-phy-cappos-alist))))
	default
      (let* ((cappos-one
	      (if (string= type "i")
		  (completing-read
		   "ץ [n: s:] : "
		   '(("n" 1) ("s" 2))
		   nil t
		   (if (string-match "[ns]" default)
		       (match-string 0 default)
		     nil)
		   nil)
		(completing-read
		 "ץ [n: e: w: s:] : "
		 '(("n" 1) ("e" 2) ("w" 3) ("s" 4))
		 nil t
		 (if (string-match "[ew]" default)
		     (match-string 0 default)
		   (if (string-match "[ns]" default)
		       (match-string 0 default)
		     nil))
		 nil)))
	     (cappos-one
	      (if (string= cappos-one "")
		  (if (string-match "[ew]" default)
		      (match-string 0 default)
		    (if (string-match "[ns]" default)
			(match-string 0 default)))
		cappos-one))
	     (cappos-two
	      (if (string= cappos-one (or "n" "s"))
		  (completing-read
		   (format "ץ %s [l: c: r:] : "
			   (if (string= cappos-one "n")
			       ""
			     ""))
		   '(("l" 1) ("r" 2) ("c" 3))
		   nil t
		   (if (string-match "[lrc]" (substring (concat default " ") 1 2))
		       (match-string 0 (substring (concat default " ") 1 2))
		     nil)
		   nil)
		(completing-read
		 (format "ץ %s [n: m: s:] : "
			 (if (string= cappos-one "e")
			     ""
			   ""))
		 '(("n" 1) ("m" 2) ("s" 3))
		 nil t
		 (if (string-match "[ns]" (substring (concat default " ") 1 2))
		     (match-string 0 (substring (concat default " ") 1 2))
		   "m")
		 nil)))
	     (cappos-two
	      (if (string= cappos-two "")
		  (if (string= cappos-one (or "n" "s"))
		      (if (string-match "[lrc]" (substring (concat default " ") 1 2))
			  (match-string 0 default)
			"c")
		    (if (string-match "[ns]" (substring (concat default " ") 1 2))
			(match-string 0 default)
		      "m"))
		cappos-two))
	     (cappos
	      (concat cappos-two cappos-one)))
	(if (not (assoc cappos ewb-phy-cappos-alist))
	    default
	  (if (string= cappos "me")
	      "e"
	    (if (string= cappos "mw")
		"w"
	      cappos)))))))

(defun ewb-read-phy-capspace (default)
  "ɽȥץΤ䤤碌桼Ϥ֤"
  (let* ((default
	   (if (null default)
	       ewb-phy-capspace-default
	     default)))
    (completing-read
     "ץȤΤ [ñ mm/cm/pt/H ̵=ǥե] : "
     '(lambda (str prec dummy)
	(or
	 (string-match "^[1-9][0-9]*mm$" str)
	 (string-match "^[1-9][0-9]*cm$" str)
	 (string-match "^[1-9][0-9]*pt$" str)
	 (string-match "^[1-9][0-9]*H$" str)))
     nil t default ewb-phy-capspace-history)))

(defun ewb-read-phy-pos (default)
  "ɽ֤䤤碌桼Ϥ֤"
  (let* ((default
	   (if (null default)
	       ewb-phy-pos-default
	     default))
	 (pos
	  (completing-read
	   " [h: t: b: p:̥ڡ]ȹ礻 : "
	   '(lambda (str prec dummy)
	      (string-match "^[htbp]+$" str))
	   nil t default ewb-phy-pos-history)))
    (if (string= pos "")
	default
      pos)))

(defun ewb-read-phy-align (default)
  "ɽ·䤤碌桼Ϥ֤"
  (let* ((default
	   (if (null default)
	       ewb-phy-align-default
	     default))
	 (align
	  (completing-read
	   "· [L: C: R:] : "
	   '(lambda (str prec dummy)
	      (string-match "^[LCR]$" str))
	   nil t default nil)))
    (if (string= align "")
	default
      align)))

(defun ewb-read-phy-space (default)
  "Τ䤤碌桼Ϥ֤"
  (let* ((default
	   (if (null default)
	       ewb-phy-space-default
	     default))
	 (space
	  (if (y-or-n-p
	       (if (string= default ",")
		   "ȺΤ [̵] ǤǤ? "
		 (format "ȺΤ %s ǤǤ? " default)))
	      default
		(concat
		 (completing-read
		  "Τ [ñ mm/cm/pt/H/W()] : "
		  '(lambda (str prec dummy)
		     (or
		      (string-match "^[1-9][0-9]*mm$" str)
		      (string-match "^[1-9][0-9]*cm$" str)
		      (string-match "^[1-9][0-9]*pt$" str)
		      (string-match "^[1-9][0-9]*H$" str)
		      (string-match "^[1-9][0-9]*W$" str)))
		  nil t
		  (if (not (string-match "\\," default))
		      nil
		    (substring default 0 (string-match "\\," default)))
		  ewb-phy-right-space-history)
		 ","
		 (completing-read
		  "Τ [ñ mm/cm/pt/H/W()] : "
		  '(lambda (str prec dummy)
		     (or
		      (string-match "^[1-9][0-9]*mm$" str)
		      (string-match "^[1-9][0-9]*cm$" str)
		      (string-match "^[1-9][0-9]*pt$" str)
		      (string-match "^[1-9][0-9]*H$" str)
		      (string-match "^[1-9][0-9]*W$" str)))
		  nil t
		  (if (not (string-match "\\," default))
		      nil
		    (substring default (+ (string-match "\\," default) 1)))
		  ewb-phy-left-space-history)))))
    (concat
     (if (string-match "^\\([0-9]+\\)W$" (substring space 0 (string-match "\\," space)))
	 (concat
	  (match-string 1 (substring space 0 (string-match "\\," space)))
	  "")
       (if (string= "" (substring space 0 (string-match "\\," space)))
	   (substring default 0 (string-match "\\," default))
	 (substring space 0 (string-match "\\," space))))
     ","
     (if (string-match "^\\([0-9]+\\)W$" (substring space (+ (string-match "\\," space) 1)))
	 (concat
	  (match-string 1 (substring space (+ (string-match "\\," space) 1)))
	  "")
       (if (string= "" (substring space (+ (string-match "\\," space) 1)))
	   (substring default (+ (string-match "\\," default) 1))
	 (substring space (+ (string-match "\\," space) 1)))))))

(defun ewb-write-phy (file phy-list)
  "ե̾ȰʲΥꥹȤForAll.phy˽񤭹ࡣ

ȥꥬ̾  ե̾  װ,פ  ·,,"
  (let* ((sbuf (find-file-noselect ewb-phy-file-name))
	 (m (make-marker))
	 (triger (nth 0 phy-list))
	 (type (nth 1 phy-list))
	 (file-name (nth 2 phy-list))
	 (size (nth 3 phy-list))
	 (capspace
	  (substring (nth 4 phy-list) (+ (string-match "\\," (nth 4 phy-list)) 1)))
	 (cappos
	  (substring (nth 4 phy-list) 0 (string-match "\\," (nth 4 phy-list))))
	 (pos (nth 5 phy-list))
	 (space (substring (nth 6 phy-list) (+ (string-match "\\," (nth 6 phy-list)) 1)))
	 (align
	  (substring (nth 6 phy-list) 0 (string-match "\\," (nth 6 phy-list)))))
    (progn
      (set-buffer sbuf)
      (goto-char (point-min))
      (if (not (re-search-forward
	   (concat
	    "^\# *\.\./"
	    file
	    )
	   nil t nil))
	  (progn
	    (goto-char (point-max))
	    (insert
	     (concat
	      "\# \.\./"
	      file
	      "\n"
	      ))))
      (beginning-of-line)
      (set-marker m (point))
      (forward-line 1)
      (if (re-search-forward "^\# *\.\./" nil t nil)
	  (beginning-of-line)
	(goto-char (point-max)))
      (narrow-to-region m (point))
      (goto-char (point-min))
      (if (re-search-forward
	   (concat
	    "^"
	    triger "\t+"	; ȥꥬ̾
	    ".\t+"		; 
	    "[^\t]+\t+"		; Ĺ,ĤĹ or ɽꥹȤΥե̾
	    "[^\t]+\t+"		; ·ȥץ
	    "[^\t]+\t+"		; 
	    "[^\t]+\t+"		; ץȤΤ,,
	    "[^\t]+\t+"		; EPSե̾ or '-'
	    "[^\t]+\t+"		; Ψ
	    ".*$"
	    )
	   nil t nil)
	  (progn
	    (beginning-of-line)
	    (kill-line))
	(progn
	  (goto-char (point-max))
	  (open-line 1)))
      ;; ν񤭹
      (if (string= type "i")
	  (insert (format "%s\t%s\t%s\t%s,%s\t%s\t%s,%s\t-\t0\t-"
			  triger type file-name align cappos pos capspace space))
	(if (string= type "e")
	    (if (string-match "\\," size)
		(insert (format "%s\t%s\t%s\t%s%s\t%s\t%s,%s\t%s\t0\t-"
				triger type size align cappos pos capspace space file-name))
	      (insert (format "%s\t%s\t0mm,0mm\t%s%s\t%s\t%s,%s\t%s\t%s\t-"
			      triger type align cappos pos capspace space file-name size)))
	  (insert (format "%s\t%s\t%s\t%s%s\t%s\t%s,%s\t-\t0\t-"
			  triger type size align cappos pos capspace space))))
      (save-buffer)
      (kill-buffer sbuf)
      )))

(defun ewb-makeout-phy (phy-list)
  "ʲΥꥹȤʬ䤹ʸ֤

ȥꥬ̾  ե̾  װ,פ  ·,,"
  (let* ((triger (nth 0 phy-list))
	 (type (nth 1 phy-list))
	 (file-name
	  (if (and (string= (nth 2 phy-list) "-")
		   (string= type "l"))
	      "ӤΤ"
	    (nth 2 phy-list)))
	 (size
	  (if (string-match "\\," (nth 3 phy-list))
	      (nth 3 phy-list)
	    (concat
	     (nth 3 phy-list)
	     "%")))
	 (capspace
	  (substring (nth 4 phy-list) (+ (string-match "\\," (nth 4 phy-list)) 1)))
	 (cappos
	  (cdr (assoc
		(substring (nth 4 phy-list) 0 (string-match "\\," (nth 4 phy-list)))
		ewb-phy-cappos-alist)))
	 (pos (nth 5 phy-list))
	 (space (substring (nth 6 phy-list) (+ (string-match "\\," (nth 6 phy-list)) 1)))
	 (align
	  (cdr (assoc
		(substring (nth 6 phy-list) 0 (string-match "\\," (nth 6 phy-list)))
		ewb-phy-align-alist))))
    (progn
      (setq capspace
	    (if (string= capspace "")
		"-"
	      (concat
	       capspace
	       "")))
      (if (string= type "i")
	  (format "%s %s ·:%s,%s :%s,%s"
		  file-name pos align space cappos capspace)
	(format "%s %s %s ·:%s,%s :%s,%s"
		file-name size pos align space cappos capspace)))))

(defun ewb-get-default-phy (triger)
  "ForAll.phy ȥꥬ̾˳ǥեȤͤʲΥꥹȤ֤

ȥꥬ̾  ե̾  װ,פ  ·,,

ǥեȤͤϡForAll.phy κǽ˻ꤵ줿ƱפΥȥꥬ̾롣"
  (let* (file-name size cappos pos space ratio
	 (result
	  (list
	   triger
	   ewb-phy-type-default
	   (concat
	    ewb-phy-directory-default
	    triger
	    ".eps")
	   ewb-phy-size-default
	   (concat
	    ewb-phy-cappos-default
	    ","
	    ewb-phy-capspace-default)
	   ewb-phy-pos-default
	   (concat
	    ewb-phy-align-default
	    ","
	    ewb-phy-space-default)))
	 (sbuf (find-file-noselect ewb-phy-file-name))
	 (type
	  (progn
	    (string-match
	     (concat "\\("
		     (ewb-make-figure-regexp-list-text (ewb-get-figure-from-triger-def))
		     "\\)")
	     triger)
	    (match-string 0 triger))))
    (progn
      (set-buffer sbuf)
      (goto-char (point-min))
      (if (re-search-forward
	   (concat
	    "^"
	    type "[0-9]+\t+"		; ȥꥬ̾
	    "\\(.\\)\t+"		; 
	    "\\([^\t]+\\)\t+"		; Ĺ,ĤĹ or ɽꥹȤΥե̾
	    "\\([^\t]+\\)\t+"		; ·ȥץ
	    "\\([^\t]+\\)\t+"		; 
	    "\\([^\t]+\\)\t+"		; ץȤΤ,,
	    "\\([^\t]+\\)\t+"		; EPSե̾ or '-'
	    "\\([^\t]+\\)\t+"		; Ψ
	    ".*$"
	    )
	   nil t nil)
	  (progn
	    (setq type (match-string 1))
	    (setq cappos (match-string 3))
	    (setq pos (match-string 4))
	    (setq space (match-string 5))
	    (if (or
		 (string= type "e")
		 (string= type "l"))
		(progn
		  (setq size (match-string 2))
		  (setq ratio (match-string 7))
		  (if (string= type "e")
		      (setq size
			    (if (string= ratio "0")
				size
			      ratio)))
		  (setq file-name
			(if (string= type "e")
			    (match-string 6)
			  "-")))
	      (progn
		(setq size "-")
		(setq file-name (match-string 2))))
	    (if (not (string= type "l"))
		(setq file-name (concat
				(file-name-directory file-name)
				triger
				(if (file-name-extension file-name)
				    (concat
				     "."
				     (file-name-extension file-name))))))
	    (setq result
		  (list
		   triger
		   type
		   file-name
		   size
		   (concat
		    (substring cappos 1)
		    ","
		    (substring space 0 (string-match "\\," space)))
		   pos
		   (concat
		    (substring cappos 0 1)
		    (substring space (string-match "\\," space)))))))
      (kill-buffer sbuf)
      result)))

(provide 'ewb-phy)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; ewb-phy.el ends here
