;;; novice-menubar.el --- Menubar and popup-menu support for novice user.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(require 'novice-search)
(require 'gnuserv)

(or (boundp 'running-xemacs)
    (defvar running-xemacs (string-match "XEmacs\\|Lucid" emacs-version)))

(or (fboundp 'emacs-version>=)
    (defun emacs-version>= (major &optional minor patch)
      "Return true if the Emacs version is >= to the given MAJOR, MINOR,
   and PATCH numbers.
The MAJOR version number argument is required, but the other arguments
argument are optional. Only the Non-nil arguments are used in the test."
      (let ((emacs-patch (or emacs-patch-level emacs-beta-version -1)))
	(cond ((> emacs-major-version major))
	      ((< emacs-major-version major) nil)
	      ((null minor))
	      ((> emacs-minor-version minor))
	      ((< emacs-minor-version minor) nil)
	      ((null patch))
	      ((>= emacs-patch patch))))))

;;; for 21.4 and later
(cond ((and running-xemacs
	    (emacs-version>= 21 4))
       (defmacro purecopy-menubar (var)
	 var)
       ))

;; kill-emacs hack
; 1st version
;(defun gnuserv-kill-emacs-query-function ()
;  (if (not (null gnuserv-clients))
;      (if (gnuserv-buffer-p (current-buffer))
;	  (gnuserv-edit)
;	(message "\"Done\"Υ˥塼νФ븵ΥХåեǤ")
;	nil)
;    t))
;
; 2nd version
; ưǸХåե˰ưƽλ褦ѹ
(defun gnuserv-kill-emacs-query-function ()
  (if (not (null gnuserv-clients))
      (if (gnuserv-buffer-p (current-buffer))
	  (gnuserv-edit)
	(progn
	  (set-buffer (gnuserv-next-buffer))
	  (gnuserv-edit)))
    t))


;;; Warning-free compile
(eval-when-compile
  (defvar language-environment-list)
  (require 'pending-del))

(defconst novice-default-menubar
  (purecopy-menubar
   ;; note backquote.
   `(
     ("File"
;      :filter file-menu-filter
      ["Open..."		find-file		t]
;      ["Open in Other Window..." find-file-other-window	t]
;      ["Open in New Frame..."	find-file-other-frame	t]
      ["Insert File..." 	insert-file		t]
;      ["View File..."		view-file		t]
      "------"
      ["Save"			save-buffer		t  nil]
      ["Save As..."		write-file		t]
;      ["Save Some Buffers"	save-some-buffers	t]
      "-----"
;      ["Print Buffer"		lpr-buffer		t  nil]
;      ["Pretty-Print Buffer"	ps-print-buffer-with-faces t  nil]
;      "-----"
;      ["New Frame"		make-frame		t]
;      ["Frame on Other Display..."
;				make-frame-on-display	t]
;      ["Delete Frame"		delete-frame		t]
;      "-----"
      ["Split Window"		split-window-vertically t]
      ["Un-Split (Keep This)"	delete-other-windows	(not (one-window-p t))]
      ["Un-Split (Keep Others)"	delete-window		(not (one-window-p t))]
      "-----"
      ["Revert Buffer"		revert-buffer		 t  nil]
      ["Delete Buffer"		kill-this-buffer	 t  nil]
      "-----"
      ["Exit XEmacs"		save-buffers-kill-emacs	t]
      )

     ("Edit"
;      :filter edit-menu-filter
      ["Undo"			advertised-undo		   t]
      ["Cut"			x-kill-primary-selection   t]
      ["Copy"			x-copy-primary-selection   t]
      ["Paste"			x-yank-clipboard-selection t]
      ["Clear"			x-delete-primary-selection t]
      "----"
      ["Search..."		novice-search		t]
      ["Search Next Forward..."	novice-search-repeat-forward	t]
      ["Search Next Backward..."	novice-search-repeat-backward	t]
      "----"
      ["Incremental Search..."		isearch-forward		t]
      ["Incremental Search Backward..."	isearch-backward	t]
      ["Replace..."		query-replace		t]
      "----"
      ["Incremental Search (Regexp)..."	isearch-forward-regexp	t]
      ["Incremental Search Backward (Regexp)..." isearch-backward-regexp t]
      ["Replace (Regexp)..."	query-replace-regexp	t]
      "----"
      ("Bookmarks"
       ("Jump to bookmark"
	:filter bookmark-menu-filter)
       ["Set bookmark"  	bookmark-set		t]
       "---"
       ["Insert contents"  	bookmark-menu-insert	t]
       ["Insert location"  	bookmark-menu-locate	t]
       "---"
       ["Rename bookmark"  	bookmark-menu-rename	t]
       ("Delete bookmark"
  	:filter bookmark-delete-filter)
       ["Edit Bookmark List"    bookmark-bmenu-list	t]
       "---"
       ["Save bookmarks"        bookmark-save		t]
       ["Save bookmarks as..."  bookmark-write		t]
       ["Load a bookmark file"  bookmark-load		t])
      "----"
      ["Goto Line..."		goto-line		t]
      ["What Line"		what-line		t]
      "----"
      ["Start Macro Recording"	start-kbd-macro	      (not defining-kbd-macro)]
      ["End Macro Recording"	end-kbd-macro		defining-kbd-macro]
      ["Execute Last Macro"	call-last-kbd-macro	last-kbd-macro]
;      "----"
;      ["Show Message Log"	show-message-log	t]
      )
     
     ("Buffers"
      :filter buffers-menu-filter
      ["List All Buffers" list-buffers t]
      "--"
      )

     nil		; the partition: menus after this are flushright

     ("Help"
      ["EWB mode Help" toolbar-ewb-info t]
     )
     )))

(set-menubar novice-default-menubar)


(provide 'novice-menubar)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; novice-menubar.el ends here.
