##
## DOCSTRIP ʸδĶҤĴ٤ perl ץ
##
use FileHandle;
exit(main());

#------------------------------------------------------------
# routines
#
sub main {
  if (@ARGV) {
    for (@ARGV) {
      dstcheck($_);
    }
  }
  else {
    usage();
  }
}

sub usage {
  my ($basename) = $0;
  $basename =~ s!.*/!!;
  print<<EOF

  usage: perl $basename dtx_filenames...

EOF
}

sub dstcheck {
  my ($fname) = @_;
  my ($fh) = new FileHandle "< $fname";
  unless (defined $fh) {
    print STDERR "Cannot open $fname\n";
    return -1;
  }
  else {
    my (@dst, @env, $linenum, $conditions, $environment);
    push(@dst,"DUMMY"); push(@dst,"000");
    push(@env,"DUMMY"); push(@env,"000");
    while (<$fh>) {
      if (/^%<\*([^>]+)>/) { # check conditions
        push(@dst,$1);
        push(@dst,$.);
      } elsif (/^%<\/([^>]+)>/) {
        $linenum = pop(@dst);
        $conditions = pop(@dst);
        if ($1 ne $conditions) {
          if ($conditions eq "DUMMY") {
            print "$fname: `</$1>' (l.$.) is not started.\n";
            push(@dst,"DUMMY");
            push(@dst,"000");
          } else {
            print "$fname: `<*$conditions>' (l.$linenum) is ended ";
            print "by `<*$1>' (l.$.)\n";
          }
        }
      }
      if (/^% *\\begin\{verbatim\}/) { # check environments
        while(<$fh>) {
            last if (/^% *\\end\{verbatim\}/);
        }
      } elsif (/^% *\\begin\{([^{}]+)\}\{(.*)\}/) {
        push(@env,$1);
        push(@env,$.);
      } elsif (/^% *\\begin\{([^{}]+)\}/) {
        push(@env,$1);
        push(@env,$.);
      } elsif (/^% *\\end\{([^{}]+)\}/) {
        $linenum = pop(@env);
        $environment = pop(@env);
        if ($1 ne $environment) {
          if ($environment eq "DUMMY") {
            print "$fname: `\\end{$1}' (l.$.) is not started.\n";
            push(@env,"DUMMY");
            push(@env,"000");
          } else {
            print "$fname: \\begin{$environement} (l.$linenum) is ended ";
            print "by \\end{$1} (l.$.)\n";
          }
        }
      }
    }
    $linenum = pop(@dst);
    $conditions = pop(@dst);
    while ($conditions ne "DUMMY") {
        print "$fname: `<*$conditions>' (l.$linenum) is not ended.\n";
        $linenum = pop(@dst);
        $conditions = pop(@dst);
    }
    $linenum = pop(@env);
    $environment = pop(@env);
    while ($environment ne "DUMMY") {
        print "$fname: `\\begin{$environment}' (l.$linenum) is not ended.\n";
        $linenum = pop(@env);
        $environment = pop(@env);
    }
    undef $fh;
  }
  return 0;
}
##  
## 
##  End of file `dstcheck.pl'.
