/***************************************************************************
 *   Copyright (C) 2003 by Gav Wood                                        *
 *   gav@cs.york.ac.uk                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 ***************************************************************************/

#define __GEDDEI_BUILD

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <cmath>
using namespace std;

#include <qfile.h>
#include "qfactoryexporter.h"

#include "geddei.h"
using namespace Geddei;

#include "signaltypes.h"
using namespace SignalTypes;

class Dumper: public Processor
{
	QFile theOut;
	
	virtual void initFromProperties(const Properties &p);
	virtual const bool verifyAndSpecifyTypes(const SignalTypeRefs &, SignalTypeRefs &);
	virtual void processor();
	virtual void processorStopped();
	
public:
	Dumper();
};

Dumper::Dumper(): Processor("Dumper", In, Guarded)
{
}

void Dumper::initFromProperties(const Properties &p)
{
	theOut.setName(p["Output"].toString());
	setupIO(Undefined, 0);
}

const bool Dumper::verifyAndSpecifyTypes(const SignalTypeRefs &, SignalTypeRefs &)
{
	return true;
}

void Dumper::processor()
{
	theOut.open(IO_Truncate|IO_WriteOnly);
	while(thereIsInputForProcessing(1))
		for(uint i = 0; i < numInputs(); i++)
			theOut.putch(int(input(i).readSample()[0] * 255));
}

void Dumper::processorStopped()
{
	theOut.close();
}

EXPORT_CLASS(Dumper, 0,1,0, Processor);
