/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright  CNRS, INRIA, Universit Bordeaux 1
 * See COPYING in top-level directory.
 */

#ifndef __STDIO_EV_CODES_H__
#define __STDIO_EV_CODES_H__

#include "ev_codes.h"


#define STDIO_EVENTS_ID 0x03
#define STDIO_PREFIX    (STDIO_EVENTS_ID << NB_BITS_EVENTS)

#define FUT_STDIO_READ_START      (STDIO_PREFIX | 0X0110)
#define FUT_STDIO_PREAD_START     (STDIO_PREFIX | 0X0120)
#define FUT_STDIO_READV_START     (STDIO_PREFIX | 0X0130)
#define FUT_STDIO_FREAD_START     (STDIO_PREFIX | 0X0140)

#define FUT_STDIO_WRITE_START     (STDIO_PREFIX | 0X0210)
#define FUT_STDIO_PWRITE_START    (STDIO_PREFIX | 0X0220)
#define FUT_STDIO_WRITEV_START    (STDIO_PREFIX | 0X0230)
#define FUT_STDIO_FWRITE_START    (STDIO_PREFIX | 0X0240)

#define FUT_STDIO_SELECT_START    (STDIO_PREFIX | 0X0310)
#define FUT_STDIO_PSELECT_START   (STDIO_PREFIX | 0X0320)
#define FUT_STDIO_LSEEK_START     (STDIO_PREFIX | 0X0330)
#define FUT_STDIO_POLL_START      (STDIO_PREFIX | 0X0340)
#define FUT_STDIO_PPOLL_START     (STDIO_PREFIX | 0X0350)


#define FUT_STDIO_READ_STOP      (STDIO_PREFIX | 0X0111)
#define FUT_STDIO_PREAD_STOP     (STDIO_PREFIX | 0X0121)
#define FUT_STDIO_READV_STOP     (STDIO_PREFIX | 0X0131)
#define FUT_STDIO_FREAD_STOP     (STDIO_PREFIX | 0X0141)

#define FUT_STDIO_WRITE_STOP     (STDIO_PREFIX | 0X0211)
#define FUT_STDIO_PWRITE_STOP    (STDIO_PREFIX | 0X0221)
#define FUT_STDIO_WRITEV_STOP    (STDIO_PREFIX | 0X0231)
#define FUT_STDIO_FWRITE_STOP    (STDIO_PREFIX | 0X0241)

#define FUT_STDIO_SELECT_STOP    (STDIO_PREFIX | 0X0311)
#define FUT_STDIO_PSELECT_STOP   (STDIO_PREFIX | 0X0321)
#define FUT_STDIO_LSEEK_STOP     (STDIO_PREFIX | 0X0331)
#define FUT_STDIO_POLL_STOP      (STDIO_PREFIX | 0X0341)
#define FUT_STDIO_PPOLL_STOP     (STDIO_PREFIX | 0X0351)


#endif	/* __STDIO_EV_CODES_H__ */
