/***************************************************************************
                          FLFormSearchDB.cpp  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLFormSearchDB.h"
#include "FLSqlCursor.h"
#include "FLReceiver.h"

static const char * button_ok_xpm[] = {
"32 32 132 2",
"  	c None",
". 	c #18AD00",
"+ 	c #1AB000",
"@ 	c #08A400",
"# 	c #0AA700",
"$ 	c #0C9100",
"% 	c #00A100",
"& 	c #009A00",
"* 	c #009E00",
"= 	c #007500",
"- 	c #009B00",
"; 	c #009C00",
"> 	c #008E00",
", 	c #009900",
"' 	c #0BA20B",
") 	c #006D00",
"! 	c #009100",
"~ 	c #009800",
"{ 	c #008900",
"] 	c #009500",
"^ 	c #12A512",
"/ 	c #56D256",
"( 	c #1FAB1F",
"_ 	c #009600",
": 	c #005F00",
"< 	c #009400",
"[ 	c #3EC93E",
"} 	c #008600",
"| 	c #0FA10F",
"1 	c #4CD74C",
"2 	c #78F878",
"3 	c #1AA71A",
"4 	c #008F00",
"5 	c #3DD53D",
"6 	c #3AD63A",
"7 	c #008200",
"8 	c #008C00",
"9 	c #059605",
"0 	c #2DC82D",
"a 	c #60FF60",
"b 	c #50EA50",
"c 	c #0E9D0E",
"d 	c #15AF15",
"e 	c #41FF41",
"f 	c #26D426",
"g 	c #008B00",
"h 	c #007E00",
"i 	c #039203",
"j 	c #1DC51D",
"k 	c #3CF83C",
"l 	c #37E937",
"m 	c #059205",
"n 	c #038E03",
"o 	c #22FF22",
"p 	c #13D213",
"q 	c #008700",
"r 	c #007A00",
"s 	c #008500",
"t 	c #018E01",
"u 	c #0EC30E",
"v 	c #1FF81F",
"w 	c #1DE81D",
"x 	c #007F00",
"y 	c #008300",
"z 	c #04E004",
"A 	c #05FF05",
"B 	c #02D002",
"C 	c #007600",
"D 	c #008100",
"E 	c #008A00",
"F 	c #00C100",
"G 	c #04F704",
"H 	c #05D005",
"I 	c #007B00",
"J 	c #007D00",
"K 	c #00B400",
"L 	c #00FA00",
"M 	c #00CB00",
"N 	c #007200",
"O 	c #00BB00",
"P 	c #00F200",
"Q 	c #006B00",
"R 	c #007400",
"S 	c #009000",
"T 	c #00F400",
"U 	c #00C600",
"V 	c #00A700",
"W 	c #00E400",
"X 	c #006800",
"Y 	c #00DF00",
"Z 	c #00EE00",
"` 	c #00D700",
" .	c #00DE00",
"..	c #00A300",
"+.	c #006400",
"@.	c #007100",
"#.	c #00E800",
"$.	c #009D00",
"%.	c #004D00",
"&.	c #006900",
"*.	c #00E100",
"=.	c #00DA00",
"-.	c #004A00",
";.	c #007000",
">.	c #00DB00",
",.	c #00D400",
"'.	c #004700",
").	c #00B200",
"!.	c #00D500",
"~.	c #00CE00",
"{.	c #007900",
"].	c #006200",
"^.	c #00CF00",
"/.	c #005E00",
"(.	c #005800",
"_.	c #006A00",
":.	c #00C900",
"<.	c #00B500",
"[.	c #006300",
"}.	c #005B00",
"|.	c #00B600",
"1.	c #00C300",
"2.	c #00B000",
"3.	c #005500",
"4.	c #009200",
"5.	c #00BD00",
"6.	c #009F00",
"7.	c #006100",
"8.	c #005700",
"9.	c #007800",
"0.	c #005300",
"a.	c #004F00",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                            . + ",
"                                                        @ # # $ ",
"% &                                                 * % % % =   ",
"- ; >                                           , ; ' ; ; )     ",
"! ~ ~ {                                     ] ~ ^ / ( _ :       ",
"  < [ < }                               ! < | 1 2 3 !           ",
"  4 5 6 4 7                         8 4 9 0 a b c 8             ",
"  } d e f g h                   { g i j k e l m 7               ",
"    n o o p q r             s s t u v o o w n x                 ",
"    y z A A B y C       D D E F G A A A H y I                   ",
"    J K L L L M h N = J h O P L L L L M h Q                     ",
"    R S T T T T U r r V W T T T T T U r X                       ",
"      C Y Z Z Z Z `  .Z Z Z Z Z Z ..C +.                        ",
"      @.O #.#.#.#.#.#.#.#.#.#.#.$.@.%.                          ",
"      &.! *.*.*.*.*.*.*.*.*.=.~ ) -.                            ",
"        ;.>.>.>.>.>.>.>.>.,.h &.'.                              ",
"        +.).!.!.!.!.!.!.~.{.].                                  ",
"        : S ^.^.^.^.^.F = /.                                    ",
"        (._.:.:.:.:.<.[.(.                                      ",
"          }.|.1.1.2.].3.                                        ",
"          }.4.5.6.7.3.                                          ",
"          8.9.] }.0.                                            ",
"            }.}.%.                                              ",
"            }.a.                                                ",
"                                                                ",
"                                                                ",
"                                                                ",
"                                                                "};

static const char * button_cancel_xpm[] = {
"32 32 231 2",
"  	c None",
". 	c #A62212",
"+ 	c #B03B2A",
"@ 	c #C36D57",
"# 	c #CC866D",
"$ 	c #CC856C",
"% 	c #CA836A",
"& 	c #CA8269",
"* 	c #CA8168",
"= 	c #C98165",
"- 	c #C97F64",
"; 	c #C97F63",
"> 	c #C87E61",
", 	c #C87D60",
"' 	c #C77C5F",
") 	c #C77B5D",
"! 	c #C6795C",
"~ 	c #C6785A",
"{ 	c #C57759",
"] 	c #C57657",
"^ 	c #C47556",
"/ 	c #C47455",
"( 	c #BC5F43",
"_ 	c #AE3622",
": 	c #C36E58",
"< 	c #D9A98D",
"[ 	c #D2977B",
"} 	c #CD8869",
"| 	c #C87E5E",
"1 	c #C87E5D",
"2 	c #C87F5E",
"3 	c #C87F5D",
"4 	c #C97F5D",
"5 	c #C8805C",
"6 	c #C9805C",
"7 	c #C9815C",
"8 	c #C8815C",
"9 	c #C9855F",
"0 	c #CC8962",
"a 	c #CC8B65",
"b 	c #BB5D40",
"c 	c #D7A488",
"d 	c #C06848",
"e 	c #B95530",
"f 	c #BA5632",
"g 	c #BA5834",
"h 	c #BB5A36",
"i 	c #BB5D37",
"j 	c #BC5F39",
"k 	c #BD603A",
"l 	c #BD623B",
"m 	c #BE633E",
"n 	c #BE653F",
"o 	c #BF6740",
"p 	c #C06942",
"q 	c #C06B44",
"r 	c #C26D45",
"s 	c #C26E48",
"t 	c #C27149",
"u 	c #C4734B",
"v 	c #C4744D",
"w 	c #C4754E",
"x 	c #C57750",
"y 	c #C77E57",
"z 	c #CA8861",
"A 	c #BB5A3F",
"B 	c #C57952",
"C 	c #C67C54",
"D 	c #C87F58",
"E 	c #C8835D",
"F 	c #AC3420",
"G 	c #C97B58",
"H 	c #E5B39E",
"I 	c #F7D5C7",
"J 	c #FFECE3",
"K 	c #FFEDE3",
"L 	c #F2CDBC",
"M 	c #E2AF95",
"N 	c #C77B56",
"O 	c #C77D56",
"P 	c #C77F58",
"Q 	c #C8815A",
"R 	c #B9573A",
"S 	c #CE8364",
"T 	c #FFEBE2",
"U 	c #FFFFFF",
"V 	c #F9DACC",
"W 	c #C9805A",
"X 	c #C88059",
"Y 	c #BE6745",
"Z 	c #DFA68D",
"` 	c #D49777",
" .	c #C8825C",
"..	c #BD6443",
"+.	c #FFFFFD",
"@.	c #EDC2AF",
"#.	c #D28D6D",
"$.	c #D99C7F",
"%.	c #F9DBCC",
"&.	c #D79B7B",
"*.	c #C9855E",
"=.	c #C78058",
"-.	c #BD6241",
";.	c #D48F73",
">.	c #F7D7C8",
",.	c #C67652",
"'.	c #D89A7D",
").	c #D39172",
"!.	c #CF8B69",
"~.	c #FFFAF3",
"{.	c #CD8A65",
"].	c #CA8760",
"^.	c #BC6040",
"/.	c #FFF6EF",
"(.	c #E2AF96",
"_.	c #CF8A68",
":.	c #CC8660",
"<.	c #FFFBF3",
"[.	c #F0CEBA",
"}.	c #BC5F3E",
"|.	c #D49174",
"1.	c #EEC5B1",
"2.	c #DAA082",
"3.	c #D79C7C",
"4.	c #CF906B",
"5.	c #CA8963",
"6.	c #BB5D3B",
"7.	c #F1C9B9",
"8.	c #E2AC94",
"9.	c #EEC6B2",
"0.	c #DAA183",
"a.	c #FADFD1",
"b.	c #E3B59B",
"c.	c #C77E58",
"d.	c #BB5C3A",
"e.	c #FFECE2",
"f.	c #C77853",
"g.	c #EEC6B3",
"h.	c #DBA286",
"i.	c #E2B297",
"j.	c #F1D1BE",
"k.	c #CD8D69",
"l.	c #C77F59",
"m.	c #BA5938",
"n.	c #EEC7B4",
"o.	c #DBA587",
"p.	c #DDAA8D",
"q.	c #F2D2BF",
"r.	c #CE916C",
"s.	c #C87F59",
"t.	c #BA5736",
"u.	c #EFC8B5",
"v.	c #DBA588",
"w.	c #DEAB8F",
"x.	c #F2D3C0",
"y.	c #CF936F",
"z.	c #C87E59",
"A.	c #B95535",
"B.	c #C87D58",
"C.	c #EFC9B5",
"D.	c #DCA78A",
"E.	c #E3B59C",
"F.	c #F3D4C3",
"G.	c #D19573",
"H.	c #C87E5A",
"I.	c #B95432",
"J.	c #F8D9C9",
"K.	c #E4B29A",
"L.	c #EFCAB6",
"M.	c #DCA88B",
"N.	c #FBE3D4",
"O.	c #E6BDA5",
"P.	c #D29976",
"Q.	c #C87F5A",
"R.	c #B85231",
"S.	c #DDA58A",
"T.	c #F0CCB8",
"U.	c #DDA98C",
"V.	c #D59D7C",
"W.	c #D59E7D",
"X.	c #D39B79",
"Y.	c #C87F5C",
"Z.	c #B85030",
"`.	c #F9DCCE",
" +	c #EBC3AC",
".+	c #D9A182",
"++	c #D19471",
"@+	c #FFFDF7",
"#+	c #FDE7DA",
"$+	c #D49D7D",
"%+	c #B64E2E",
"&+	c #D99E81",
"*+	c #F5D4C3",
"=+	c #E2B399",
"-+	c #D7A080",
";+	c #D59F80",
">+	c #B54C2D",
",+	c #E6BAA2",
"'+	c #D39675",
")+	c #D9A485",
"!+	c #F2D1BE",
"~+	c #DFB195",
"{+	c #D5A183",
"]+	c #B54A2B",
"^+	c #F0CAB8",
"/+	c #E4B99F",
"(+	c #D7A487",
"_+	c #C97E5E",
":+	c #B4482A",
"<+	c #DCA789",
"[+	c #FFF2E9",
"}+	c #DBA88B",
"|+	c #D8A78B",
"1+	c #C57353",
"2+	c #B34529",
"3+	c #F1D0BD",
"4+	c #FFF5EB",
"5+	c #FFF6EC",
"6+	c #FFF6ED",
"7+	c #FFEEE3",
"8+	c #EFCEBA",
"9+	c #DAA688",
"0+	c #D9A98F",
"a+	c #BE6241",
"b+	c #B03B22",
"c+	c #C77E56",
"d+	c #D19478",
"e+	c #B84F2D",
"f+	c #A92B17",
"g+	c #BA5534",
"h+	c #B03A21",
"                                                                ",
"          . . . . . . . . . . . . . . . . . . . . . .           ",
"      . . + @ # $ % & * = - ; > , ' ) ! ~ { ] ^ / ( _ . .       ",
"    . . : < [ } | 1 2 3 4 4 4 4 5 5 6 6 7 8 8 8 9 0 a b . .     ",
"    . : c d e f g h i j k l m n o p q r s t u v w x y z A .     ",
"  . + < d e f g h i j k l m n o p q r s t u v w x B C D E F .   ",
"  . @ [ e f g h i j k l G H I J K L M N u v w x B C O P Q R .   ",
"  . # } f g h i j k S T U U U U U U U U V W x B C O P X X Y .   ",
"  . $ | g h i j k Z U U U U U U U U U U U U ` C O P X  .X ...   ",
"  . % 1 h i j k Z U U U +.@.#.s t $.%.U U U U &.P X  .*.=.-..   ",
"  . & 2 i j k ;.U U U >.,.r s '.).v w !.~.U U U {. .*.].P ^..   ",
"  . * 3 j k l /.U U >.q r s (.U U _.x B :.<.U U [.*.].z P }..   ",
"  . = 4 k l |.U U +.q r s t 1.U U 2.B C O 3.U U U 4.z 5.P 6..   ",
"  . - 4 l m 7.U U 8.r s t u 9.U U 0.C O P X a.U U b.5.a c.d..   ",
"  . ; 4 m n e.U U f.s t u v g.U U h.O P X  .i.U U j.a k.l.m..   ",
"  . > 4 n o U U U s t u v w n.U U o.P X  .*.p.U U q.k.r.s.t..   ",
"  . , 5 o p U U U t u v w x u.U U v.X  .*.].w.U U x.r.y.z.A..   ",
"  . ' 5 p q K U U B.v w x B C.U U D. .*.].z E.U U F.y.G.H.I..   ",
"  . ) 6 q r J.U U K.w x B C L.U U M.*.].z 5.N.U U O.G.P.Q.R..   ",
"  . ! 6 r s S.U U U x B C O T.U U U.].z 5.V.U U U W.P.X.Y.Z..   ",
"  . ~ 7 s t u U U U `.C O P  +U U .+z 5.++@+U U #+P.X.$+Y.%+.   ",
"  . { 8 t u v &+U U U *+P X  .=+.+z 5.++@+U U U -+X.$+;+1 >+.   ",
"  . ] 8 u v w x u.U U U U ,+'+].z )+!+U U U U ~+X.$+;+{+1 ]+.   ",
"  . ^ 8 v w x B C ^+U U U U U U U U U U U U /+X.$+;+{+(+_+:+.   ",
"  . / 9 w x B C O P <+[+U U U U U U U U #+}+X.$+;+{+(+|+1+2+.   ",
"  . ( 0 x B C O P X  .*..+3+4+5+6+7+8+9+P.X.$+;+{+(+|+0+a+b+.   ",
"  . _ a c+C O P X  .*.].z 5.a k.r.y.G.P.X.$+;+{+(+|+0+d+e+f+.   ",
"    . b z D P X  .*.].z 5.a k.r.y.G.P.X.$+;+{+(+|+0+d+g+h+.     ",
"    . . A E Q X X =.P P P c.l.s.z.H.Q.Y.Y.1 1 _+1+a+e+h+. .     ",
"      . . F R Y ..-.^.}.6.d.m.t.A.I.R.Z.%+>+]+:+2+b+f+. .       ",
"          . . . . . . . . . . . . . . . . . . . . . .           ",
"                                                                "};

FLFormSearchDB::FLFormSearchDB (const char *name, QWidget * parent, FLReceiver * receiver):
FLFormDB (name, parent, Qt::WDestructiveClose | Qt::WType_Dialog | Qt::WShowModal, receiver),
layoutButtons (0),
loop (false),
accepted_ (true)
{
  setFont (qApp->font ());
}

FLFormSearchDB::FLFormSearchDB (FLSqlCursor * cursor, QWidget * parent, FLReceiver * receiver):
FLFormDB (cursor, parent, Qt::WDestructiveClose | Qt::WType_Dialog | Qt::WShowModal, receiver), layoutButtons (0), loop (false), accepted_ (true)
{
  setFont (qApp->font ());
}

FLFormSearchDB::~FLFormSearchDB ()
{
}

void
FLFormSearchDB::exec ()
{
  show ();
  loop = true;
  qApp->enter_loop ();
}

void
FLFormSearchDB::closeEvent (QCloseEvent * e)
{
  if (loop)
	qApp->exit_loop ();

  loop = false;
  accepted_ = false;
  emit closed ();
  QWidget::closeEvent (e);
}

void
FLFormSearchDB::setMainWidget (QWidget * w)
{
  if (!cursor_)
	return;

  if (layoutButtons)
	delete layoutButtons;

  if (layout)
	delete layout;

  layout = new QVBoxLayout (this);
  layout->setSpacing (5);
  layout->setMargin (5);

  layoutButtons = new QHBoxLayout;
  layoutButtons->setSpacing (6);
  layoutButtons->setMargin (0);
  QSpacerItem *spacer_3 = new QSpacerItem (20, 20, QSizePolicy::Expanding,
										   QSizePolicy::Minimum);

  layoutButtons->addItem (spacer_3);

  pushButtonAccept = new QPushButton (this, "pushButtonAccept");
  QPixmap ok(button_ok_xpm);
  pushButtonAccept->setIconSet(ok);
  pushButtonAccept->
	setSizePolicy (QSizePolicy ((QSizePolicy::SizeType) 7, (QSizePolicy::SizeType) 0, pushButtonAccept->sizePolicy ().hasHeightForWidth ()));
  pushButtonAccept->setMinimumSize (QSize (0, 0));
  pushButtonAccept->setText (tr ("Aceptar (F10)", ""));
  pushButtonAccept->setFocusPolicy (QWidget::NoFocus);
  pushButtonAccept->setAccel (QKeySequence (Qt::Key_F10));
  pushButtonAccept->setDefault (true);
  layoutButtons->addWidget (pushButtonAccept);
  QSpacerItem *spacer_4 = new QSpacerItem (20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum);
  layoutButtons->addItem (spacer_4);
  connect (pushButtonAccept, SIGNAL (clicked ()), this, SLOT (accept ()));

  pushButtonCancel = new QPushButton (this, "pushButtonCancel");
  QPixmap cancel(button_cancel_xpm);
  pushButtonCancel->setIconSet(cancel);
  pushButtonCancel->
	setSizePolicy (QSizePolicy ((QSizePolicy::SizeType) 7, (QSizePolicy::SizeType) 0, pushButtonCancel->sizePolicy ().hasHeightForWidth ()));
  pushButtonCancel->setText (tr ("Cancelar (ESC)", ""));
  pushButtonCancel->setFocusPolicy (QWidget::NoFocus);
  pushButtonCancel->setAccel (4096);
  layoutButtons->addWidget (pushButtonCancel);
  connect (pushButtonCancel, SIGNAL (clicked ()), this, SLOT (reject ()));

  layout->add (w);
  layout->addLayout (layoutButtons);
  mainWidget_ = w;
  setFocusProxy (mainWidget_);
  mainWidget_->setFocusPolicy (QWidget::NoFocus);
  mainWidget_->setFocus ();
  resize (mainWidget_->size ());
  connectButtonClose ();

  cursor_->setEdition (false);
  cursor_->setBrowse (false);
  connect (cursor_, SIGNAL (recordChoosed ()), this, SLOT (accept ()));

  if (receiver_)
	receiver_->setSender (this);
}

void
FLFormSearchDB::accept ()
{
  disconnect (cursor_, SIGNAL (recordChoosed ()), this, SLOT (accept ()));
  if (!cursor_)
	close ();
  else
	{
	  if (loop)
		qApp->exit_loop ();
	  loop = false;
	  hide ();
	}
}

void
FLFormSearchDB::reject ()
{
  close ();
}
