#!/bin/sh

func_complete_build()
{
cat << EOT

######################################################
#     BUILD IS SUCCESFULL                            #
#                                                    #
# You can install The Falcon Programming Language    #
# on this system issuing the                         #
#                                                    #
#     $ ./build.sh -i                                #
#                                                    #
# command                                            #
######################################################
EOT
exit 0
}

func_complete_inst()
{
cat << EOT

######################################################
#     INSTALL IS SUCCESFULL                          #
#                                                    #
# Falcon is installed in the target path.            #
# You should run                                     #
#                                                    #
#   $ ldconfig                                       #
#                                                    #
# to update system library cache                     #
######################################################
EOT
exit 0
}

func_errors()
{
cat << EOT
######################################################
#     BUILD PROCESS FAILED!                          #
#                                                    #
# We are sorry, something went wrong. Please, verify #
# the dependencies and other pre-requisite listed    #
# in the README file are correctly set-up.           #
#                                                    #
# In that case, please report the error conditions   #
# to                                                 #
#                                                    #
#       http://www.falconpl.org                      #
#       (Contacts area)                              #
#                                                    #
# Thanks for your cooperation                        #
######################################################
EOT
exit 1
}

func_usage()
{
cat << EOT

Falcon source package build and install tool
usage:
         $0 -p <perefix> [-f <final> ] [options]
  -or-   $0 -i [options]

        -p Define standard installation prefix (absolute)
        -f Defines a final destination different from prefix (absolute)
        -i Perform installation step

   Other options
        -j Number of processors to use in make (default 1)
        -d Compile a debug enabled version.
        -s Do NOT strip binaries even if in reselase mode.
        -l set a different library path under prefix (default is lib)

   Environment variables
      CFLAGS - extra C flags to pass to the compiler
      CXXFLAGS - extra C++ flags to pass to the compiler
EOT
}


cat << EOT
######################################################
#     Falcon source distribution build facility      #
######################################################
EOT

TARGET_DEST=""
TARGET_LIB_DIR="lib"
FINAL_DEST=""
DO_INSTALL="no"
DEBUG="no"
STRIP="yes"
PROCESSORS="1"

until [ -z "$1" ]; do
   case "$1" in
      "-p") shift; TARGET_DEST=$1;;
      "-l") shift; TARGET_LIB_DIR=$1;;
      "-f") shift; FINAL_DEST=$1;;
      "-i") DO_INSTALL="yes";;
      "-j") shift; PROCESSORS=$1;;
      "-d") DEBUG="yes";;
      "-s") STRIP="no";;
      *) func_usage ; exit 0 ;;
   esac
   shift
done

if [ -z "$TARGET_DEST" ]; then
   if [ "$DO_INSTALL" = "no" ]; then
      echo "$0: the parameter -p <prefix> must be given"
      func_usage
      exit 0
   fi
fi

FINAL_DEST=${FINAL_DEST:-$TARGET_DEST}

export FALCON_SRC_TREE="$(pwd)"
export FALCON_DEVEL_TREE=$FALCON_SRC_TREE/devel
if [ "x$DEBUG" = "xyes" ]; then
   export FALCON_ACTIVE_TREE=$FALCON_DEVEL_TREE/debug
else
   export FALCON_ACTIVE_TREE=$FALCON_DEVEL_TREE/release
fi
export FALCON_BUILD_TREE=$FALCON_ACTIVE_TREE/build

if [ -z "$TARGET_DEST" ]; then

cat << EOT

      Performing installation

######################################################
EOT
cd $FALCON_BUILD_TREE
make install || func_errors
func_complete_inst

else

cat << EOT

   - Target directory : $TARGET_DEST
   - Final Destination: $FINAL_DEST

   Configuring and building environment
######################################################

EOT

if [ "x$DEBUG" = "xyes" ]; then
   export FALCON_BUILD_TYPE="debug"
   export FALCON_BUILD_NAME="debug"
else
   if [ "x$STRIP" = "xno" ]; then
      export FALCON_BUILD_TYPE="RelWithDebugInfo"
      export FALCON_BUILD_NAME="RelWithDebugInfo"
   else
      export FALCON_BUILD_TYPE="release"
      export FALCON_BUILD_NAME="release"
   fi
fi


. "$FALCON_SRC_TREE/versioninfo"
export FALCON_VERSION_MAJOR
export FALCON_VERSION_MINOR
export FALCON_VERSION_REVISION
export FALCON_VERSION_PATCH

export FALCON_VERSION_NAME

export FALCON_SONAME_VERSION
export FALCON_SONAME_REVISION
export FALCON_SONAME_AGE


echo "Launching CMAKE"
mkdir -p $FALCON_BUILD_TREE
cd $FALCON_BUILD_TREE

cmake -DCMAKE_CXX_FLAGS:STRING="$CXXFLAGS" \
      -DCMAKE_C_FLAGS:STRING="$CFLAGS" \
      -DCMAKE_BUILD_TYPE:STRING="$FALCON_BUILD_TYPE" \
      -DFALCON_INSTALL_TREE_LIB:STRING="$TARGET_LIB_DIR" \
      -DFALCON_INSTALL_TREE:STRING="$TARGET_DEST" \
      -DFALCON_FINAL_DESTINATION:STRING="$FINAL_DEST" \
      $FALCON_SRC_TREE \
      || func_errors

make -j $PROCESSORS || func_errors
func_complete_build
fi

