m4_include(`farversion.m4')m4_dnl
.Language=Ukrainian,Ukrainian (Українська)
.Options CtrlColorChar=\
.Options CtrlStartPosChar=^<wrap>

@Contents
$^#Програма управління файлами та архівами#
`$^#'FULLVERSIONNOBRACES`#'
`$^#©1996-2000 Eugene Roshal, ©2000-2016 FAR Group,' ©COPYRIGHTYEARS `FAR People'#
~Індекс файлу допомоги~@Index@
~Як користуватися допомогою~@Help@

~Що таке FAR2L~@About@
~Ліцензія~@License@

~Режими інтерфейсу~@UIBackends@
~Параметри командного рядка~@CmdLine@
~Клавіатурні команди~@KeyRef@
~Підтримка модулів, що підключаються~@Plugins@
~Огляд можливостей модулів , що підключаються~@PluginsReviews@
~Термінал~@Terminal@

~Панелі:~@Panels@ ~Панель файлів~@FilePanel@
~Дерево папок~@TreePanel@
~Панель інформації~@InfoPanel@
~Панель швидкого перегляду~@QViewPanel@
~Перетягування файлів~@DragAndDrop@
~Налаштування режимів перегляду панелі файлів~@PanelViewModes@
~Помітка файлів~@SelectFiles@

~Меню:~@Menus@ ~Меню лівої та правої панелей~@LeftRightMenu@
~Меню файлів~@FilesMenu@
~Меню команд~@CmdMenu@
~Меню параметрів~@OptMenu@

~Пошук файлу~@FindFile@
~Історія команд~@History@
~Пошук папки~@FindFolder@
~Порівняння папок~@CompFolders@
~Меню користувача~@UserMenu@
~Меню переходу~@DriveDlg@

~Асоціації файлів~@FileAssoc@
~Команди операційної системи~@OSCommands@
~Закладки~@Bookmarks@
~Меню фільтрів~@FiltersMenu@
~Переключення між екранами~@ScrSwitch@
~Список завдань~@TaskList@
~Список пристроїв~@HotPlugList@

~Системні параметри~@SystemSettings@
~Установки панелі~@PanelSettings@
~Налаштування інтерфейсу~@InterfSettings@
~Налаштування введення~@InputSettings@
~Налаштування діалогів~@DialogSettings@
~Установки меню~@VMenuSettings@
~Налаштування командного рядка~@CmdlineSettings@
~Locations menu settings~@ChangeLocationConfig@

~Розмальовка файлів та групи сортування~@Highlight@
~Опис файлів~@FileDiz@
~Установки програми перегляду~@ViewerSettings@
~Налаштування редактора~@EditorSettings@

~Копіювання, перенесення, перейменування та створення посилань~@CopyFiles@

~Вбудована програма перегляду~@Viewer@
~Вбудований редактор~@Editor@

~Маски файлів~@FileMasks@
~Клавіатурні макрокоманди~@KeyMacro@


@Help
$ # FAR: як користуватися допомогою #
 У змісті довідкової системи є посилання (вони функціонують приблизно
так само, як і гіперпосилання, знайомі кожному користувачеві Інтернет), які
вказують на розділи з більш детальною інформацією. Додатково на головній
сторінці знаходиться "~Індекс файлу допомоги~@Index@", він показує зміст
всіх сторінок (топиків) наявних у файлі допомоги і, у ряді випадків, дозволяє
швидше знайти потрібну інформацію.

 Для переміщення між посиланнями можна використовувати #Tab# і #Shift-Tab#.
Натискання #Enter# викличе сторінку, яка відповідає вибраному посиланню. Цей же
результат можна отримати натиснувши кнопку "миші" на потрібне посилання.

 Якщо текст міститься у вікні допомоги не повністю, то з'являється смуга
прокручування. У цьому випадку текст можна переміщати вгору і вниз за допомогою клавіш #
# Управління курсором #.

 Натискання #Alt-F1# або #BS# призводить до переходу на попередню сторінку.
#Shift-F1# викликає зміст допомоги.

 Press #F7# to search in Help (will show help topics containing the searched text fragment).

Натисніть #Shift-F2#, щоб отримати допомогу у ~зовнішніх модулях~@Plugins@.

 За промовчанням "#Допомога#" відображається у згорнутому вікні, розгорнути його можна
за допомогою клавіші #F5# "#Размер#", повторне натискання #F5# поверне розмір вікна в
первісний стан.


@About
$ # FAR: що це таке #
 #FAR2L# - це програма управління файлами, що працює в текстовому режимі, яка
має великий набір додаткових функций.

 #FAR2L# є #freeware# і #open source# програмою, що розповсюджується
під GNU GPL v2 ~ліцензією~@License@.

#FAR2L# дозволяє працювати з #архівами#. При цьому файли в архівах
обробляються аналогічно файлам у папках. #FAR2L# сам перетворює ваші команди на
відповідні дзвінки зовнішніх архіваторів.

 #FAR2L# також забезпечує значну кількість сервісних функцій.

 - FAR2L офіційний сайт
~http://github.com/elfmz/far2l~@http://github.com/elfmz/far2l@
 - Офіційний сайт вихідного проекту FAR Manager
~http://www.farmanager.com~@http://www.farmanager.com@


@License
$ # FAR2L: Ліцензія
Проект розповсюджується під ліцензією GNU GPL v2, деякі файли
спочатку ліцензовані під 3-clause BSD ліцензією.
Дивіться LICENSE.txt та LICENSE.Far2.txt у вихідних файлах для деталей.

@CmdLine
$ # FAR2L: параметри командного рядка
 Ви можете задавати наступні аргументи в командному рядку або змінному оточенні FAR2L_ARGS:

 #--tty#
Запускає far2l відразу в ~режимі TTY~@UIBackends@ замість автоматичного визначення можливості
роботи у режимі GUI. Хоча GUI режим переважний з погляду користувача
досвід, іноді може знадобитися запуск строго в термінальному режимі.

 #--notty#
Не використовувати термінальний режим, якщо неможливо використовувати ~GUI режим~@UIBackends@.

 #--nodetect#
 За промовчанням far2l намагається на запуску визначити, чи не працює він у терміналі іншого
far2l. У цьому випадку far2l автоматично використовує режим TTY із розширеннями терміналу far2l. В
у разі відсутності таких розширень терміналу - far2l перевіряє наявність доступу до X11 сесії та
використовує її для поліпшення можливостей інтерфейсу, якщо зібрати з опцією TTYX.
Цей ключ вимикає всю перераховану функціональність, запобігаючи автовизначенню наявності
розширень і дозволяє використовувати лише базові можливості звичайного термінала в TTY режимі.

 #--mortal#
Цей аргумент застосовується лише для far2l, який працює в режимі TTY. За замовчуванням про закриття
термінала far2l продовжує працювати 'у фоні' і при наступному запуску іншого far2l у режимі TTY
буде запропоновано активувати far2l, що пішов у фон, замість запуску нової копії програми. Цей ключ
командного рядка півночі відключає цю функціональність, так що закриття терміналу буде наводити
для завершення роботи far2l, що працює в ньому.

 #--primary-selection#
Використовувати PRIMARY selection замість CLIPBOARD X11 selection. Цей аргумент застосовний тільки для
far2l, який працює у режимі WX.

 #/a#
 Заборона відображення символів з кодами 0 - 31 та 255. Може бути корисним при
запуску FAR2L із telnet.

 #/ag#
 Заборона відображення псевдографічних символів з кодами > 127.

 #/an#
 Не відображати псевдографічні символи зовсім.

 #/e[<рядок>[:<позиція>]] <filename>#
Редагування вказаного файлу. Після /e можна додатково вказати рядок
та позицію у рядку, що встановлюються після запуску редактора.
 Наприклад: far/e70:2 readme.

 #/p[<path>]#
 Шукати "основні" зовнішні модулі у папці, вказаній у <path>.
Можна вказати кілька шляхів пошуку, розділених символом ';'. При вказівці
шляхи пошуку можна використовувати змінні середовища.

 #/co#
Примушує FAR2L завантажувати зовнішні модулі лише з кешу. Завантаження при цьому відбувається
швидше, але нові або змінені модулі не виявляються. Має сенс застосовувати
ТІЛЬКИ при стабільному списку модулів. Після додавання, заміни або видалення модулів
треба завантажити FAR2L без цього параметра. Якщо кешу немає, то модулі не завантажуватимуться.

 Зауваження щодо ключів /p та /co:

 - ^<wrap>якщо вказано порожній /p, то FAR2L запуститься без плагінів;
 - ^<wrap>якщо вказано /p<path>, то завантажаться тільки плагіни з <path>;
 - ^<wrap>якщо вказано тільки ключ /co і кеш плагінів не порожній, то
завантажуються плагіни з кешу;
 - ^<wrap>ключ /co ігнорується, якщо також вказано /p;
 - ^<wrap>якщо не вказані ключі /p та /co, то завантажаться плагіни
з основного каталогу та з каталогу, вказаного у параметрі
"~Шлях до персональних плагінів~@PluginsManagerSettings@"

 #/m#
 При старті FAR2L не завантажуватиме макрокоманди з реєстру.

 #/ma#
 При старті FAR2L не виконуватиме макрокоманди з опцією "Виконувати після запуску FAR2L".

 #/u <username>#
 Дозволяє використовувати різні настройки для різних користувачів.
 Наприклад: far /u guest

FAR2L встановить ~змінне середовище~@FAREnv@ "FARUSER" у значення, що дорівнює <username>.

 #/v <filename>#
Перегляд вказаного файлу. Якщо як <filename> використано `#-#', дані
будуть читатися зі stdin (стандартного вхідного потоку).

 Наприклад, "dir | far /v -" виведе результат роботи команди dir.

 Якщо при використанні '-' вхідний потік порожній (наприклад, ви не вказали команду dir
у вказаному прикладі), то FAR2L чекатиме завершення вхідного потоку вічно.
Це особливість поточної версії FAR2L.

 #/w#
 Підлаштовуватись під розмір консольного вікна замість консольного буфера.

 #/x#
Вимкнути обробку виняткових ситуацій. Ця опція призначена для
розробників зовнішніх модулів та у нормальній ситуації вказувати цю опцію не рекомендується.


 У командному рядку можна вказати не більше двох шляхів (до каталогів, файлів, архівів)
або двох команд із префіксом плагіна. Перший шлях для активної панелі, другий – для пасивної:
 - ^<wrap>для каталогів та архівів FAR2L покаже їх вміст;
 - ^<wrap>для файлів - відбудеться перехід у каталог із файлом та позиціонування на вказаний файл, якщо він існує;
 - ^<wrap>при вказівці префіксів плагінів (допускається змішане використання зі звичайними шляхами) спочатку виконується
команда для пасивної панелі (пасивна панель у своїй тимчасово активируется). Односимвольні префікси ігноруються.
 Приклад: far ma:c:\\Far20.7z "macro:post MsgBox(\"FAR2L\",\"Successfully started\")"


@KeyRef
$ #Клавіатурні команди#

~Команда керування панелями~@PanelCmd@

~Командний рядок~@CmdLineCmd@

~Управління файлами та сервісні команди~@FuncCmd@

~Миша: підтримка колеса~@MsWheel@

~Інші команди~@MiscCmd@


@PanelCmd
$ #Команди управління панелями#
 #Загальні команди#

 Змінити активну панель #Tab#
 Поміняти панелі подекуди #Ctrl-U#
 Перечитати вміст панелі #Ctrl-R#
 Прибрати/показати інформаційну панель #Ctrl-L#
Прибрати/показати ~панель швидкого перегляду~@QViewPanel@ #Ctrl-Q#
 Прибрати/показати дерево папок #Ctrl-T#
 Прибрати/показати обидві панелі #Ctrl-O#
 Тимчасово забрати обидві панелі #Ctrl-Alt-Shift#
 (працює доти, доки утримуємо ці клавіші)
 Прибрати/показати неактивну панель #Ctrl-P#
 Прибрати/показати ліву панель #Ctrl-F1#
 Прибрати/показати праву панель #Ctrl-F2#
 Змінити висоту панелей #Ctrl-Up, Ctrl-Down#
 Змінити висоту поточної панелі #Ctrl-Shift-Up,Ctrl-Shift-Down#
 Змінити ширину (при порожньому командному рядку) #Ctrl-Left,Ctrl-Right#
 Відновити ширину панелей за промовчанням #Ctrl-Numpad5#
 Відновити висоту панелей за промовчанням #Ctrl-Alt-Numpad5#
 Сховати/показати лінійку функціональних клавіш #Ctrl-B#

 #Команда файлової панелі#

 Позначити/зняти позначку файлу #Ins, Shift-Клавіші курсору#
 Позначити групу #Gray +#
 Зняти позначку із групи #Gray -#
 Інвертувати позначку #Gray *#
 Позначити файли з розширенням як поточний файл #Ctrl-<Gray +>#
 Зняти позначку з файлів із розширенням, як у поточного #Ctrl-<Gray ->#
 Інвертувати позначку, включаючи папки #Ctrl-<Gray *>#
 (без урахування стану командного рядка)
 Позначити файли з ім'ям як у поточного файлу #Alt-<Gray +>#
 Зняти позначку з файлів з ім'ям, як у поточного файлу #Alt-<Gray ->#
 Позначити всі файли #Shift-<Gray +>#
 Зняти відмітку з усіх файлів #Shift-<Gray ->#
 Відновити попередню позначку #Ctrl-M#

 Прокручування довгих імен та описів #Alt-Left,Alt-Right#
 #Alt-Home,Alt-End#

 Встановити короткий режим перегляду #ЛівийCtrl-1#
 Встановити середній режим перегляду #ЛівийCtrl-2#
 Встановити повний режим перегляду #ЛівийCtrl-3#
 Встановити широкий режим перегляду #ЛівийCtrl-4#
 Встановити детальний режим перегляду #ЛівийCtrl-5#
 Встановити режим перегляду описів #ЛівийCtrl-6#
 Встановити режим перегляду довгих описів #ЛівийCtrl-7#
 Встановити режим перегляду власників файлів #ЛівийCtrl-8#
 Встановити режим перегляду посилань #ЛівийCtrl-9#
 Встановити альтернативний повний режим перегляду #ЛівийCtrl-0#

 Прибрати/показати файли з атрибутом "Прихований" та "Системний" #Ctrl-H#
 Переключити відображення довгих/коротких назв файлів #Ctrl-N#

 Сховати/Показати ліву панель #Ctrl-F1#
 Сховати/Показати праву панель #Ctrl-F2#

 Сортувати файли активної панелі на ім'я #Ctrl-F3#
 Сортувати файли активної панелі для розширення #Ctrl-F4#
 Сортувати файли активної панелі за часом запису #Ctrl-F5#
 Сортувати файли активної панелі за розміром #Ctrl-F6#
 Не сортувати файли активної панелі #Ctrl-F7#
 Сортувати файли активної панелі за часом створення #Ctrl-F8#
 Сортувати файли активної панелі за часом доступу #Ctrl-F9#
 Сортувати файли активної панелі за описами #Ctrl-F10#
 Сортувати файли активної панелі за власником #Ctrl-F11#
Вивести меню ~режимів сортування~@PanelCmdSort@ #Ctrl-F12#
 Використовувати сортування за групами #Shift-F11#
 Показувати позначені файли першими #Shift-F12#

Створити ~закладку~@Bookmarks@ #Ctrl-Shift-0# .. #Ctrl-Shift-9#
 Перейти за посиланням на папку #ПравийCtrl-0#.. #ПравыйCtrl-9#

Якщо активна панель є ~панеллю швидкого перегляду~@QViewPanel@,
~деревом каталогів~@TreePanel@ або ~інформаційною панеллю~@InfoPanel@, то каталог
 змінюється не так на активної, але в пасивної панелі.

 Помістити позначені імена у Буфер Обмін #Ctrl-Ins#
 (при порожньому командному рядку)
 Помістити файли в Буфер Обміну #Ctrl-C#
 (без урахування стану командного рядка)
 Помістити імена в Буфер Обмін #Ctrl-Shift-Ins#
 (без урахування стану командного рядка)
 Помістити позначені повні імена в Буфер Обмін #Alt-Shift-Ins#
 (без урахування стану командного рядка)
 Помістити мережеві (UNC) імена позначених файлів #Ctrl-Alt-Ins#
 у Буфер Обміну (без урахування стану командної
 рядки)

також список ~макроклавіш~@KeyMacroShellList@, доступних у панелях.

 Примітки:

 1. ^<wrap>Якщо включено опцію "Дозволити зворотне сортування" у діалозі
~Налаштувань панелі~@PanelSettings@, то повторне натискання однієї і тієї ж клавіші
сортування файлів призводить до зміни напряму сортування із зростаючим на спадне і навпаки;

 2. ^<wrap>Комбінації Alt-Left and Alt-Right, які використовуються для прокручування
довгих імен та описів, не працюють із клавішами Left та Right, розташованими
на цифровій клавіатурі, тому що ці клавіші використовуються для введення символів
через їх десяткові коди.

 3. ^<wrap>Комбінація клавіш #Ctrl-Alt-Ins# працює за такими правилами:
 ^<wrap>*для мережних дисків - мережеве (UNC) ім'я файлового об'єкта;
^<wrap>*для локальних дисків - повне ім'я з урахуванням ~символічних~@HardSymLink@ посилань.

 4. ^<wrap>Комбінації клавіш #Ctrl-Ins#, #Alt-Shift-Ins# та #Ctrl-Alt-Ins# обробляють
Ім'я "#..#" як ім'я поточної папки.


@PanelCmdSort
$ #Режими сортування#
 Меню режимів сортування викликається комбінацією #Ctrl-F12# і застосовується для
активної на даний момент панелі. Доступні такі режими сортування панелі:

 Сортувати файли на ім'я #Ctrl-F3#
 Сортувати за розширенням #Ctrl-F4#
 Сортувати за часом запису #Ctrl-F5#
 Сортувати за розміром #Ctrl-F6#
 Не сортувати файли #Ctrl-F7#
 Сортувати файли за часом створення #Ctrl-F8#
 Сортувати файли за часом доступу #Ctrl-F9#
 Сортувати за файлами за описами #Ctrl-F10#
 Сортувати за власником #Ctrl-F11#

 Клавіша #+# встановлює пряме сортування.
 Клавіша #-# встановлює зворотне сортування.
 Клавіша змінює сортування на зворотне.

 Використовувати сортування за групами #Shift-F11#
 Показувати позначені файли першими #Shift-F12#
 Використовувати числове сортування.
 Використовувати сортування з урахуванням регістру.

 #Примітки щодо числового сортування#

 Починаючи з Windows XP алгоритм сортування використовуваний операційною системою
при виведенні списку файлів, змінений з рядкового на числовий -
#провідні нулі в імені файлу не враховуються#.
FAR2L також дозволяє використовувати числове сортування.
Наступний приклад показує, як сортуються файли:

 Режим вимкнено (Windows 2000) Режим увімкнено

 Ie4_01 Ie4_01
 Ie4_128 Ie4_128
 Ie401sp2 Ie5
 Ie5 Ie6
 Ie501sp2 Ie401sp2
 Ie6 Ie501sp2
 11.txt 5.txt
 5.txt 11.txt
 88.txt 88.txt


@FastFind
$ #Швидкий пошук у панелях#
 Для позиціонування на файл можна скористатися операцією #швидкого
#пошуку# за першими літерами імені. Для цього утримуючи клавішу #Alt# (або
#Alt-Shift#), набирайте ім'я файлу, доки на нього не переміститься
курсор.

 За допомогою #Ctrl-Enter# можна циклічно переміщатися елементами панелі в
відповідно до введеної у рядку файлової маски. #Ctrl-Shift-Enter# дозволяє
переміщатися елементами у зворотному напрямку.

 Крім звичайних символів в імені файлу можна використовувати символи '#*#'
та '#?#'.

 Вставлення вмісту буфера обміну (клавішами #Ctrl-V# або #Shift-Ins#)
вікно швидкого пошуку проводиться до того часу, поки є збіг.

 У процесі набору імені можна застосовувати функцію транслітерації при
помилковій розкладці клавіатури. У цьому випадку FAR2L перекодує набраний текст
і намагається знайти перший збіг нового імені. Докладніше про призначення клавіш
для транслітерації див. TechInfo##10.

також список ~макроклавіш~@KeyMacroSearchList@, доступних у швидкому пошуку файлу.


@CmdLineCmd
$ # Командний рядок
 #Загальні команди#

 Символ вліво #Left,Ctrl-S#
 Символ праворуч #Right,Ctrl-D#
 Слово вліво #Ctrl-Left#
 Слово праворуч #Ctrl-Right#
 На початок рядка #Ctrl-Home#
 На кінець рядка #Ctrl-End#
 Видалити символ #Del#
 Видалити символ зліва #BS#
 Видалити до кінця рядка #Ctrl-K#
 Видалити слово зліва #Ctrl-BS#
 Видалити слово праворуч #Ctrl-Del#
 Розглядати наступну комбінацію клавіш як код #Ctrl-Q#
 Копіювати в Буфер Обмін #Ctrl-Ins#
 Вставити з Буфера Обмін #Shift-Ins#
 Попередня команда #Ctrl-E#
 Наступна команда #Ctrl-X#
 Очистити командний рядок #Ctrl-Y#

 # Команди вставки #

 Вставити ім'я файлу із активної панелі #Ctrl-J,Ctrl-Enter#

У режимі ~швидкого пошуку~@FastFind@ #Ctrl-Enter# не вставляє ім'я
 файлу, а робить циклічний обхід за елементами
 файлової панелі.

 Вставити ім'я файлу із пасивної панелі #Ctrl-Shift-Enter#
 Вставити повне ім'я з активної панелі #Ctrl-F#
 Вставити повне ім'я файлу із пасивної панелі #Ctrl-;#
 Вставити мережеве (UNC) ім'я файлу з активної панелі #Ctrl-Alt-F#
 Вставити мережеве (UNC) ім'я файлу з пасивної панелі #Ctrl-Alt-;#

 Вставити шлях із лівої панелі #Ctrl-[#
 Вставити шлях із правої панелі #Ctrl-]#
 Вставити мережевий (UNC) шлях із лівої панелі #Ctrl-Alt-[#
 Вставити мережевий шлях (UNC) з правої панелі #Ctrl-Alt-]#

 Вставити шлях із активної панелі #Ctrl-Shift-[#
 Вставити шлях із пасивної панелі #Ctrl-Shift-]#
 Вставити мережевий шлях (UNC) з активної панелі #Alt-Shift-[#
 Вставити мережевий шлях (UNC) з пасивної панелі #Alt-Shift-]#

 Примітки:

 1. ^<wrap>Якщо командний рядок порожній, #Ctrl-Ins# копіюватиме імена
вибраних в панелі файлів у Буфер Обміну так само, як і #Ctrl-Shift-Ins#
(див. ~Команда управління панелями~@PanelCmd@);

 2. ^<wrap>#Ctrl-End#, натиснувши в кінці командного рядка, замінює її поточне
вміст командою з ~історії команди~@History@, що починається з вже введених
букв, якщо така команда існує. Щоб перейти до наступної такої команди,
Ви можете натиснути #Ctrl-End# повторно.

 3. ^<wrap>Більшість з описаних вище команд дійсна для всіх рядків
редагування, включаючи рядки у діалогах та вбудований редактор.

 4. ^<wrap>#Alt-Shift-Left#, #Alt-Shift-Right#, #Alt-Shift-Home# та #Alt-Shift-End#
виділяють блок у командному рядку незалежно від стану панелей.

 5. ^<wrap>Комбінації клавіш, що дозволяють отримати мережеве (UNC) ім'я файлового
об'єкта, що працюють за такими правилами:
 ^<wrap>* для мережних дисків - мережне (UNC) ім'я файлового об'єкта;
^<wrap>* для локальних дисків - повне ім'я з урахуванням ~символічних~@HardSymLink@ посилань.

6. ^<wrap>Про кнопкосполучення та інші особливості вбудованого емулятора терміналу ~читайте тут~@Terminal@

@FuncCmd
$ #Команда управління панелями - сервісні команди#
 Допомога #F1#

Викликати ~користувальне меню~@UserMenu@ #F2#

 Перегляд #Ctrl-Shift-F3, Numpad 5, F3#

 Якщо #NumPad 5# або #F3# натиснуто на файл, вони викликають
~вбудовану~@Viewer@, зовнішню або ~асоційовану~@FileAssoc@ програму
перегляду, залежно від типу файлу та ~налаштувань програми перегляду~@ViewerSettings@.
 #Ctrl-Shift-F3# завжди викликає вбудовану програму перегляду, поза
залежно від файлових асоціацій.
 При натисканні будь-якої з цих клавіш на папці обчислюються та відображаються
розміри вибраних папок.

 Редагування, Розпакування #Ctrl-Shift-F4, F4#

#F4# викликає ~вбудований~@Editor@, зовнішній або ~асоційований~@FileAssoc@
редактор, залежно від типу файлу та ~налаштувань редактора~@EditorSettings@.
 #Ctrl-Shift-F4# завжди викликає вбудований редактор, незалежно від
файлових асоціацій.
#F4# і #Ctrl-Shift-F4# для папок викликають діалог зміни файлових ~атрибутів~@FileAttrDlg@.

~Копіювання~@CopyFiles@ #F5#

Копіює файли та папки. Якщо ви хочете створити папку призначення перед
копіюванням, додайте до її імені зворотну межу (\\).

~Перейменування або перенесення~@CopyFiles@ #F6#

Перейменування або перенесення файлів та папок. Якщо ви хочете створити папку
призначення перед перенесенням, додайте її імені зворотну межу (\\).

~Створення нової папки~@MakeFolder@ #F7#

~Видалення файлів та папок~@DeleteFile@ #Shift-Del, Shift-F8, F8#

~Знищення файлів та папок~@DeleteFile@ #Alt-Del#

Показати горизонтальне ~меню~@Menus@ #F9#

 Завершити роботу з FAR2L # F10 #

Показати команди ~модулів, що підключаються~@Plugins@ #F11#

 Змінити поточний диск на лівій панелі #Alt-F1#

 Змінити поточний диск у правій панелі #Alt-F2#

 Вбудована/зовнішня програма перегляду #Alt-F3#

 Викликає залежно від типу файлу
~асоційовану програму перегляду~@FileAssoc@ або зовнішню програму
перегляду, вказану в ~налаштуваннях~@ViewerSettings@, якщо за замовчуванням
використовується внутрішня, або внутрішня, якщо використовується
зовнішня.

 Вбудований/зовнішній редактор #Alt-F4#

Викликає залежно від типу файлу ~асоційований редактор~@FileAssoc@
або зовнішній редактор, вказаний у ~налаштуваннях~@EditorSettings@, якщо за
використовується внутрішній, і внутрішній, якщо за замовчуванням використовується
зовнішній.

 Друк файлів #Alt-F5#

 Якщо встановлено плагін "Print Manager", то друк виділених файлів
здійснюється через нього, інакше – засобами FAR2L.

Створення ~посилань~@HardSymLink@ файлів та папок #Alt-F6#

 Використовуючи жорсткі посилання на файли, ви можете мати кілька різних імен
файлів, що посилаються на ті самі дані.

Провести ~пошук файлу~@FindFile@ #Alt-F7#

Показати ~історію команд~@History@ #Alt-F8#

 Зміна розміру вікна FAR2L #Alt-F9#

 У віконному режимі перемикання відбувається з нормального до максимального
допустимого розміру консольного вікна та назад. У повноекранному режимі #Alt-F9#
перемикає екран із 25 ліній на 50 і назад. Докладніше див. TechInfo##38.

Налаштування параметрів зовнішніх модулів, що підключаються~@Plugins@ #Alt-Shift-F9#

Провести ~пошук папки~@FindFolder@ #Alt-F10#

Показати історію ~перегляду та редагування~@HistoryViews@ #Alt-F11#

Показати ~історію папок~@HistoryFolders@ #Alt-F12#

 Додати файли до архіву #Shift-F1#
 Вийняти файли з архіву #Shift-F2#
 Виконати команди керування архівом #Shift-F3#
Редагувати ~новий файл~@FileOpenCreate@ #Shift-F4#

 При створенні нового файлу використовується кодова сторінка, вибрана в
останнього відкритого редактора. Якщо редактор відкривається вперше у поточній
сесії FAR2L, використовується кодова сторінка за промовчанням.

 Копіювання файлу під курсором #Shift-F5#
 Перейменування або перенесення файлу під курсором #Shift-F6#

 Для папки: якщо заданий відносний або абсолютний шлях відповідає
існуючої папки відбувається переміщення в цю папку.

 Наприклад, при переміщенні #c:\folder1\# в #d:\folder2\#:
 - якщо #d:\folder2\# існує, то вміст #c:\folder1\# переміститься в
#d:\folder2\folder1\#;
 - інакше вміст #c:\folder1\# переміститься в
новостворену папку #d:\folder2\#.

~Видалення файлу~@DeleteFile@ під курсором #Shift-F8#
 Зберегти конфігурацію #Shift-F9#
 Вибрати останній пункт меню #Shift-F10#

 Запуск, зміна папки, вхід до архіву #Enter#
 Запуск в окремому вікні #Shift-Enter#
 Запуск від імені адміністратора #Ctrl-Alt-Enter#

 #Shift-Enter# для папки викликає Провідник із показом вмісту вибраної
папки. Для того щоб у Провіднику показати кореневу папку, потрібно натиснути
#Shift-Enter# на потрібному диску в меню ~вибору дисків~@ DriveDlg@.
#Shift-Enter# на папці з ім'ям "#..#" відкриває у Провіднику поточну папку.

 Змінити папку на кореневу #Ctrl-\\#

 Change to the home directory (~~)                            #Ctrl-`#

 Зміна папки, вхід до архіву (також у SFX архів), #Ctrl-[Shift-]PgDn#

 Якщо курсор вказує на папку, то змінюється поточна папка на
вказану. Якщо курсор вказує на файл, то залежно від типу файлу,
виконується ~асоційована команда~@FileAssoc@, або відбувається вхід до архіву.
 #Ctrl-Shift-PgDn# завжди ініціює вхід до архіву, незалежно від
файлових асоціацій.

  For symlink jump to target symlink                         #Ctrl-Shift-PgDn#
   (for others files a la #Ctrl-PgDn#)

 Перейти до папки рівнем вище #Ctrl-PgUp#

 На #Ctrl-PgUp# у кореневій папці впливає опція
"~Використовувати Ctrl-PgUp для вибору диска~@InterfSettings@".

  Revert to symlink                                          #Ctrl-Shift-PgUp#
   (only if before was jump by #Ctrl-Shift-PgDn# to target symlink)

 Створити закладку на папку #Ctrl-Shift-0..9#
 Використовувати закладку #ПравийCtrl-0..9#

Встановити ~файлові атрибути~@FileAttrDlg@ #Ctrl-A#
~Застосувати команду~@ApplyCmd@ до позначених файлів #Ctrl-G#
Додати ~описи~@FileDiz@ до позначених файлів #Ctrl-Z#


@DeleteFile
$ #Видалення та знищення файлів та папок#
 Для видалення або знищення файлів та папок застосовуються такі поєднання
клавіш:

 #F8# - якщо на панелі вибрані будь-які файли або
 каталоги, то видаляється обрана група, інакше
 поточний об'єкт під курсором.

 #Shift-F8# - видалення файлу або папки лише під курсором
 (незалежно від вибраних об'єктів на панелі);

 #Shift-Del# - видалення вибраних об'єктів обминаючи Кошик

 #Alt-Del# - знищення файлів та папок.


 Примітки:

1. ^<wrap>Залежно від установок у меню ~Системні параметри~@SystemSettings@
комбінації клавіш #F8# і #Shift-F8# переміщують чи ні файли, що видаляються в
Кошик (Recycle Bin). Комбінація клавіш #Shift-Del# завжди видаляє файли,
минаючи Кошик.

 2. ^<wrap>У процесі знищення файл перезаписується нулями (можна задати
інший символ-заповнювач, див. TechInfo##29), усікається до нульової довжини,
перейменовується у тимчасове ім'я та віддаляється.

@ErrCannotExecute
$ #Помилка: Помилка виконання#
 Команда, що запускається, не є внутрішньою або зовнішньою
командою, що виконується програмою чи пакетним файлом.

 При запуску вмісту командного рядка FAR2L шукає виконуваний
модуль за наступною логікою (поперемінно підставляючи розширення, перераховані в
змінної оточення %PATHEXT%):

 1. Поточний каталог
 2. Каталоги, які перераховані у змінному оточенні %PATH%
 3. 32-бітний системний каталог Windows (SYSTEM32)
 4. 16-бітний системний каталог Windows (SYSTEM)
 5. Каталог Windows.


@MiscCmd
$ #Команда управління панелями - інші команди#
 Копіювання тексту з екрана #Alt-Ins#

 Ця команда дозволяє вибрати та помістити в Буфер Обміну будь-яку область
екрану. Для переміщення курсору використовуйте клавіші керування курсором або
натисніть ліву кнопку миші. Для вибору тексту використовуйте клавіші керування
#курсором# при натиснутій #Shift# або натиснутою #ліву кнопку миші#. #Enter#,
#Ctrl-Ins#, #права кнопка миші# або подвійне натискання #лівої кнопки миші#
копіюють вибраний текст у Буфер Обміну, #Ctrl-<Gray +># додає його до
поточному змісту Буфера Обміну #Esc# скасовує позначку і завершує операцію.
Комбінація #Ctrl-U# знімає виділення.

Записати ~клавіатурну макрокоманду~@KeyMacro@ #Ctrl-<.>#

 Історія у рядках редагування діалогів #Ctrl-Up, Ctrl-Down#

 В історії рядків редагування діалогів ви можете використовувати #Enter# для
копіювання поточного елемента в рядок редагування або #Ins# для позначки
елемент. Зазначені елементи не витісняються з історії новими елементами, так
що ви можете відзначити часто використовувані рядки, щоб весь час тримати їх у
історії.

 Очищення історії у рядках редагування діалогів #Del#

 Видалення поточного невідзначеного пункту історії
 у рядках редагування діалогів #Shift-Del#

 Вставити в діалог ім'я файлу під курсором #Shift-Enter#

 Помістити курсор у діалогах на елемент за промовчанням #PgDn#

 Вставити у діалог ім'я файлу пасивної панелі #Ctrl-Shift-Enter#

 Ця комбінація клавіш може бути використана у всіх рядках
редагування крім командного рядка, включаючи діалоги та
~вбудований редактор~@Editor@.

 #Ctrl-Enter# у діалогах викликає дію за замовчуванням (натискання на кнопку
за умовчанням або подібна за змістом дія).

 У діалогах, коли поточним елементом управління є контрольний
перемикач (кнопка із незалежною фіксацією або Check Box):

 - увімкнути (#[x]#) #Gray +#
 - Вимкнути (#[ ]#) #Gray -#
 - змінити стан на невизначений (#[?]#) #Gray *#
 (якщо перемикач має трипозиційний стан)

 Клацніть #лівою клавішею миші# за межами діалогу аналогічне натисканню
клавіші #Esc#.

 Клацніть #правою клавішею миші# за межами діалогу аналогічне натисканню
клавіші # Enter #.

 Клацніть #середньою клавішею миші# з відповідними модифікаторами (#Ctrl#,
#Alt#, #Shift#) у ~панелях~@PanelCmd@ аналогічний натисканню клавіші #Enter#. Для
непустого ~командного рядка~@CmdLineCmd@ буде виконано її вміст.

FAR2L також вміє обробляти ~колесо миші~@MsWheel@.

 Перемістити діалог можна мишею чи комбінацією #Ctrl-F5#.

 #Липкі керуючі кнопки# якщо ваше оточення не дає вам використовувати
деякі кнопкосполучення через обмеження TTY режиму або якщо кнопкосполучення
зайнято зовнішньою програмою, то ви можете використовувати липкі керуючі кнопки.
Це означає кнопка, яка віртуально залишається натиснутою до наступного
не-керуючої (цифро-символьної) кнопки:
 Ctrl+SPACE дає липкий CONTROL
 Alt+SPACE дає липкий ALT
 правий_Ctrl+SPACE дає липкий правий CONTROL
 правий_Alt+SPACE дає липкий правий ALT
Іншим способом отримати працездатні гарячі кнопки може бути перенастроювання
зовнішніх програм (з метою звільнити потрібні поєднання) або використання
опції ексклюзивної обробки натискань у ~налаштуваннях інтерфейсу~@InterfSettings@.

@MsWheel
$ #Миша: підтримка колеса#

 #Панелі# Прокрутка списку при незмінній позиції курсору
на екрані. Натискання #середньої кнопки# аналогічно
 натискання #Enter #.

 #Редактор# Прокручування тексту з постійним позиціонуванням
 курсора (аналогічно #Ctrl-Up#/#Ctrl-Down#).

 #Вбудована# Прокручування всього тексту.
 #програма#
 #перегляду#

 #Система допомоги# Прокрутка тексту.


 #Меню# Прокрутка колеса аналогічна дії клавіш
#Up#/#Down#. Натискання середньої кнопки аналогічне
натискання #Enter #. Можна вибирати пункти, не рухаючи
 курсор.

 #Діалоги# У діалогах при прокручуванні колеса для рядка
 редагування з історією та комбінованого
списку відкривається список. Всередині списку
 Прокручування працює так само, як для меню.

 Ви можете задати кількість рядків для прокручування в панелях, редакторі та во
вбудованій програмі перегляду (див. TechInfo##33).


@Plugins
$ #Підтримка модулів, що підключаються#
 Зовнішні модулі (plugins) можуть бути використані для
створення нових команд FAR2L та підтримки додаткових файлових систем. Наприклад,
робота з архівами, FTP-клієнт, тимчасова панель та перегляд мережі реалізовані з
допомогою емулюючих файлових систем модулів.

 Усі модулі, що підключаються, зберігаються в окремих папках, розміщених у папці
'Plugins', що знаходиться в одній папці з FAR2L.EXE. При виявленні нового
модуля FAR2L зберігає інформацію про нього і згодом завантажує його лише за
необхідності, так що модулі, що не використовуються, не вимагають додаткової пам'яті.
Тим не менш, якщо ви впевнені, що якісь модулі вам не потрібні, ви можете
видалити їх, щоб зберегти місце на диску.

Модулі можуть бути викликані або з Меню переходу~@DriveDlg@, або з
меню ~Команди зовнішніх модулів~@PluginCommands@, що активізується за допомогою #F11# або
пункту ~Меню команд~@CmdMenu@. #F4# у меню "Команди зовнішніх"
модулів" дозволяє призначити гарячі клавіші для пунктів цього меню, що
спрощує їх подальший дзвінок за допомогою ~клавіатурних макрокоманд~@KeyMacro@.
Це меню доступне з файлових панелей, діалогів та з вбудованої програми
перегляду та редактора. Під час дзвінка з діалогів, програми перегляду або редактора
будуть показані не всі модулі, а лише ті, що спеціально створені для роботи
у цьому режимі.

 Ви можете налаштувати параметри модулів за допомогою команди
~Параметри зовнішніх модулів~@PluginsConfig@ з ~Меню параметрів~@OptMenu@ або
комбінацію клавіш #Alt-Shift-F9#.
 Операції обробки файлів (копіювання, перенесення, видалення,
редагування, ~Пошук файлу~@FindFile@ тощо) можуть працювати з модулями,
Емулюючі файлові системи, якщо ці модулі забезпечують відповідну
функціональність.

Модулі мають власні файли повідомлень та допомоги. Ви можете отримати
список доступної допомоги за модулями, натиснувши:

 #Shift-F2# - в основній допомозі FAR2L
 #Shift-F1# - у списку плагінів (контекстно-залежна допомога).

 Якщо плагін не має файлу допомоги, то допомога викликатись не буде.

 Якщо активна панель відображає файлову систему, яку підтримують зовнішні
модулем, то команда "CD" у командному рядку може бути використана для зміни
поточної папки файлової системи. На відміну від "CD" команда "CHDIR" завжди
сприймає вказаний параметр як ім'я реальної папки, незалежно від типу
файлової панелі.


@PluginCommands
$ # Команди зовнішніх модулів #
 Дане меню - один із способів використання функціональності, яку
надають зовнішні модулі (про інші способи див. ~"Підтримка модулів, що підключаються"~@Plugins@).
Вміст цього меню та дії, які виконуються при виборі пункту меню,
визначаються зовнішніми модулями.

 Меню може бути викликане такими способами:

 - натискання #F11# у файлових панелях або вибір пункту #Команда зовнішніх модулів#
~меню команд~@CmdMenu@, при цьому показуються команди, призначені для
 виклику із файлових панелей;
 - натискання #F11# у вікні перегляду, редактора або діалогу, при цьому відображаються
лише команди, призначені для поточної області дзвінка.

 Кожному пункту меню #F4# може бути призначена гаряча клавіша, що відображається
ліворуч від нього. Ця можливість широко використовується при створенні
~клавіатурних макрокоманд~@KeyMacro@ виклику функцій зовнішніх модулів. Символ #A#
у крайній лівій колонці меню означає, що відповідний модуль розроблено
для Far 1.x і не підтримує всіх можливостей Far 2 (зокрема, символів
Unicode в іменах файлів та в редакторі).

 Гарячі клавіші меню Команди зовнішніх модулів:

 #Shift-F1# - допомога у використанні виділеного пункту меню.
 Текст допомоги береться з HLF-файлу, пов'язаного із зовнішнім
 модулем, якому належить виділений пункт меню.
 #F4# - призначити гарячу клавішу виділеного пункту меню.
 Якщо ввести пробіл, Far установить гарячу клавішу
 автоматично.
 #Shift-F9# - параметри вибраного модуля.
#Alt-Shift-F9# - відкрити меню ~"Конфігурація модулів"~@PluginsConfig@.

також: ~Підтримка модулів, що підключаються~@Plugins@.


@PluginsConfig
$ #Параметри зовнішніх модулів#
Ви можете налаштувати параметри ~модулів , що підключаються~@Plugins@,
використовуючи команду # "Параметри зовнішніх модулів" # з ~"Меню параметрів"~@OptMenu@
або натиснувши комбінацію клавіш #Alt-Shift-F9# з меню ~вибору дисків~@DriveDlg@
і меню команд модулів, що підключаються.

 Ви можете отримати інформацію про конкретний модуль, натиснувши #Shift-F1# -
контекстно-залежна допомога з налаштування модуля. Якщо плагін не має файлу
допомоги, то допомога викликатись не буде.

 Під час виклику контекстної допомоги FAR2L спробує показати тему з ім'ям
# Config #. Якщо такої теми у файлі допомоги плагіна немає, буде показано основну тему
тема допомоги по даному плагіну.

 Кожному пункту меню #F4# може бути призначена гаряча клавіша, що відображається
ліворуч від нього; дана можливість широко використовується при створенні
~клавіатурних макрокоманд~@KeyMacro@ виклику функцій зовнішніх модулів. Символ #A#
у крайній лівій колонці меню означає, що відповідний плагін розроблено
для Far 1.x і не підтримує всіх можливостей Far 2 (зокрема, символів
Unicode в іменах файлів та в редакторі).

@PluginsReviews
$ #Огляд можливостей модулів, що підключаються#
 Оболонка FAR2L настільки тісно злилася зі своїми плагінами, що
говорити про неї і не говорити про плагіни просто безглуздо. Плагіни неймовірно
розширюють можливості FAR2L, доповнюючи їх та модифікуючи.

@Panels
$ #Панелі#
 Зазвичай FAR2L показує дві панелі (ліве та праве вікна) з різною
інформацією. Якщо ви бажаєте змінити тип інформації, що відображається в панелі,
використовуйте ~меню панелей~@LeftRightMenu@ або відповідні
~клавіатурні команди~@KeyRef@.

 Для отримання додаткової інформації про панелі прочитайте перелічені
нижче за тему:

~Панель файлів~@FilePanel@ ~Дерево папок~@TreePanel@
~Панель інформації~@InfoPanel@ ~Панель швидкого перегляду~@QVi ewPanel@

~Перетягування файлів~@DragAndDrop@
~Помітка файлів~@SelectFiles@
~Налаштування режимів перегляду панелі файлів~@PanelViewModes@


@FilePanel
$ #Панель файлів#
Панель файлів відображає вміст поточної папки. Ви можете вибирати файли
та папки, виконувати різні файлові та архівні операції. Команди управління
панелями описані у темі ~Список команд~@KeyRef@.

 За замовчуванням на панелі файлів використовуються такі режими перегляду:

 Короткий Імена файлів виводяться в три колонки.

 #Средний# Імена файлів виводяться у дві колонки.

 #Повний# Виводяться ім'я, розмір, дата та час файлу.

 #Широкий# Виводяться ім'я та розмір файлу.

 #Детальний# Виводяться імена, розміри, упаковані розміри,
 час останнього запису, створення, доступу
та атрибути файлу. Повноекранний режим.

#Описи# Імена та ~описи файлів~@FileDiz@

 #Довгі# Імена, розміри та описи файлів.
 #описи# Повноекранний режим.

 #Власники# Імена, розміри та власники файлів.
 #файлів#

 #Посилання файлів# Імена, розміри та кількість жорстких посилань файлів.

 # Альтернативний # Ім'я, розмір (форматований за допомогою ком)
 Повний і дата файлу.

Ви можете налаштувати ~режими перегляду панелі файлів~@PanelViewModes@.

 Фізичний розмір показує скільки місця файл реально використовується для
зберігання файлу. Для звичайних файлів цей розмір дорівнює логічному розміру файлу
заокругленому вгору відповідно до розміру кластера файлової системи. Але для стислих
або розріджених файлів цей розмір може бути меншим за логічний розмір.

 Якщо потрібно змінити режим перегляду панелі, виберіть бажаний з
~меню панелей~@LeftRightMenu@. Після зміни режиму перегляду або поточного
диска тип будь-якої панелі автоматично змінюється на панель файлів.

 Для позиціонування на файл можна скористатися операцією
~швидкого пошуку~@FastFind@ за першими літерами імені.

також список ~макроклавіш~@KeyMacroShellList@, доступних у панелях.

@TreePanel
$ #Дерево папок#
 Панель дерева папок відображає структуру папок поточного диска як
дерево. Це дозволяє швидко змінити поточну папку, а також виконувати операції
над папками.

 FAR2L запам'ятовує інформацію про структуру папок у файлі #tree2.far#,
розташований у кореневій папці кожного диска. Якщо запис на диск неможливий,
то ця інформація збережеться в прихованій папці Tree.Cache, що знаходиться в тій же
папці, що й FAR2L.EXE.
 За замовчуванням файл tree2.tar відсутній, для створення потрібно хоча б один
раз скористатися командою #Пошук папки# або режимом панелі #Дерево папок#.
Якщо такий файл є, то при зміні каталогів (видалення, створення,
перейменування, копіювання) FAR2L відстежує та оновлює його
Внутрішню структуру. Якщо зміни були зроблені не в FAR2L оновити
вміст файлу tree2.far можна поєднанням клавіша #Ctrl-R#.

 Для позиціонування на папку можна використовувати операцію #швидкого
#пошуку#. Для цього, утримуючи клавішу #Alt, набирайте ім'я потрібної папки,
доки на неї не переміститься курсор. За допомогою #Ctrl-Enter#/#Ctrl-Shift-Enter#
можна переміститися на наступне/попереднє ім'я, яке відповідає введеному рядку.

 #Gray +# і #Gray -# використовуються для швидкого переміщення вгору або вниз
за папками одного рівня.

Дивіться також список ~макроклавіш~@KeyMacroTreeList@, доступних на панелі дерева папок.

@InfoPanel
$ #Панель інформації#
 Панель інформації містить такі дані:

- ^<wrap>#мережеві# імена комп'ютера та користувача (див. ~Налаштування інформаційної панелі~@InfoPanelSettings@);

 - ^<wrap>ім'я та тип #поточного диска#, тип його файлової системи,
мережеве ім'я, загальний та вільний розміри, мітку тома та серійний номер;

 - ^<wrap>рівень завантаження #пам'яті# (100% означає, що використана вся пам'ять),
розмір встановленої пам'яті (у Vista і вище), загальний та вільний розміри фізичної пам'яті
(доступною для Windows), віртуальної пам'яті та файлу підкачування;

 - файл #опису папки#

 Ви можете переглянути вміст цього файлу у повноекранному режимі, натиснувши
#F3# або #ліву кнопку миші#. Щоб редагувати або створити цей файл, натисніть
#F4# або #праву кнопку миші#. Ви також можете використовувати багато команд
~вбудована програма перегляду~@Viewer@ (пошук, вибір кодової сторінки і т.д.) для
перегляду файлу опису.

 Список можливих імен файлів опису папок може бути заданий за допомогою
команди "Файли опису папок" у ~Меню параметрів~@OptMenu@.

Для приводів компакт-дисків FAR2L вміє визначати тип приводу. Розрізняються
такі типи: CD-ROM, CD-RW, CD-RW/DVD, DVD-ROM, DVD-RW та DVD-RAM. Функція
визначення типу приводу вимагає чи адміністративних прав, чи дозволу доступу
до локальних приводів компакт-дисків за допомогою політик безпеки (для цього треба запустити з командної
рядки утиліту #secpol.msc# та встановити налаштування '#Локальні політики/Параметри#
#безпеки/Пристрої: Дозволити доступ до дисководів компакт-дисків#
#локальним користувачам#' на значення '#Дозволити#').

 Для віртуальних пристроїв (SUBST-дисків) вказуються параметри
основного диска

також список ~макроклавіш~@KeyMacroInfoList@, доступних на панелі інформації.

@QViewPanel
$ #Панель швидкого перегляду#
 Панель швидкого перегляду використовується для отримання інформації про вибране
елементі ~панелі файлів~@FilePanel@ або ~дерева папок~@TreePanel@.

Якщо вибраний елемент - файл, відображається його вміст. Для файлу,
відображається в панелі доступні багато команд вбудованої програми
~перегляду~@Viewer@. Для відомих Windows типів файлів також виводиться
назва типу.

 Для папок на панелі швидкого перегляду повідомляється загальний розмір, загальний
упакований розмір, кількість файлів та вкладених папок, розмір кластера
поточного диска, реальний розмір файлів, включаючи фрагменти, що не використовуються
кластерів. Загальний упакований розмір застосовується лише для дисків з файловою
системою NTFS.

Для ~символічних посилань~@HardSymLink@ відображається шлях до вихідних
об'єктам.

 Для папок загальні розміри можуть не відповідати реальним значенням:

 1. ^<wrap>Якщо серед вкладених папок є символічні посилання та включена опція
"Сканувати символічні посилання" (діалог налаштування ~системних параметрів~@SystemSettings@).

 2. ^<wrap>Якщо всередині папки є кілька жорстких посилань на той самий файл.

також список ~макроклавіш~@KeyMacroQViewList@, доступних на панелі швидкого перегляду.

@DragAndDrop
$ #Копіювання: перетягування файлів#
 Операції #копіювання # і #перенесення файлів можуть бути виконані за допомогою
#перетягування #. Натисніть #ліву кнопку миші# на вихідному файлі або папці,
перетягніть його на іншу панель та відпустіть кнопку миші.

 Якщо ви хочете обробити групу файлів або папок, позначте їх перед
перетягуванням, натисніть #ліву кнопку миші# на вихідній панелі та перетягніть
файли іншу панель.

 Ви можете переключатися між копіюванням та перенесенням, натискаючи #праву#
кнопку миші під час перетягування. Для перенесення файлів ви також можете
утримувати клавішу # Shift # в момент натискання # лівої кнопки миші #.


@Menus
$ #Меню #
 Для активізації меню можна використовувати #F9# або натиснути #ліву кнопку#
#миші# на верхньому рядку екрана.

 При активізації клавіші #F9# автоматично вибирається меню,
відповідне активної панелі. За активного меню клавіша #Tab# дозволяє
перемикатися між меню лівої та правої панелей. Якщо вибрано меню "Файли",
"Команда" або "Параметри", клавіша #Tab# перемикає на меню пасивної панелі.

 Комбінація #Shift-F10# дозволяє вибрати останній використаний пункт
меню.

 Описи конкретних меню можна прочитати на наступні теми:

~Меню лівої та правої панелей~@LeftRightMenu@ ~Меню файлів~@FilesMenu@

~Меню команд~@CmdMenu@ ~Меню параметрів~@OptMenu@

також список ~макроклавіш~@KeyMacroMainMenuList@, доступних у головному меню.

@LeftRightMenu
$ #Меню лівої та правої панелей#
 Меню #Ліва# та #Права# дозволяють змінити параметри лівої та правої панелі
відповідно. Ці меню включають такі пункти:

 Короткий Показувати файли в три колонки.

 #Середній# Показувати файли у дві колонки.

 #Повний# Показувати ім'я, розмір, дату та час файлу.

 #Широкий# Показувати ім'я та розмір файлу.

 #Детальний# Показувати ім'я, розмір, упакований розмір,
 час запису, створення та доступу
та атрибути файлу. Повноекранний режим.

#Опис # Ім'я та ~опис~@FileDiz@ файлу.

 #Довгі описи# Ім'я, розмір та опис файлу.
 Повноекранний режим.

 #Власники файлів# Ім'я, розмір та власник файлу.

 #Посилання файлів# Ім'я, розмір та кількість жорстких посилань
 файлів.

 # Альтернативний # Ім'я, розмір (форматований з використанням
 #повний# ком) і дата файлу.

#Панель інформації# Змінити панель на ~панель інформації~@InfoPanel@.

#Дерево папок# Змінити панель на ~дерево папок~@TreePanel@.

#Швидкий перегляд# Змінити панель на ~панель швидкого перегляду~@QViewPanel@.

 #Режими сортування# Показати доступні режими сортування.

 #Показувати довгі# Показувати довгі/короткі імена.
 #імена#

 #Панель Вкл/Выкл# Показати/заховати панель.

 #Перечитати# Перечитати вміст панелі.

 #Змінити диск# Змінити поточний диск.


@FilesMenu
$#Меню файлів#
#Перегляд# ~Перегляд файлів~@Viewer@, підрахунок розмірів папок.

#Редагування# ~Редагування~@Editor@ файлів.

#Копіювання# ~Копіювання~@CopyFiles@ файлів та папок.

#Перенесення# ~Перейменування або перенесення~@CopyFiles@ файлів та папок.

#Створення папки# ~Створення~@MakeFolder@ нової папки.

 #Видалення# Видалення файлів та папок.

#Знищення# Знищує файли та папки. Перед видаленням
 файл перезаписується нулями, усікається
 до нульової довжини і перейменовується в
 тимчасове ім'я.

 #Архівувати# Додати вибрані файли до архіву.

 #Розпакувати# Розпакувати вибрані файли з архіву.

#Атрибути файлів# ~Змінити атрибути~@FileAttrDlg@ та час файлу.

#Застосувати команду# ~Застосувати команду~@ApplyCmd@ до вибраних файлів.

#Опис файлів# Додати ~описи~@FileDiz@ до вибраних файлів.

 #Позначити групу# Позначити задану маскою групу файлів.

 #Зняти позначку# Зняти позначку з відповідною заданою
 маски групи файлів.

 #Інверсія позначки# Інвертувати поточну позначку файлів.

 #Відновити позначку# Відновити попередню позначку після
 обробки файлів або операції позначки групи.

 Деякі команди цього меню також описані в темі
~Керування файлами та сервісні команди~@FuncCmd@.


@CmdMenu
$ #Меню команд#
 Пошук файлу Пошук файлів, що задовольняють заданій масці.
 Ця команда описана докладніше
у темі ~Пошук файлу~@FindFile@.

#Історія команд# Показати попередні команди. Ця команда
описано докладніше у темі ~Історія команд~@History@.

 #Відеорежим# Вибрати кількість рядків на екрані.

 Пошук папки Пошук папки в дереві папок.
 Додаткова інформація про цю команду
міститься в темі ~Пошук папки~@FindFolder@.

#Історія перегляду# Показати ~історію перегляду~@HistoryViews@ та редагування
 файлів.

#Історія папок# Показати ~історію зміни папок~@HistoryFolders@.

 Елементи історії перегляду та історії зміни
 папок після вибору пересуваються до кінця
списку. Ви можете використовувати #Shift-Enter#,
 щоб вибрати елемент без зміни його позиції.

 #Змінити панелі# Змінити ліву та праву панелі місцями.

 #Панелі Увімк./Вимк.# Показати/заховати обидві панелі.

 #Порівняння папок# Порівняти вміст папок.
 Додаткова інформація про цю команду
міститься в темі Порівняння папок @CompFolders@.

 #Меню користувача# Дозволяє редагувати головне або місцеве
~меню користувача~@UserMenu@. Для вставки пункту
 використовується #Ins#, для видалення - #Del#,
 для редагування – #F4#.

#Асоціації файлів# Показує список ~асоціацій файлів~@FileAssoc@.
 Для вставки нової асоціації може
 використовуватися #Ins#, для видалення - #Del#,
 для редагування – #F4#.

#Закладки# Показує поточні ~закладки~@Bookmarks@.

 #Фільтр панелі# Дозволяє керувати вмістом панелі файлів.
 #файлів# Додаткова інформація про цю команду
міститься в темі ~меню фільтрів~@FiltersMenu@.

 #Команда# Показує список доступних
#Зовнішніх модулів# ~Підключаються модулів~@Plugins@.

#Список екранів# Показує ~список відкритих екранів~@ScrSwitch@.

#Список задач# Показує ~список активних задач~@TaskList@.

#Список пристроїв# Показує ~список підключених пристроїв~@HotPlugList@.


@OptMenu
$ #Меню параметрів#
#Системні параметри# Викликає ~діалог системних параметрів~@SystemSettings@.

#Налаштування панелі# Викликає ~діалог налаштувань панелі~@PanelSettings@.

#Налаштування інтерфейсу# Викликає ~діалог налаштувань інтерфейсу~@InterfSettings@.

#Налаштування введення#      Викликає ~діалог налаштувань введення~@InputSettings@.

#Налаштування діалогів# Викликає ~діалог налаштувань діалогів~@DialogSettings@

#Налаштування меню# Викликає ~діалог налаштувань меню~@VMenuSettings@

#Налаштування командної# Викликає ~діалог налаштувань командного рядка~@CmdlineSettings@
 #рядки#

 # Мови # Вибір основної мови та мови допомоги.
 Використовуйте команду "Зберегти параметри",
 щоб зберегти вибрані мови.

 #Параметри# Налаштування параметрів, що підключаються
#Зовнішні модулі# ~Зовнішні модулі~@Plugins@.

#Підтвердження# Увімкнення або вимкнення ~підтверджень~@ConfirmDlg@
 для деяких операцій.

#Режими панелі# ~Налаштування режимів перегляду~@PanelViewModes@ панелі файлів.
 #файлів#

#Опис файлів# Режими оновлення та імена ~описів файлів~@FileDiz@.

#Файли опису# Імена або маски файлів~@FileMasks@, що відображаються
#папок# в ~панелі інформації~@InfoPanel@ як опис
 папки.

#Налаштування програми# ~Налаштування зовнішньої програми перегляду~@ViewerSettings@.
 #перегляду#

#Налаштування редактора# ~Налаштування зовнішнього та вбудованого редактора~@EditorSettings@.

 #Квіти# Зміна кольору різних елементів
 інтерфейсу або зміна всієї палітри кольорів
 або на чорно-білу, або на пропоновану
 за замовчуванням.

 #Розмальовка файлів# Редагування
#і групи сортування# ~розмальовки файлів та груп сортування~@Highlight@.

 #Зберегти параметри# Збереження поточної конфігурації, кольорів
 та зовнішнього вигляду екрана.

@Terminal
$ #Термінал
 #FAR2L# містить вбудований емулятор терміналу, що дозволяє виконувати програми командного рядка та керувати ними, спостерігаючи їх виведення.
Для дотримання звичного досвіду користувача far2l запускає додатки всередині піддерюваної інтерактивної оболонки командного рядка.
#Автодоповнення# FAR2L має два незалежні механізми автоматичного доповнення командного рядка. Перший є механізмом автодоповнення,
реалізованому в оригінальному FAR і працює пропонуючи меню варіантів поки ви друкуєте команди. Другий працює на основі механізму автодоповнення
командної оболонки bash може бути активований натисканням #SHIFT+подвійний-TAB# (швидко двічі натиснути TAB при натиснутому SHIFT).
 #Поведінка команди exit:# введення команди 'exit' призведе до закриття оболонки командного рядка, але не закриє сам додаток far2l, а наступний
запуск іншої команди запустить нову оболонку. Це дозволяє 'скинути' оточення оболонки від змінених змінних оболонки та інших її налаштувань.
Якщо ж ви хочете закрити far2l з командного рядка: надрукуйте псевдокоманду 'exit far' - вона буде розпізнана як far2l команда закриття.
 #Кнопосполучення та скролінг під час виконання команди:# ви можете використовувати кнопкосполучення Ctrl+Shift+F3 щоб відкрити історію
виводу терміналу у вбудованому переглядачі або #Ctrl+Shift+F4# – щоб відкрити її у вбудованому редакторі. Це дозволяє ефективно досліджувати
виведення команд, використовуючи можливості вбудованого переглядача і редактора, такі як скролінг, пошук підрядків і т.п. Ви також можете відкрити
браузер проскромливий мишкою вгору і закрити його проскроллів потім в самий кінець історії.
Кнопкосполучення #Ctrl+C, Ctrl+Z# викликають стандартні сигнали, до речі у разі повного зависання команди з ігноруванням стандартних сигналів
ви можете вбити все запущене в оболонці, натиснувши #Ctrl+Alt+C#. Врахуйте що не рекомендується зловживати даним кнопком поєднанням так як воно може
викликати пошкодження або збереження даних вбитої програми. Якщо far2l працює в TTY, то ви також можете використовувати поєднання #Ctrl+Alt+Z# щоб помістити far2l у фон, звільнивши термінал, але продовжуючи виконувати поточну команду.
 #Кнопкосполучення та скролінг НЕ під час виконання команди:# хоча вищеописані #Ctrl+Shift+F3/F4# так само функціонують у такому режимі ви можете
замість них використати просто #F3/F4#. Також ви можете використовувати кнопку #F8# щоб очистити буфер історії та екран. Перемикання між терміналом та
панелями можливо натисканням поєднання #Ctrl+O# або клацанням по лівому верхньому куті вікна.
 #Розширення терміналу FAR2L# хоча FAR2L сам по собі це додаток текстового режиму, воно може працювати в режимі виведення через підсистему
~GUI або TTY (термінал)~@UIBackends@. Хоча TTY режим може функціонувати у звичайному терміналі, як xterm або терміналі клієнта SSH сесії,
але він також може працювати всередині терміналу іншого far2l, отримуючи від цього додаткові можливості, недоступні під 'звичайними' терміналами,
такі як розпізнавання всіх кнопок клавіатури та подій натискання/відпускання кнопок. Також 'хостовий' far2l може надавати доступ до буфера
обміну хоста та механізм повідомлень робочого столу. Ви можете використовувати цю функціональність, запускаючи TTY far2l на SSH сервері всередині SSH сесії
клієнта, запущеного всередині терміналу far2l, що працює в режимі GUI на хості клієнта. Або, що набагато простіше, використовуючи плагін із можливістю
запуску команд на віддаленому SSH сервері. Прикладом такого плагіна є NetRocks, а точніше протоколи, що підтримуються ним SFTP/SCP.

  Виділений мишею текст автоматично копіюється у буфер обміну

  Previous command                                          #Up, Ctrl-E#
  Next command                                            #Down, Ctrl-X#
  Clear command line                                            #Ctrl-Y#
    (see also ~Keyboard reference of Command line~@CmdLineCmd@)

  Autocomplete (FAR2L mechanisms)                                  #Tab#
  Autocomplete (bash mechanisms)                         #Shift-Tab-Tab#

  Hide/show both panels                                         #Ctrl-O#
  Hide/show left panel                                         #Ctrl-F1#
  Hide/show right panel                                        #Ctrl-F2#

  Insert current file name from the active panel            #Ctrl-Enter#
  Insert current file name from the passive panel     #Ctrl-Shift-Enter#
  Insert full file name from the active panel                   #Ctrl-F#
  Insert full file name from the passive panel                  #Ctrl-;#

  Terminal->Viewer                                   #F3, Ctrl+Shift+F3#
    (all terminal output history in built-in Viewer - useful for scrolling of long output)

  Terminal->Editor                                   #F4, Ctrl+Shift+F4#
    (all terminal output history in built-in Editor)

  Cleanup terminal history and screen                               #F8#

  Usual signals                                         #Ctrl+C, Ctrl+Z#

  Hard kill everything in shell                             #Ctrl+Alt+C#
    (not recommended, it may cause corruption or lost of unsaved data)

  Put far2l instance to background                          #Ctrl+Alt+Z#
    (only if far2l works in TTY backend)


@UIBackends
$ #Режими інтерфейсу
 Залежно від налаштувань білда та доступних можливостей платформи #FAR2L# може виводити
свій інтерфейс використовуючи такі режими:

 - #Режим GUI:# виводить інтерфейс у своє власне графічне вікно, забезпечуючи найповнішу
підтримка клавіатурних комбінацій.
- #Режим TTY:# виводить інтерфейс у стандартний термінал. Це найбільш сумісний спосіб, але він надає
найменш повну підтримку клавіатурних комбінацій, немає загального буфера обміну тощо.
 - #Режим TTY|X:# виводить інтерфейс у звичайний термінал, але використовує X11 для доступу до буфера обміну та для отримання
станів клавіш-модифікаторів Це забезпечує більш зручне використання, але все ще деякі клавіатурні
комбінації можуть не підтримуватись.
 - #Режим TTY|Xi:# виводить інтерфейс у звичайний термінал, але використовує X11 з розширеннями Xi для доступу до буфера обміну
та для отримання станів усіх клавіш клавіатури. Це забезпечує найзручніше використання у звичайному терміналі.
- #Режим TTY|F:# виводить інтерфейс термінал створений іншим додатком far2l instance. Це забезпечує рівень
зручність використання аналогічний режиму GUI (якщо термінал наданий GUI версією far2l).

 Якщо ви хочете запустити far2l віддалено з максимальною зручністю, то рекомендується або запустити його із сесії
підключення NetRocks, що дозволяє використовувати режим TTY|F. Якщо це неможливо - рекомендується запускати far2l
у SSH сесії з включеним довіреним форвардингом протоколу X11 та стисненням (ssh-Y-C...) що дозволяє використовувати
режим TTY | Xi або хоча б TTY | X. При цьому
Вкрай не рекомендується використовувати довірений форвардинг X11 при підключенні до не довіреного сервера,
оскільки це відкриває коду, що виконується на віддаленому сервері, неконтрольовану можливість прослуховування ваших
клавіатурних натискань, копіювання вмісту буфера обміну та скріншотів вікон. Таким чином, TTY | F режим є
єдиним безпечним методом віддаленого запуску far2l на не довіреному сервері з підтримкою всіх звичних
клавіатурних поєднань та інших зручностей.


@ConfirmDlg
$ #Підтвердження#
 У діалозі "Підтвердження" ви можете дозволити або заборонити
підтвердження для наступних операцій:

 - перезаписування файлів під час копіювання;

 - перезаписування файлів під час перенесення;

 - перезаписування та видалення файлів з атрибутом "тільки для читання";

- ~перетягування~@DragAndDrop@ файлів;

 - Видалення файлів;

 - Видалення папок;

 - переривання операцій (натиснули клавішу #Esc#);

- ~відключення мережевого пристрою~@DisconnectDrive@ з меню дисків;

 - ачыстка экрана і гісторыі тэрмінала націскам F8;

 - відключення накопичувачів для USB з меню дисків;

- ~повторне відкриття~@EditorReload@ файлу в редакторі;

 - очищення списку історій редагування/перегляду, переходів та
 виконаних команд;

 - Вихід з FAR2L.


@PluginsManagerSettings
$ #Менеджер зовнішніх модулів#

 #Шлях до персональних плагінів#
Вкажіть повний шлях, де FAR2L шукатиме "персональні" плагіни на додаток до "основних". Можна вказати
кілька шляхів пошуку, розділених символом ';'. Якщо вказати шлях пошуку, можна використовувати змінні середовища.
Персональні плагіни не завантажуватимуться, якщо в параметрах ~командного рядка~@CmdLine@ вказано один із ключів /p або /co.


@ChoosePluginMenu
$ #Меню вибору плагіна#


@MakeFolder
$ #Створення папки#
Ця функція використовується для створення папок. Ви можете використовувати змінні
оточення в рядку введення, які перед створенням папки перетворюються на
що міститься у ній значення. Також існує можливість створювати декілька
вкладених папок за один раз: для цього відокремте імена папок один від одного
символом "\". Наприклад:

 #%USERDOMAIN%\\USERNAME%\\Папка3#

 Якщо увімкнено опцію "#Обробляти кілька імен папок#", то можна
створювати кілька папок за один раз. У цьому випадку імена папок мають бути
розділені символом-розділювачем "#; #" або "#, #". Якщо ця опція включена та ім'я
папки містить у собі символ "#;#" (або "#,#"), то воно має бути взяте в
лапки. Наприклад, якщо буде введено #C:\\Foo1;"E:\\foo,2;";D:\\foo3#, то
будуть створені папки з іменами: "#C:\\Foo1#", "#E:\\foo,2;#" та "#D:\\foo3#".


@FindFile
$ #Пошук файлу #
 Ця команда призначена для пошуку одного або декількох файлів та папок у
дереві папок, відповідно до однієї або кількох розділених комами або
точкою з комою ~масками~@FileMasks@. Також вона може бути використана з
файловими системами, що підтримуються за допомогою ~зовнішніх модулів~@Plugins@.

 Додатково може бути вказаний текст, який повинен утримуватися в
шуканих файлів. У цьому випадку параметр "Враховувати регістр" може бути
використано для проведення реєстрозалежного пошуку.

 Параметр #Тільки цілі слова# дозволить шукати лише текст, який відокремлений
від решти тексту пробілом, знаком табуляції, повернення каретки, перекладу
рядки або стандартними роздільниками:
#!%^&*()+|{}:"<>?`-=\\[];',./#.

 Встановлення параметра #Шукати 16-річний код# дозволяє шукати файли,
що містять шістнадцяткову послідовність введених байт. В цьому випадку
параметри #Враховувати регістр#, #Тільки цілі слова#, #Використовуючи кодову сторінку#
і #Шукати папки# блокуються та їх значення на процес пошуку не
впливають.

 Список, що випадає #Використовуючи кодову сторінку# дозволяє вибрати конкретну
кодову сторінку, яка використовується для пошуку тексту. Якщо у списку вибрати
пункт #Всі ​​кодові сторінки#, то FAR2L використовуватиме для пошуку всі стандартні
та #Улюблені# кодові сторінки (список #Улюблених# кодових сторінок можна налаштувати в
меню вибору кодової сторінки редактора або програми перегляду). Якщо список
кодових сторінок, пошук за якими проводиться при виборі пункту # Усі кодові #
#сторінки#, є для вас надлишковим, то ви можете за допомогою клавіш #Ins# і
#Space#, вибрати зі списку стандартних та #Улюблених# кодових сторінок тільки ті кодові
сторінки, якими вам необхідно здійснювати пошук.

Для пошуку файлів та в архівах потрібно встановити опцію #Шукати в архівах#. В
водночас, це суттєво уповільнює виконання операції.
 Пошук у вкладених архівах не провадиться.

 Параметр #Шукати папки# дозволяє включати до списку пошуку папки,
збігаються з маскою пошуку. При цьому лічильник знайдених файлів враховує також
та знайдені папки.

 Параметр #Шукати у символічних посиланнях# дозволяє шукати файли в
~символічні посилання~@HardSymLink@ нарівні зі звичайними підкаталогами.

 Пошук може виконуватись:

 - на всіх дисках, крім змінних;

 - на всіх локальних дисках, крім змінних та мережевих;

 - у всіх папках, перерахованих у змінній оточенні %PATH%
 (без вкладених папок);

 - у всіх папках, починаючи з кореневої, у діалозі пошуку
 можна вибрати диск пошуку (кнопка "Диск");

 - у всіх папках, починаючи з поточної папки;

 - лише у поточній папці;

 - у зазначених папках.

 Параметри пошуку зберігаються в конфігурації.

 Для пошуку файлів, які підпадають під певні умови, використовуйте перемикач
#Використовувати фільтр#. Налаштування умов ~фільтру~@FiltersMenu@ здійснюється
кнопкою "Фільтр".

 За допомогою кнопки #Додатково# викликається діалог налаштування
~додаткові параметри пошуку~@FindFileAdvanced@, які використовуються для
налаштування розширеного набору властивостей пошуку.


@FindFileAdvanced
$ #Додаткові параметри пошуку#
 Введена в поле #містять текст# (або в полі #містять 16-річний код#)
рядок тексту може розшукуватися не тільки у всьому файлі, але також у заданому
початковому діапазоні, що визначається властивістю #Проводити пошук у перших#.
Якщо встановлено значення, яке менше розміру файлу, то залишок файлу
буде ігноруватися, навіть якщо шукана послідовність там буде.

 При заданні розміру можна використовувати такі суфікси:
 B – для байтів (так само без суфікса);
 K – для кілобайтів;
 M – для мегабайтів;
 G – для гігабайтів;
 T – для терабайтів;
 P – для петабайтів;
 E – для ексабайтів.

 #Обробляти альтернативні потоки даних# - крім основного потоку даних
(що представляє собою безпосередньо вміст файлу)
здійснювати пошук також у альтернативних іменованих потоках, які підтримуються деякими
файлових систем (наприклад, #NTFS#).

 # Типи колонок # - дозволяє задавати формат виведення результатів пошуку.
Типи колонок кодуються за допомогою однієї або декількох літер, розділених комами.
Допускаються такі типи колонок:

 S[C,T,F,E] - розмір файлу
 P[C,T,F,E] - упакований розмір файлу
 G[C,T,F,E] - розмір потоків файлу
 де: C – форматувати розмір файлу;
 T - використовувати 1000 замість 1024 як дільник;
 F - відображати розмір файлу в стилі Windows
 Explorer (тобто 999 байт будуть показані
 як 999, а 1000 б як 0.97 K);
 E - економічний режим, не показувати пробіл
 перед суфіксом розміру файлу
 (тобто 0.97KB);

 D - дата останнього запису у файл
 T - час останнього запису у файл

 DM[B,M] - дата і час останнього запису файл
 DC[B,M] - дата та час створення файлу
 DA[B,M] - дата та час останнього доступу до файлу
 DE[B,M] - дата та час зміни файлу
 де: B – короткий (Unix-стиль) формат часу файлу;
 M – використання текстових імен місяців;

 A – атрибути файлу

 LN - кількість жорстких посилань

 F – кількість потоків


 Атрибути файлу мають такі позначення:

 #R# - Тільки для читання
 #S# - Системний
 #H# - Прихований
 #A# - Архівний
 #L# - Зв'язок або символічне посилання
 #C# або #E# - Стиснутий або Зашифрований
 #$# - Розріджений (sparse)
 #T# - Тимчасовий
 #I# - Неіндексований за вмістом
 #O# - Автономний (offline)
 #V# - Віртуальний

Порядок відображення атрибутів – RSHALCTIOV. Символ атрибуту
"Розріджений" використовується тільки для файлів і ставиться замість 'L'.
Символ атрибута "Зашифроване" ставиться замість 'C', т.к. файл/каталог не
можуть мати одночасно обидва атрибути ("Стиснутий" і "Зашифрований"). за
за замовчуванням розмір колонки атрибутів – 6 символів. Для відображення
додаткових атрибутів 'T', 'I', 'O' та 'V' необхідно явно вказати
розмір колонки 10 символів.

 #Ширина колонок# - дозволяє змінити ширину колонок результатів пошуку.
Якщо ширина дорівнює 0, використовується значення за замовчуванням.

 Для використання 12-годинного формату часу треба збільшити
на одиницю стандартну ширину колонки часу файлу або колонки
часу та дати файлу. Після подальшого збільшення у цих колонках
також будуть показані секунди та мілісекунди.

 Для показу року у 4-х символьному форматі потрібно збільшити ширину
стовпчика дати на 2.

 На відміну від режимів панелей, результат пошуку може містити лише
одну колонку. Ім'я файлу є завжди - додається останньою колонкою
автоматично.

 При вказівці колонок, що відповідають за показ посилань та потоків (G, LN, та F) час
пошуку збільшується.

 Щоб у результатах пошуку відображати лише імена файлових об'єктів без
додаткових атрибутів, залиште поле "Типи стовпчиків" порожнім.

 За промовчанням значення полів рівні:
 "Типи колонок" - D,S,A
 "Ширина колонок" – 14,13,0


@FindFileResult
$ #Пошук файлу: клавіші керування#
Під час або після завершення ~пошуку~@FindFile@ ви можете використовувати
клавіші управління курсором для пересування по списку файлів та кнопки для
виконання необхідних дій.

 Під час або після завершення пошуку доступні такі кнопки:

 #Новий пошук# Почати нову операцію пошуку.

 #Перейти# Перервати пошук, змінити поточну папку та помістити
 курсор на вибраний файл.

 #Дивитись# Перегляд вибраного файлу без переривання пошуку.

 #Панель# Створити тимчасову панель та заповнити її знайденими
 файлами.

# Стоп # Перервати пошук. Доступна під час пошуку.

 #Скасувати# Перервати пошук та закрити діалог.

 Для перегляду та редагування знайдених файлів можуть бути використані
#F3# та #F4#. Редагування та перегляд підтримуються також для файлових систем
модулів, що підключаються. Зауважте, що збереження змін у редакторі за клавішею
#F2# для файлових систем модулів, що підключаються, буде викликати операцію
#Зберегти замість звичайного #Зберегти#.


@FindFolder
$ #Пошук папки#
 Ця команда призначена для швидкого пошуку потрібної папки у дереві папок.

 Для вибору папки можна використовувати клавіші керування курсором або
набрати кілька початкових символів імені папки.

 Натисніть #Enter#, щоб перейти до вибраної папки.

 #Ctrl-R# і #F2# дозволяють перечитати дерево папок.

 #Gray +# і #Gray -# використовуються для швидкого переміщення вгору або вниз
за папками одного рівня.

 #F5# дозволяє розгорнути вікно на весь екран, повторне натискання #F5# поверне
розмір вікна у початковий стан.

 За допомогою #Ctrl-Enter# можна циклічно переміщатися елементами дерева в
відповідно до введеної у рядку файлової маски. #Ctrl-Shift-Enter# дозволяє
переміщатися елементами у зворотному напрямку.

також список ~макроклавіш~@KeyMacroFindFolderList@, доступних у пошуку папок.

@Filter
$ #Фільтр#
 Фільтр служить для обробки певних груп файлів за заданими
користувачем параметрів, за дотримання яких файл буде оброблений
використовує його операцією. Фільтр може налаштовуватися за різними типами
параметрів.

 Діалог фільтра складається з наступних елементів:

 #Ім'я фільтра# Назва, яка відображатиметься у списку
фільтрів. Ви можете залишити це поле порожнім.

 Цей елемент відсутній, якщо фільтр викликаний
з команди ~Розмальовка файлів та групи сортування~@Highlight@.


#Маска# Одна або кілька масок файлів~@FileMasks@.

 Файл потрапляє до умов фільтра, якщо увімкнено
 аналіз масок файлу та його ім'я відповідає хоча б
одній масці. Якщо аналіз масок вимкнено, ім'я
 файлу немає значення.


 #Розмір# Мінімальний та максимальний розмір файлу.
 При заданні розміру можна використовувати такі суфікси:
 B або без суфікса – для байтів;
 K – для кілобайтів;
 M – для мегабайтів;
 G – для гігабайтів;
 T – для терабайтів;
 P – для петабайтів;
 E – для ексабайтів.

 Файл потрапляє до умов фільтра, якщо увімкнено
 аналіз розміру файлу і він входить до введеного
діапазон. Якщо в якості однієї або обох кордонів
 діапазону нічого не введено (порожній рядок), тоді
 розмір за цією умовою не обмежується.

 Наприклад:
 >= 1K - вибрати файли більші або рівні 1 кілобайт
 <= 1M – до менше або рівні 1 мегабайт


 #Дата/час# Дата/час початку та закінчення дії фільтра.
 Можна вказати дату останнього #запису#, дату
 #створення# файлу, дату останнього #доступу# або
 дату #зміни#.

 Кнопка "Поточна" дозволяє заповнити поля часу
 файлу поточним часом, після чого ви можете
 змінити окрему складову дати та часу,
 наприклад, тільки місяць або тільки хвилини.
 #Скинути#, щоб очистити поля з датами та часом.

 Файл потрапляє до умов фільтра, якщо увімкнено
 аналіз дати файлу і вона потрапляє до введеного
 діапазон та відповідає встановленому типу.
 Якщо одне чи обидва поля з датами порожнє, тоді дата
 з цього поля не обмежується.

 Наприклад:
 <= 31.01.2010 - вибрати файли в період до 31 числа
 >= 01.01.2010 - але після 1 січня 2010 року

 Опція Відносна дозволяє переключитися
 на роботу з датою у відносному часі.
 Логіка роботи за даної опції аналогічна
 арифметиці із негативними числами.

 Наприклад:
 <= 0 - вибрати файли в період від "сьогодні"
 >= 30 - і до 30 днів тому включно

 # Атрибути # Атрибути включення та атрибути виключення.

 Файл потрапляє до умов фільтра, якщо увімкнено
 аналіз атрибутів файлу і він має всі атрибути
 включення та не має атрибутів виключення:
 #[x]# - атрибут включення - файл повинен мати
 вказаний атрибут.
 #[ ]# - атрибут виключення - файл не повинен мати
 вказаний атрибут.
 #[?]# - цей атрибут не впливає на фільтр.

 Атрибути #Стиснутий#, #Зашифрований#, #Неіндексований#,
 #Розріджений#, #Тимчасовий# та #Автономний# використовуються
тільки на дисках із файловою системою NTFS. Атрибут
 #Віртуальний# не використовується у Windows 2000/XP/2003.

 Для швидкого вимкнення однієї або декількох умов фільтра вимкніть
відповідні опції. Клавіша Очистити скине всі умови фільтра.

@History
$ #Історія команд#
Історія команд показує список раніше виконаних команд. Окрім клавіш
керування курсором доступні такі клавіші:

 Повторно виконати команду #Enter#

 Повторно виконати команду в окремому вікні #Shift-Enter#

 Повторно виконати команду від імені адміністратора #Ctrl-Alt-Enter#

 Помістити команду до командного рядка #Ctrl-Enter#

 Очистити історію команд #Del#

 Встановити/зняти позначку блокування пункт історії #Ins#

 Очистити поточний пункт історії #Shift-Del#

 Копіювати вміст поточної позиції історії #Ctrl-C#
 в Буфер Обміну не закриваючи списку або #Ctrl-Ins#

 Toggle to quick filtering                                #Ctrl-Alt-F#
  (shows only items containing the typing text)

 Для переходу до попередньої або наступної команди безпосередньо з
командного рядка, можна використовувати клавіші #Ctrl-E# або #Ctrl-X#
відповідно.

 Для вибору команди також можна використовувати літери, що підсвічуються.

 Щоб зберегти історію команд після виходу, використовуйте відповідну
опцію з ~діалогу системних параметрів~@SystemSettings@.

 Зазначені пункти не видалятимуться при очищенні історії.

 For automatic exclusion from history, see ~діалогу Налаштування автозавершення та історії~@AutoCompleteSettings@.

@HistoryViews
$ #Історія перегляду та редагування#
 Історія перегляду та редагування файлів показує список переглянутих
або редагованих раніше файлів. Крім клавіш керування курсором доступні
наступні клавіші:

 Повторно відкрити файл для перегляду #Enter#
 або редагування

 Помістити ім'я файлу у командний рядок #Ctrl-Enter#

 Очистити список історії #Del#

 Очистити поточний пункт історії #Shift-Del#

 Встановити/зняти позначку блокування пункт історії #Ins#

 Оновити список, видаляючи недоступні файли #Ctrl-R#

 Копіювати вміст поточної позиції історії #Ctrl-C#
 в Буфер Обміну не закриваючи списку або #Ctrl-Ins#

 Toggle to quick filtering                                #Ctrl-Alt-F#
  (shows only items containing the typing text)

Відкрити файл у ~редакторі~@Editor@ #F4#

Відкрити файл у ~програмі перегляду~@Viewer@ #F3#
 або #Numpad 5#

 Також можна використовувати підсвічені літери, щоб вибрати пункт у списку історії.

 Елементи історії перегляду та редагування після вибору пересуваються в
кінець списку. Ви можете використовувати #Shift-Enter#, щоб вибрати елемент без
зміни його позиції.

 Для збереження історії перегляду та редагування файлів після
виходу, використовуйте відповідні опції з діалогу ~системних параметрів~@SystemSettings@.

 Примітки:

 1. ^<wrap>Операція оновлення списку (Ctrl-R) може зайняти значний час,
якщо файл знаходився на недоступному на даний момент мережному ресурсі.

 2. ^<wrap>Зазначені пункти не видалятимуться під час очищення або оновлення історії.

@HistoryFolders
$ #Історія зміни папок#
Історія зміни папок показує список папок, що раніше відвідувалися. Окрім клавіш
керування курсором доступні такі клавіші:

 Перейти до вказаної папки #Enter#

 Перейти до вказаної папки на пасивній панелі #Ctrl-Shift-Enter#

 Помістити ім'я папки у командний рядок #Ctrl-Enter#

 Очистити список історії #Del#

 Очистити поточний пункт історії #Shift-Del#

 Встановити/зняти позначку блокування пункт історії #Ins#

 Оновити список, видаляючи недоступні папки #Ctrl-R#

 Копіювати вміст поточної позиції історії #Ctrl-C#
 в Буфер Обміну не закриваючи списку або #Ctrl-Ins#

 Toggle to quick filtering                                #Ctrl-Alt-F#
  (shows only items containing the typing text)

 Також можна використовувати підсвічені літери, щоб вибрати пункт у списку історії.

Елементи історії зміни папок після вибору пересуваються до кінця списку. Ви
Ви можете використовувати #Shift-Enter#, щоб вибрати елемент без зміни його позиції.

 Щоб зберегти історію зміни папок після виходу, використовуйте
відповідну опцію з діалогу ~системних параметрів~@SystemSettings@.

 Примітки:

 1. ^<wrap>Операція оновлення списку (Ctrl-R) може зайняти значний час,
якщо каталог знаходився на недоступному в даний момент мережному ресурсі.

 2. ^<wrap>Зазначені пункти не видалятимуться під час очищення або оновлення історії.

@TaskList
$ #Список задач#
Список задач показує активні завдання. Кожен рядок
Список містить заголовок вікна завдання.

 Зі списку завдань можна перейти на вікно завдання або видалити завдання,
використовуючи клавішу #Del#. Будьте обережні з видаленням завдань. Ця операція
виконується негайно і будь-яка незбережена інформація цієї задачі буде
втрачено. Тому видалення завдань має використовуватися тільки за
необхідності, наприклад, якщо програма перестала відповідати на запити
користувача.

Список завдань може бути викликаний або з ~Меню команд~@CmdMenu@, або
використовуючи #Ctrl-W#. В останньому випадку список завдань також може бути викликаний
програми перегляду чи редактора.

 #Ctrl-R# дозволяє оновити список завдань.


@HotPlugList
$ #Список Hotplug-пристроїв#
 Список Hotplug-пристроїв показує плати PC Card та інші аналогічні
пристрої, встановлені та працюють на комп'ютері.

 Щоб видалити пристрій, необхідно вибрати пристрій у списку та натиснути
клавішу # Del #. Після цього Windows готує пристрій до безпечного
витягу. Після закінчення операції користувачеві виводиться повідомлення про
можливості вилучення пристрою.

 #Ctrl-R# дозволяє оновити список підключених пристроїв.


@CompFolders
$ #Порівняння папок#
 Команду порівняння папок можна виконувати лише коли обидві панелі на екрані
є ~панелями файлів~@FilePanel@. Вона порівнює вміст відображуваних у
цих панелях папок. Файли, які присутні лише в одній панелі, або
файли з пізнішою датою запису, ніж у файлів з тим самим ім'ям в інший
панелі, стають поміченими.

Вкладені папки не порівнюються. Для порівняння файлів використовується їхнє ім'я,
дата та час, але не вміст.


@UserMenu
$ #Меню користувача#
 Меню користувача призначене для спрощення виконання часто використовуваних
операцій. Воно містить задані користувачем команди та послідовності
команд, які можуть бути виконані за допомогою цього меню. Меню
користувача може містити вкладені меню. Спеціальні
~метасимволи~@MetaSymbols@ підтримуються і в командах, і в заголовках команд
меню. Зверніть увагу, що символ!?<title>?<init>! може бути використаний
для введення додаткових параметрів перед виконанням команди.

 Для редагування або створення головного або місцевого меню користувача
застосовується команда #Меню користувача# з ~Меню команд~@CmdMenu@. Головне меню
користувача може бути лише одне. Головне меню викликається у тому випадку, якщо
для поточної папки немає місцевого меню. Місцеве меню може бути розташоване
у будь-якій папці. Ви можете в будь-який момент переключитися між місцевим меню та
головним меню за допомогою клавіш Shift-F2 #. Ви також можете викликати місцеве меню
з батьківської папки за допомогою кнопки #BkSpace#.

 Для додавання роздільника в меню користувача потрібно
додати новий пункт меню (команду), в якому як "Гаряча клавіша"
вказати "--". Видалити такий роздільник можна лише через #Ctrl-F4#.

 Для виконання команди з меню користувача потрібно вибрати її за допомогою
клавіш управління курсором та натиснути #Enter#. Також можна використовувати
призначену для цього пункту меню # гарячу клавішу #.

 Ви можете видалити вкладене меню або пункт меню за допомогою клавіші #Del#,
вставити нове вкладене меню або пункт меню за допомогою #Ins# та редагувати
існуюче вкладене меню або пункт меню за допомогою #F4#. Натисніть #Ctrl-F4# для
редагування меню як текстового файла.

 Як гарячі клавіші для звернення до пунктів меню можуть використовуватися
цифри, літери та функціональні клавіші (#F1#..#F24#). Якщо використані #F1# та #F4#,
їх початкові функції губляться. У цьому випадку для редагування меню може
застосовуватися # Shift-F4 #.

 Під час редагування або створення пункту меню необхідно ввести заголовок пункту,
який буде відображатися в меню, послідовність команд, що виконуються при
вибору даного пункту меню, та, при необхідності, гарячу клавішу для швидкого
доступу до цього пункту.

 У разі редагування або створення вкладеного меню достатньо ввести заголовок
вкладеного меню та, при необхідності, гарячу клавішу.

Місцеві меню зберігаються у текстових файлах #FarMenu.Ini#. Головне меню з
за замовчуванням зберігається в Реєстрі, але його також можна тримати у файлі. Якщо створити
місцеве меню в папці FAR2L, то воно буде використане замість того, що зберігається в
Реєстр головного меню.

 Ви можете закрити меню на будь-якому рівні вкладеності, натиснувши #Shift-F10#.

також список ~макроклавіш~@KeyMacroUserMenuList@, доступних у меню користувача.

@FileAssoc
$ #Асоціації файлів#
 FAR2L підтримує асоціацію файлів, які дозволяють задавати
різноманітні дії для запуску, редагування та перегляду файлів, заданих
~маскою~@FileMasks@.

 Ви можете додати нові асоціації за допомогою команди #Асоціації файлів
~Меню команд~@CmdMenu@.

 Ви можете задати кілька асоціацій для одного типу файлів та вибирати
бажану асоціацію з меню.

 У списку асоціацій доступні такі дії:

#Ins# - ~додати~@FileAssocModify@ нову асоціацію

#F4# - ~змінити~@FileAssocModify@ налаштування поточної асоціації

 #Del# - видалити поточну асоціацію

 #Ctrl-Up# - пересунути асоціацію нагору

 #Ctrl-Down# - пересунути асоціацію вниз

 Якщо для цього файлу відсутні асоційовані команди запуску та
встановлено параметр #Використовувати стандартні типи# в ~Системних параметрах~@SystemSettings@,
FAR2L намагається використовувати асоціації Windows для запуску цього типу
файлів.


@FileAssocModify
$ #Налаштування асоціації файлів#
 FAR2L дозволяє задати шість команд, асоційованих з певним типом
файлу, заданим ~маскою~@FileMasks@:

 #Команда запуску по Enter# Виконується при натисканні #Enter#

 #Команда запуску за Ctrl-PgDn# Виконується при натисканні #Ctrl-PgDn#

 #Команда перегляду# Виконується при натисканні #F3#

 #Альтернативна команда# Виконується при натисканні #Alt-F3#
 #перегляду#

 #Команда редагування# Виконується при натисканні #F4#

 #Альтернативна команда# Виконується при натисканні #Alt-F4#
 #редагування#

 Асоціацію можна описати в полі Опис асоціації.

 Якщо ви не бажаєте, щоб перед виконанням асоційованої команди гасилися
панелі, почніть команду із символу '#@@#'.

 В асоційованих командах можуть використовуватись спеціальні
~метасимволи~@MetaSymbols@.

 Примітки:

 1. ^<wrap>Якщо для цього файлу відсутні асоційовані команди
запуску та встановлено параметр #Використовувати стандартні типи#
у ~Системних параметрах~@SystemSettings@, то FAR2L намагається використовувати
Windows для запуску цього типу файлів.

2. ^<wrap>~Команди~@OSCommands@ операційної системи "IF EXIST" та "IF DEFINED"
дозволяють зробити асоціації "розумнішими" - якщо ви призначили кілька
асоціацій для одного типу файлів, то в меню потраплять ті асоціації,
у яких умови виконуватимуться.

@MetaSymbols
$ #Метасимволи#
У ~асоційованих командах~@FileAssoc@, ~користувацького меню~@UserMenu@
та команді ~"Застосувати команду"~@ApplyCmd@ можуть використовуватися спеціальні
метасимволи:

 #!!# символ '!'
 #!# Довге ім'я файлу без розширення
 #!~~# Коротке ім'я файлу без розширення
 #!`# Довге розширення файлу без імені (ext)
 #!`~~# Коротке розширення файлу без імені (ext)
 #!.!# Довге ім'я файлу з розширенням
 #!-!# Коротке ім'я файлу з розширенням
 #!+!# Аналогічно !-!, але якщо довге ім'я файлу втрачено
 після виконання команди FAR2L відновить його
# !@ @!# Ім'я файлу, що містить імена позначених файлів
 #!$!# Ім'я файлу, що містить короткі імена позначених файлів
 #!  Список помічених файлів
 #!&~~# Список помічених файлів з короткими іменами
 #!:# Поточний диск у форматі "C:"
 Для мережевих каталогів - "\\\server\share"
 #!\\# Поточний шлях
 #!/# Коротке ім'я поточного шляху
#!=\\# Поточний шлях з урахуванням ~символічних посилань~@HardSymLink@.
#!=/# Коротке ім'я поточного шляху з урахуванням ~символічних посилань~@HardSymLink@.

 #!?<title>?<init>!#
 Під час виконання команди цей символ замінюється
даними, введеними користувачем. <title> та
 <init> - заголовок та вихідний текст рядка
 редагування.

 Допускається використання кількох таких символів
 в одному рядку, наприклад:

grep !?Search for:?! !?In:?*.*!|c:\far\\far.exe -v -

 У <title> можна вказати ім'я історії для рядка <init>.
 У цьому випадку команда має такий формат:

 #!?$<history>$<title>?<init>!#

 наприклад:

grep !?#$GrepHist$#Search for:?! !?In:?*.*!|far.exe -v -

 У <title> та <init> допускається використання інших
 метасимволів, уклавши їх у круглі операторні дужки,
 наприклад:

grep !?В (!.!) знайти:?! |far.exe -v -

 #!### Префікс "!##", вказаний перед символом асоціації
 файлу, змушує його (і всі наступні) посилатися
 на пасивну панель (див. примітку 4).
Наприклад, !##!.! позначає ім'я поточного файлу на
 пасивної панелі.

 #!^# Префікс "!^", вказаний перед символом асоціації
 файлу, змушує його (і всі наступні) посилатися
 на активну панель (див. примітку 4).
Наприклад, !^!.! позначає ім'я поточного файлу на
активної панелі, а конструкція !##!\\!^!.! - файл на
 пасивної панелі з таким самим ім'ям, як ім'я поточного
 файлу на активній панелі.

 Примітки:

 1. ^<wrap>FAR2L під час обробки метасимволів підставляється лише те, що вони означають
(ім'я файлу, розширення тощо). Жодних додаткових символів (наприклад,
лапок або прізвищ розробників (FAR2L) не підставляється, і ви повинні це зробити
самі, якщо потрібно. Наприклад, якщо використовується в асоціаціях програма
вимагає, щоб ім'я файлу було в лапках, ви повинні писати
#program.exe "!.!"#, а не #program.exe!.!#.

2. ^<wrap>Для асоціацій ! @ @! та !$! допускаються такі модифікатори:

 'Q' - укладати імена з пробілами в лапки;
 'S' - використовувати '/' замість '\\' у шляхах файлів;
 'F' – використовувати повний шлях;
 'A' – використовувати кодову сторінку ANSI;
 'U' – використовувати кодову сторінку UTF-8;
 'W' – використовувати кодову сторінку UTF-16 (Little endian).

Наприклад, асоціація # !@ @AFQ!# - ім'я файлу, що містить імена помічених
файлів з повним шляхом у кодовій сторінці ANSI; імена файлів, що містять пробіли
укладені в лапки.

3. ^<wrap>Метасимволи !@ @! та !$! у меню вибору (коли задано кілька асоціацій)
показуються так, перетворення відбувається в момент виконання команди.

 4. ^<wrap>Префікси "!##" та "!^" працюють як перемикачі для асоціацій.
Дія цих префіксів поширюється до такого префіксу.
Наприклад:

if exist !##!\\!^!.! diff -c -p !##!\\!^!.! !\\!.!

 "Якщо на пасивній панелі існує такий самий файл, як і на
 активної під курсором, то показати розбіжності між файлом
 на пасивній панелі та файлом на активній панелі, незалежно
 від імені поточного файлу на пасивній панелі"

 5. ^<wrap>Якщо потрібно передати програмі ім'я із завершальною зворотною рисою,
то використовуйте конструкцію - #!. Наприклад, розпакувати rar-архів у
папку з таким самим ім'ям

winrar x "!.!" "!."


@SystemSettings
$ #Системні параметри#
 #Знімати атрибут R/O із CD файлів#
 Знімати атрибут "Тільки для читання" з файлів, що копіюються з компакт-дисків.

 #Видаляти в Кошик#
Дозволяє видалити файли за допомогою Кошика (Recycle Bin). Операція видалення в
Кошик здійснюється лише для локальних жорстких дисків.

 #Видаляти символічні посилання#
 Перед видаленням каталогу в Кошик просканувати та видалити символічні посилання на підкаталоги.
 У Windows Vista і вище ця опція не використовується.

 #Використовувати системну функцію копіювання#
 Використовувати функції копіювання файлів, що надаються операційною системою, замість внутрішньої
реалізації копіювання файлів. Це може бути корисно на NTFS, оскільки системна функція (CopyFileEx)
копіює розширені атрибути файлів. У той же час, при ввімкненій опції буде недоступна можливість
розрізати файли на частини при ~копіюванні~@CopyFiles@ або переміщенні та "інтелектуальне" копіювання
розріджених файлів.

 #Копіювати відкриті для запису файли#
Дозволяє копіювати файли, які відкриті для запису іншими програмами. Цей режим зручний, коли
потрібно скопіювати відкритий протягом багато часу файл, але він може бути небезпечним, якщо цей файл
модифікується одночасно з копіюванням.

 #Сканувати символічні посилання#
Обробляти ~символічні посилання~@HardSymLink@ нарівні зі звичайними підкаталогами при побудові дерева
каталогів та визначення сумарного розміру файлів у підкаталогах.

 # Створювати папки великими літерами #
 Якщо ім'я нової папки містить лише малі літери та встановлена ​​ця опція, то папка буде створена великими літерами.

 # Час бездіяльності #
 Завершує роботу FAR2L, якщо протягом зазначеного інтервалу не було натискання клавіш миші або клавіатури,
FAR2L очікував на введення з командного рядка і відсутні фонові екрани редагування або перегляду.

 #Зберігати історію команд#
Викликає збереження ~історії команд~@History@ перед завершенням та її відновлення після запуску FAR2L.

 #Зберігати історію папок#
Викликає збереження ~історії папок~@HistoryFolders@ перед завершенням та її відновлення після запуску FAR2L.
Щоб переглянути вміст історії папок, натисніть #Alt-F12#.

 #Зберігати історію перегляду та редактора#
Викликає збереження ~історії перегляду~@HistoryViews@ та редактора перед завершенням та її відновлення
після запуску FAR2L. Щоб переглянути файли, що входять до цього списку, натисніть #Alt-F11#.

 #Використовувати стандартні типи файлів#
 Якщо ця опція увімкнена, то при натисканні Enter на файлі, тип якого відомий Windows і відсутня
в ~асоціаціях файлів~@FileAssoc@FAR2L, буде запущено програму Windows, призначену для обробки цього типу файлів.

 #Автоматично монтувати CDROM#
Якщо вибрано компакт-диск у меню ~вибору дисків~@DriveDlg@ FAR2L, закриється відкритий лоток приводу компакт-дисків. Вимкніть цю опцію,
якщо автоматичне монтування приводів працює некоректно (це може статися через помилки в драйверах
деяких приводів)

 #Автозапис конфігурації#
 Якщо цю опцію увімкнено, FAR2L буде автоматично зберігати конфігурацію.
Також зберігатимуться поточні папки обох панелей.


@PanelSettings
$ #Налаштування панелі#
 #Показувати приховані# Дозволяє показ файлів з атрибутами
і системні файли Прихований і Системний. Цей режим також
 може бути переключено за допомогою #Ctrl-H#.

#Розмальовка файлів# Дозволяє ~розмальовку файлів~@Highlight@

 #Автозміна папки# Якщо ця опція увімкнена, то пересування
курсору по ~дереву папок~@TreePanel@ будуть викликати
зміну папки на іншій панелі. Якщо ця опція
 вимкнено, то для зміни папки з дерева
 папок ви повинні натиснути #Enter#.

 #Позначка папок# Дозволяє позначку папок з використанням
#Gray +# та #Gray *#. Інакше ці
 команди працюють лише з файлами.

 #Сортувати імена# Застосовувати режим сортування для розширення
#папок розширення# не тільки до файлів, але і до папок. При
 увімкненої опції сортування з розширення
 працює так само, як і у FAR2L 1.65.
 Якщо опцію вимкнено, то в режимі
 сортування з розширення папки будуть
 сортуватися так само, як у режимі
 сортування на ім'я.

 #Дозволити зворотний# Якщо ця опція увімкнена, і поточний режим
 #Сортування# сортування файлової панелі обрано повторно,
 то буде встановлено режим зворотного
 сортування.

 #Вимкнути# Механізм автоматичного оновлення панелі
 #Автооновлення# при зміні стану файлової системи
 #панелей...# буде відключатися, якщо кількість файлових
 об'єктів перевищить задане значення.

 Механізм автоматичного стеження за файловою системою працює
тільки для файлових систем FAT/FAT32/NTFS. Значення параметру,
 рівне нулю відповідає стану "автоматичне оновлення
 увімкнено завжди". Для примусового оновлення панелі
 використовуйте #Ctrl-R#.

 #Автооновлення# Опція включає механізм автоматичного
 #мережевих дисків# оновлення панелі при зміні стану
 файлової системи на мережевих дисках
 Вимкнення цієї опції корисно на повільних
 мережеві підключення.

 #Показувати заголовки# Дозволяє показ заголовків колонок
#колонок# ~панелі файлів~@FilePanel@.

 #Показувати рядок# Дозволяє показ рядка статусу
 #статусу# в панелі файлів.

 #Показувати сумарну# Дозволяє показ сумарної інформації
 #інформацію# у нижньому рядку панелі файлів.

 #Показувати вільне# Дозволяє показ вільного місця
 #Місце# на поточному диску.

 #Показувати смугу# Дозволяє показ смуги прокручування на панелі
#прокручування в панелях# файлів і ~панелі дерева папок~@TreePanel@.

#Показувати кількість# Дозволяє показувати кількість фонових екранів~@ScrSwitch@.
 #фонових екранів#

 #Показувати букву# Показувати поточний режим сортування
 #режиму сортування# у верхньому лівому кутку панелі.


@InputSettings
$ #Настройка ввода#
 #Миша#
 Використовувати мишу.

 #Правила транслітерації:#
 Виберіть тут правила транслітерації, які відповідають вашій звичайній розкладці клавіатури.
Доступні правила завантажуються з файлу #xlats.ini#, який визначає відповідність між латинськими
і не латинськими кнопка клавіатури, що потім використовується в #швидкому пошуку файлу по Alt+ФАЙЛ#,
гарячих клавішах у #діалоговій навігації# і деякої внутрішньої функціональності.

 #Ексклюзивна обробка натискань#
 Ця опція дозволяє вибрати керуючі кнопки, використання яких у
комбінації кнопкосполучення буде змушувати FAR2L ексклюзивно захоплювати
клавіатурне введення, запобігаючи таким чином перехоплення таких сполучень іншими
додатками. Врахуйте, що ця опція працює тільки в режимі GUI.


@InterfSettings
$ #Налаштування інтерфейсу#
 #Годинник у панелях#
 Показувати годинник у верхньому правому куті екрана.

 #Годинник при редагуванні та перегляді#
 Показувати годинник під час редагування та перегляду файлів.

 #Показувати лінійку клавіш#
 Показувати призначення функціональних клавіш у нижньому рядку екрана.
Ця опція також може перемикатися на #Ctrl-B#.

 #Завжди показувати меню#
 Показувати меню у верхній частині екрана, навіть коли воно неактивне.

 #Збереження екрану#
 Запуск програми збереження екрана після заданого у хвилинах інтервалу
бездіяльності. Зберігач екрану також включається, якщо підвести покажчик
миші у верхній правий кут вікна FAR2L (при вибраній опції).

 #Показувати загальний індикатор копіювання#
 Показувати загальний індикатор під час операції копіювання.
Це може вимагати додаткового часу перед початком копіювання
для підрахунку загального розміру файлів.

 #Показувати інформацію про час копіювання#
 Виводити інформацію про середню швидкість копіювання, час копіювання та
приблизно часу до кінця операції в діалозі копіювання.
 Так як ця функція вимагає часу для збору статистики, то на
невеликих файлах при вимкненому "загальному індикаторі копіювання"
Ви можете нічого не побачити.

 #Показувати загальний індикатор видалення#
 Показувати загальний індикатор під час операції видалення.
Це може вимагати додаткового часу перед початком видалення
для підрахунку загальної кількості файлів та папок.

 #Використовувати Ctrl-PgUp для вибору диска#
 Комбінація клавіш #Ctrl-PgUp# у кореневій папці:
 - для локальних дисків викликає меню вибору дисків;
 - для мережевих дисків викличе плагін Network (якщо плагін є)
або меню вибору дисків (якщо плагін Network відсутня).

 #Заголовок вікна FAR#
 Інформація, що відображається у заголовку вікна консолі. Може містити будь-який текст,
включаючи такі змінні:
 - #%State# - поточний стан FAR2L (раніше було заголовком вікна за замовчуванням);
 - #%Ver# - версія FAR2L;
 - #%Platform# - архітектура FAR2L;
 - #%Backend# - режим інтерфейсу FAR2L;
 - #%Host# - ім'я машини;
 - #%User# - ім'я користувача;
 - #%Admin# - слово "Root", якщо FAR2L запущено від імені адміністратора, інакше порожній рядок.


@DialogSettings
$ #Налаштування діалогів#
 #Історія у рядках# Зберігати історію у рядках введення
#введення діалогів# деяких діалогів FAR2L. Список раніше
 введених рядків може бути викликаний за допомогою
миші або #Ctrl-Up# та #Ctrl-Down#. Якщо ви
 не хочете вести таку історію, наприклад,
 з міркувань безпеки, вимкніть
 цю опцію.

 #Постійні блоки# Не знімати виділення під час переміщення
 #У рядках введення# курсору в рядках введення.

 #Del видаляє блоки# Клавіша Del видаляє виділений блок
 #У рядках введення# у рядках введення.

 #Автозавершення# Дозволяє використання функції
 #у рядках введення# автозавершення у рядках введення, що мають
 історію або у комбінованих списках.
 При вимкненій опції для автозавершення
 рядків можна скористатися комбінацією
клавіш #Ctrl-End#. Операція автозавершення
 не працює під час запису та виконання
 макросу.


 #Backspace видаляє# Якщо опція увімкнена, то натискання клавіші
 #незмінений текст# BackSpace в незміненій текстовій
 рядку видаляє весь рядок, начебто
 натиснули клавішу # Del #.

 #Клік миші поза діалогом# Клацніть лівою або правою клавішею миші
 #закриває діалог# за межами діалогу закриває діалог
(Докладніше див. ~Інші команди~@MiscCmd@).
 Ця опція дозволяє вимкнути вказану
 функціональність.

також список ~макроклавіш~@KeyMacroDialogList@, доступних у діалогах.

@VMenuSettings
$ #Налаштування меню#
 #Клік лівої/правої/середньої кнопки миші поза меню#
 Ви можете вибрати дію кнопок миші при натисканні поза полем меню:
 #Закрити зі скасуванням#, #Виконати поточний пункт# або #Нічого не робити#.

@CmdlineSettings
$ #Налаштування командного рядка#
 # Постійні блоки #
 Не знімати виділення під час переміщення у командному рядку.

 #Del видаляє блоки#
 Клавіша Del видаляє виділений блок у командному рядку.

 #Автозавершення#
 Дозволяє використання функції автозавершення у командному рядку.
 При вимкненій опції для автозавершення можна скористатися комбінацією
клавіш #Ctrl-Shift-End#. Операція автозавершення не працює під час запису та
виконання макросу.

 #Встановити формат командного рядка#
Ця опція дозволяє змінити ~формат запрошення~@CommandPrompt@ командного рядка.

@AutoCompleteSettings
$ #Налаштування автозавершення та історії#
  #Шаблони &винятковий# also affect which commands are stored in far2l history.
  For example, adding " *"  (mandatory in quotes) excludes from adding in history
  commands that start with a space (similar to the bash $HISTCONTROL=ignorespace).
  Info: in far2l history work like bash $HISTCONTROL
   with options ignoredups (lines which match the previous line are not saved)
   и erasedups (all previous lines matching the current line are removed from the history).

@InfoPanelSettings
$ #Налаштування інформаційної панелі#
 #Формат виведення імені комп'ютера#

Визначає формат відображення імені комп'ютера. Може бути одним із:

 #Physical NetBIOS#
 ^<wrap>NetBIOS назва локального комп'ютера.

 #Physical DNS hostname#
 ^<wrap>DNS ім'я локального комп'ютера.

 #Physical DNS domain#
 ^<wrap>DNS ім'я домену, якому належить комп'ютер.

 #Physical DNS fully-qualified#
^<wrap>Повне доменне ім'я, яке однозначно ідентифікує цей комп'ютер. Ім'я є комбінацією DNS імені хоста і DNS імені домену (формат HostName.DomainName).

 #NetBIOS#
^<wrap>NetBIOS назва локального комп'ютера. Якщо комп'ютер є вузлом кластера, виводиться NetBIOS ім'я кластера віртуального сервера.

 #DNS hostname#
^<wrap>DNS ім'я локального комп'ютера. Якщо комп'ютер є вузлом кластера, виводиться DNS ім'я кластера віртуального сервера.

 #DNS domain#
^<wrap>DNS ім'я домену, якому належить комп'ютер. Якщо комп'ютер є вузлом кластера, виводиться DNS ім'я домену кластера віртуального сервера.

 #DNS fully-qualified#
^<wrap>Повне доменне ім'я, яке однозначно ідентифікує цей комп'ютер. Ім'я є комбінацією DNS імені хоста і DNS імені домену (формат HostName.DomainName). Якщо комп'ютер є вузлом кластера, виводиться повне DNS ім'я кластера віртуального сервера.

 Формат виведення залежить від наявності доменної структури, групових політик, установок DNS.

 #Формат виведення імені користувача#

Визначає формат виводу імені користувача. Може бути одним із:

 #За замовчуванням#
 Логін користувача, наприклад, JohnDoe
 #Повністю певне ім'я домену#
 ^<wrap>FQDN (Fully Qualified Domain Name) - включає найменування всіх рівнів ієрархії, починаючи від імені кінцевого вузла і закінчуючи кореневою точкою (логіном), наприклад,
 CN=JohnDoe, OU=Software, OU=Engineering, O=Widget, C=US
 #Sam Compatible#
 Engineering\JohnDoe
 #Display#
Probably "John Doe" but could be something else. Ie The display name is not necessarily the defining RDN.
 #Унікальний ідентифікатор#
 ^<wrap>Унікальний ідентифікатор імені користувача (GUID), наприклад,
 {4fa050f0-f561-11cf-bdd9-00aa003a77b6}
 #Канонічний вид#
 ^<wrap>ADCN (Active Directory Canonical Name) - цей формат є шляхом в ієрархічній структурі до об'єкта (логіну), наприклад,
 engineering.widget.com/software/JohnDoe
 #Основне ім'я користувача#
 ^<wrap>UPN (User Principial Name) - відомий як адреса електронної пошти, наприклад,
 someone@example.com
 #Service Principal#
 www/srv.engineering.com/engineering.com
 #Dns Domain#
 engineering.widget.com\JohnDoe

 Формат виведення залежить від наявності доменної структури.

@CommandPrompt
$ #Формат командного рядка#
 FAR2L дозволяє змінити формат запрошення командного рядка.
Для цього в полі введення #Встановити формат командного рядка діалогу
~Налаштувань командного рядка~@CmdlineSettings@ необхідно ввести потрібну
послідовність змінних та спеціальних кодів, яка дозволить
показати додаткову інформацію у запрошенні.

 Допускається використовувати змінні оточення та наступні
спеціальні коди:

 $a - символ &
 $b – символ |
 $c - символ (
 $d - поточна дата (залежить від системних налаштувань)
 $f - символ)
 $g - символ >
 $h - видалити попередній символ
 $l - символ <
 $## - символ ## якщо FAR2L запущений під root, інакше $
 $p - поточний диск та шлях
 $r - поточний диск та шлях, без скорочень
 $u - ім'я користувача
 $n - ім'я комп'ютера
 $q - символ =
 $s - пробіл
 $t - поточний час у форматі HH:MM:SS
 $$ - символ $
 $+ - глибина стеку каталогів

 $@ @xx - ^<wrap>"Адміністратор", якщо FAR2L запущено від імені адміністратора.
Замість 'xx' необхідно вказати два символи, які обрамлятимуть слово "Адміністратор".
Наприклад, # $@ @{}$s$p$g# буде представлено як "{Адміністратор} C:\>"

 За промовчанням використовується послідовність #$p$g# - поточний дисковод
і шлях ("C:").

 приклади.

 1. ^<wrap>Запрошення формату #[%HOSTNAME%]$S$P$### буде
містити ім'я комп'ютера, поточний диск та шлях

 2. ^<wrap>Запрошення формату #[$T$H$H$H]$S$P$G# перед поточним шляхом
виведе час у форматі HH:MM

 3. ^<wrap>Код "$+" відображає потрібну кількість знаків плюс (+) залежно
від поточної глибини стеку каталогів ~PUSHD~@OSCommands@, по одному знаку на
кожен збережений шлях.

@Viewer
$ #Програма перегляду: клавіші керування#
 Команди програми перегляду

 #Left# Символ ліворуч
 #Right# Символ праворуч
 #Up# Рядок вгору
 #Down# Рядок вниз
 #Ctrl-Left# 20 символів ліворуч
 У 16-річному режимі - на 1 позицію вліво
 #Ctrl-Right# 20 символів праворуч
 У 16-річному режимі - на 1 позицію праворуч
 #PgUp# Сторінку вгору
 #PgDn# Сторінку вниз
 #Alt+PgUp# Сторінку вгору зі збільшенням швидкості
 #Alt+PgDn# Сторінку вниз зі збільшенням швидкості
 #Ctrl-Shift-Left# На початок рядків на екрані
 #Ctrl-Shift-Right# Наприкінці рядків на екрані
 #Home, Ctrl-Home# На початок файлу
 #End, Ctrl-End# Наприкінці файлу
 #Shift-Left/Right# Збільшити існуюче виділення ліворуч/праворуч

 #F1# Допомога
 #F2# Перенесення рядків (увімкнено, вимкнено)
 #Shift-F2# Вид перенесення рядків (за літерами, за словами)
 #F4# Переключити текстовий/16-річний режим
 #F5# Переключити сирий/оброблений режим
 #Alt-F5# Друк файлу (використовується плагін
 "Print Manager".
#F6# Перейти в ~редактор~@Editor@
#F7# ~Пошук~@ViewerSearch@
 #Shift-F7, Space# Продовжити пошук
 #Alt-F7# Продовжити пошук у зворотному напрямку
 #F8# Перемикання OEM/ANSI кодової сторінки
 #Shift-F8# Вибір кодової сторінки
#Alt-F8# ~Змінити поточну позицію~@ViewerGotoPos@
 #Alt-F9# Зміна розмірів вікна FAR2L
#F9,Alt-Shift-F9# Виклик діалогу ~налаштування програми перегляду~@ViewerSettings@
 #NumPad5,F3,F10,Esc# Вихід
 #Ctrl-F10# Позиціонувати на поточний файл без виходу.
#F11# Викликати меню "~Команди зовнішніх модулів~@Plugins@"
#Alt-F11# Показати ~історію перегляду~@HistoryViews@
 #+# Перейти до наступного файлу
 #-# Перейти до попереднього файлу
 #Ctrl-O# Показати екран користувача
 #Ctrl-Alt-Shift# Тимчасово показати екран користувача
 (працює доти, доки утримуємо ці
 клавіші)
 #Ctrl-B# Сховати/Показати лінійку функціональних
 клавіш
 #Ctrl-Shift-B# Сховати/Показати статусний рядок
 #Ctrl-S# Сховати/Показати смугу прокручування
 #Alt-BS, Ctrl-Z# Повернення до попередньої позиції
 #ПравийCtrl-0..9# Встановити закладку 0..9 у поточній позиції
 #Ctrl-Shift-0..9# Встановити закладку 0..9 у поточній позиції
 #ЛівийCtrl-0..9# Перейти до позиції закладки 0..9

 #Ctrl-Ins, Ctrl-C# Скопіювати виділений в результаті пошуку
 текст у Буфер обміну.
 #Ctrl-U# Скинути виділення, отримане в результаті
 пошуку.

також список ~макроклавіш~@KeyMacroViewerList@, доступних у програмі перегляду.

 Примітки:

 1. Для виклику діалогу пошуку ви можете просто
 почати вводити призначений для пошуку текст.

 2. Файл відкривається у програмі перегляду з дозволом на
видалення його стороннім процесом. Якщо станеться таке
 видалення, то реально файл буде видалений з каталогу тільки
 після закриття програми перегляду, при цьому він не буде
 доступний для обробки з будь-якого процесу - ця властивість
 MS Windows.

 3. У поточній версії FAR2L існує обмеження на максимальне
 кількість колонок у програмі перегляду - їх не може бути
 більше 2048. Якщо файл має рядок довжиною більше
 цього числа, то вона займатиме на екрані не одну
 рядок, а кілька, навіть якщо вимкнено режим перенесення
 рядків.

4. FAR2L ~шукає~@ViewerSearch@ перше входження підрядки (#F7#) з початку видимої
 області екрана програми перегляду.

 5. Для автоматичного скролінгу переглядається
 динамічно оновлюваного файлу необхідно стати в
 кінець файлу (клавіша End).

 6. Натискання Alt+PgUp/PgDn плавно збільшує швидкість скролінгу, наступне
 відпускання кнопки Alt при збереженні натиснутою PgUp/PgDn продовжить скролінг
із обраною швидкістю. Швидкість скролінгу скидається у звичайне значення
 при відпусканні всіх кнопок на тривалий час або натискання будь-якої іншої кнопки.

@ViewerGotoPos
$ #Програма перегляду: змінити поточну позицію#
 Цей діалог дозволяє змінити позицію у вбудованій програмі перегляду

 Ви можете ввести значення у вигляді десяткового усунення, відсотків, або
шістнадцяткового значення.

 Також можете вказати відносне значення - просто вкажіть знак + або -
перед числом.

 Шістнадцяткові значення вводяться в одній з наступних форм:

 #0xNNNN#, #NNNNh#, #$NNNN#

 Десятичне усунення вказується у формі NNNNd.

 Приклади:

 #50%# Перейти на середину файлу (50%)
 #-10% # Іти на 10% тому.
 Якщо у вас було 50%, то стане 40%
 #0x100# Іти на зсув 0x100 (256)
 #+0x300# Іти на 0x300 (768) байтів уперед

 Якщо ви явно вказали знак відсотка "%", або форму шістнадцяткового
числа ('0x', 'h', '$'), або форму десяткового числа ('d'), то зазначені
кнопки радіо ігноруються.

@ViewerSearch
$ #Програма перегляду: пошук#
Для пошуку в ~програмі перегляду~@Viewer@ вам доступні наступні режими та
опції:

 #Шукати текст#

 Пошук довільного тесту, набраного у рядку #Шукати#.
 У цьому режимі доступні такі опції:

 #Враховувати регістр# - ^<wrap>при пошуку враховуватиметься регістр введених символів.

 #Тільки цілі слова# - ^<wrap>при пошуку буде здійснено пошук тільки цілого слова.

#Регулярні вирази# - ^<wrap>розглядати рядок пошуку, як ~регулярний вираз~@RegExp@.

 #Шукати 16-річний код#

 ^<wrap>Пошук фрагмента, що відповідає шістнадцятковим кодам, набраному в рядку #Шукати#.

 #Зворотній пошук#

 Змінити пошук на зворотний – шукати від кінця файлу до початку.


@Editor
$ #Редактор#
Для редагування виділеного курсором файлу натисніть #F4#. Може
використовуватися як вбудований редактор, так і будь-який інший вказаний
користувачем, вибір редактора здійснюється у меню
~Налаштування редактора~@EditorSettings@.

 #Створення файлів за допомогою редактора#

 Якщо після натискання комбінації клавіш #Shift-F4# ввести ім'я файлу, не
наявного на диску, то буде створено новий файл.

 Примітки:

 1. ^<wrap>Якщо при відкритті нового файлу ви вказали ім'я неіснуючої папки, то
з'явиться попередження: "Шлях до редагованого файлу не існує~@WarnEditorPath@".

 2. ^<wrap>При спробі повторного відкриття на редагування файлу FAR2L видасть
попередження: "~Повторне відкриття файлу~@EditorReload@".

 3. ^<wrap>Кодову сторінку, яка використовується під час створення нового файлу, можна вибрати в меню
~Налаштування редактора~@EditorSettings@.

 #Клавіші управління#

 Команди керування курсором

 #Left# Символ ліворуч
 #Ctrl-S# ^<wrap>Символ ліворуч, але курсор не переходитиме на попередній рядок при досягненні початку рядка
 #Right# Символ праворуч
 #Up# Рядок вгору
 #Down# Рядок вниз
 #Ctrl-Left# Слово вліво
 #Ctrl-Right# Слово праворуч
 #Ctrl-Up# Прокручування екрана вгору
 #Ctrl-Down# Прокручування екрана вниз
 #PgUp# Сторінку вгору
 #PgDn# Сторінку вниз
 #Home# На початок рядка
 #End# В кінець рядка
 #Ctrl-Home, Ctrl-PgUp# На початок файлу
 #Ctrl-End, Ctrl-PgDn# Наприкінці файлу
 #Ctrl-N# На початок екрану
 #Ctrl-E# Наприкінці екрана

 Видалення

#Del# ^<wrap>Видалити символ (також може видалити блок, залежно від ~Налаштувань редактора~@EditorSettings@)
 #BS# Видалити символ ліворуч
 #Ctrl-Y# Видалити рядок
 #Ctrl-K, Alt-D# Видалити до кінця рядка
 #Ctrl-BS# Видалити слово зліва
 #Ctrl-T, Ctrl-Del# Видалити слово праворуч

 Операції над блоками

 #Shift-Клавіші курсору# Позначка блоку
 #Ctrl-Shift-Клав.курсора# Позначка блоку за словами
 #Alt-Клав.курсора# Позначка вертикального блоку
 #Alt-Shift-Клав.курсора# Позначка вертикального блоку (NumLock клав)
 #Ctrl-A# Позначити весь текст
 #Ctrl-U# Зняти позначку з блоку
 #Shift-Ins, Ctrl-V# Скопіювати блок із Буфера Обміну
 #Shift-Del, Ctrl-X# Перемістити блок у Буфер Обміну
 #Ctrl-Ins, Ctrl-C# Копіювати блок у Буфер Обміну
 #Ctrl-<Gray +># Додати блок до Буфера Обміну
 #Ctrl-D# Видалити блок
 #Ctrl-P# ^<wrap>Копіювати блок у поточну позицію курсора (тільки в режимі постійних блоків, Буфер Обміну не змінюється)
 #Ctrl-M# ^<wrap>Перенести блок на поточну позицію курсора (тільки в режимі постійних блоків, Буфер Обміну не змінюється)
 #Alt-U# Зсунути блок ліворуч
 #Alt-I# Зсунути блок праворуч

 Інші операції

 #F1# Допомога
 #F2# Зберегти файл
#Shift-F2# ~Зберегти файл як ...~@FileSaveAs@
#Shift-F4# Редагувати ~новий файл~@FileOpenCreate@
 #F5#                      Toggle whitespace characters displaying
 #Shift-F5#                Change Tab character width
 #Ctrl-F5#                 Toggle Tab-to-spaces expansion
 #Alt-F5# ^<wrap>Друк файлу/виділеного блоку (використовується плагін "Print Manager").
#F6# Перейти до ~програми перегляду~@Viewer@
#F7# ~Пошук~@EditorSearch@
#Ctrl-F7# ~Заміна~@EditorSearch@
 #Shift-F7# Продовжити пошук/заміну
 #Alt-F7# Продовжити пошук/заміну у зворотному напрямку
 #F8# Перемикання OEM/ANSI кодової сторінки
 #Shift-F8# Вибір кодової сторінки
#Alt-F8# ~Перейти~@EditorGotoPos@ на вказаний рядок та позицію
 #Alt-F9# Зміна розмірів вікна FAR2L
#F9,Alt-Shift-F9# Виклик діалогу ~налаштувань редактора~@EditorSettings@
 #F10, F4, Esc# Вихід
 #Shift-F10# Збереження та вихід
 #Ctrl-F10# ^<wrap>Позиціонувати на поточний файл без виходу.
#F11# Викликати меню "~Команди зовнішніх модулів~@Plugins@"
#Alt-F11# Показати ~історію редагування~@HistoryViews@
 #Alt-BS, Ctrl-Z# Скасування дії (Undo)
 #Ctrl-Shift-Z# Повторення дії (Redo)
 #Ctrl-L# ^<wrap>Заборонити модифікацію тексту, що редагується
 #Ctrl-O# Показати екран користувача
 #Ctrl-Alt-Shift# ^<wrap>Тимчасово показати екран користувача (працює доти, поки утримуємо ці клавіші)
 #Ctrl-Q# ^<wrap>Розглядати наступну комбінацію клавіш як код символу
 #ПравийCtrl-0..9# Встановити закладку 0..9 у поточній позиції
 #Ctrl-Shift-0..9# Встановити закладку 0..9 у поточній позиції
 #ЛівийCtrl-0..9# Перейти до позиції закладки 0..9
 #Shift-Enter# ^<wrap>Вставити в позицію курсора ім'я поточного файлу на панелі.
 #Ctrl-Shift-Enter# ^<wrap>Вставити в позицію курсора ім'я поточного файлу на пасивній панелі.
 #Ctrl-F# ^<wrap>Вставити в позицію курсора повне ім'я файлу, що редагується.
 #Ctrl-B# ^<wrap>Сховати/Показати лінійку функціональних клавіш
 #Ctrl-Shift-B# Сховати/Показати статусний рядок

також список ~макроклавіш~@KeyMacroEditList@, доступних у редакторі.

 Примітки:

 1. #Alt-U#/#Alt-I# зсувають поточний рядок, якщо блок не виділено.

 2. ^<wrap>Alt-код символу на додатковій клавіатурі вставляє в
редагований рядок символ із зазначеним кодом (0-65535).

 3. ^<wrap>Якщо блок не виділено, то #Ctrl-Ins#/#Ctrl-C# позначають поточну
рядок як блок і копіюють її в Буфер Обміну.

@EditorSearch
$ #Редактор: пошук та заміна#
Для пошуку та заміни в ~редакторі~@Editor@ вам доступні наступні режими та опції:

 #Враховувати регістр# - ^<wrap>при пошуку враховуватиметься регістр введених символів.

 #Тільки цілі слова# - ^<wrap>при пошуку буде здійснено пошук тільки цілого слова.

 #Зворотній пошук# - ^<wrap>змінити пошук на зворотний - шукати від кінця файлу до початку.

#Регулярні вирази# - ^<wrap>використовувати регулярні вирази для ~пошуку~@RegExp@ та ~заміни~@RegExpRepl@.

 У режимі пошуку також доступна опція:

 #Виділяти знайдене# - ^<wrap>знайдені послідовності будуть виділені.


@FileOpenCreate
$ #Редактор: Відкрити/створити файл#
 За допомогою комбінації # Shift-F4 # можна відкрити існуючий або
створити новий файл.

Залежно від ~налаштувань редактора~@EditorSettings@ для нового файлу
вибирається кодова сторінка OEM чи ANSI. За необхідності з #списку#
Ви можете вибрати іншу кодову сторінку.

 Для існуючого файлу змінювати опцію # Кодова сторінка:
сенс тоді, коли під час відкриття вона визначилася неправильно.


@FileSaveAs
$ #Редактор: зберегти файл як...#
 Редагований файл можна зберегти під іншим ім'ям - натиснути #Shift-F2# та
вказати інше ім'я, кодову сторінку та формат представлення символу перекладу
рядки.

 Якщо для збереженого файлу вибрано одну з кодових сторінок: UTF-8,
UTF-16 (Little endian) або UTF-16 (Big endian), то при включеній опції #Додати сигнатуру (BOM)#
на початок файлу додається спеціальний маркер, що дозволяє іншим програмам
однозначно ідентифікувати цей файл.

 Ви також можете вказати формат представлення символу перекладу рядка:

 #Вихідний формат#
 Не змінювати символи перекладу рядків.

 #У форматі DOS/Windows (CR LF)#
 Як послідовність перекладу рядків будуть
 використовуватися два символи - повернення каретки та переклад
 рядки (CR LF) прийняті в DOS/Windows.

 #У форматі UNIX (LF)#
 Як послідовність перекладу рядків буде
 використовувати символ перекладу рядка (LF), прийнятий в
 UNIX.

 #У форматі MAC (CR)#
 Як послідовність перекладу рядків буде
 використовувати символ повернення каретки (CR), прийнятий в
 MAC.


@EditorGotoPos
$ #Редактор: перейти на вказану позицію#
 У цьому діалозі можна вказати #рядок# і #колонку# для переходу.

Ви можете вводити два числа - рядок та колонку. Розділювач чисел - одні з
набору символів: "#,.:;#" або пробіл.

 Якщо ви введете "Колонка", то редактор перейде на вказану колонку в
поточному рядку.

Також є можливість переходу за відсотками. Введіть #50%# і ви перейдете
рівно всередину тексту.


@EditorReload
$ #Редактор: повторне відкриття файлу#
 FAR2L відслідковує всі спроби повторного відкриття в редакторі
редагованих файлів. Правила повторного відкриття:

 1. Якщо файл не змінено, то при вимкненій опції "Повторне відкриття
файлу в редакторі" в діалозі ~підтверджень~@ConfirmDlg@ відбувається перехід до
редагування поточного файлу без додаткових запитів.

 2. Якщо файл було змінено або увімкнено опцію "Повторне відкриття файлу в
редакторі", то існує три варіанти дій:

 #Поточний# - Продовжити редагування того ж файлу.

 #Нова копія# - Файл буде відкрито для редагування в новій
копії редактора. В цьому випадку будьте уважні:
 вміст файлу на диску буде відповідати
 тому, в якій із копій редактора востаннє
 зберігали цей файл.

 #Перевантажити# - Поточні зміни не зберігаються і в редактор
 завантажується колишній вміст файлу (з моменту
 останнього збереження).



@WarnEditorPath
$ #Попередження: Шлях до редагованого файлу не існує#
При відкритті нового файлу в ~редакторі~@Editor@ ви вказали ім'я
неіснуючої папки. Перед збереженням файлу FAR2L створить таку папку при
умови, що вами вказано коректний шлях (некоректним буде, наприклад, шлях,
що починається з неіснуючої літери диска) і що ви маєте достатньо
повноважень створення папки.


@WarnEditorPluginName
$ #Попередження: Ім'я файла, що редагується, не може бути порожнім#
 Для створення нового файлу на активній панелі плагіна необхідно вказати
ім'я файлу.


@WarnEditorSavedEx
$ #Попередження: Файл змінено зовнішньою програмою#
 Дата/час запису або розмір редагованого файлу на диску
збігаються з тими, що FAR2L запам'ятав при останньому зверненні до цього файлу.
Це означає, що інша програма, інший користувач (або навіть ви самі в
іншому вікні редактора) змінили вміст файлу на диску.

 Якщо ви натиснете "Зберегти", файл буде перезаписано, і всі зміни,
внесені зовнішньою програмою, будуть втрачені.


@CodePagesMenu
$ #Меню вибору кодової сторінки#
 Це меню дозволяє вибрати сторінку редактора або програми перегляду.

 Меню поділено на кілька частин:

 # Автоматичне визначення - визначення правильної кодової сторінки;

 #Системні# - основні однобайтні системні кодові сторінки - ANSI та OEM;

 # Юнікод # - Юнікодні кодові сторінки;

 #Вибрані# - кодові сторінки, зазначені користувачем;

 #Інші# - всі інші встановлені в системі кодові сторінки.

 Меню має два режими - повний, у якому розділ #Інші# показується, та
скорочений, у якому він прихований. Перемикання режимів здійснюється поєднанням клавіш
#Ctrl-H#.

 Клавіша #Ins# переміщує кодову сторінку з розділу #Інші# в розділ #Вибрані#.
Клавіша #Del# здійснює зворотну дію. Клавіша #F4# дозволяє змінювати відображені
імена для #улюблених# та #інших# кодових сторінок (кодові сторінки для яких було
змінено ім'я позначені символом #*# перед ім'ям).

Діалог ~Зміна імені кодової сторінки~@EditCodePageNameDlg@

@EditCodePageNameDlg
$ #Зміна імені кодової сторінки#
 Діалог #Зміна імені кодової сторінки# дозволяє змінити ім'я, що відображається для
#улюблених# та #інших# кодових сторінок.

 Примітки:

 - ^<wrap>Якщо ввести порожнє ім'я кодової сторінки, після підтвердження введення
Ім'я кодової сторінки, що відображається, набуде значення за замовчуванням, тобто ім'я отримане
від системи.
 - ^<wrap>Так само відображуване ім'я кодової сторінки набуває значення за замовчуванням
після натискання кнопки #Скинути#.

@DriveDlg
$ #Меню переходу#
 Це меню дозволяє швидко перейти в інше місце ФС, відмонтувати шлях або 
відкрити нову панель ~модуля, що підключається~@Plugins@.

 Виберіть пункт меню з відповідною літерою диска для зміни поточного диска
або пункт назви модуля, щоб створити нову панель модуля. Якщо панель не
є ~панеллю файлів~@FilePanel@, її тип буде змінено на панель файлів.

 Клавіша #F4# дозволяє призначити гарячу клавішу для модуля, що підключається.

 Клавіша #Del# може використовуватись для:

- ~відмонтування~@DisconnectDrive@ файлової системи по заданому шляху.

 - Видалення ~закладки ~.

 Комбінація #Shift-Del# використовується для безумовного відмонтування та 
запитує привілеї суперкористувача.

 #F9# показує ~діалог для налаштування відображення цієї інформації~@ChangeLocationConfig@.

 Налаштування меню переходу зберігаються у конфігурації FAR2L.

При включеній опції "~Використовувати Ctrl-PgUp для вибору диска~@InterfSettings@",
комбінація клавіш #Ctrl-PgUp# аналогічна клавіші #Esc# - відмовитись від
вибору диска та закрити меню.

 #Shift-Enter# викликає Провідник із показом кореня зазначеного диска (працює
лише для дисків).

 #Ctrl-R# дозволяє оновити меню переходу.

 #Alt-Shift-F9# дозволяє ~налаштувати параметри~@PluginsConfig@ зовнішніх, що підключаються
модулів (працює, якщо увімкнено показ імен модулів, що підключаються).

 #Shift-F9# в області зовнішніх модулів, що підключаються, викликає діалог налаштування
відповідного модуля.

 #Shift-F1# в області зовнішніх модулів, що підключаються, показує відповідну
модулю контекстно-залежну підказку (якщо плагін має файл допомоги).

    You can specify manual/scripted source of additional items in Location menu that
will be appended to mountpoints entries. For that you need to create text file under
path #~~/.config/far2l/favorites# and that file must contain lines, each line can have
one or two or three parts separated by <TAB> character. First part represent path,
second and third parts are optional and represent information rendered in additional
columns. Its possible to insert separator with optional title by specifing line
with first part having only '-' character and another part (if present) defining
title text.
Note that favorites file can contain shell environment variables denoted with $
character like $HOME, and shell commands substitution, i.e. $(/path/to/some/script.sh)
will invoke that script.sh and its output will be embedded into content of this file
during processing. This allows to implement custom dynamic locations list composing.

також список ~макроклавіш~@KeyMacroDisksList@, доступних у меню переходу.


@DisconnectDrive
$ #Отмонтування шляху#
Відмонтувати файлову систему за заданим шляхом можна з ~Меню переходу~@DriveDlg@
клавішею # Del #.

 Опція #[x] Відновлювати під час входу до системи# доступна для змін
тільки для мережних пристроїв, які постійно підключені.

Видання підтвердження можна відключити в діалозі ~"Підтвердження"~@ConfirmDlg@


@Highlight
$ #Розмальовка файлів та групи сортування#
 Для більш зручного та наочного представлення файлів та папок на панелях у
FAR2L передбачена можливість кольорового виділення файлових об'єктів.
Файлові об'єкти можна об'єднувати за різними критеріями (~маски файлів~@FileMasks@,
файлові атрибути) у групи і призначати власні кольори.

 Розмальовку файлів можна увімкнути або відключити в діалозі
~налаштування панелей~@PanelSettings@ (пункт "Параметри|Розмальовка файлів").

~Змінити~@HighlightEdit@ параметри будь-якої групи розмальовки можна з меню
"~Параметри~@OptMenu@" (пункт "Розфарбування файлів та групи сортування").


@HighlightList
$ #Розмальовка файлів та групи сортування: клавіші керування#
Меню ~розмальовки файлів та групи сортування~@Highlight@ дозволяє
маніпулювати списком. Доступні такі клавіші:

 #Ins# - Додати нову групу розмальовки

 #F5# - Дублювати поточну групу

 #Del# - Видалити поточну групу

#Enter# або #F4# - ~Змінити параметри~@HighlightEdit@ поточної групи розмальовки

 #Ctrl-R# - Відновити певні групи забарвлення
 файлів.

 #Ctrl-Up# - Пересунути групу нагору.

 #Ctrl-Down# - Пересунути групу донизу.

Групи розмальовки аналізуються від початку до кінця. Якщо виявлено, що файл
належить до будь-якої групи, то приналежність до інших груп не
перевіряється.


@HighlightEdit
$ #Розмальовка файлів та групи сортування: редагування#
Діалог #Редагування розмальовки файлів# дозволяє змінити ~параметри~@Filter@
групи розмальовки файлів. Кожне визначення групи включає:

- одну або кілька ~масок файлів~@FileMasks@;

 - атрибути включення та виключення:
 #[x]# - атрибут включення - файл повинен мати
 вказаний атрибут.
 #[ ]# - атрибут виключення - файл не повинен мати
 вказаний атрибут.
 #[?]# - вказаний атрибут не впливає на фільтр;

 - кольори звичайного імені, позначеного імені, імені під курсором
та позначеного імені під курсором. Якщо ви хочете використати
 колір за промовчанням, встановіть колір у "Чорний на чорному";

 - опціонально може бути вказано будь-який символ для позначення
що належать до групи файлів. Він може бути використаний
 як разом із колірним виділенням, так і замість нього.

 Якщо ви вимкнете опцію "#Збіг з маскою (масками)#", то маски файлів
будуть виключені з аналізу, а порівняння проводитиметься лише за атрибутами.

 Файл належить до групи розмальовки, якщо:

 - включений аналіз масок та його ім'я відповідає хоча б
 однієї масці (якщо аналіз масок вимкнено, то ім'я файлу не
 має значення);

 - він має усі атрибути включення;

 - він немає атрибутів винятку.

 Атрибути "Стиснутий", "Зашифрований", "Неіндексований", "Розріджений",
"Тимчасовий", "Символічна посилання", "Автономний" та "Віртуальний" використовуються
тільки на дисках із файловою системою NTFS. Атрибут "Віртуальний" не використовується
Windows 2000/XP/2003.


@ViewerSettings
$ #Налаштування програми перегляду#
 У цьому діалозі можна змінити параметри зовнішньої та вбудованої
~програми перегляду~@Viewer@.

 Зовнішня програма перегляду



 #Запускати зовнішню# Запускати зовнішню програму перегляду
 #програму перегляду# по #F3# замість #Alt-F3#.
 #по F3#

 Команда перегляду Команда для запуску зовнішньої програми
перегляду. Для вказівки імені
 використовуваного файлу використовуйте
~спеціальні символи~@MetaSymbols@.
 Якщо ви не хочете, щоб перед запуском
 програми перегляду гасилися панелі,
 почніть команду із символу '@@'.

 Вбудована програма перегляду

 #Постійне виділення# Не видаляти позначку блоку під час переміщення
  курсор.

 #Показувати стрілки# Якщо текст зсувається ліворуч або праворуч
 #зсуву# залишається текст, то вікно перегляду буде
 показувати збоку стрілки, що показують.

 #Зберігати позицію# Зберігати та відновлювати позицію
 #файла# у нещодавно переглянутих файлах.
 Ця опція також викликає збереження
 кодової сторінки, використаної
 під час перегляду файлу, якщо ця сторінка
 була обрана користувачем вручну,
 а також режиму перегляду файлу
 (шістнадцяткового або нормального).

 #Зберігати закладки# Зберігати та відновлювати закладки на
 поточні позиції в недавно переглянутих
 файли, збережені з використанням
 #ПравийCtrl-0..9# або #Ctrl-Shift-0..9#.

 #Розмір табуляції# Кількість пробілів під час показу символу
 табуляції.

 #Показувати смугу# Показувати смугу прокручування у внутрішній
#прокручування# програмі перегляду. Також ця опція може
 перемикатися натисканням #Ctrl-S# у вікні
 перегляду.

#Автовизначення# ~Автовизначення кодової сторінки~@CodePage@
 #кодової сторінки# файлу, що переглядається.

 #Використовувати кодову# Використати кодову сторінку ANSI при
 #сторінку ANSI з перегляду файлів, інакше - OEM.
 #замовчуванням#

 Якщо зовнішню програму перегляду призначено на клавішу #F3#, вона буде
запускатися тільки в тому випадку, якщо ~асоційована~@FileAssoc@ програма
перегляду для цього типу файлів відсутній.

 Змінені налаштування не впливають на раніше відкриті вікна вбудованої програми
перегляду.

Також можна викликати діалог налаштування з ~програми перегляду~@Viewer@,
натиснувши #Alt-Shift-F9#. Зміни набудуть чинності негайно, але діятимуть
лише на поточний сеанс роботи.


@EditorSettings
$ #Налаштування редактора#
 У цьому діалозі можна змінити параметри, що використовуються за замовчуванням.
зовнішнього та ~вбудованого редакторів~@Editor@.

 Зовнішній редактор

 #Запускати зовнішній# Запускати зовнішній редактор по #F4# замість
 # Редактор з F4 # # Alt-F4 #.

 Команда Команда для запуску зовнішнього редактора.
 #редагування# Для вказівки імені файлу, що переглядається
використовуйте ~спеціальні символи~@MetaSymbols@.
 Якщо ви не хочете, щоб перед запуском
 редактора гасилися панелі, почніть команду
 із символу '@@'.

 Вбудований редактор

 #Не перетворювати# Під час редагування документа символ #Tab#
 #табуляцію# не перетворювати на прогалини.

 #Перетворювати нові# При редагуванні документа нововведений
 # символи табуляції в # символ # Tab # замінювати на відповідне
кількість пробілів. Інші символи
 #Tab# не перетворювати.

 #Перетворювати все# При відкритті документа в редакторі все
 # символи табуляції в # символи # Tab # замінити на відповідне
 кількість пробілів.

 #Постійні блоки# Не видаляти позначку блоку під час переміщення
 курсор.

 #Del видаляє блоки# Якщо є позначений блок, #Del# буде
 видаляти цей блок, а не символ під
 курсором.

 #Зберігати позицію# Зберігати та відновлювати позицію
 #файла# у недавно відредагованих файлах.
 Ця опція також викликає збереження
 кодової сторінки, використаної
 під час редагування файлу, якщо ця сторінка
 була обрана користувачем вручну.

 #Зберігати закладки# Зберігати та відновлювати закладки на
 поточні позиції в недавно переглянутих
 файли, збережені з використанням
 #ПравийCtrl-0..9# або #Ctrl-Shift-0..9#.

 #Автовідступ# Вмикає режим автовідступу під час введення
 тексту.

 #Курсор за межами# Дозволити переміщення курсору за межі
 рядки.

 #Розмір табуляції# Кількість пробілів під час показу символу
 табуляції.

 #Показувати смугу# Показувати смугу прокручування
 #прокручування#

 #Cлово під курсором# При виклику діалогу пошуку/заміни в рядок
 пошуку буде підставлятися слово, на
 якому стоїть курсор.

#Автовизначення# ~Автовизначення кодової сторінки~@CodePage@
 #кодової сторінки# файлу, що редагується.

 #Редагувати відкриті# Дозволяє відкривати в редакторі файли,
 #для запису файли# які відкриті для запису іншими
програмами. Цей режим зручний, коли потрібно
 отримати доступ до відкритого протягом
 довгого часу файлу, але він може бути
 небезпечним, якщо цей файл модифікується
 одночасно з редагуванням.

 #Блокувати# При відкритті на редагування файлу,
 #редагування# має атрибут "тільки для читання",
 #файла з атрибутом R/O# редактор також переходить у режим заборони
 модифікації вмісту файлу, як якщо
 б натиснули #Ctrl-L#.

 #Предупреждать при# Перед відкриттям на редагування файлу,
 #відкриття файлу з# має атрибут "тільки для читання",
 #атрибутом R/O# видаватиметься попереджувальне повідомлення.

 #Використовувати кодову# Використати кодову сторінку ANSI при
 #сторінку ANSI з редагування файлів, інакше - OEM.
 #замовчуванням#

 #Використовувати кодову# Використати кодову сторінку ANSI при
 #сторінку ANSI при створенні файлів, інакше - OEM.
 створення файлів

 Якщо зовнішній редактор призначений на клавішу #F4#, він запускатиметься лише
у тому випадку, якщо ~асоційований~@FileAssoc@ редактор для даного типу
файлів немає.

 Змінені параметри не впливають на раніше відкриті вікна редактора.

Діалог налаштування також можна викликати з ~редактора~@Editor@, натиснувши
#Alt-Shift-F9#. Зміни набудуть чинності негайно, але діятимуть
лише на поточний сеанс роботи.


@CodePage
$ #Автовизначення кодової сторінки#
 FAR2L намагатиметься вибрати правильну кодову сторінку для перегляду/редагування
файлу. Зауважте, що коректне визначення не гарантується, особливо для
маленьких чи нетипових текстових файлів.

@FileAttrDlg
$ #Файлові атрибути#
 Ця команда дозволяє змінити атрибути та час як в окремих файлах, так
та у груп файлів та папок. Якщо вам не потрібно обробляти файли у вкладених
папки, скасуйте параметр "Обробляти вкладені папки".

 #Файлові атрибути#

 Для виділених об'єктів (файлів та папок) контрольні перемикачі мають 3
стану:

 #[x]# - атрибут встановлений для всіх об'єктів
 (Встановити у всіх)

 #[ ]# - атрибут скинутий для всіх об'єктів
 (Скинути у всіх)

 #[?]# - атрибут не у всіх об'єктів
 (Не змінювати цей атрибут)

 Якщо виділені об'єкти мають однакові атрибути, то контрольні
перемикачі будуть 2-х позиційними – встановити/скинути. Виняток
становить випадок, коли серед виділених об'єктів трапляються папки - у цьому
Якщо всі контрольні перемикачі будуть 3-х позиційними.

 Якщо стан контрольних перемикачів на момент виконання команди
установки атрибутів не змінилося (порівняно з початковим станом), то
зазначений атрибут не змінюватиметься.

 Якщо серед виділених об'єктів немає папок, то опція "Обробляти вкладені
папки" буде недоступною.

 Атрибути #Стиснутий#, #Зашифрований#, #Неіндексований#, #Розріджений#,
#Тимчасовий#, #Автономний#, #Точка повторної обробки# та #Віртуальний# доступні тільки на дисках з
файловою системою NTFS. Атрибут #Віртуальний# не використовується у Windows
2000/XP/2003. Атрибути #Стиснутий# і #Зашифрований# є взаємовиключними,
тобто. можна виставити лише один із них. У Windows 2000/XP/2003 виставлений
атрибут #Розріджений# скинути не можна.

Для ~символічних посилань~@HardSymLink@ у діалозі відображається шлях, на
що вона посилається. Якщо ця інформація недоступна, виводиться
повідомлення "#(немає даних)#".

 #Дата і час#

 Підтримуються чотири різних часу файлу:

 - час останнього запису;

 - час створення файла;

 - час останнього доступу;

 - Час зміни.

 Для дисків з файловою системою FAT години, хвилини та секунди часу
останнього доступу завжди дорівнюють нулю.

 Якщо ви не бажаєте змінювати час файлу, залиште відповідне поле
порожній. Ви можете натиснути кнопку #Blank# (Скинути), щоб очистити всі поля з
датами та часом, після чого змінити окрему складову дати та часу,
наприклад, тільки місяць або тільки хвилини. Інші значення полів залишаються
незмінними.

 Кнопка #Current# (Поточне) дозволяє заповнити поля часу файлу поточним
часом.

 Кнопка #Original# (Вихідне) заповнює поля часу файлу оригінальними
значеннями. Доступний для одиночного файлового об'єкта.


@Bookmarks
$ #Закладки#
 Закладки дозволяють забезпечити швидкий доступ до часто використовуваних
папок. Для створення закладки на поточну папку необхідно натиснути #Ctrl-Shift-0..9#.
Після цього, щоб перейти до папки, записаної у посиланні, достатньо натиснути
#ПравийCtrl-0..9 #. Якщо #ПравийCtrl-0..9# натиснутий у рядку редагування, то
шлях посилання буде вставлено у цей рядок. Закладки також доступні в меню
переходу.

Пункт #Закладки# в ~Меню команд~@CmdMenu@ дозволяє переглядати,
встановлювати, редагувати та видаляти закладки на папки та їх кнопкосполучення.

 Ви можете переміщати виділену закладку вгору та вниз натисканням сполучень
кнопок #Shift+Вгору# і #Shift+Вниз#.

 У режимі редагування (#F4#) ви не можете зробити посилання на плагінове
панель.



@FiltersMenu
$ #Меню фільтрів#
 За допомогою #Меню фільтрів# ви можете визначити набір типів файлів
заданими вами параметрами, за дотримання яких файл буде оброблений
використовує його операцією.

Меню складається із двох частин. У верхній частині розташовані Фільтри
#Користувача#, в нижній частині меню знаходяться маски всіх файлів, що містяться в
в поточній панелі файлів (а також маски файлів вибрані в
поточної області меню навіть якщо файлів відповідним до цих масок немає в поточній
панелі).

 Для Фільтру користувача доступні такі клавіші:

 #Ins# Створити новий фільтр, відкриється порожній діалог для
завдання параметрів ~фільтра~@Filter@.

#F4# Змінити існуючий ~фільтр~@Filter @.

#F5# Копіювати ~фільтр~@Filter@.

 #Del# Видалити фільтр.

 #Ctrl-Up# Перемістити фільтр на одну позицію вгору.

 #Ctrl-Down# Перемістити фільтр на одну позицію донизу.


 Управління як #Фільтрами користувача#, так і автоматично
згенерованими фільтрами (маски файлів), здійснюється такими клавішами:

 #Space#, Елементи, вибрані за допомогою #Space# або '#+#',
#Plus# позначаються символом +. Якщо такі елементи
 присутні, то будуть оброблені тільки
 файли, що задовольняють їм.

 #Minus# Елементи, вибрані за допомогою клавіші '#-#',
 позначаються символом '-', і всі, хто задовольняє
 ним файли не будуть оброблені.

 #I# і #X# Подібні #Plus# і #Minus#, але мають більше
 високий пріоритет під час фільтрації.

 #Backspace# Зняти позначку з вибраного об'єкта.

 #Shift-Backspace# Зняти позначку з усіх вибраних об'єктів.


 Позначка фільтрів зберігається у конфігурації.

 Коли фільтр використовується в панелі, це індикується символом '*' після
літери режиму сортування у верхньому лівому куті панелі.

 Меню фільтрів використовується в таких областях:
- ~Панель файлів~@FilePanel@;
- ~Копіювання, перенесення, перейменування та створення посилань~@CopyFiles@;
- ~Пошук файлу~@FindFile@.


@FileDiz
$ #Опис файлів#
 Описи можуть бути використані для того, щоб пов'язати з текстовим файлом
інформацію. Опис файлів поточної папки зберігається у цій папці у спеціальному
файл - списку описів. У ньому на початку кожного рядка міститься ім'я
описуваного файлу, та відокремлений від нього пробілами текст опису.

Описи можна переглянути у відповідних ~режимах перегляду~@PanelViewModes@
панелі файлів. За замовчуванням цими режимами є #Описи# та #Довгі#
# Описи #.

Команда #Опис файлів# (#Ctrl-Z#) з ~Меню файлів~@FilesMenu@
призначена для додавання описів до вибраних файлів.

 Імена списків описів можуть бути змінені в діалозі #Описи файлів# з
меню ~Меню параметрів~@OptMenu@. У цьому діалозі також можна встановити режим
оновлення локальних описів. Оновлення може бути заборонено зовсім,
дозволено, лише якщо поточний режим перегляду файлової панелі показує
описи, або дозволено завжди. За промовчанням FAR2L встановлює атрибут "Hidden"
на створені списки описів, але ви можете заборонити це, вимкнувши опцію
"Встановлювати атрибут "Hidden" на нові списки описів" цього ж діалогу.
Також тут ви можете вказати позицію для вирівнювання нових описів у списку
описів.

 Якщо файл з описами має атрибут "Тільки для читання", FAR2L не
оновлює описи та, після операцій перейменування/видалення файлових об'єктів,
буде виведено повідомлення про помилку. При увімкненій опції #Оновлювати файл#
#описів з атрибутом "Тільки для читання"# FAR2L спробує коректно оновити
описи.

 Якщо це дозволено в конфігурації, FAR2L оновлює опис файлів при
копіювання, перенесення та видалення файлів. Але якщо команда обробляє і частину
файлів у вкладених папках, для цих файлів описи не оновлюються.


@PanelViewModes
$ #Налаштування режимів перегляду панелі файлів#
~Панель файлів~@FilePanel@ може виводити інформацію, використовуючи 10 заданих
заздалегідь режимів: короткий, середній, повний, широкий, детальний, опис,
довгі описи, власники файлів, посилання файлів, альтернативний повний. Зазвичай
цього досить, але, за бажанням можна змінити параметри цих
режимів або навіть повністю замінити їх на нові.

Команда #Режими панелі файлів# з меню ~Меню параметрів~@OptMenu@ дозволяє
змінити параметри режимів перегляду. Спочатку вона пропонує вибрати потрібний
режим зі списку. У цьому списку режим 0 відповідає режиму перегляду,
викликається по #ЛівийCtrl-0# (альтернативний повний), режим 1 відповідає
короткому режиму (#ЛівийCtrl-1#), режим 2 відповідає середньому режиму
(#ЛівийCtrl-2#) і так далі. Після вибору режиму з'являється діалог, у якому
можна змінити такі параметри:

 - #Типи колонок# - типи колонок кодуються за допомогою однієї
або кількох букв, розділених комами. Допускаються такі
типи колонок:

 N[M,O,R] - ім'я файлу
 де: M – показувати символи позначки;
 O - показувати імена без шляхів (призначено
в основному для ~модулів, що підключаються~@Plugins@);
 R - вирівнювати імена з правого краю;
 Ці символи можна комбінувати, наприклад NMR

 S[C,T,F,E] - розмір файлу
 P[C,T,F,E] - упакований розмір файлу
 G[C,T,F,E] - розмір потоків файлу
 де: C – форматувати розмір файлу;
 T - використовувати 1000 замість 1024 як дільник;
 F - відображати розмір файлу в стилі Windows
 Explorer (тобто 999 байт будуть показані
 як 999, а 1000 б як 0.97 K);
 E - економічний режим, не показувати пробіл
 перед суфіксом розміру файлу
 (тобто 0.97KB);

 D - дата останнього запису у файл
 T - час останнього запису у файл

 DM[B,M] - дата і час останнього запису файл
 DC[B,M] - дата та час створення файлу
 DA[B,M] - дата та час останнього доступу до файлу
 DE[B,M] - дата та час зміни файлу
 де: B – короткий (Unix-стиль) формат часу файлу;
 M – використання текстових імен місяців;

 A – атрибути файлу
 Z - опис файлу

 O[L] - власник файлу
 де: L – відображати також ім'я домену;

 LN - кількість жорстких посилань

 F – кількість потоків

 Якщо опис типів колонок містить більше однієї колонки імені
файлу, панель файлів буде відображатися у багатоколонній формі.

 Атрибути файлу мають такі позначення:

 #R# - Тільки для читання
 #S# - Системний
 #H# - Прихований
 #A# - Архівний
 #L# - Зв'язок або символічне посилання
 #C# або #E# - Стиснутий або Зашифрований
 #$# - Розріджений (sparse)
 #T# - Тимчасовий
 #I# - Неіндексований за вмістом
 #O# - Автономний (offline)
 #V# - Віртуальний

Порядок відображення атрибутів – RSHALCTIOV. Символ атрибуту
"Розріджений" використовується тільки для файлів і ставиться замість 'L'.
Символ атрибута "Зашифроване" ставиться замість 'C', т.к. файл/каталог не
можуть мати одночасно обидва атрибути ("Стиснутий" і "Зашифрований"). за
за замовчуванням розмір колонки атрибутів – 6 символів. Для відображення
додаткових атрибутів 'T', 'I', 'O' та 'V' необхідно явно вказати
розмір колонки 10 символів.

 - #Ширина колонок# - дозволяє змінити ширину колонок панелі.
Якщо ширина дорівнює 0, використовується значення за замовчуванням.
Якщо ширина колонки з ім'ям, описом або власником дорівнює 0,
вона буде підрахована автоматично залежно від ширини панелі.
Для правильної роботи з різною шириною екрана настійно
рекомендується, щоб у кожному режимі перегляду була хоча б одна
колонка з шириною, що автоматично обчислюється.
Ширину колонки також можна встановити у відсотках від вільного місця
що залишився після колонок з фіксованою шириною, для цього після
числового значення необхідно дописати знак %. Якщо сумарний розмір
таких колонок більше 100%, їх розміри відповідно масштабуються.

 Для використання 12-годинного формату часу треба збільшити
на одиницю стандартну ширину колонки часу файлу або колонки
часу та дати файлу. Після подальшого збільшення у цих колонках
також будуть показані секунди та мілісекунди.

 Для показу року у 4-х символьному форматі потрібно збільшити ширину
стовпчика дати на 2.

 При вказівці колонок, що відповідають за показ посилань, потоків та власників (G, LN, F та O) час
відображення вмісту каталогу збільшується.

 - #Типи колонок рядка статусу# і #Ширина колонок рядка статусу# -
аналогічно "Типам колонок" та "Ширині колонок", але для рядка статусу
панелі.

 - #Повноекранний режим# - показувати панель на весь екран замість
половини екрану.

 - #Вирівнювати розширення файлів# - показувати розширення файлів
вирівняними.

 - #Вирівнювати розширення папок# - показувати розширення папок
вирівняними.

 - #Показувати папки великими літерами# - показувати всі імена папок
у верхньому регістрі, незалежно від реального регістру.

 - #Показувати файли малими літерами# - показувати всі імена файлів
у нижньому регістрі, незалежно від реального регістру.

 - #Показувати імена файлів із великих літер малими літерами# -
показувати всі імена файлів, які містять лише великі літери,
малими літерами. За замовчуванням ця опція увімкнена, але якщо ви хочете
завжди бачити справжній регістр імені файлу, вимкніть його, а також
#Показувати папки великими літерами# і #Показувати файли малими літерами#.
Всі ці параметри впливають тільки на спосіб показу файлів, для їх обробки
FAR2L завжди використовує цей регістр.


@SortGroups
$ #Групи сортування#
Групи сортування можуть застосовуватися в ~панелі файлів~@FilePanel@ спільно
з сортуванням #на ім'я# або #по розширенню#. Вони активізуються при натисканні
#Shift-F11# і дозволяють встановити правила сортування файлів, що доповнюють вже
діючі.

 Кожна група сортування складається з однієї чи кількох розділених
комами ~масок файлів~@FileMasks@. Якщо позиція однієї групи сортування в
у загальному списку груп вище, ніж у іншої групи, то при сортуванні за зростанням
всі файли, що належать до цієї групи, будуть вищими, ніж ті, що належать до іншої
групі.

Команда #Групи сортування з ~Меню команд~@CmdMenu@ дозволяє видаляти,
створювати та редагувати групи сортування, використовуючи клавіші #Del#, #Ins# та
# F4 #. Групи, що знаходяться вище роздільника меню, відносяться до початку файлової
панелі, і всі файли, що потрапили в ці групи, будуть розташовані вище не потрапили
у них файлів. Групи, що знаходяться нижче роздільника меню, належать до кінця
файлової панелі, і всі файли, що потрапили в ці групи, будуть розташовані нижче
файлів, що в них потрапили.


@FileMasks
$ #Маски файлів#
 Маски файлів часто використовуються у командах FAR2L для вибору окремих файлів
та папок або їхніх груп. Маски можуть містити звичайні допустимі в іменах файлів
символи, '*' і '?', а також спеціальні вирази:

 #*# будь-яку кількість символів (в т.ч. жодного);

 #?# будь-який символ;

 #[c,xz]# будь-який символ з квадратних дужках.
 Допускаються окремі символи, та його діапазони.

 Наприклад, файли ftp.exe, fc.exe та f.ext можуть бути вибрані за допомогою маски
f*.ex?, маска *co* вибере і color.ini, і edit.com, маска [cf,t]*.txt може
вибрати config.txt, demo.txt, faq.txt та tips.txt.

 У багатьох командах FAR2L можна задати кілька розділених комами або
крапкою з комою масок. Наприклад, щоб вибрати всі документи, можна ввести
*.doc,*.txt,*.wri у команді "Позначити групу".

 Дозволяється укладати будь-яку з масок (але не весь список) у подвійні лапки.
Наприклад, це потрібно робити, коли маска містить один із символів-розділювачів
(кома або точку з комою), щоб така маска не була сплутана зі списком.

У масках можна використовувати ~регулярні вирази~@RegExp@, при цьому текст
регулярного виразу має бути оточений символами #/#.

 Приклад:
 #/(eng|ukr)/i# файли, імена яких містять рядки "eng" або "ukr",
 регістр символів не враховується.

У деяких ситуаціях (~пошук~@FindFile@ файлів, ~фільтр~@Filter@,
~меню фільтрів~@FiltersMenu@,
~позначка~@SelectFiles@ файлів, ~асоціації~@FileAssoc@ файлів
і ~розмальовка та групи сортування~@Highlight@ файлів) можна
використовувати маски виключення. #Маска виключення# є одна або кілька масок
файлів, яким не повинні відповідати імена потрібних файлів, вона
відокремлюється від основної маски символом '#|#'.

^Приклади використання масок виключення:
 1. *.cpp
 Усі файли з розширенням cpp.
 2. *|*.bak,*.tmp
 Усі файли, крім файлів з розширенням bak та tmp.
 3. *|
 Помилка - введено спецсимвол |, але сама маска виключення не
 вказано.
 4. *|*.bak|*.tmp
Помилка – спецсимвол | не може зустрічатися більше одного разу.
 5. |*.bak
 Обробляється як *|*.bak
 6. *|/^pict\d{1,3}\.gif$/i
 Усі файли, крім pict0.gif - pict999.gif, незалежно від регістру символів.

 Через кому (або точку з комою) перераховуються маски файлів, а при
допомоги '|' маски-включення відокремлюються від масок-виключення.


@SelectFiles
$ #Помітка файлів#
Для обробки файлів та папок ~панелі файлів~@FilePanel@ вони можуть бути
обрані декількома різними способами. #Ins# позначає файл під курсором і
переміщує курсор вниз, #Shift-Клавіші курсору# дозволяють переміщати курсор в
різних напрямках.

 #Gray +# та #Gray -# вибирають або знімають позначку з групи з використанням
однієї або кількох розділених комами ~масок файлів~@FileMasks@. #Gray *#
інвертує поточну позначку. Команда #Відновити позначку# (#Ctrl-M#)
відновлює вибрану раніше групу.

 #Ctrl-<Gray +># і #Ctrl-<Gray -># вибирають або знімають позначку з усіх
файлів з тим самим розширенням, що й у файлу під курсором.

 #Alt-<Gray +># та #Alt-<Gray -># вибирають або знімають позначку з усіх файлів
з тим самим ім'ям, що й у файлу під курсором.

#Ctrl-<Gray *># інвертує поточну позначку, включаючи папки. Якщо параметр
#Позначка папок# у діалозі ~Налаштувань панелі~@PanelSettings@ включена, це
працює аналогічно #Gray *#.

 #Shift-<Gray +># і #Shift-<Gray -># вибирають або знімають позначку з усіх
файлів.

 Якщо жоден файл не вибраний, буде оброблено лише файл під курсором.


@CopyFiles
$ #Копіювання, перенесення, перейменування та створення зв'язків та посилань#
 Наступні команди можуть бути використані для копіювання, перенесення та
перейменування файлів та папок:

Копіювати ~вибрані~@SelectFiles@ файли #F5#

 Копіювати файл під курсором незалежно #Shift-F5#
 від позначки

 Перейменувати або перенести вибрані файли #F6#

 Перейменувати або перенести файл під курсором #Shift-F6#
 незалежно від позначки

 Для папки: якщо шлях, який ми задали (відносний або абсолютний)
відповідає існуючій папці, переміщує в цю папку; інакше змінює
шлях на заданий.
 Наприклад, при переміщенні #/folder1/# в #/folder2/#:
 - якщо #/folder2/# існує, то вміст #/folder1/# переміститься в
#/folder2/folder1/#;
 - інакше вміст #/folder1/# переміститься в
новостворену папку #/folder2/#.

Створення ~посилань~@HardSymLink@ файлів та папок #Alt-F6#

 Якщо увімкнено опцію "#Обробляти кілька імен файлів#", то в рядку
введення може вказуватись як одна мета для копіювання або переміщення, так і
кілька. В останньому випадку цілі мають бути розділені символом-розділювачем
"#;#" або "#,#". Якщо ціль містить у своєму імені символ ";" (або ","), то ця
ціль повинна бути взята в лапки.

 Якщо опція #Копіювати режим доступу до файлів# увімкнена, то копії файлів отримають такі самі
UNIX режими доступу як у оригінальних файлів, за винятком бітів відфільтрованих umask.

 Якщо опція #Копіювати розширені атрибути включена, то копії файлів отримають такі ж
розширені атрибути як оригінальні файли.

 Якщо опція #Вимкнути кешування запису# увімкнена, то копіювання буде здійснюватися
минаючи кеш запису, якщо файлова система та ОС підтримують режим O_DIRECT.

 Якщо опція # Створювати розріджені файли включена, то процедура копіювання буде
включати пошук заповнених тільки нулями регіонів файлів розміром 4КБ і більше - на
На місці таких регіонів результуючі розріджені файли будуть містити "дірки". Це дозволяє
заощадити місце та прискорити копіювання якщо файли містять великі області нульових даних.
Потенційним мінусом є підвищена фрагментація файлу, якщо в подальшому ці регіони
будуть перезаписані звичайними даними.

 Якщо опція #Використовувати копіювання-при-запису якщо можливо# увімкнена, то процедура
копіювання буде використовувати спеціальний API ядра, який копіює файли таким чином,
що скопійований файл свідчить про дані оригінального файла. Дані будуть фактично
скопійовані лише у випадку коли один із файлів буде модифікований. Врахуйте що ця
функціональність вимагає ядро ​​Linux версії 4.5+ або MacOS v10.12+ та файлову систему,
яка підтримує такі файли. В іншому випадку файли будуть скопійовані звичайним способом.
У разі використання ця опція значно прискорює копіювання та заощаджує місце на диску.
Потенційним мінусом є підвищена фрагментація файлу, якщо надалі цей файл
або його початкова копія буде перезаписана.

 Випадаючий список #Символічні посилання дозволяє вибрати один з трьох можливих 
способів копіювання зустрічених символічних посилань:
 - Або всі символічні посилання будуть скопійовані як посилання.
 - Або far2l перевірятиме шлях, який вказується кожним посиланням щоб зрозуміти -
він вказує на "зовнішній" файл або один з так само копіюваних файлів. В першому випадку
посилання буде скопійовано як файл, а в другому випадку буде створено посилання, яке буде
посилатись на новий екземпляр файлу.
 - Або всі символічні посилання буде скопійовано як файли.

 Якщо ви бажаєте створити папку призначення перед копіюванням, додайте до неї
імені зворотну межу. Також у діалозі копіювання ви можете натиснути #F10# для
вибору папки з дерева активної файлової панелі або #Alt-F10# для вибору
пасивної файлової панелі дерева. #Shift-F10# дозволяє відкрити дерево з урахуванням
шляху, що міститься в рядку введення (якщо там перераховано кілька шляхів, то
враховується лише перший із них). Якщо увімкнено опцію "#Обробляти кілька#
#імен файлів#", то вибрана папка додається до вмісту рядка введення через
точку з комою.

 Можливість копіювання, перенесення та перейменування файлів для підключених
модулів залежить від функціональності конкретного модуля.

 Якщо файл, у який виконується копіювання, вже існує, він може
бути перезаписаний, пропущений, або вміст копійованого файлу може бути
дописано до його кінця.

 Якщо диск, на який виконується копіювання або перенесення файлів, в ході
операції заповнився, то можна або скасувати операцію, або замінити диск та
вибрати пункт "Розділити", після чого файл, що копіюється, буде розділений між
дисками. Ця функція доступна лише за вимкненого параметра "Використати
системну функцію "копіювання" з діалогу ~Системні параметри~@SystemSettings@.

 Параметр "Вже існуючі файли" визначає поведінку FAR2L для випадку,
коли однойменний файл вже існує у папці-приймачі.
 Можливі значення:
# Запит дії # - буде відображено ~діалог~@CopyAskOverwrite@ із запитом;
 # Замість # - всі існуючі файли будуть замінені копіюваними;
 #Пропустити# - існуючі файли залишаться без змін;
 #Ім'я# - існуючі файли залишаться без змін, копіювати будуть присвоєні інші імена;
 #Дописати# - файли, що копіюються, будуть дописані в кінець існуючих;
 #Тільки нові/оновлені файли# - копіювати тільки файли з новішими
датою та часом запису. Стан цієї опції не зберігається на майбутні сеанси копіювання.
 #Запит підтвердження для R/O файлів# - визначає, чи потрібне додаткове
підтвердження для файлів із встановленим атрибутом "лише читання".

 При перенесенні файлів для визначення того, чи має операція здійснюватись
як копіювання з подальшим видаленням або як пряме перенесення (у межах
одного фізичного диска), FAR2L враховує ~символічні посилання~@HardSymLink@.

 Для копіювання файлів, які підпадають під певні умови, використовуйте
перемикач #Використовувати фільтр#. Налаштування умов ~фільтру~@FiltersMenu@
здійснюється кнопкою "Фільтр". Врахуйте, що якщо ви копіюєте каталог з
файлами і жоден з них не підпадає під умови фільтра, то порожній каталог в
місце призначення не буде скопійовано.


@CopyAskOverwrite
$ #Копіювання: запит дії#
 Якщо однойменний файл вже існує у папці-приймачі, FAR2L запропонує на вибір
кілька можливих дій:

 # Замість # - існуючий файл буде замінено копіюваним;

 #Пропустити# - існуючий файл залишиться без змін;

 #Ім'я# - існуючі файли залишаться без змін, копіювати будуть присвоєні інші імена;

 #Дописати# - файл, що копіюється, буде дописаний в кінець існуючого.

 Якщо відмічено перемикач #Запам'ятати вибір#, вибрана дія буде
використано для всіх існуючих файлів у поточному сеансі копіювання
і повторні запити не з'являтимуться.

 Якщо для прийняття рішення вам недостатньо інформації про розмір та дату останньої
запису файлів, ви також можете порівняти їх вміст за допомогою вбудованої програми перегляду.


@CopyRule
$ #Копіювання: правила#
Під час копіювання/переміщення~@CopyFiles@ папок та
~символічних посилань~@HardSymLink@ дотримуються наступних правил.

 #Копіювання символічного посилання#

 Якщо увімкнено опцію "Копіювати вміст символічних посилань"
 або джерело або приймач - мережні диски, то приймачі
 створюється папка і в неї копіюється вміст посилання-джерела
 (Для вкладених посилань рекурсивно).

 Якщо опцію "Копіювати вміст символічних посилань" вимкнено,
 і джерело і приймач - локальні диски, то у приймачі створюється
 зв'язок або символічне посилання, залежно від типу джерела.

 #Переміщення символічного посилання#

 Якщо увімкнено опцію "Копіювати вміст символічних посилань"
 або джерело або приймач - мережні диски, то приймачі
 створюється папка і в неї копіюється вміст посилання-джерела
(Для вкладених посилань рекурсивно). Саме посилання у джерелі
 видаляється.

 Якщо опцію "Копіювати вміст символічних посилань" вимкнено,
 і джерело і приймач - локальні диски, то посилання-джерело просто
переноситься. Рекурсивний спуск по дереву не провадиться.

 #Переміщення каталогу, що містить символічні посилання#

 Якщо джерело та приймач – локальні диски, то каталог просто
 переміщується.

 Якщо джерело або приймач - мережні диски, незалежно від
 стану опції "Копіювати вміст символічних посилань"
 у приймачі створюється папка і до неї копіюється вміст
 посилання-джерела (для вкладених посилань рекурсивно).
 Саме посилання у джерелі видаляється.


@HardSymLink
$ #Жорсткі посилання, зв'язки папок, символічні посилання#

 На розділах NTFS можна створювати #жорсткі посилання# (HardLink) для файлів,
#зв'язку# (Junction) для папок та #символічні посилання# (SymLink) для файлів та
папок за допомогою команди Alt-F6#.


 #Жорсткі посилання#

 Жорстке посилання (HardLink) - це просто ще один запис у папці для даного
файлу.

 Коли створюється жорстке посилання, сам файл не копіюється фізично, а лише
з'являється під ще одним ім'ям або в ще одному місці, а його старі ім'я та
місцезнаходження залишаються недоторканими. З цього моменту жорстке посилання
# не відрізняється від початкового запису в папці. Єдина відмінність - те, що
для жорсткого посилання не створюється коротке ім'я файлу, тому з ДОС-програм вона
не видно.

 Коли змінюється розмір або дата файлу, всі відповідні записи у папках
оновлюються автоматично. При видаленні файлу він не видаляється фізично
доки всі жорсткі посилання, що вказують на нього, не будуть видалені. Порядок їх
Видалення значення не має. При видаленні жорсткого посилання в кошик кількість
посилань у файлу зберігається.

 FAR2L вміє створювати жорсткі посилання, відображати їх кількість для кожного
файлу в окремій колонці (за замовчуванням це остання колонка у 9-му режимі
панелей), а також сортувати файли за кількістю жорстких посилань.

 Створювати жорсткі посилання можна тільки на тому ж диску, на якому розташовано
початковий файл.


 #Звязки#

 Ця технологія дозволяє відображати будь-які локальні папки на будь-які інші
локальні папки. Наприклад, якщо папка D:\\SYMLINK вказує на C:\\WINNT\\SYSTEM32
в якості своєї мети, то програма, що звертається до D: SYMLINK DRIVERS, буде
насправді звертатися до C:WINNTSYSTEM32DRIVERS. На відміну від жорстких
посилань, зв'язку папок не обов'язково повинні розміщуватися на тому ж диску.
 У Windows 2000 не можна безпосередньо створити зв'язок, що посилається на папку CD-ROM,
але це обмеження можна обійти, змонтувавши CD-ROM на папку NTFS-розділу.


 #Символічні посилання#

 Символічні посилання (SymLink) на NTFS підтримуються, починаючи з Windows Vista
(NT 6.0). Вони є поліпшеним варіантом зв'язків каталогів - символічні
посилання можуть вказувати як на папки, так і на файли як на локальні, так і на мережеві,
у своїй підтримуються відносні шляхи.


@ErrCopyItSelf
$ #Помилка: копіювання/перенесення "в себе"#
 Ви не можете копіювати/переносити файл або папку "в себе".

 Ця помилка також виникає, якщо є дві папки, одна з яких
є ~символічним посиланням~@HardSymLink@ на іншу.


@WarnCopyStream
$ #Попередження: Вихідний файл містить більше одного потоку даних#
 Вихідний файл містить більше одного потоку даних або файлова система
призначення не підтримує багатопоточність файлових об'єктів.

 Потоки - це можливість файлової системи NTFS, що дозволяє асоціювати з
файлом додаткову інформацію (наприклад, відомості про його автора, назву,
ключові слова тощо, а також будь-які інші дані). Ця інформація зберігається
разом із файлом і ніяк не видно при використанні програм, що не підтримують
потоки. Зокрема, потоки використовує Windows Explorer для зберігання додаткових
властивостей файлу. Файлові системи FAT/FAT32 не підтримують потоки.

 Щоб скопіювати файловий об'єкт повністю (з усіма потоками),
увімкніть опцію #"Використовувати системну функцію копіювання"# у діалозі
налаштування ~системних параметрів~@SystemSettings@.

 Якщо ви копіюєте багатопотоковий файловий об'єкт на тому, що відрізняється від NTFS,
то й у цьому випадку втратите дані – буде скопійовано лише основний потік.


@WarnCopyEncrypt
$ #Попередження: Втрата шифрування файлу#
Вихідний файл зашифровано. Копіювання або переміщення його за межі
вихідного диска можливо, якщо файл призначення буде розшифровано.

 Кнопки "Ігнорувати" (або "Ігнорувати всі") ігнорують це
попередження та файл копіюється у нове місце нешифрованим.

 Для копіювання шифрованого файлу за межі вихідного диска буде використано
внутрішній механізм копіювання, незалежно від того, включений параметр
"Використовувати системну функцію копіювання" чи ні.


@ErrLoadPlugin
$ #Помилка: плагін не завантажений#
 Ця помилка з'являється у випадках, коли:

 1. Для нормальної роботи DLL-модуля потрібна динамічна
 бібліотека, яка відсутня у вашій системі.

 2. Модуль з якоїсь причини повернув системі інформацію про
 неприпустимість подальшого завантаження.

 3. DLL-модуль плагіна зіпсований.


@ScrSwitch
$ #Переключення між екранами#
 FAR2L дозволяє відкрити кілька копій вбудованої програми перегляду та
редактора. Використовуйте #Ctrl-Tab#, #Ctrl-Shift-Tab# або #F12# для перемикання
між панелями та екранами з цими копіями. #Ctrl-Tab# перемикає на наступний
екран, #Ctrl-Shift-Tab# на попередній, #F12# виводить список усіх доступних
екрани.

 Кількість фонових екранів редагування та перегляду відображається в
верхньому лівому кутку лівої панелі. Ви можете заборонити показ кількості екранів,
використовуючи діалог ~Налаштування панелі~@PanelSettings@.


@ApplyCmd
$ # Застосувати команду
Використовуючи пункт #Застосувати команду# з ~Меню файлів~@FilesMenu@,
Ви можете застосувати команду до кожного поміченого файлу. Для позначення
імені файлу повинні використовуватися ті ж ~символи~@MetaSymbols@, що
та в ~Асоціаціях файлів~@FileAssoc@.

Наприклад, 'type !.!' буде виводити на екран всі помічені файли
черги, а команда 'rar32 m !.!.rar !.!' перенесе всі зазначені файли в
однойменні RAR-архіви. Команда 'explorer /select,!.!' запустить провідник і
встановить курсор на поточному файлі чи папці.

також ~"Команда операційної системи"~@OSCommands@


@OSCommands
$ # Команди операційної системи #
 FAR2L самостійно обробляє наступні команди операційної
системи:

 #CLS#

 Очищення екрана.

 #disk:#

 Змінити на панелі поточний диск на вказаний диск.

 #CD [disk:]path# або #CHDIR [disk:]path#

Змінити на панелі поточний шлях на вказаний path. Якщо вказано ім'я диска,
змінюється так само і диск. Якщо активна панель відображає файлову систему,
підтримувану ~зовнішнім модулем~@Plugins@, то команда "CD" у командному рядку
може бути використана для зміни поточної папки файлової системи. В
на відміну від "CD" команда "CHDIR" завжди сприймає вказаний параметр як ім'я
реальної папки, незалежно від типу файлової панелі.

 #CHCP [nnn]#

Виведення або зміна поточного номера кодової сторінки. "nnn" - номер кодовий
сторінки. CHCP без параметра покаже поточний номер кодової сторінки.

 #SET variable=[string]#

Встановити змінне середовище "variable" у значення "string". Якщо "string"
не вказано, то змінне середовище "variable" буде видалено. Деякі
~змінні середовища~@FAREnv@ FAR2L встановлює при старті самостійно.

 #IF [NOT] EXIST filename command#

Виконати команду "command", якщо "filename" існує. Префікс "NOT"
свідчить про зворотне умова, тобто. виконати команду "command" якщо "filename"
Не існує.

 #IF [NOT] DEFINED variable command#

 Команда аналогічна IF EXIST, але перевіряє існування змінного середовища
"Variable". Якщо змінне середовище "variable" існує, то буде виконано
команда "Command".

 Команди "IF" можуть бути вкладені, наприклад команда "command"

 #if exist file1 if not exist file2 if defined variable command#

 буде виконана тільки в тому випадку, якщо існує файл "file1" та не
існує файл "file2" і визначено змінне середовище "variable".

 #pushd path#

 Команда PUSHD зберігає поточний каталог у внутрішньому стеку та робить
поточний каталог path.

 #popd#

 Переходить до каталогу, збереженого командою PUSHD.

 #clrd#

 Очищає стек каталогів, збережених командою PUSHD.

 Примітки:

 1. ^<wrap>Якщо синтаксис команд відрізняється від зазначених, то
FAR2L передає управління командному процесору
операційна система.

 2. Перераховані команди працюють у:
- ~Командному рядку~@CmdLineCmd@
- ~Застосувати команду~@ApplyCmd@
- ~Меню користувача~@UserMenu@
- ~Асоціація файлів~@FileAssoc@


@FAREnv
$ #Змінні середовища #
 Після запуску FAR2L виставляє наступні змінні середовища, доступні
дочірнім процесам:

 #FARHOME# каталог, з якого було запущено FAR2L.

 #FARLANG# назва поточної мови інтерфейсу

#FARUSER# ^<wrap>ім'я користувача, вказане у параметрі /u ~командного рядка~@CmdLine@

 #FARDIRSTACK# ^<wrap>зміст вершини стека каталогів (який управляється командами pushd і popd)

 #FARADMINMODE# ^<wrap>рівна "1", якщо FAR2L запущений від імені адміністратора

@RegExp
$ #Регулярні висловлювання для пошуку#
 Синтаксис регулярних виразів майже повністю збігається із перловими регекспами.

 Загальний вигляд: #regexp# або /#regexp#/#options#.

 Опції (#options#):
 #i# - ігнорувати регістр
#s# - ^<wrap>розглядати текст як один рядок, '.' збігається з абсолютно будь-яким знаком
#m# - ^<wrap>розглядати текст як багато рядків. ^ і $ збігаються з початком та кінцем
будь-якого "внутрішнього" рядка
 #x# - ^<wrap>просто пробільні знаки (без зворотного сліша попереду) ігноруються -
корисно у складних висловлюваннях для структуризації

#regexp# - послідовність знаків та метасимволів. До знаків
відносяться літери та цифри, все інше, якщо і не є метасимволом, може
їм стати, тому все, що не є буквою і не є цифрою, слід робити
знаком "насильно". Для цього треба перед ним поставити зворотний сліш -
#\#.

 Всі сліди (і прямі, і зворотні) у вашому
регулярному вираженні повинні писатися зі спецсимволом попереду, щоб не
бути поплутаними з іншими спецсимволами або кінцем виразу. Приклад: рядок
"велике\біле/страшне" у вигляді регулярного виразу має виглядати так -
"велике\біле\/страшне".

 #Метасимволи#

 #\# - ^<wrap>наступний за ним знак буде розглянутий саме як знак, а не як метасимвол
 #^# - ^<wrap>початок рядка
 #$# - ^<wrap>кінець рядка
#|# - ^<wrap>альтернатива. Повинно збігтися вираз до або після |

 ^<wrap>Приклад: "\d+\w+|Hello\d+" працює як "(\d+\w+)|(Hello\d+)", а не як "\d+(\w+|H)ello\d+".

 #()# - ^<wrap>угруповання - угруповання служить або для використання
"посилань", або для використання фрагмента тексту, що потрапив у дужку, при заміні.
 #[]# - ^<wrap>клас знаків - це метасимвол який збігається з будь-яким
перелічених у #[]# знаком чи діапазоном знаків. Діапазони вказуються наприклад: [az]
Метасимволи не враховуються у класах символів. Якщо перший знак класу - #^#, це робиться негативний клас. Якщо
хочеться додати до класу знак #^#, він або не повинен бути першим, або перед ним повинен бути #\#.

 Крім угруповання круглі дужки служать ще для наступних операцій:
 #(?:pattern)# - ^<wrap>звичайне угруповання, але тільки ця дужка не отримує "номера".
#(?=pattern)# - ^<wrap>перегляд вперед. Збіг продовжиться з того ж місця, але тільки якщо pattern у цій дужці
співпав. Наприклад, #\w+(?=\s)# збігається зі словом, за яким йде пробіл, причому пробіл не буде
включено до результату пошуку.
#(?!pattern)# - ^<wrap>заперечення перегляду вперед. Збіг продовжиться з того ж місця, якщо pattern НЕ
збігається. Наприклад, #foo(?!bar)# збігається з будь-яким входженням "foo", яке зустрічається без
наступного "bar". Пам'ятайте, що цей вираз має нульовий розмір, що означає, що
#a(?!b)d# збігається з #ad#, тому що #a# супроводжується знаком, який не #b# (а #d#),
а #d# йде за виразом нульового розміру.
#(?<=pattern)# - ^<wrap>перегляд назад. На жаль, pattern має бути фіксованою довжиною.
#(?<!pattern)# - ^<wrap>заперечення перегляду назад. Ті ж обмеження, що й для перегляду.

 #Квантифікатори#

 За будь-яким знаком, групою або класом знаків може йти один із
квантифікаторів:

 #?# - ^<wrap>жадний збіг 0 або один раз.
 #??# - ^<wrap>нежадібний збіг 0 або один раз.
 #*# - ^<wrap>жадний збіг 0 або більше разів.
 #*?# - ^<wrap>нежадібний збіг 0 або більше разів.
 #+# - ^<wrap>жадібний збіг 1 або більше разів.
 #+?# - ^<wrap>нежадібний збіг 1 або більше разів.
 #{n}# - ^<wrap>збіг точно n разів.
 #{n,}# - ^<wrap>жадібний збіг n або більше разів.
 #{n,}?# - ^<wrap>нежадібний збіг n або більше разів.
 #{n,m}# - ^<wrap>жадний збіг не менше ніж n, але не більше ніж m разів.
 #{n,m}?# - ^<wrap>нежадний збіг не менше ніж n, але не більше ніж m разів.
 #{,m}# - ^<wrap>еквівалентно {0,m}
 #{,m}?# - ^<wrap>еквівалентно {0,m}?


 Що таке "жадібний" і "нежадібний" квантифікатор #

Жадібний квантифікатор захоплює якнайбільше. І тільки якщо
подальшого збігу не вийшло, "віддає" захоплене (відбувається
"відкат", не "дешева" операція).
 Якщо вираз "A.*Z" порівняти рядку
"AZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", то #.*# спочатку захопить весь рядок, а
потім буде по одному знаку "відкочуватися" поки не знайде Z. А якщо
вираз буде "A. *? Z", то Z знайдеться відразу ж. Нежаданий квантифікатор ще
називають #мінімізуючим#, він захоплює мінімально можливу кількість
знаків, і тільки якщо подальший збіг не вийшло, захоплює ще.

 #Спецсимволи#

 Перед небукою і нецифрою можна здебільшого ставити знак '#\#', а
для літер та цифр це робити потрібно обережно, бо таким чином позначаються
спецсимволи:

#.# - ^<wrap>будь-який знак, крім перекладу рядка. Якщо серед опцій є s, взагалі будь-який знак.
 #\t# - tab (0x09)
 #\n# - new line (lf, 0x0a)
 #\r# - return (cr, 0x0d)
 #\f# - form feed (0x0c)
 #\a# - bell (0x07)
 #\e# - escape (0x1b)
 # xNNNN - hex char, де N - [0-9A-Fa-f].
 #\Q# - ^<wrap>початок квотування метасимволів - все, що квотується,
буде оброблятися як текст, а не як регулярний вираз
 #\E# - кінець квотування метасимволів
 #\w# - буква, цифра або '_'.
 #\W# - не \w
 #\s# - пробельний знак (tab/space/lf/cr).
 #\S# - не \s
 #\d# - цифра
 #\D# - не цифра
 #\i# - літера
 #\I# - не буква
 #\l# - знак у нижньому регістрі
 #\L# - не знак у нижньому регістрі
 #\u# - знак у верхньому регістрі
 #\U# - не знак у верхньому регістрі
 #\b# - ^<wrap>межа слова - означає, що ліворуч або праворуч від поточної
позиції знаходиться знак із "слова", а праворуч або зліва, відповідно, з "не слова"
 #\B# - не \b
 #\A# - початок тексту, незалежно від опції m
 #\Z# - кінець тексту, незалежно від опції m
#\O# - ^<wrap>точка "повернення". Якщо під час матчингу пройдено цей знак,
то відкату не буде, відразу видасть no match. Можна, можливо
використовувати у складному вираженні після обов'язкового
фрагмент з квантифікатором. Цей спецсимвол можна
використовувати, коли оброблювані обсяги даних дуже
великі.
 Приклад:
 /.*?name\O=(['"])(.*?)\1\O.*?value\O=(['"])(.*?)\3/
 ^<wrap>Рядки, в яких є "name=", але немає "value=", будуть оброблятися (фактично - пропускатися) швидше.

#\NN# - ^<wrap>посилання на раніше збіглу дужку. NN - ціле число
від 0 до 15. Кожна дужка крім (?: pattern), (? = pattern),
(?! pattern), (? <= pattern) та (? <! pattern)
має номер (за порядком появи дужки, що відкриває).

 Приклад:
 "(['"])hello\1" збігається з "hello" або 'hello'.


 #Приклади#

 #/foobar/#
 збігається з "foobar", але не з "foobar"
 #/ FOO bar /ix#
 збігається з "foobar" та з "FOOBAR"
 #/(foo)?bar/#
 збігається з "foobar" та "bar"
 #/^foobar$/#
 збігається _тільки_ з "foobar", але не з "foofoofoobarfoobar"
 #/[\d\.]+/#
 збігається з будь-яким числом із десятковою точкою
 #/(foo|bar)+/#
 збігається з "foofoofoobarfoobar" та "bar"
 #/\Q.)))$\E/#
 еквівалентно "\.\)\)\)\$"

@RegExpRepl
$ #Регулярні вирази для заміни#
 У рядку заміни крім звичайних знаків ви можете використовувати спеціальні
оператори - регулярні висловлювання для рядка заміни.

 #$0#..#$9#, #$A#..#$Z#

Номери знайдених груп. Відповідна група підставляється у рядок під час
роботи. Номери групам присвоюються в порядку проходження дужок, що відкривають
регулярному вираженні. #$0# означає всю знайдену послідовність
цілком. #$*# замінюється на символ '*'.


@ElevationDlg
$ #Запит привілеїв адміністратора#


@KeyMacro
$ #Макроси #
 Клавіатурні макрокоманди чи макроси - це записана послідовність
натискання клавіш. Макрос дозволяє багаторазово виконувати одну і ту ж
послідовність дій за одне натискання гарячої кнопки.

 Кожен макрос має такі параметри:

 - гарячу клавішу, при натисканні на яку буде виконана
 записана послідовність;
- набір додаткових ~параметрів~@KeyMacroSetting@, які впливають на спосіб
 та місце відтворення FAR2L записаної послідовності;

Макроси можуть містити ~спеціальні команди~@KeyMacroLang@, що реалізують
сервісні функції, умовне та циклічне відтворення послідовностей тощо.

 Макроси, найчастіше, використовуються для:

 1. Вчинення однакових дій кілька разів, використовуючи для
 виклику послідовності цих дій одне поєднання кнопок.
 2. Виконання спеціальних функцій, що задаються спеціальними
 командами в текст макросу.
 3. Перевизначення стандартних сполучень клавіш, які
 використовує FAR2L для здійснення тих чи інших дій.

 Основним застосуванням макросів є визначення кнопок для швидкого
виклику зовнішніх плагінів та перевизначення дій FAR2L.

 Див. також:

~Області дії макросів~@KeyMacroArea@
~Кнопки призначення~@KeyMacroAssign@
~Запис та відтворення макросів~@KeyMacroRecPlay@
~Видалення макросу~@KeyMacroDelete@
~Параметри макрокоманди~@KeyMacroSetting@
~Макромова~@KeyMacroLang@
~Встановлені макроси~@KeyMacroList@


@KeyMacroArea
$ #Макроси: області дії#
FAR2L дозволяє створювати незалежні ~макроси~@KeyMacro@ (макроси, у яких
збігається поєднання клавіш запуску) для різних областей.

 Увага: Область, до якої належатиме макрос,
 визначається тим місцем, де його записали.

 Наразі такими незалежними областями є:

 - файлові панелі;
 - Внутрішня програма перегляду;
 - Редактор;
 - діалоги;
 - Швидкий пошук у панелях;
 - меню вибору дисків;
 - основне меню;
 - інші меню;
 - Система допомоги;
 - інформаційна панель;
 - панель швидкого перегляду;
 - панель дерева папок;
 - меню користувача;
 - Решта: режим копіювання тексту з екрана, вертикальні меню.

 Не можна призначити на якесь поєднання клавіш в одній області кілька
різних процесів. При спробі призначити для нового макросу
Поєднання попереднього макросу буде видалено.

 Таким чином, ви можете мати по одному макросу з однаковим поєднанням
клавіш запуску в кожній із перерахованих областей.


@KeyMacroAssign
$ #Макроси: кнопки призначення#
~Макрос~@KeyMacro@ може бути призначений на:

 1. будь-яку клавішу;
 2. на поєднання клавіші з модифікаторами # Ctrl #, # Alt # і # Shift #;
 3. на поєднання кнопки з двома модифікаторами.
 FAR2L дозволяє використовувати наступні подвійні модифікатори:
 #Ctrl-Shift-<клавіша>#, #Ctrl-Alt-<клавіша># та #Alt-Shift-<клавіша#>

 Макрос #не# може бути призначений на наступні клавіші та поєднання клавіш:
#Alt-Ins#, #Ctrl-<.>#, #Ctrl-Shift-<.>#, #Ctrl-Alt#, #Ctrl-Shift#, #Shift-Alt#
та #Shift-<символ>#.

 Деякі комбінації клавіш (зокрема, #Enter#, #Esc#, #F1#, #Ctrl-F5#,
#MsWheelUp# і #MsWheelDown# з комбінацією #Ctrl#, #Shift# та #Alt#) неможливо
ввести безпосередньо в діалозі призначення макроклавіші, оскільки вони мають
Спеціальні функції. Для того, щоб призначити макрос на одну з таких
комбінацій клавіш, виберіть її зі списку.


@ChangeLocationConfig
$ #Change location configuration#
    This dialog can be opened by pressing F9 key in Location menu opened by Alt+F1/F2.
    Here you can choose specific kind of items to be included in change location
menu: #mountpoints#, #bookmarks# and #plugins#.
    Also you can customize mountpoints items by specifing wildcards exceptions
and changing templates of what should be included into additional columns.
    Following abbreviations can be used there to represent values:
    #$T# - total disk space
    #$U# - used disk space
    #$F# - free disk space
    #$A# - disk space available for non-priviledged user
    #$u# - percents space used of total
    #$f# - percents space free of total
    #$a# - percents space available of total
    #$N# - filesystem name
    #$D# - device from which filesystem is mounted 
    #$S# - filesystem status, single character that can be
       ! - for readonly FS
       ? - for erroring/unresponsive FS
       <space> - for normally mounted and accessible FS
    Following abbreviations can be used there for extra alignment:
    #$<# - pad word on the left with spaces so its length will be same as longest word at same place
    #$># - pad word on the right with spaces so its length will be same as longest word at same place


@KeyMacroRecPlay
$ #Макроси: запис та відтворення#
FAR2L може виконувати ~макроси~@KeyMacro@ у двох основних режимах:

 1. Загальний режим: клавіші під час запису
 і відтворенні #передаватимуться плагінам.

 2. Спеціальний режим: клавіші під час запису
 і відтворенні #не будуть передаватися плагінам,
 перехоплюючим події у редакторі.

 Наприклад, якщо якийсь плагін обробляє клавіші #Ctrl+A#, то
при спеціальному режимі роботи макросів цей плагін не отримає управління та не
виконає дії, що він зазвичай виконує при реакцію це поєднання
клавіш.

 Створення макросу виконується такими діями:

 1. Початок запису макросу.

  Клавіша #Ctrl-<.># (#Ctrl# та клавішу з точкою) для запису
 макросу в загальному режимі та #Ctrl-Shift-<.># (#Ctrl#,
 #Shift# та клавішу з точкою), для запису макросу в спеціальному
 режимі.

 Після того як FAR2L почав запис макросу у лівому верхньому
 куті екрана відображатиметься символ '\4FR\-'.

 2. Текст макросу.

 FAR2L буде зберігати всі клавіші з наступними
 винятками:

 - будуть збережені лише клавіші FAR2L.
Тобто. якщо ви в процесі запису макросу з консолі FAR2L
 запустіть зовнішню програму, то FAR2L збереже лише
 клавіші, натиснуті до запуску та після завершення зовнішньої
 програми.

 #Примітка:# На час запису макросу всі інші макроси
відключаються. Таким чином, не можна записати "багатоступінчастий"
 макрос, що викликає раніше записані макропослідовності.

 3. Закінчення запису макросу.

 Для завершення запису макросу служать спеціальні поєднання
клавіш. Т.к. макрос може бути додатково налаштований,
 то таких поєднань два: #Ctrl-<.># (#Ctrl# і клавіша з крапкою)
 і #Ctrl-Shift-<.># (#Ctrl#, #Shift# та клавіша з точкою).
 Перше поєднання викликає запис макросу з параметрами
відтворення, прийняті за умовчанням. Друге поєднання
клавіш показує діалог з ~параметрами~@KeyMacroSetting@ виконання макросу.

 4. Призначення комбінації клавіш для запуску макросу.

 Після закінчення введення тексту макросу та призначення параметрів
його виконання буде показаний діалог ~призначення клавіші~@KeyMacroSetting@,
 в якому можна встановити гарячу клавішу для відтворення
 записаної послідовності.

 Відтворення макросу супроводжується відображенням у верхньому лівому куті екрана символу '\2FP\-'.

@KeyMacroDelete
$ #Макроси: видалення макросу#
Для того, щоб видалити ~макро~@KeyMacro@, потрібно записати порожній (не
що містить дій) макрос і привласнити йому гарячу клавішу макросу, який ви
хочете видалити.

 Цю операцію можна виконати, здійснивши такі дії:

 1. Почати запис макросу (#Ctrl-<.>#)
 2. Закінчити запис макросу (#Ctrl-<.>#)
 3. Ввести або вибрати у діалоговому вікні призначення гарячої клавіші
 поєднання, макрос для якого ви хочете видалити

 #Увага#

 Після видалення макросу поєднання клавіш, що використовується для його
виконання, почне виконувати свою початкову функцію. Тобто.
 якщо це поєднання клавіш до запису макросу оброблялося FAR2L
 або будь-яким плагіном, то після видалення макросу воно знову почне
 оброблятися.


@KeyMacroSetting
$ #Макроси: параметри макрокоманди#
Для завдання додаткових параметрів ~макрокоманди~@KeyMacro@ завершіть її
запис за допомогою #Ctrl-Shift-.# замість #Ctrl-.# і виберіть бажані опції в
з'явився діалог:

 #Послідовність:#

 Дозволяє змінити записані клавіші.

 #Дозволити під час виконання виведення на екран#

 Якщо вимкнути цей параметр, під час виконання макрокоманди FAR2L
Manager вимикає перемальовку екрана. Усі зміни будуть відображені після
завершення макрокоманди.

 #Виконувати після запуску FAR#

 Дозволяє виконувати макрокоманду одразу після запуску FAR2L.

 Для активної та пасивної панелей можливі такі умови, що активізують
макрокоманду:

 #На панелі плагіна#
 [x] - виконувати тільки якщо панель плагінова
 [ ] - виконувати лише для файлової панелі
 [?] – ігнорувати тип панелі

 #Виконувати для папок#
 [x] - виконувати тільки якщо на панелі під курсором папка
 [ ] - виконувати тільки якщо на панелі під курсором файл
 [?] - виконувати для папок та файлів

 #Визначено файли#
 [x] - виконувати, тільки якщо на панелі є відмічені
 файли/папки
 [ ] - виконувати, якщо немає зазначених файлів/папок
 [?] - ігнорувати стан позначки файлів/папок

 Інші умови, що активізують макрокоманду:

 #Порожній командний рядок#
 [x] - виконувати тільки якщо командний рядок порожній
 [ ] - виконувати тільки якщо командний рядок не порожній
 [?] - ігнорувати стан командного рядка

 # Відзначено блок #
 [x] - виконувати тільки якщо виділений блок у редакторі,
 програмі перегляду, командному рядку або у рядку
 введення у діалозі.
 [ ] - виконувати, якщо немає зазначеного блоку
 [?] – ігнорувати стан позначки блоку


 Примітки:

 1. FAR2L, перед активацією макрокоманди, перевіряє всі описані вище
умови.

 2. Деякі комбінації клавіш (зокрема, #Enter#, #Esc#, #F1#,
#Ctrl-F5#, #MsWheelUp#, #MsWheelDown# та інші клавіші миші з комбінацією #Ctrl#, #Shift# та #Alt#)
неможливо ввести безпосередньо, оскільки вони мають спеціальні функції у діалозі.
Для того, щоб ~призначити макрос~@KeyMacroAssign@ на одну з таких комбінацій
клавіш, виберіть її зі списку в діалозі.


@KeyMacroLang
$ #Макроси: макромова#
 У FAR2L реалізована примітивна макромова, яка дозволяє в просту
послідовність клавіш ввести логіку, що робить макроси (разом з
~плагінами~@Plugins@) потужним засобом, що допомагає в роботі з FAR2L.

 Ось частина команд, яка демонструє можливості:
 #$Exit# - перервати виконання макрокоманди
 #$Text# - вставка довільного тексту
 #$XLat# - функція транслітерації
 #$If-$Else# - умовний оператор
 #$While# - умовний оператор
 #$Rep# - оператор циклу
 #%var# - використання змінних
 та інші...

Додати елементи макромови в ~макро~@KeyMacro@ можна тільки шляхом ручної
правки реєстру або шляхом застосування спеціальних програм/плагінів.

 Опис макромови можна знайти у супровідній документації.

@KeyMacroList
$ #Макроси: Список встановлених макросів#
Нижче наведено список розділів, в яких можна дізнатися які ~макроси~@KeyMacro@
діють у поточній сесії Far Manager.

~Список змінних~@KeyMacroVarList@
~Список констант~@KeyMacroConstList@

~Загальні макроси#~@KeyMacroCommonList@

~Панелі~@KeyMacroShellList@
~Панель швидкого перегляду~@KeyMacroQViewList@
~Панель папок~@KeyMacroTreeList@
~Інформаційна панель~@KeyMacroInfoList@

~Швидкий пошук у панелях~@KeyMacroSearchList@
~Пошук папки~@KeyMacroFindFolderList@

~Діалоги~@KeyMacroDialogList@

~Головне меню~@KeyMacroMainMenuList@
~Меню вибору дисків~@KeyMacroDisksList@
~Меню користувача~@KeyMacroUserMenuList@
~Інші меню~@KeyMacroMenuList@
 
~Програма перегляду~@KeyMacroViewerList@
~Редактор~@KeyMacroEditList@
 
~Файл допомоги#~@KeyMacroHelpList@
 
~Інші області~@KeyMacroOtherList@

@KeyMacroVarList
$ #Макроси: Список змінних#
 Нижче наведено список глобальних змінних, які можна використовувати у макросах.

<!Macro:Vars!>

@KeyMacroConstList
$ #Макроси: Список констант#
 Нижче наведено список констант, які можна використовувати у макросах.

<!Macro:Consts!>

@KeyMacroCommonList
$ #Макроси: Загальні#
 Нижче наведені комбінації макроклавіш, що діють скрізь.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>

@KeyMacroQViewList
$ #Макроси: Панель швидкого перегляду#
 Нижче наведено комбінації макроклавіш, що діють на панелі швидкого перегляду.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Qview!>

@KeyMacroMainMenuList
$ #Макроси: Головне меню#
 Нижче наведено комбінації макроклавіш, які у головному меню.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:MainMenu!>

@KeyMacroTreeList
$ #Макроси: Панель папок#
 Нижче наведено комбінації макроклавіш, що діють на панелі папок.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Tree!>

@KeyMacroDialogList
$ #Макроси: Діалоги#
 Нижче наведено комбінації макроклавіш, що діють у діалогах.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Dialog!>

@KeyMacroInfoList
$ #Макроси: Інформаційна панель#
 Нижче наведені комбінації макроклавіш, що діють на інформаційній панелі.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Info!>

@KeyMacroDisksList
$ #Макроси: Меню вибору дисків#
 Нижче наведено комбінації макроклавіш, що діють меню вибору дисків.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Disks!>

@KeyMacroUserMenuList
$ #Макроси: Меню користувача#
 Нижче наведені комбінації макроклавіш, що діють у меню користувача.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:UserMenu!>

@KeyMacroShellList
$ #Макроси: Панелі#
 Нижче наведені комбінації макроклавіш, які у файлових панелях.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Shell!>

@KeyMacroSearchList
$ #Макроси: Швидкий пошук у панелях#
 Нижче наведені комбінації макроклавіш, які у швидкому пошуку файлових панелей.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Search!>

@KeyMacroFindFolderList
$ #Макроси: Пошук папки#
 Нижче наведено комбінації макроклавіш, що діють у пошуку папки.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:FindFolder!>

@KeyMacroViewerList
$ #Макроси: Програма перегляду#
 Нижче наведено комбінації макроклавіш, що діють у програмі перегляду.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Viewer!>

@KeyMacroMenuList
$ #Макроси: Інші меню#
 Нижче наведені комбінації макроклавіш, що діють у інших меню.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Menu!>

@KeyMacroEditList
$ #Макроси: Редактор#
 Нижче наведені комбінації макроклавіш, що у редакторі.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Editor!>

@KeyMacroHelpList
$ #Макроси: Файл допомоги#
 Нижче наведені комбінації макроклавіш, які у файлі допомоги.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Help!>

@KeyMacroOtherList
$ #Макроси: Інші області#
 Нижче наведені комбінації макроклавіш, що діють в інших областях: копіювання тексту з екрана, вертикальних меню.
 Опис кожної макроклавіші береться з реєстру (поле Description).

<!Macro:Common!>
<!Macro:Other!>

@Index
$ #Індекс файлу допомоги#
<%INDEX%>
