/*
 * Farsight Voice+Video library
 * Copyright (C) 2005 Philippe Khalaf <burger@speedy.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_YAHOOWEBCAM_H__
#define __FARSIGHT_YAHOOWEBCAM_H__

#include <glib.h>
#include <glib-object.h>

#include <farsight/farsight-protocol.h>

#include <gst/base/gstadapter.h>

G_BEGIN_DECLS

// from gaim's yahoo protocol plugin
#define yahoo_put32(buf, data) ( \
        (*((buf)) = (unsigned char)((data)>>24)&0xff), \
        (*((buf)+1) = (unsigned char)((data)>>16)&0xff), \
        (*((buf)+2) = (unsigned char)((data)>>8)&0xff), \
        (*((buf)+3) = (unsigned char)(data)&0xff), \
        4)

typedef enum {
    DOWNLOADER = 0,
    UPLOADER
} YahooWebcamSessionType;

/* TYPE MACROS */
#define FARSIGHT_TYPE_YAHOOWEBCAM \
  (farsight_yahoowebcam_get_type())
#define FARSIGHT_YAHOOWEBCAM(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_YAHOOWEBCAM, FarsightYahooWebcam))
#define FARSIGHT_YAHOOWEBCAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_YAHOOWEBCAM, FarsightYahooWebcamClass))
#define FARSIGHT_IS_YAHOOWEBCAM(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_YAHOOWEBCAM))
#define FARSIGHT_IS_YAHOOWEBCAM_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_YAHOOWEBCAM))
#define FARSIGHT_YAHOOWEBCAM_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_YAHOOWEBCAM, FarsightYahooWebcamClass))

typedef struct _FarsightYahooWebcam      FarsightYahooWebcam;
typedef struct _FarsightYahooWebcamClass FarsightYahooWebcamClass;

struct _FarsightYahooWebcamClass {
    FarsightProtocolClass parent_class;

    //signals
    void (*viewer_request)      (FarsightYahooWebcam *yahoowebcam,
                                  gchar *viewer_email);
    void (*viewer_joined)        (FarsightYahooWebcam *yahoowebcam,
                                  gchar *viewer_email);
    void (*viewer_count)         (FarsightYahooWebcam *yahoowebcam,
                                  gint count);
    void (*viewer_ips)           (FarsightYahooWebcam *yahoowebcam,
                                  gchar *internal_ip,
                                  gchar *external_ip);
 };

struct _FarsightYahooWebcam {
    FarsightProtocol parent;

    YahooWebcamSessionType session_type;
    guint connect_watch;
    GIOChannel *connection;

    gchar *local_user;
    gchar *remote_user;
    gchar *server_key;
    gchar *local_ip;
    guint conn_type;

    GstAdapter *adapter;

    // this sux, it's becoz i skip the first header
    // received when verifying servers response to my
    // request, i should probably not ignore this and
    // verify it, but i dont know what to check for
    // since i dont know how to make it fail
    // i get this when all is good:
    // 0d 00 05 00 00 00 00 00 00 00 00 00 03
    // i bet that 03 would be different
    gboolean first;

    // All the following vars are used by handle_server_messages_cb
    guchar packet_type;
    guint timestamp, payload_size;
    guchar reason;
    gboolean have_header;

    // server host returned from master server
    gchar *server;
};

GType farsight_yahoowebcam_get_type   (void);

G_END_DECLS

#endif
