/*
 * rtpsession.h - Source for RTP plugin session implementation
 *
 * Farsight RTP/AVP/SAVP/AVPF Module
 * Copyright (C) 2005,2006 Collabora Ltd.
 * Copyright (C) 2005,2006 Nokia Corporation
 *   @author Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author Philippe Kalaf <philippe.kalaf@collabora.co.uk>
 * Copyright (C) 2005 INdT 
 *   @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "rtp.h"
#include "rtpstream.h"
#include "rtpsession.h"

#include <gst/gst.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

static void farsight_rtp_session_class_init (FarsightRTPSessionClass *klass);
static void farsight_rtp_session_init (FarsightRTPSession *rtp_session);
static void farsight_rtp_session_finalize (GObject *object);

static FarsightStream *farsight_rtp_session_create_stream (FarsightSession *session,
                                                           FarsightMediaType media_type, 
                                                           FarsightStreamDirection dir);

static FarsightSessionClass *rtp_session_parent_class = NULL;

GType
farsight_rtp_session_get_type (void)
{
  static GType type = 0;

  if (type == 0) {
    static const GTypeInfo info = {
      sizeof (FarsightRTPSessionClass),
      NULL,
      NULL,
      (GClassInitFunc) farsight_rtp_session_class_init,
      NULL,
      NULL,
      sizeof (FarsightRTPSession),
      0,
      (GInstanceInitFunc) farsight_rtp_session_init
    };

    type = g_type_register_static (FARSIGHT_TYPE_SESSION,
        "FarsightRTPSession", &info, 0);
  }

  return type;
}

static void
farsight_rtp_session_class_init (FarsightRTPSessionClass *klass)
{
  GObjectClass *gobject_class;
  FarsightSessionClass *farsight_session_class;

  gobject_class = (GObjectClass *) klass;
  farsight_session_class = (FarsightSessionClass *) klass;
  rtp_session_parent_class = g_type_class_peek_parent (klass);

  farsight_session_class->create_stream = farsight_rtp_session_create_stream;

  gobject_class->finalize = farsight_rtp_session_finalize;
}

static void
farsight_rtp_session_init (FarsightRTPSession *rtp_session)
{
}

static void
farsight_rtp_session_finalize (GObject *object)
{
  G_OBJECT_CLASS (rtp_session_parent_class)->finalize (object);
}

static FarsightStream *
farsight_rtp_session_create_stream (FarsightSession *session, 
                                    FarsightMediaType media_type, 
                                    FarsightStreamDirection dir)
{
  FarsightRTPStream *rtpstream;

  g_return_val_if_fail (FARSIGHT_IS_RTP_SESSION (session),NULL);

  rtpstream = g_object_new (FARSIGHT_TYPE_RTP_STREAM, 
          "media-type", media_type,
          "direction", dir, NULL);
  return FARSIGHT_STREAM(rtpstream);
}
