/* $Id: Visitor.tpp 4331 2009-01-27 14:57:41Z potyra $ 
 * vim:tabstop=8:shiftwidth=8:filetype=cpp:textwidth=72:
 * Visitor: base class for all visitors.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <iostream>
#include <sstream>
#include <cassert>

namespace ast {

template <typename T>
void
Visitor::listTraverse(T l)
{
	for (typename T::const_iterator i = l.begin(); i != l.end(); i++) {
		assert(*i);
		(*i)->accept(*this);
	}
}

template <typename T>
void
Visitor::listTraverse(T &l, bool& deleteFlag)
{
	typename T::iterator i=l.begin();
	
	while (i != l.end()) {
		assert(*i);
		(*i)->accept(*this);
		
		if (deleteFlag) {
			i = l.erase(i);
			deleteFlag = false;
			continue;
		}
		i++;
	}
}

}; /* namespace ast */
