/* $Id: trace.h 4351 2009-02-05 12:48:13Z sand $
 *
 * Tracing related functionality.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __TRACE_H_INCLUDED
#define __TRACE_H_INCLUDED

#include "libfauhdli.h"
#include "signals.h"
#include <stdio.h>
#include <stdbool.h>

struct trace_t {
	/* pointer to output file */
	FILE *output;
	/** set of traced signals (uses internal tracing structure) */
	struct slist *traced_sigs;
	/** next ident code to be handed out. */
	char ident_code;
	/** header already written? */
	bool header_written;
};

/** create a trace instance.
 *  @param trace_file output file name
 *  @return trace instance.
 */
extern
struct trace_t *
trace_create(const char *trace_file);

/** destroy the trace instance.
 *  @param s trace instance.
 */
extern void
trace_destroy(struct trace_t *s);

/** add a signal to the set of traced signals.
 *  @param s trace instance.
 *  @param sig signal instance to trace.
 *  @param name name of the signal
 *  @param type basic type of the signal.
 *  @param display_bits override display bits with this. (-1 means do not
 *  	   override)
 */
extern void
trace_add_signal(
	struct trace_t *s,
	const struct signal *sig, 
	const char *name, 
	enum type_kind type,
	int display_bits
);

/** signal an event at the current simulation time for a signal to the
 *  tracer.
 *  @param s trace instance.
 *  @param sig signal that was updated.
 */
extern void
trace_sig_event(struct trace_t *s, const struct signal *sig);

/** Tell the tracer to advance the simulation time.
 *  @param s trace instance.
 *  @param sim_time new value of the simulation time.
 */
extern void
trace_time_advance(struct trace_t *s, universal_integer sim_time);

#endif /* __TRACE_H_INCLUDED */
