" Vim syntax file
" Language:	fauhdlc intermediate code
" Maintainer:	Stefan Potyra <stefan.potyra@informatik.uni-erlangen.de>
" Last Change:	2008 Feb 15
" Filenames: *.ic

syn case ignore

syn keyword Statement	mov add sub je jmp getsig wakeat
syn keyword Statement	imul call wakeon log abort
syn keyword Statement	update jb jne jbe aoffset roffset
syn keyword Statement	data return suspend proc div gettime
syn keyword Statement	begintr endtr setparm connect getparm
syn match   Special 	"\.STACK"
syn match   Special 	"\.TRANSFER"
syn match   Special 	"\.TEXT"
syn match   Special 	"\.REGISTERS"
syn match   Special	"SIGNAL"
syn match   Special	"VARIABLE"
syn match   Special	"DRIVER"
syn match   Special	"CONTAINER"
syn match   Special	"END CONTAINER"
syn match   Type	"TYPE [a-zA-Z0-9_]\+ is"
syn match   Type	"[a-zA-Z0-9_]*->"
syn match   Type	"[a-zA-Z0-9_]\+\["
syn match   Type 	"[a-zA-Z0-9_]*\( \)*:="
syn match   String	"\"[a-zA-Z0-9:_]*\""
syn match   Identifier 	"[a-z_][0-9a-z_]*:"
syn match   Number	"$-\?[0-9]*[lf]"
syn match   Identifier	"@[a-z0-9_]*"
syn match   Comment	"{[^}]*}"

syn case match

let b:current_syntax = "ic"

" vim: ts=8
