/* $Id: AttributableDeclaration.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * AttributableDeclaration: base class for symbol declarations, that can have
 * attributes.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ATTRIBUTABLE_DECLARATION_HPP_INCLUDED
#define __ATTRIBUTABLE_DECLARATION_HPP_INCLUDED

#include <map>
#include "frontend/ast/AttributeSpecification.hpp"

namespace ast {

//! any symbol declaration that can have attributes.
/** This class represents any Symbol declaration that can be attributed.
 */
class AttributableDeclaration : public SymbolDeclaration {
public:
	AttributableDeclaration(
		std::string *declName,
		Location loc
		) : 	SymbolDeclaration(declName, loc) {}

	/** is an attribute specifictaion with name present?
	 *  @param attrName name of the attribute to check for.
	 *  @return matching attribute specification, or NULL if not present.
	 */
	AttributeSpecification *
	hasAttr(std::string attrName) const;

public:
	/** set of attributes */
	std::map<std::string, AttributeSpecification *> attributes;
};

}; /* namespace ast */

#endif /* __ATTRIBUTABLE_DECLARATION_HPP_INCLUDED */
