/* $Id: Operand.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __OPERAND_HPP_INCLUDED
#define __OPERAND_HPP_INCLUDED

#include "intermediate/Node.hpp"
#include <ostream>

namespace intermediate {

//! different types of operands
enum OpType {
	//! an integer value (only immediate)
	OP_TYPE_INTEGER,
	//! a real value (only immediate)
	OP_TYPE_REAL,
	//! a pointer value (immediate or indirect, indirect & offset)
	OP_TYPE_POINTER
};

//! one operand
/** This class represents one operand for the intermediate code.
 */
class Operand : public Node {
public:
	//! c'tor
	/** @param t operand type
	 */
	Operand(enum OpType t) : type(t) {}
	
	//! base type of the Operand
	enum OpType type;
};


/** helper operator, to put an OpType enum to a stream.
 *  @param stream stream to which the enum should get written to
 *  @param t OpType to write to the stream
 *  @return modified stream.
 */
std::ostream&
operator <<(std::ostream& stream, const enum OpType t);

}; /* namespace intermediate */

#endif /* __OPERAND_HPP_INCLUDED */
