/* $Id: CondalSigAssign.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONDAL_SIG_ASSIGN_HPP_INCLUDED
#define __CONDAL_SIG_ASSIGN_HPP_INCLUDED

#include "frontend/ast/ConcurrentStat.hpp"
#include "frontend/ast/SeqStat.hpp"
#include "frontend/ast/Name.hpp"

namespace ast {

//! A concurrent condal signal assign statement.
/** This class represents a concurent condal signal assign statement or
 *  a concurrent selected signal assign statement.
 *  It can be assumed, that the correct if/case-statements have been
 *  produced, which reflect the concurrent statement. 
 *
 *  @TODO options and guarded, whereas guarded needs symbol analysis
 *        before it can be transformed into guard statements.
 */
class CondalSigAssign : public ConcurrentStat {
public:	
	//! c'tor
	/** @param trg target of the signal assignment.
	 *  @param assignTree the sequential statements that reflect
	 *         the semantics of the CondalSigAssign. Should be either
	 *         an SigAssignStat or a probably nested IfStat with 
	 *         SigAssignStats as it's actions.
	 *  @param loc location of the assign symbol.
	 */
	CondalSigAssign(
		Name* trg,
		SeqStat* assignTree,
		Location loc
		) : 	ConcurrentStat(loc),
			target(trg),
			assignStat(assignTree) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << this->target << " <= " << this->assignStat << ';';
	}

	/** target of the signal assignment */
	Expression* target;

	/** Either an IfStat or a SigAssignStat. The signal assignment
	 *  should get sequentialized during parsing already.
	 */
	SeqStat* assignStat;

protected:
	/** Destructor */
	virtual ~CondalSigAssign() {
		util::MiscUtil::terminate(target);
		util::MiscUtil::terminate(assignStat);
	}
};

}; /* namespace ast */

#endif /* __CONDAL_SIG_ASSIGN_HPP_INCLUDED */
