/*
 * Copyright (C) 2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	FILE *output_file;
} NAME;

#endif /* STATE */
#ifdef EXPORT

/*forward*/ static void
NAME_(dump_data)(struct cpssp *cpssp);

#endif /* EXPORT */
#ifdef BEHAVIOR

static void
NAME_(dump_data)(struct cpssp *cpssp)
{
	int file_version;
	char file_name[10];
	struct {
		int number_analog_channels;
		int number_digital_channels;
		unsigned long long start_time;
		unsigned long long end_time;
		int sweep_time; /* in seconds */
		double time_hz_d;
		unsigned int sample_rate;
	} h_d;
	unsigned int number_data_points[NUMBER_ANALOG_CHANNELS+NUMBER_DIGITAL_CHANNELS];
	int ch;
	struct {
		int value;
		unsigned long long time_stamp;
		double time_stamp_d;
	} d_p;
	int ret;

	for (file_version = 1; ; file_version++) {
		FILE *fp;

		sprintf(file_name, "dump_%d", file_version);
		fp = fopen(file_name, "r");
		if (! fp) {
			break;
		}
		(void) fclose(fp);
	}

	/* Open file. */
	sprintf(file_name, "dump_%d", file_version);
	cpssp->NAME.output_file = fopen(file_name, "w");
	if (! cpssp->NAME.output_file) {
		perror(file_name);
		return;
	}

	/* Write header. */
	h_d.number_analog_channels = NUMBER_ANALOG_CHANNELS;
	h_d.number_digital_channels = NUMBER_DIGITAL_CHANNELS;
	h_d.start_time = cpssp->start_time;
	h_d.end_time = cpssp->end_time;
	h_d.sweep_time = cpssp->sweep_time;
	h_d.time_hz_d = (double) TIME_HZ;
	h_d.sample_rate = cpssp->sample_rate;
	fwrite(&h_d, sizeof(h_d), 1, cpssp->NAME.output_file);

	/* Write number of data points. */
	for (ch = 0; ch < NUMBER_ANALOG_CHANNELS; ch++) {
		number_data_points[ch]
				= cpssp->total_number_buffer_items[ch];
	}
	for (ch = 0; ch < NUMBER_DIGITAL_CHANNELS; ch++) {
		number_data_points[ch + NUMBER_ANALOG_CHANNELS]
				= cpssp->total_number_events[ch];
	}
	for (ch = 0; ch < NUMBER_ANALOG_CHANNELS + NUMBER_DIGITAL_CHANNELS; ch++) {
		fprintf(stderr, "number data points %u\n", number_data_points[ch]);
	}
	fwrite(&number_data_points, sizeof(number_data_points), 1,
			cpssp->NAME.output_file);

	/* Write channel data. */
	for (ch = 0; ch < NUMBER_ANALOG_CHANNELS; ch++) {
		int buffer_pos = cpssp->first_buffer_pos[ch];
		if (buffer_pos < 0) {
			continue;
		}
		struct RLE_buffer_item buf = cpssp->RLE_buffer[ch][buffer_pos];

		while (buf.time_stamp != 0) {
			d_p.value = buf.value;
			d_p.time_stamp = buf.time_stamp;

			fwrite(&d_p, sizeof(d_p), 1, cpssp->NAME.output_file);
			if (buffer_pos == cpssp->last_buffer_pos[ch]) {
				break;
			}

			buffer_pos++;
			buffer_pos %= RLE_BUFFER_SIZE;
			buf = cpssp->RLE_buffer[ch][buffer_pos];
		}
	}
	for (ch = 0; ch < NUMBER_DIGITAL_CHANNELS; ch++) {
		int buffer_pos = cpssp->first_event_buffer_pos[ch];
		if (buffer_pos == -1) {
			/* no events for this ch */
			continue;
		}
		struct event_measure_point buf =
				cpssp->event_buffer[ch][buffer_pos];
		while (buf.time_stamp != 0) {
			if (buf.hi == true) {
				d_p.value = 5000;
			} else {
				d_p.value = 0;
			}
			d_p.time_stamp = buf.time_stamp;
			fwrite(&d_p, sizeof(d_p), 1, cpssp->NAME.output_file);
			if (buffer_pos
				== cpssp->last_event_buffer_pos[ch]) {
				break;
			}
			buffer_pos++;
			buffer_pos %= EVENT_BUFFER_SIZE;
			buf = cpssp->event_buffer[ch][buffer_pos];
		}
	}
	ret = fclose(cpssp->NAME.output_file);
	assert(0 <= ret);

	fprintf(stderr, "Dump saved as '%s'\n", file_name);
}

#endif /* BEHAVIOUR */
