/*
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/*
 *  Glue layer to setup components/signals. Should replace mssetup.h/c from
 *  expect.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"
#include "glue-setup.h"
#include "fauhdli.h"
#include "glue-vhdl.h"

/** glue_setup structure. There can be only one glue_setup
 *  for a running FAUmachine.
 */
static struct cpssp {
	/** fauhdl interpreter instance. */
	struct fauhdli *fauhdli;
	/** glue_vhdl instance */
	void *glue_vhdl;
} cpssp;

static void
glue_setup_quit(int status)
{
	failure = status;
	sim_exit();
}

void
glue_setup_create(void)
{
	int ret;
	char top_entity[2048];
	static struct glue_vhdl_cb cb = {
		/* memory related */
#if 0
		.malloc = shm_alloc,
		.free = shm_free,
#else
		.malloc = malloc,
		.free = free,
#endif
		/* scheduling related */
		.time_virt = time_virt,
		.time_call_at = time_call_at,
		.time_call_delete = time_call_delete,
		.quit = glue_setup_quit,
		/* logging */
		.log = (void (*)(int, 
				const char *, 
				const char *, 
				const char *,
				...))faum_log,

	};

	assert(cpssp.fauhdli == NULL);

	cpssp.glue_vhdl = glue_vhdl_create(&cb);
	cpssp.fauhdli = fauhdli_create(
				simsetup.vhdl_model, 
				NULL, 
				0 < loglevel,
				&cb,
				cpssp.glue_vhdl
				);

	glue_vhdl_init(cpssp.glue_vhdl, cpssp.fauhdli);

	/* FIXME really use expect as library name space, or rather
	 *       define that in simulation.setup? 
	 *       (there is the possibility to override this via fauhdlc!)
	 */
	ret = snprintf(top_entity, sizeof(top_entity), "expect:%s", 
			simsetup.base_entity);
	assert(ret < sizeof(top_entity));

	fauhdli_init(cpssp.fauhdli, top_entity);
}

void
glue_setup_destroy(void)
{
	assert(cpssp.fauhdli != NULL);
	fauhdli_destroy(cpssp.fauhdli);
	glue_vhdl_destroy(cpssp.glue_vhdl);
	cpssp.fauhdli = NULL;
}
