#!/bin/sh
#
# Do what dh_sphinxdoc should be doing, and shut lintian
# up by replacing sphinx .js files with those in libjs-sphinx.
#
set -e

find "debian/${1}" -name "*.js" |
  while read pkg_js_file
  do
    dpkg --listfiles libjs-bootstrap libjs-sphinxdoc |
      while read sphinx_js
      do
        [ ."${pkg_js_file##*/}" = ."${sphinx_js##*/}" ] || continue
	ln --relative --symbolic --force "${sphinx_js}" "${pkg_js_file}"
      done
  done

#
# Ditto for fonts in fonts-glyphicons-halflings.
#
find "debian/${1}" -name "glyphicons-halflings-regular.*" |
  while read pkg_font_file
  do
    dpkg --listfiles fonts-glyphicons-halflings |
      while read sphinx_font
      do
        [ ."${pkg_font_file##*/}" = ."${sphinx_font##*/}" ] || continue
	ln --relative --symbolic --force "${sphinx_font}" "${pkg_font_file}"
      done
  done

