/*
 * Copyright (C) 2000-2002 Chris Ross and various contributors
 * Copyright (C) 1999-2000 Chris Ross
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * o Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * o Neither the name of the ferite software nor the names of its contributors may
 *   be used to endorse or promote products derived from this software without
 *   specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __FERITE_CLASS_H__
#define __FERITE_CLASS_H__

void             ferite_delete_class( FeriteScript *script, FeriteClass *classp );
FeriteClass     *ferite_find_class( FeriteScript *script, FeriteNamespace *ns, char *name );
long             ferite_find_class_id( FeriteScript *script, FeriteNamespace *ns, char *name );
FeriteObject    *ferite_find_object( FeriteScript *script, FeriteObject *parent, char *obj );
FeriteFunction  *ferite_find_function_in_object( FeriteScript *script, FeriteObject *obj, char *function );
void             ferite_delete_object( FeriteObject *obj );
void             ferite_delete_class_object( FeriteScript *script, FeriteObject *obj, int do_destructor );
void             ferite_delete_objects( FeriteObject *obj );
FeriteVariable  *ferite_object_call_super( FeriteScript *script, FeriteObject *object, FeriteVariable **params );
int              ferite_object_is_sublass( FeriteObject *obj, char *name );
void             ferite_object_set_var(FeriteScript* script,FeriteObject* obj, char *id, FeriteVariable *data);
FeriteVariable  *ferite_object_get_var( FeriteScript *script, FeriteObject *object, char *name );
FeriteVariable  *ferite_class_get_var( FeriteScript *script, FeriteClass *klass, char *name );
FeriteFunction  *ferite_object_get_function( FeriteScript *script, FeriteObject *object, char *name );
int              ferite_class_has_function(FeriteScript *script, FeriteClass *cls, char *name);
FeriteFunction  *ferite_find_parent_constructor( FeriteScript *script, FeriteClass *klass );
FeriteVariable **ferite_object_add_self_variable_to_params( FeriteScript *script, FeriteVariable **param, FeriteObject *ptr );
FeriteClass     *ferite_class_dup( FeriteScript *script, FeriteClass *klass, FeriteNamespace *container );

#endif /* __FERITE_CLASS_H__ */
