#ifndef __FERITE_THREAD_H__
#define __FERITE_THREAD_H__

#ifdef THREAD_SAFE
# define FE_LOCK_SCRIPT( scr ) aphex_mutex_lock( scr->lock );
# define FE_UNLOCK_SCRIPT( scr ) aphex_mutex_unlock( scr->lock );
# define LOCK_VARIABLE( var ) if( var->lock != NULL ) aphex_mutex_lock( var->lock )
# define UNLOCK_VARIABLE( var ) if( var->lock != NULL ) aphex_mutex_unlock( var->lock )
#else
# define FE_LOCK_SCRIPT( scr ) 
# define FE_UNLOCK_SCRIPT( scr ) 
# define LOCK_VARIABLE( x )
# define UNLOCK_VARIABLE( x )
#endif

FeriteThreadGroup *ferite_create_thread_group();
void ferite_thread_group_destroy( FeriteScript *script, FeriteThreadGroup *group );
void ferite_thread_group_attach( FeriteScript *script, FeriteThreadGroup *group, FeriteThread *data );
void ferite_thread_group_dettach( FeriteScript *script, FeriteThreadGroup *group, FeriteThread *data );
void ferite_thread_group_wait( FeriteScript *script, FeriteThreadGroup *group );

#endif
