/* This file has been automatically generated by builder part of the ferite distribution */
/* file: serialize_Serialize.c */
/* namespace: Serialize */

#include <ferite.h>       /* we need this without a doubt */
#include "serialize_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( serialize_Serialize_fromNative_s )
{
   FeriteString *data;

   ferite_get_parameters( params, 1, &data );

   { /* Main function body. */
#line 129 "serialize.fec"

    
	FeriteVariable *ptr,*var,*v,*st[100];
	FeriteNamespaceBucket *nsb;
	FeriteStack *objects = ferite_create_stack( script, 100 );
	char *p, *str = data->data;
	char name[200], ns[200];
	int version, length = data->length;
	int level, type, len;


	if( length < 12 )
	{
	    ferite_error( script, 0, "data too small to fit serializer header" );
	    FE_RETURN_NULL_OBJECT;
	}
	version = *str++ - '0';
	if( version != SERIALIZER_VERSION )
	{
	    if( version < SERIALIZER_VERSION )
	        ferite_error( script, 0, "Serialized object uses old scheme" );
	    else
		ferite_error( script, 0, "Serialized object uses newer scheme" );
	    FE_RETURN_NULL_OBJECT;
	}
	if( length != atoi( str ) )
	{
	    if( length < atoi( str ) )
		ferite_error( script, 0, "Serialized object is not complete" );
	    else
		ferite_error( script, 0, "Serialized object contains additional data" );
	    FE_RETURN_NULL_OBJECT;
	}
	str += 10;
	for( level = 0; *str;)
	{
	    if( Serialize_native_decode_first( script, &str, &type, &len, level ) )
		break;
	    strncpy( name, str, len );
	    name[len] = '\0';
	    str += len + 1;
	    ptr = NULL;
	    switch( type )
	    {
		case 0:
		    SE_DEBUG( "level--\n" );
		    str++;
		    level--;
		    break;
		case F_VAR_LONG:
		    SE_DEBUG( "long\n" );
		    ptr = ferite_create_number_long_variable( script, name, strtol( str, &p, 0 ), FE_ALLOC );
		    str = p + 1;
		    break;
		case F_VAR_DOUBLE:
		    SE_DEBUG( "double\n" );
		    ptr = ferite_create_number_double_variable( script, name, strtod( str, &p ), FE_ALLOC );
		    break;
		case F_VAR_STR:
		    SE_DEBUG( "string\n" );
		    len = strtol( str, &p, 0 );
		    str = p + 1;
		    ptr = ferite_create_string_variable_from_ptr( script, name, str, len, FE_CHARSET_DEFAULT, FE_ALLOC );
		    str += len + 1;
		    break;
		case F_VAR_OBJ:
		    SE_DEBUG( "object\n" );
		    len = strtol( str, &p, 0 );
		    str = p + 1;
		    strncpy( ns, str, len );
		    ns[len] = '\0';
		    if( (nsb = ferite_find_namespace( script, script->mainns, ns, 0 )) == NULL )
		    {
			ptr = ferite_create_object_variable( script, name, FE_ALLOC );
		    }
		    else
		    {
			ptr = ferite_build_object( script, (FeriteClass *)nsb->data );
			ffree( VAO(ptr)->name );    /* We need to change the name from 'new_object' */
			VAO(ptr)->name = fstrdup( ns );
			ferite_set_variable_name( script, ptr, name );
			ferite_stack_push( objects, VAO(ptr) );
		    }
		    str += len + 1;
		    break;
		case -1: /* Object reference */
		    SE_DEBUG( "reference\n" );
		    len = strtol( str, &p, 0 );
		    str = p + 1;
		    ptr = ferite_create_object_variable( script, name, FE_ALLOC );
		    if( objects->stack_ptr >= len )
		    {
			VAO(ptr) = objects->stack[len];
			VAO(ptr)->refcount++;
		    }
		    break;
		case F_VAR_UARRAY:
		    SE_DEBUG( "array\n" );
		    ptr = ferite_create_uarray_variable( script, name, FE_ARRAY_DEFAULT_SIZE, FE_ALLOC );
		    break;
		default:
		    SE_DEBUG( "erk\n" );
		    ferite_error(script, 0, "Can not create variable from unknown type\n");
	    }
	    if( ptr )
	    {
		/* If it't the first variable, place it on the stack */
		if( level == 0 )
		    st[level++] = ptr;
		else if( st[level-1]->type == F_VAR_OBJ )
		{
		    /* Add variable to object */
		    ferite_object_set_var( script, VAO(st[level-1]), ptr->name, ptr );
		}
		else
		{
		    char *n;
		    /* if variable is nameless, do not add it to the hash index */
		    n = ( strcmp( ptr->name, "-1" ) == 0 || ptr->name[0] == '\0' ) ? NULL : ptr->name;
		    /* Add variable to array */
		    ferite_uarray_add( script, VAUA(st[level-1]), ptr, n , FE_ARRAY_ADD_AT_END );
		}
		if( ptr->type == F_VAR_OBJ || ptr->type == F_VAR_UARRAY )
		{
		    /* Add to level stack */
		    st[level++] = ptr;
		}
	    }
	}
	ferite_delete_stack( script, objects );

	FE_RETURN_VAR( st[0] );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( serialize_Serialize_toNative_so )
{
   FeriteString *name;
   FeriteObject *o;

   ferite_get_parameters( params, 2, &name, &o );

   { /* Main function body. */
#line 64 "serialize.fec"

    
	SerializeContex *ctx = Serialize_walk_init( script );
	FeriteVariable *var = ferite_create_object_variable( script, name->data, FE_ALLOC );
	char len[12];

	ferite_buffer_alloc( ctx->buf, 11 );
	VAO(var) = o;
	if( Serialize_walk_native( script, ctx, var, 0 ) != 0 )
	{
	    ferite_error( script, 0, "Could not create serialized output, weird stuff in object" );
	    FE_RETURN_NULL_OBJECT;
	}
	var = ferite_buffer_to_var( ctx->buf );
	snprintf( len, 12, "%d%.*d\n", SERIALIZER_VERSION, 9, FE_STRLEN(var) );
	strncpy( FE_STR2PTR( var ), len, 11 );
	Serialize_walk_deinit( script, ctx );
	FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( serialize_Serialize_toXML_so )
{
   FeriteString *name;
   FeriteObject *o;

   ferite_get_parameters( params, 2, &name, &o );

   { /* Main function body. */
#line 99 "serialize.fec"

    
	SerializeContex *ctx = Serialize_walk_init( script );
	FeriteVariable *var = ferite_create_object_variable( script, name->data, FE_ALLOC );
	char len[12];

	VAO(var) = o;
	if( Serialize_walk_XML( script, ctx, var, 0 ) != 0 )
	{
	    ferite_error( script, 0, "Could not create serialized output, weird stuff in object" );
	    FE_RETURN_NULL_OBJECT;
	}
	var = ferite_buffer_to_var( ctx->buf );
	Serialize_walk_deinit( script, ctx );
	FE_RETURN_VAR( var );
    
   }
   FE_RETURN_VOID;
}

